/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import retrofit.Callback;
import retrofit.Types;
import retrofit.http.Body;
import retrofit.http.Field;
import retrofit.http.FormUrlEncoded;
import retrofit.http.Header;
import retrofit.http.Headers;
import retrofit.http.Multipart;
import retrofit.http.Part;
import retrofit.http.Path;
import retrofit.http.Query;
import retrofit.http.RestMethod;

final class RestMethodInfo {
    static final int NO_BODY = -1;
    private static final String PARAM = "[a-zA-Z][a-zA-Z0-9_-]*";
    private static final Pattern PARAM_NAME_REGEX = Pattern.compile("[a-zA-Z][a-zA-Z0-9_-]*");
    private static final Pattern PARAM_URL_REGEX = Pattern.compile("\\{([a-zA-Z][a-zA-Z0-9_-]*)\\}");
    final Method method;
    boolean loaded = false;
    final boolean isSynchronous;
    Type responseObjectType;
    RequestType requestType = RequestType.SIMPLE;
    String requestMethod;
    boolean requestHasBody;
    String requestUrl;
    Set<String> requestUrlParamNames;
    String requestQuery;
    List<retrofit.client.Header> headers;
    String[] requestUrlParam;
    String[] requestQueryName;
    boolean hasQueryParams = false;
    String[] requestFormFields;
    String[] requestMultipartPart;
    String[] requestParamHeader;
    int bodyIndex = -1;

    RestMethodInfo(Method method) {
        this.method = method;
        this.isSynchronous = this.parseResponseType();
    }

    synchronized void init() {
        if (this.loaded) {
            return;
        }
        this.parseMethodAnnotations();
        this.parseParameters();
        this.loaded = true;
    }

    private void parseMethodAnnotations() {
        for (Annotation methodAnnotation : this.method.getAnnotations()) {
            Class<? extends Annotation> annotationType = methodAnnotation.annotationType();
            RestMethod methodInfo = null;
            for (Annotation innerAnnotation : annotationType.getAnnotations()) {
                if (RestMethod.class != innerAnnotation.annotationType()) continue;
                methodInfo = (RestMethod)innerAnnotation;
                break;
            }
            if (methodInfo != null) {
                String path;
                if (this.requestMethod != null) {
                    throw new IllegalArgumentException("Method " + this.method.getName() + " contains multiple HTTP methods. Found: " + this.requestMethod + " and " + methodInfo.value());
                }
                try {
                    path = (String)annotationType.getMethod("value", new Class[0]).invoke((Object)methodAnnotation, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to extract path from " + annotationType.getSimpleName() + " annotation on " + this.method.getName() + ".", e);
                }
                this.parsePath(path);
                this.requestMethod = methodInfo.value();
                this.requestHasBody = methodInfo.hasBody();
                continue;
            }
            if (annotationType == Headers.class) {
                String[] headersToParse = ((Headers)methodAnnotation).value();
                if (headersToParse.length == 0) {
                    throw new IllegalStateException("Headers annotation was empty.");
                }
                this.headers = this.parseHeaders(headersToParse);
                continue;
            }
            if (annotationType == Multipart.class) {
                if (this.requestType != RequestType.SIMPLE) {
                    throw new IllegalStateException("Only one encoding annotation per method is allowed: " + this.method.getName());
                }
                this.requestType = RequestType.MULTIPART;
                continue;
            }
            if (annotationType != FormUrlEncoded.class) continue;
            if (this.requestType != RequestType.SIMPLE) {
                throw new IllegalStateException("Only one encoding annotation per method is allowed: " + this.method.getName());
            }
            this.requestType = RequestType.FORM_URL_ENCODED;
        }
        if (this.requestMethod == null) {
            throw new IllegalStateException("Method " + this.method.getName() + " not annotated with request type (e.g., GET, POST).");
        }
        if (!this.requestHasBody) {
            if (this.requestType == RequestType.MULTIPART) {
                throw new IllegalStateException("Multipart can only be specific on HTTP methods with request body (e.g., POST). (" + this.method.getName() + ")");
            }
            if (this.requestType == RequestType.FORM_URL_ENCODED) {
                throw new IllegalStateException("Multipart can only be specific on HTTP methods with request body (e.g., POST). (" + this.method.getName() + ")");
            }
        }
    }

    private void parsePath(String path) {
        if (path == null || path.length() == 0 || path.charAt(0) != '/') {
            throw new IllegalArgumentException("URL path \"" + path + "\" on method " + this.method.getName() + " must start with '/'. (" + this.method.getName() + ")");
        }
        String url = path;
        String query = null;
        int question = path.indexOf(63);
        if (question != -1 && question < path.length() - 1) {
            url = path.substring(0, question);
            query = path.substring(question + 1);
            this.hasQueryParams = true;
            Matcher queryParamMatcher = PARAM_URL_REGEX.matcher(query);
            if (queryParamMatcher.find()) {
                throw new IllegalStateException("URL query string \"" + query + "\" on method " + this.method.getName() + " may not have replace block.");
            }
        }
        Set<String> urlParams = RestMethodInfo.parsePathParameters(path);
        this.requestUrl = url;
        this.requestUrlParamNames = urlParams;
        this.requestQuery = query;
    }

    private List<retrofit.client.Header> parseHeaders(String[] headers) {
        ArrayList<retrofit.client.Header> headerList = new ArrayList<retrofit.client.Header>();
        for (String header : headers) {
            int colon = header.indexOf(58);
            if (colon == -1 || colon == 0 || colon == headers.length - 1) {
                throw new IllegalStateException("Header must be in the form 'Name: Value': " + header);
            }
            headerList.add(new retrofit.client.Header(header.substring(0, colon), header.substring(colon + 1).trim()));
        }
        return headerList;
    }

    private boolean parseResponseType() {
        boolean hasCallback;
        Type returnType = this.method.getGenericReturnType();
        Type lastArgType = null;
        Class lastArgClass = null;
        Type[] parameterTypes = this.method.getGenericParameterTypes();
        if (parameterTypes.length > 0) {
            Type typeToCheck;
            lastArgType = typeToCheck = parameterTypes[parameterTypes.length - 1];
            if (typeToCheck instanceof ParameterizedType) {
                typeToCheck = ((ParameterizedType)typeToCheck).getRawType();
            }
            if (typeToCheck instanceof Class) {
                lastArgClass = (Class)typeToCheck;
            }
        }
        boolean hasReturnType = returnType != Void.TYPE;
        boolean bl = hasCallback = lastArgClass != null && Callback.class.isAssignableFrom(lastArgClass);
        if (hasReturnType && hasCallback) {
            throw new IllegalArgumentException("Method " + this.method.getName() + " may only have return type or Callback as last argument, not both.");
        }
        if (!hasReturnType && !hasCallback) {
            throw new IllegalArgumentException("Method " + this.method.getName() + " must have either a return type or Callback as last argument.");
        }
        if (hasReturnType) {
            this.responseObjectType = returnType;
            return true;
        }
        if ((lastArgType = Types.getSupertype(lastArgType, Types.getRawType(lastArgType), Callback.class)) instanceof ParameterizedType) {
            Type[] types = ((ParameterizedType)lastArgType).getActualTypeArguments();
            for (int i = 0; i < types.length; ++i) {
                Type type = types[i];
                if (!(type instanceof WildcardType)) continue;
                types[i] = ((WildcardType)type).getUpperBounds()[0];
            }
            this.responseObjectType = types[0];
            return false;
        }
        throw new IllegalArgumentException("Last parameter of " + this.method.getName() + " must be of type Callback<X> or Callback<? super X>. Found: " + lastArgType);
    }

    private void parseParameters() {
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        Annotation[][] parameterAnnotationArrays = this.method.getParameterAnnotations();
        int count = parameterAnnotationArrays.length;
        if (!this.isSynchronous) {
            --count;
        }
        String[] urlParam = new String[count];
        String[] queryName = new String[count];
        String[] formValue = new String[count];
        String[] multipartPart = new String[count];
        String[] paramHeader = new String[count];
        boolean gotField = false;
        boolean gotPart = false;
        for (int i = 0; i < count; ++i) {
            boolean hasRetrofitAnnotation = false;
            Class<?> parameterType = parameterTypes[i];
            Annotation[] parameterAnnotations = parameterAnnotationArrays[i];
            if (parameterAnnotations != null) {
                for (Annotation parameterAnnotation : parameterAnnotations) {
                    String name;
                    Class<? extends Annotation> annotationType = parameterAnnotation.annotationType();
                    if (annotationType == Path.class) {
                        hasRetrofitAnnotation = true;
                        name = ((Path)parameterAnnotation).value();
                        if (!PARAM_NAME_REGEX.matcher(name).matches()) {
                            throw new IllegalStateException("Path parameter name is not valid: " + name + ". Must match " + PARAM_URL_REGEX.pattern());
                        }
                        if (!this.requestUrlParamNames.contains(name)) {
                            throw new IllegalStateException("Method URL \"" + this.requestUrl + "\" does not contain {" + name + "}.");
                        }
                        urlParam[i] = name;
                        continue;
                    }
                    if (annotationType == Query.class) {
                        hasRetrofitAnnotation = true;
                        this.hasQueryParams = true;
                        queryName[i] = name = ((Query)parameterAnnotation).value();
                        continue;
                    }
                    if (annotationType == Header.class) {
                        name = ((Header)parameterAnnotation).value();
                        if (parameterType != String.class) {
                            throw new IllegalStateException("@Header parameter type must be String: " + name);
                        }
                        hasRetrofitAnnotation = true;
                        paramHeader[i] = name;
                        continue;
                    }
                    if (annotationType == Field.class) {
                        if (this.requestType != RequestType.FORM_URL_ENCODED) {
                            throw new IllegalStateException("@Field parameters can only be used with form encoding.");
                        }
                        name = ((Field)parameterAnnotation).value();
                        gotField = true;
                        hasRetrofitAnnotation = true;
                        formValue[i] = name;
                        continue;
                    }
                    if (annotationType == Part.class) {
                        if (this.requestType != RequestType.MULTIPART) {
                            throw new IllegalStateException("@Part parameters can only be used with multipart encoding.");
                        }
                        name = ((Part)parameterAnnotation).value();
                        gotPart = true;
                        hasRetrofitAnnotation = true;
                        multipartPart[i] = name;
                        continue;
                    }
                    if (annotationType != Body.class) continue;
                    if (this.requestType != RequestType.SIMPLE) {
                        throw new IllegalStateException("@Body parameters cannot be used with form or multi-part encoding.");
                    }
                    if (this.bodyIndex != -1) {
                        throw new IllegalStateException("Method annotated with multiple Body method annotations: " + this.method);
                    }
                    hasRetrofitAnnotation = true;
                    this.bodyIndex = i;
                }
            }
            if (hasRetrofitAnnotation) continue;
            throw new IllegalStateException("No annotations found on parameter " + (i + 1) + " of " + this.method.getName());
        }
        if (this.requestType == RequestType.SIMPLE && !this.requestHasBody && this.bodyIndex != -1) {
            throw new IllegalStateException("Non-body HTTP method cannot contain @Body or @TypedOutput.");
        }
        if (this.requestType == RequestType.FORM_URL_ENCODED && !gotField) {
            throw new IllegalStateException("Form-encoded method must contain at least one @Field.");
        }
        if (this.requestType == RequestType.MULTIPART && !gotPart) {
            throw new IllegalStateException("Multipart method must contain at least one @Part.");
        }
        this.requestUrlParam = urlParam;
        this.requestQueryName = queryName;
        this.requestFormFields = formValue;
        this.requestMultipartPart = multipartPart;
        this.requestParamHeader = paramHeader;
    }

    static Set<String> parsePathParameters(String path) {
        Matcher m = PARAM_URL_REGEX.matcher(path);
        LinkedHashSet<String> patterns = new LinkedHashSet<String>();
        while (m.find()) {
            patterns.add(m.group(1));
        }
        return patterns;
    }

    static enum RequestType {
        SIMPLE,
        MULTIPART,
        FORM_URL_ENCODED;

    }
}

