/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.widget.ImageView;
import com.squareup.picasso.BitmapHunter;
import com.squareup.picasso.Callback;
import com.squareup.picasso.DeferredRequestCreator;
import com.squareup.picasso.FetchAction;
import com.squareup.picasso.GetAction;
import com.squareup.picasso.ImageViewAction;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.PicassoDrawable;
import com.squareup.picasso.Request;
import com.squareup.picasso.Target;
import com.squareup.picasso.TargetAction;
import com.squareup.picasso.Transformation;
import com.squareup.picasso.Utils;
import java.io.IOException;

public class RequestCreator {
    private final Picasso picasso;
    private final Request.Builder data;
    private boolean skipMemoryCache;
    private boolean noFade;
    private boolean deferred;
    private int placeholderResId;
    private Drawable placeholderDrawable;
    private int errorResId;
    private Drawable errorDrawable;

    RequestCreator(Picasso picasso, Uri uri, int resourceId) {
        if (picasso.shutdown) {
            throw new IllegalStateException("Picasso instance already shut down. Cannot submit new requests.");
        }
        this.picasso = picasso;
        this.data = new Request.Builder(uri, resourceId);
    }

    RequestCreator() {
        this.picasso = null;
        this.data = new Request.Builder(null, 0);
    }

    public RequestCreator placeholder(int placeholderResId) {
        if (placeholderResId == 0) {
            throw new IllegalArgumentException("Placeholder image resource invalid.");
        }
        if (this.placeholderDrawable != null) {
            throw new IllegalStateException("Placeholder image already set.");
        }
        this.placeholderResId = placeholderResId;
        return this;
    }

    public RequestCreator placeholder(Drawable placeholderDrawable) {
        if (this.placeholderResId != 0) {
            throw new IllegalStateException("Placeholder image already set.");
        }
        this.placeholderDrawable = placeholderDrawable;
        return this;
    }

    public RequestCreator error(int errorResId) {
        if (errorResId == 0) {
            throw new IllegalArgumentException("Error image resource invalid.");
        }
        if (this.errorDrawable != null) {
            throw new IllegalStateException("Error image already set.");
        }
        this.errorResId = errorResId;
        return this;
    }

    public RequestCreator error(Drawable errorDrawable) {
        if (errorDrawable == null) {
            throw new IllegalArgumentException("Error image may not be null.");
        }
        if (this.errorResId != 0) {
            throw new IllegalStateException("Error image already set.");
        }
        this.errorDrawable = errorDrawable;
        return this;
    }

    public RequestCreator fit() {
        this.deferred = true;
        return this;
    }

    RequestCreator unfit() {
        this.deferred = false;
        return this;
    }

    public RequestCreator resizeDimen(int targetWidthResId, int targetHeightResId) {
        Resources resources = this.picasso.context.getResources();
        int targetWidth = resources.getDimensionPixelSize(targetWidthResId);
        int targetHeight = resources.getDimensionPixelSize(targetHeightResId);
        return this.resize(targetWidth, targetHeight);
    }

    public RequestCreator resize(int targetWidth, int targetHeight) {
        this.data.resize(targetWidth, targetHeight);
        return this;
    }

    public RequestCreator centerCrop() {
        this.data.centerCrop();
        return this;
    }

    public RequestCreator centerInside() {
        this.data.centerInside();
        return this;
    }

    public RequestCreator rotate(float degrees) {
        this.data.rotate(degrees);
        return this;
    }

    public RequestCreator rotate(float degrees, float pivotX, float pivotY) {
        this.data.rotate(degrees, pivotX, pivotY);
        return this;
    }

    public RequestCreator transform(Transformation transformation) {
        this.data.transform(transformation);
        return this;
    }

    public RequestCreator skipMemoryCache() {
        this.skipMemoryCache = true;
        return this;
    }

    public RequestCreator noFade() {
        this.noFade = true;
        return this;
    }

    public Bitmap get() throws IOException {
        Utils.checkNotMain();
        if (this.deferred) {
            throw new IllegalStateException("Fit cannot be used with get.");
        }
        if (!this.data.hasImage()) {
            return null;
        }
        Request finalData = this.picasso.transformRequest(this.data.build());
        String key = Utils.createKey(finalData);
        GetAction action = new GetAction(this.picasso, finalData, this.skipMemoryCache, key);
        return BitmapHunter.forRequest(this.picasso.context, this.picasso, this.picasso.dispatcher, this.picasso.cache, this.picasso.stats, action, this.picasso.dispatcher.downloader).hunt();
    }

    public void fetch() {
        if (this.deferred) {
            throw new IllegalStateException("Fit cannot be used with fetch.");
        }
        if (this.data.hasImage()) {
            Request finalData = this.picasso.transformRequest(this.data.build());
            String key = Utils.createKey(finalData);
            FetchAction action = new FetchAction(this.picasso, finalData, this.skipMemoryCache, key);
            this.picasso.enqueueAndSubmit(action);
        }
    }

    public void into(Target target) {
        Bitmap bitmap;
        Drawable drawable;
        if (target == null) {
            throw new IllegalArgumentException("Target must not be null.");
        }
        if (this.deferred) {
            throw new IllegalStateException("Fit cannot be used with a Target.");
        }
        Drawable drawable2 = drawable = this.placeholderResId != 0 ? this.picasso.context.getResources().getDrawable(this.placeholderResId) : this.placeholderDrawable;
        if (!this.data.hasImage()) {
            this.picasso.cancelRequest(target);
            target.onPrepareLoad(drawable);
            return;
        }
        Request finalData = this.picasso.transformRequest(this.data.build());
        String requestKey = Utils.createKey(finalData);
        if (!this.skipMemoryCache && (bitmap = this.picasso.quickMemoryCacheCheck(requestKey)) != null) {
            this.picasso.cancelRequest(target);
            target.onBitmapLoaded(bitmap, Picasso.LoadedFrom.MEMORY);
            return;
        }
        target.onPrepareLoad(drawable);
        TargetAction action = new TargetAction(this.picasso, target, finalData, this.skipMemoryCache, requestKey);
        this.picasso.enqueueAndSubmit(action);
    }

    public void into(ImageView target) {
        this.into(target, null);
    }

    public void into(ImageView target, Callback callback) {
        Bitmap bitmap;
        if (target == null) {
            throw new IllegalArgumentException("Target must not be null.");
        }
        if (!this.data.hasImage()) {
            this.picasso.cancelRequest(target);
            PicassoDrawable.setPlaceholder(target, this.placeholderResId, this.placeholderDrawable);
            return;
        }
        if (this.deferred) {
            if (this.data.hasSize()) {
                throw new IllegalStateException("Fit cannot be used with resize.");
            }
            int measuredWidth = target.getMeasuredWidth();
            int measuredHeight = target.getMeasuredHeight();
            if (measuredWidth == 0 && measuredHeight == 0) {
                PicassoDrawable.setPlaceholder(target, this.placeholderResId, this.placeholderDrawable);
                this.picasso.defer(target, new DeferredRequestCreator(this, target, callback));
                return;
            }
            this.data.resize(measuredWidth, measuredHeight);
        }
        Request finalData = this.picasso.transformRequest(this.data.build());
        String requestKey = Utils.createKey(finalData);
        if (!this.skipMemoryCache && (bitmap = this.picasso.quickMemoryCacheCheck(requestKey)) != null) {
            this.picasso.cancelRequest(target);
            PicassoDrawable.setBitmap(target, this.picasso.context, bitmap, Picasso.LoadedFrom.MEMORY, this.noFade, this.picasso.debugging);
            if (callback != null) {
                callback.onSuccess();
            }
            return;
        }
        PicassoDrawable.setPlaceholder(target, this.placeholderResId, this.placeholderDrawable);
        ImageViewAction action = new ImageViewAction(this.picasso, target, finalData, this.skipMemoryCache, this.noFade, this.errorResId, this.errorDrawable, requestKey, callback);
        this.picasso.enqueueAndSubmit(action);
    }
}

