/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.NetworkInfo;
import com.squareup.picasso.Action;
import com.squareup.picasso.BitmapHunter;
import com.squareup.picasso.Cache;
import com.squareup.picasso.Dispatcher;
import com.squareup.picasso.Downloader;
import com.squareup.picasso.MarkableInputStream;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.picasso.Stats;
import com.squareup.picasso.Utils;
import java.io.IOException;
import java.io.InputStream;

class NetworkBitmapHunter
extends BitmapHunter {
    static final int DEFAULT_RETRY_COUNT = 2;
    private static final int MARKER = 65536;
    private final Downloader downloader;
    int retryCount;

    public NetworkBitmapHunter(Picasso picasso, Dispatcher dispatcher, Cache cache, Stats stats, Action action, Downloader downloader) {
        super(picasso, dispatcher, cache, stats, action);
        this.downloader = downloader;
        this.retryCount = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Bitmap decode(Request data) throws IOException {
        boolean loadFromLocalCacheOnly = this.retryCount == 0;
        Downloader.Response response = this.downloader.load(data.uri, loadFromLocalCacheOnly);
        if (response == null) {
            return null;
        }
        this.loadedFrom = response.cached ? Picasso.LoadedFrom.DISK : Picasso.LoadedFrom.NETWORK;
        Bitmap result = response.getBitmap();
        if (result != null) {
            return result;
        }
        InputStream is = response.getInputStream();
        try {
            Bitmap bitmap = this.decodeStream(is, data);
            return bitmap;
        }
        finally {
            Utils.closeQuietly(is);
        }
    }

    @Override
    boolean shouldRetry(boolean airplaneMode, NetworkInfo info) {
        boolean hasRetries;
        boolean bl = hasRetries = this.retryCount > 0;
        if (!hasRetries) {
            return false;
        }
        --this.retryCount;
        return info == null || info.isConnectedOrConnecting();
    }

    private Bitmap decodeStream(InputStream stream, Request data) throws IOException {
        if (stream == null) {
            return null;
        }
        BitmapFactory.Options options = null;
        if (data.hasSize()) {
            options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            MarkableInputStream markStream = new MarkableInputStream(stream);
            stream = markStream;
            long mark = markStream.savePosition(65536);
            BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
            NetworkBitmapHunter.calculateInSampleSize(data.targetWidth, data.targetHeight, options);
            markStream.reset(mark);
        }
        return BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
    }
}

