/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

abstract class Action<T> {
    final Picasso picasso;
    final Request data;
    final WeakReference<T> target;
    final boolean skipCache;
    final boolean noFade;
    final int errorResId;
    final Drawable errorDrawable;
    final String key;
    boolean cancelled;

    Action(Picasso picasso, T target, Request data, boolean skipCache, boolean noFade, int errorResId, Drawable errorDrawable, String key) {
        this.picasso = picasso;
        this.data = data;
        this.target = new RequestWeakReference<Object>(this, target, picasso.referenceQueue);
        this.skipCache = skipCache;
        this.noFade = noFade;
        this.errorResId = errorResId;
        this.errorDrawable = errorDrawable;
        this.key = key;
    }

    abstract void complete(Bitmap var1, Picasso.LoadedFrom var2);

    abstract void error();

    void cancel() {
        this.cancelled = true;
    }

    Request getData() {
        return this.data;
    }

    T getTarget() {
        return this.target.get();
    }

    String getKey() {
        return this.key;
    }

    boolean isCancelled() {
        return this.cancelled;
    }

    Picasso getPicasso() {
        return this.picasso;
    }

    static class RequestWeakReference<T>
    extends WeakReference<T> {
        final Action action;

        public RequestWeakReference(Action action, T referent, ReferenceQueue<? super T> q) {
            super(referent, q);
            this.action = action;
        }
    }
}

