/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import com.phonegap.api.Plugin;
import com.phonegap.api.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Storage
extends Plugin {
    SQLiteDatabase myDb = null;
    String path = null;
    String dbName = null;

    public PluginResult execute(String action, JSONArray args, String callbackId) {
        PluginResult.Status status = PluginResult.Status.OK;
        String result = "";
        try {
            if (action.equals("setStorage")) {
                this.setStorage(args.getString(0));
            } else if (action.equals("openDatabase")) {
                this.openDatabase(args.getString(0), args.getString(1), args.getString(2), args.getLong(3));
            } else if (action.equals("executeSql")) {
                JSONArray a = args.getJSONArray(1);
                int len = a.length();
                String[] s = new String[len];
                for (int i = 0; i < len; ++i) {
                    s[i] = a.getString(i);
                }
                this.executeSql(args.getString(0), s, args.getString(2));
            }
            return new PluginResult(status, result);
        }
        catch (JSONException e) {
            return new PluginResult(PluginResult.Status.JSON_EXCEPTION);
        }
    }

    public boolean isSynch(String action) {
        return false;
    }

    public void onDestroy() {
        if (this.myDb != null) {
            this.myDb.close();
            this.myDb = null;
        }
    }

    public void setStorage(String appPackage) {
        this.path = "/data/data/" + appPackage + "/databases/";
    }

    public void openDatabase(String db, String version, String display_name, long size) {
        if (this.myDb != null) {
            this.myDb.close();
        }
        if (this.path == null) {
            Package pack = ((Object)((Object)this.ctx)).getClass().getPackage();
            String appPackage = pack.getName();
            this.setStorage(appPackage);
        }
        this.dbName = this.path + db + ".db";
        this.myDb = SQLiteDatabase.openOrCreateDatabase((String)this.dbName, null);
    }

    public void executeSql(String query, String[] params, String tx_id) {
        try {
            Cursor myCursor = this.myDb.rawQuery(query, params);
            this.processResults(myCursor, tx_id);
            myCursor.close();
        }
        catch (SQLiteException ex) {
            ex.printStackTrace();
            System.out.println("Storage.executeSql(): Error=" + ex.getMessage());
            this.sendJavascript("droiddb.fail('" + ex.getMessage() + "','" + tx_id + "');");
        }
    }

    public void processResults(Cursor cur, String tx_id) {
        String result = "[]";
        if (cur.moveToFirst()) {
            JSONArray fullresult = new JSONArray();
            String key = "";
            String value = "";
            int colCount = cur.getColumnCount();
            do {
                JSONObject row = new JSONObject();
                try {
                    for (int i = 0; i < colCount; ++i) {
                        key = cur.getColumnName(i);
                        value = cur.getString(i);
                        row.put(key, (Object)value);
                    }
                    fullresult.put((Object)row);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } while (cur.moveToNext());
            result = fullresult.toString();
        }
        this.sendJavascript("droiddb.completeQuery('" + tx_id + "', " + result + ");");
    }
}

