/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.Route;
import com.squareup.okhttp.TunnelRequest;
import com.squareup.okhttp.internal.Platform;
import com.squareup.okhttp.internal.http.HttpAuthenticator;
import com.squareup.okhttp.internal.http.HttpEngine;
import com.squareup.okhttp.internal.http.HttpTransport;
import com.squareup.okhttp.internal.http.RawHeaders;
import com.squareup.okhttp.internal.http.SpdyTransport;
import com.squareup.okhttp.internal.spdy.SpdyConnection;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Arrays;
import javax.net.ssl.SSLSocket;

public final class Connection
implements Closeable {
    private static final byte[] NPN_PROTOCOLS = new byte[]{6, 115, 112, 100, 121, 47, 51, 8, 104, 116, 116, 112, 47, 49, 46, 49};
    private static final byte[] SPDY3 = new byte[]{115, 112, 100, 121, 47, 51};
    private static final byte[] HTTP_11 = new byte[]{104, 116, 116, 112, 47, 49, 46, 49};
    private final Route route;
    private Socket socket;
    private InputStream in;
    private OutputStream out;
    private boolean connected = false;
    private SpdyConnection spdyConnection;
    private int httpMinorVersion = 1;
    private long idleStartTimeNs;

    public Connection(Route route) {
        this.route = route;
    }

    public void connect(int connectTimeout, int readTimeout, TunnelRequest tunnelRequest) throws IOException {
        int mtu;
        if (this.connected) {
            throw new IllegalStateException("already connected");
        }
        this.connected = true;
        this.socket = this.route.proxy.type() != Proxy.Type.HTTP ? new Socket(this.route.proxy) : new Socket();
        Platform.get().connectSocket(this.socket, this.route.inetSocketAddress, connectTimeout);
        this.socket.setSoTimeout(readTimeout);
        this.in = this.socket.getInputStream();
        this.out = this.socket.getOutputStream();
        if (this.route.address.sslSocketFactory != null) {
            this.upgradeToTls(tunnelRequest);
        }
        if ((mtu = Platform.get().getMtu(this.socket)) < 1024) {
            mtu = 1024;
        }
        if (mtu > 8192) {
            mtu = 8192;
        }
        this.in = new BufferedInputStream(this.in, mtu);
        this.out = new BufferedOutputStream(this.out, mtu);
    }

    private void upgradeToTls(TunnelRequest tunnelRequest) throws IOException {
        byte[] selectedProtocol;
        boolean useNpn;
        Platform platform = Platform.get();
        if (this.requiresTunnel()) {
            this.makeTunnel(tunnelRequest);
        }
        this.socket = this.route.address.sslSocketFactory.createSocket(this.socket, this.route.address.uriHost, this.route.address.uriPort, true);
        SSLSocket sslSocket = (SSLSocket)this.socket;
        if (this.route.modernTls) {
            platform.enableTlsExtensions(sslSocket, this.route.address.uriHost);
        } else {
            platform.supportTlsIntolerantServer(sslSocket);
        }
        boolean bl = useNpn = this.route.modernTls && this.route.address.transports.contains("spdy/3");
        if (useNpn) {
            platform.setNpnProtocols(sslSocket, NPN_PROTOCOLS);
        }
        sslSocket.startHandshake();
        if (!this.route.address.hostnameVerifier.verify(this.route.address.uriHost, sslSocket.getSession())) {
            throw new IOException("Hostname '" + this.route.address.uriHost + "' was not verified");
        }
        this.out = sslSocket.getOutputStream();
        this.in = sslSocket.getInputStream();
        if (useNpn && (selectedProtocol = platform.getNpnSelectedProtocol(sslSocket)) != null) {
            if (Arrays.equals(selectedProtocol, SPDY3)) {
                sslSocket.setSoTimeout(0);
                this.spdyConnection = new SpdyConnection.Builder(this.route.address.getUriHost(), true, this.in, this.out).build();
                this.spdyConnection.sendConnectionHeader();
            } else if (!Arrays.equals(selectedProtocol, HTTP_11)) {
                throw new IOException("Unexpected NPN transport " + new String(selectedProtocol, "ISO-8859-1"));
            }
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    public Route getRoute() {
        return this.route;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public boolean isAlive() {
        return !this.socket.isClosed() && !this.socket.isInputShutdown() && !this.socket.isOutputShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isReadable() {
        if (!(this.in instanceof BufferedInputStream)) {
            return true;
        }
        if (this.isSpdy()) {
            return true;
        }
        BufferedInputStream bufferedInputStream = (BufferedInputStream)this.in;
        try {
            int readTimeout = this.socket.getSoTimeout();
            try {
                this.socket.setSoTimeout(1);
                bufferedInputStream.mark(1);
                if (bufferedInputStream.read() == -1) {
                    boolean bl = false;
                    return bl;
                }
                bufferedInputStream.reset();
                boolean bl = true;
                return bl;
            }
            finally {
                this.socket.setSoTimeout(readTimeout);
            }
        }
        catch (SocketTimeoutException ignored) {
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void resetIdleStartTime() {
        if (this.spdyConnection != null) {
            throw new IllegalStateException("spdyConnection != null");
        }
        this.idleStartTimeNs = System.nanoTime();
    }

    public boolean isIdle() {
        return this.spdyConnection == null || this.spdyConnection.isIdle();
    }

    public boolean isExpired(long keepAliveDurationNs) {
        return this.isIdle() && System.nanoTime() - this.getIdleStartTimeNs() > keepAliveDurationNs;
    }

    public long getIdleStartTimeNs() {
        return this.spdyConnection == null ? this.idleStartTimeNs : this.spdyConnection.getIdleStartTimeNs();
    }

    public Object newTransport(HttpEngine httpEngine) throws IOException {
        return this.spdyConnection != null ? new SpdyTransport(httpEngine, this.spdyConnection) : new HttpTransport(httpEngine, this.out, this.in);
    }

    public boolean isSpdy() {
        return this.spdyConnection != null;
    }

    public SpdyConnection getSpdyConnection() {
        return this.spdyConnection;
    }

    public int getHttpMinorVersion() {
        return this.httpMinorVersion;
    }

    public void setHttpMinorVersion(int httpMinorVersion) {
        this.httpMinorVersion = httpMinorVersion;
    }

    public boolean requiresTunnel() {
        return this.route.address.sslSocketFactory != null && this.route.proxy.type() == Proxy.Type.HTTP;
    }

    private void makeTunnel(TunnelRequest tunnelRequest) throws IOException {
        RawHeaders responseHeaders;
        RawHeaders requestHeaders = tunnelRequest.getRequestHeaders();
        block4: while (true) {
            this.out.write(requestHeaders.toBytes());
            responseHeaders = RawHeaders.fromBytes(this.in);
            switch (responseHeaders.getResponseCode()) {
                case 200: {
                    return;
                }
                case 407: {
                    requestHeaders = new RawHeaders(requestHeaders);
                    URL url = new URL("https", tunnelRequest.host, tunnelRequest.port, "/");
                    boolean credentialsFound = HttpAuthenticator.processAuthHeader(this.route.address.authenticator, 407, responseHeaders, requestHeaders, this.route.proxy, url);
                    if (credentialsFound) continue block4;
                    throw new IOException("Failed to authenticate with proxy");
                }
            }
            break;
        }
        throw new IOException("Unexpected response code for CONNECT: " + responseHeaders.getResponseCode());
    }
}

