/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.image;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.loopj.android.image.ContactImage;
import com.loopj.android.image.SmartImage;
import com.loopj.android.image.SmartImageTask;
import com.loopj.android.image.WebImage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SmartImageView
extends ImageView {
    private static final int LOADING_THREADS = 4;
    private static ExecutorService threadPool = Executors.newFixedThreadPool(4);
    private SmartImageTask currentTask;

    public SmartImageView(Context context) {
        super(context);
    }

    public SmartImageView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public SmartImageView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    public void setImageUrl(String string) {
        this.setImage(new WebImage(string));
    }

    public void setImageUrl(String string, Integer n) {
        this.setImage(new WebImage(string), n);
    }

    public void setImageUrl(String string, Integer n, Integer n2) {
        this.setImage(new WebImage(string), n, n2);
    }

    public void setImageContact(long l) {
        this.setImage(new ContactImage(l));
    }

    public void setImageContact(long l, Integer n) {
        this.setImage(new ContactImage(l), n);
    }

    public void setImageContact(long l, Integer n, Integer n2) {
        this.setImage(new ContactImage(l), n, n);
    }

    public void setImage(SmartImage smartImage) {
        this.setImage(smartImage, null, null);
    }

    public void setImage(SmartImage smartImage, Integer n) {
        this.setImage(smartImage, n, n);
    }

    public void setImage(SmartImage smartImage, final Integer n, Integer n2) {
        if (n2 != null) {
            this.setImageResource(n2);
        }
        if (this.currentTask != null) {
            this.currentTask.cancel();
            this.currentTask = null;
        }
        this.currentTask = new SmartImageTask(this.getContext(), smartImage);
        this.currentTask.setOnCompleteHandler(new SmartImageTask.OnCompleteHandler(){

            @Override
            public void onComplete(Bitmap bitmap) {
                if (bitmap != null) {
                    SmartImageView.this.setImageBitmap(bitmap);
                } else if (n != null) {
                    SmartImageView.this.setImageResource(n);
                }
            }
        });
        threadPool.execute(this.currentTask);
    }

    public static void cancelAllTasks() {
        threadPool.shutdownNow();
        threadPool = Executors.newFixedThreadPool(4);
    }
}

