/*
 * Decompiled with CFR 0.152.
 */
package retrofit.mime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import retrofit.mime.TypedOutput;

public final class MultipartTypedOutput
implements TypedOutput {
    final List<byte[]> parts = new ArrayList<byte[]>();
    private final byte[] footer;
    private final String boundary;
    private long length;

    public MultipartTypedOutput() {
        this(UUID.randomUUID().toString());
    }

    MultipartTypedOutput(String boundary) {
        this.boundary = boundary;
        this.footer = MultipartTypedOutput.buildBoundary(boundary, false, true);
        this.length = this.footer.length;
    }

    public void addPart(String name, TypedOutput body) {
        if (name == null) {
            throw new NullPointerException("Part name must not be null.");
        }
        if (body == null) {
            throw new NullPointerException("Part body must not be null.");
        }
        byte[] part = this.buildPart(name, body, this.parts.isEmpty());
        this.parts.add(part);
        this.length += (long)part.length;
    }

    public int getPartCount() {
        return this.parts.size();
    }

    @Override
    public String fileName() {
        return null;
    }

    @Override
    public String mimeType() {
        return "multipart/form-data; boundary=" + this.boundary;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        for (byte[] part : this.parts) {
            out.write(part);
        }
        out.write(this.footer);
    }

    private byte[] buildPart(String name, TypedOutput body, boolean first) {
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            out.write(MultipartTypedOutput.buildBoundary(this.boundary, first, false));
            out.write(this.buildHeader(name, body));
            body.writeTo(out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to write multipart request.", ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    private static byte[] buildBoundary(String boundary, boolean first, boolean last) {
        try {
            StringBuilder sb = new StringBuilder();
            if (!first) {
                sb.append("\r\n");
            }
            sb.append("--");
            sb.append(boundary);
            if (last) {
                sb.append("--");
            } else {
                sb.append("\r\n");
            }
            return sb.toString().getBytes("UTF-8");
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to write multipart boundary", ex);
        }
    }

    private byte[] buildHeader(String name, TypedOutput value) {
        try {
            StringBuilder headers = new StringBuilder();
            headers.append("Content-Disposition: form-data; name=\"");
            headers.append(name);
            if (value.fileName() != null) {
                headers.append("\"; filename=\"");
                headers.append(value.fileName());
            }
            headers.append("\"\r\nContent-Type: ");
            headers.append(value.mimeType());
            if (value.length() != -1L) {
                headers.append("\r\nContent-Length: ").append(value.length());
            }
            headers.append("\r\nContent-Transfer-Encoding: binary\r\n\r\n");
            return headers.toString().getBytes("UTF-8");
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to write multipart header", ex);
        }
    }
}

