/*
 * Decompiled with CFR 0.152.
 */
package retrofit.client;

import com.squareup.okhttp.OkHttpClient;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import retrofit.client.Request;
import retrofit.client.UrlConnectionClient;

public class OkClient
extends UrlConnectionClient {
    private final OkHttpClient client;

    public OkClient() {
        this(OkClient.generateDefaultOkHttp());
    }

    public OkClient(OkHttpClient client) {
        this.client = client;
    }

    @Override
    protected HttpURLConnection openConnection(Request request) throws IOException {
        return this.client.open(new URL(request.getUrl()));
    }

    private static OkHttpClient generateDefaultOkHttp() {
        OkHttpClient okHttp = new OkHttpClient();
        okHttp.setConnectTimeout(15000L, TimeUnit.MILLISECONDS);
        okHttp.setReadTimeout(20000L, TimeUnit.MILLISECONDS);
        return okHttp;
    }
}

