/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import retrofit.Callback;
import retrofit.CallbackRunnable;
import retrofit.ErrorHandler;
import retrofit.Platform;
import retrofit.Profiler;
import retrofit.RequestInterceptor;
import retrofit.RequestInterceptorTape;
import retrofit.ResponseWrapper;
import retrofit.RestMethodInfo;
import retrofit.RetrofitError;
import retrofit.Server;
import retrofit.Utils;
import retrofit.client.Client;
import retrofit.client.Header;
import retrofit.client.Request;
import retrofit.client.Response;
import retrofit.converter.Converter;
import retrofit.mime.MimeUtil;
import retrofit.mime.TypedByteArray;
import retrofit.mime.TypedInput;
import retrofit.mime.TypedOutput;

public class RestAdapter {
    private static final int LOG_CHUNK_SIZE = 4000;
    static final String THREAD_PREFIX = "Retrofit-";
    static final String IDLE_THREAD_NAME = "Retrofit-Idle";
    private final Server server;
    private final Client.Provider clientProvider;
    private final Executor httpExecutor;
    private final Executor callbackExecutor;
    private final RequestInterceptor requestInterceptor;
    private final Converter converter;
    private final Profiler profiler;
    private final ErrorHandler errorHandler;
    private final Log log;
    private volatile LogLevel logLevel;

    private RestAdapter(Server server, Client.Provider clientProvider, Executor httpExecutor, Executor callbackExecutor, RequestInterceptor requestInterceptor, Converter converter, Profiler profiler, ErrorHandler errorHandler, Log log, LogLevel logLevel) {
        this.server = server;
        this.clientProvider = clientProvider;
        this.httpExecutor = httpExecutor;
        this.callbackExecutor = callbackExecutor;
        this.requestInterceptor = requestInterceptor;
        this.converter = converter;
        this.profiler = profiler;
        this.errorHandler = errorHandler;
        this.log = log;
        this.logLevel = logLevel;
    }

    public void setLogLevel(LogLevel loglevel) {
        if (this.logLevel == null) {
            throw new NullPointerException("Log level may not be null.");
        }
        this.logLevel = loglevel;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public <T> T create(Class<T> service) {
        if (!service.isInterface()) {
            throw new IllegalArgumentException("Only interface endpoint definitions are supported.");
        }
        if (service.getSuperclass() != null) {
            throw new IllegalArgumentException("Interface definitions must not extend other interfaces.");
        }
        return (T)Proxy.newProxyInstance(service.getClassLoader(), new Class[]{service}, (InvocationHandler)new RestHandler());
    }

    private Request logAndReplaceRequest(Request request) throws IOException {
        this.log.log(String.format("---> HTTP %s %s", request.getMethod(), request.getUrl()));
        if (this.logLevel.ordinal() >= LogLevel.HEADERS.ordinal()) {
            for (Header header : request.getHeaders()) {
                this.log.log(header.getName() + ": " + header.getValue());
            }
            long bodySize = 0L;
            TypedOutput body = request.getBody();
            if (body != null) {
                bodySize = body.length();
                String bodyMime = body.mimeType();
                if (bodyMime != null) {
                    this.log.log("Content-Type: " + bodyMime);
                }
                if (bodySize != -1L) {
                    this.log.log("Content-Length: " + bodySize);
                }
                if (this.logLevel.ordinal() >= LogLevel.FULL.ordinal()) {
                    if (!request.getHeaders().isEmpty()) {
                        this.log.log("");
                    }
                    if (!(body instanceof TypedByteArray)) {
                        request = Utils.readBodyToBytesIfNecessary(request);
                        body = request.getBody();
                    }
                    byte[] bodyBytes = ((TypedByteArray)body).getBytes();
                    bodySize = bodyBytes.length;
                    String bodyCharset = MimeUtil.parseCharset(bodyMime);
                    String bodyString = new String(bodyBytes, bodyCharset);
                    int len = bodyString.length();
                    for (int i = 0; i < len; i += 4000) {
                        int end = Math.min(len, i + 4000);
                        this.log.log(bodyString.substring(i, end));
                    }
                }
            }
            this.log.log(String.format("---> END HTTP (%s-byte body)", bodySize));
        }
        return request;
    }

    private Response logAndReplaceResponse(String url, Response response, long elapsedTime) throws IOException {
        this.log.log(String.format("<--- HTTP %s %s (%sms)", response.getStatus(), url, elapsedTime));
        if (this.logLevel.ordinal() >= LogLevel.HEADERS.ordinal()) {
            for (Header header : response.getHeaders()) {
                this.log.log(header.getName() + ": " + header.getValue());
            }
            long bodySize = 0L;
            TypedInput body = response.getBody();
            if (body != null) {
                bodySize = body.length();
                if (this.logLevel.ordinal() >= LogLevel.FULL.ordinal()) {
                    if (!response.getHeaders().isEmpty()) {
                        this.log.log("");
                    }
                    if (!(body instanceof TypedByteArray)) {
                        response = Utils.readBodyToBytesIfNecessary(response);
                        body = response.getBody();
                    }
                    byte[] bodyBytes = ((TypedByteArray)body).getBytes();
                    bodySize = bodyBytes.length;
                    String bodyMime = body.mimeType();
                    String bodyCharset = MimeUtil.parseCharset(bodyMime);
                    String bodyString = new String(bodyBytes, bodyCharset);
                    int len = bodyString.length();
                    for (int i = 0; i < len; i += 4000) {
                        int end = Math.min(len, i + 4000);
                        this.log.log(bodyString.substring(i, end));
                    }
                }
            }
            this.log.log(String.format("<--- END HTTP (%s-byte body)", bodySize));
        }
        return response;
    }

    private void logException(Throwable t, String url) {
        this.log.log(String.format("---- ERROR %s", url));
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        this.log.log(sw.toString());
        this.log.log("---- END ERROR");
    }

    private static Profiler.RequestInformation getRequestInfo(String serverUrl, RestMethodInfo methodDetails, Request request) {
        long contentLength = 0L;
        String contentType = null;
        TypedOutput body = request.getBody();
        if (body != null) {
            contentLength = body.length();
            contentType = body.mimeType();
        }
        return new Profiler.RequestInformation(methodDetails.requestMethod, serverUrl, methodDetails.requestUrl, contentLength, contentType);
    }

    static /* synthetic */ Server access$600(RestAdapter x0) {
        return x0.server;
    }

    static /* synthetic */ Converter access$700(RestAdapter x0) {
        return x0.converter;
    }

    static /* synthetic */ LogLevel access$800(RestAdapter x0) {
        return x0.logLevel;
    }

    static /* synthetic */ Request access$900(RestAdapter x0, Request x1) throws IOException {
        return x0.logAndReplaceRequest(x1);
    }

    static /* synthetic */ Profiler access$1000(RestAdapter x0) {
        return x0.profiler;
    }

    static /* synthetic */ Client.Provider access$1100(RestAdapter x0) {
        return x0.clientProvider;
    }

    static /* synthetic */ Profiler.RequestInformation access$1200(String x0, RestMethodInfo x1, Request x2) {
        return RestAdapter.getRequestInfo(x0, x1, x2);
    }

    static /* synthetic */ Response access$1300(RestAdapter x0, String x1, Response x2, long x3) throws IOException {
        return x0.logAndReplaceResponse(x1, x2, x3);
    }

    static /* synthetic */ void access$1400(RestAdapter x0, Throwable x1, String x2) {
        x0.logException(x1, x2);
    }

    public static class Builder {
        private Server server;
        private Client.Provider clientProvider;
        private Executor httpExecutor;
        private Executor callbackExecutor;
        private RequestInterceptor requestInterceptor;
        private Converter converter;
        private Profiler profiler;
        private ErrorHandler errorHandler;
        private Log log;
        private LogLevel logLevel = LogLevel.NONE;

        public Builder setServer(String endpoint) {
            if (endpoint == null || endpoint.trim().length() == 0) {
                throw new NullPointerException("Server may not be blank.");
            }
            return this.setServer(new Server(endpoint));
        }

        public Builder setServer(Server server) {
            if (server == null) {
                throw new NullPointerException("Server may not be null.");
            }
            this.server = server;
            return this;
        }

        public Builder setClient(final Client client) {
            if (client == null) {
                throw new NullPointerException("Client may not be null.");
            }
            return this.setClient(new Client.Provider(){

                @Override
                public Client get() {
                    return client;
                }
            });
        }

        public Builder setClient(Client.Provider clientProvider) {
            if (clientProvider == null) {
                throw new NullPointerException("Client provider may not be null.");
            }
            this.clientProvider = clientProvider;
            return this;
        }

        public Builder setExecutors(Executor httpExecutor, Executor callbackExecutor) {
            if (httpExecutor == null) {
                throw new NullPointerException("HTTP executor may not be null.");
            }
            if (callbackExecutor == null) {
                callbackExecutor = new Utils.SynchronousExecutor();
            }
            this.httpExecutor = httpExecutor;
            this.callbackExecutor = callbackExecutor;
            return this;
        }

        public Builder setRequestInterceptor(RequestInterceptor requestInterceptor) {
            if (requestInterceptor == null) {
                throw new NullPointerException("Request interceptor may not be null.");
            }
            this.requestInterceptor = requestInterceptor;
            return this;
        }

        public Builder setConverter(Converter converter) {
            if (converter == null) {
                throw new NullPointerException("Converter may not be null.");
            }
            this.converter = converter;
            return this;
        }

        public Builder setProfiler(Profiler profiler) {
            if (profiler == null) {
                throw new NullPointerException("Profiler may not be null.");
            }
            this.profiler = profiler;
            return this;
        }

        public Builder setErrorHandler(ErrorHandler errorHandler) {
            if (errorHandler == null) {
                throw new NullPointerException("Error handler may not be null.");
            }
            this.errorHandler = errorHandler;
            return this;
        }

        public Builder setLog(Log log) {
            if (log == null) {
                throw new NullPointerException("Log may not be null.");
            }
            this.log = log;
            return this;
        }

        public Builder setLogLevel(LogLevel logLevel) {
            if (logLevel == null) {
                throw new NullPointerException("Log level may not be null.");
            }
            this.logLevel = logLevel;
            return this;
        }

        public RestAdapter build() {
            if (this.server == null) {
                throw new IllegalArgumentException("Server may not be null.");
            }
            this.ensureSaneDefaults();
            return new RestAdapter(this.server, this.clientProvider, this.httpExecutor, this.callbackExecutor, this.requestInterceptor, this.converter, this.profiler, this.errorHandler, this.log, this.logLevel);
        }

        private void ensureSaneDefaults() {
            if (this.converter == null) {
                this.converter = Platform.get().defaultConverter();
            }
            if (this.clientProvider == null) {
                this.clientProvider = Platform.get().defaultClient();
            }
            if (this.httpExecutor == null) {
                this.httpExecutor = Platform.get().defaultHttpExecutor();
            }
            if (this.callbackExecutor == null) {
                this.callbackExecutor = Platform.get().defaultCallbackExecutor();
            }
            if (this.errorHandler == null) {
                this.errorHandler = ErrorHandler.DEFAULT;
            }
            if (this.log == null) {
                this.log = Platform.get().defaultLog();
            }
            if (this.requestInterceptor == null) {
                this.requestInterceptor = RequestInterceptor.NONE;
            }
        }
    }

    private class RestHandler
    implements InvocationHandler {
        private final Map<Method, RestMethodInfo> methodDetailsCache = new LinkedHashMap<Method, RestMethodInfo>();

        private RestHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, final Object[] args) throws Throwable {
            RestMethodInfo methodDetails;
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke((Object)this, args);
            }
            Map<Method, RestMethodInfo> map = this.methodDetailsCache;
            synchronized (map) {
                RestMethodInfo tempMethodDetails = this.methodDetailsCache.get(method);
                if (tempMethodDetails == null) {
                    tempMethodDetails = new RestMethodInfo(method);
                    this.methodDetailsCache.put(method, tempMethodDetails);
                }
                methodDetails = tempMethodDetails;
            }
            if (methodDetails.isSynchronous) {
                try {
                    return this.invokeRequest(RestAdapter.this.requestInterceptor, methodDetails, args);
                }
                catch (RetrofitError error) {
                    Throwable newError = RestAdapter.this.errorHandler.handleError(error);
                    if (newError == null) {
                        throw new IllegalStateException("Error handler returned null for wrapped exception.", error);
                    }
                    throw newError;
                }
            }
            if (RestAdapter.this.httpExecutor == null || RestAdapter.this.callbackExecutor == null) {
                throw new IllegalStateException("Asynchronous invocation requires calling setExecutors.");
            }
            final RequestInterceptorTape interceptorTape = new RequestInterceptorTape();
            RestAdapter.this.requestInterceptor.intercept(interceptorTape);
            Callback callback = (Callback)args[args.length - 1];
            RestAdapter.this.httpExecutor.execute(new CallbackRunnable(callback, RestAdapter.this.callbackExecutor){

                @Override
                public ResponseWrapper obtainResponse() {
                    return (ResponseWrapper)RestHandler.this.invokeRequest(interceptorTape, methodDetails, args);
                }
            });
            return null;
        }

        /*
         * Exception decompiling
         */
        private Object invokeRequest(RequestInterceptor requestInterceptor, RestMethodInfo methodDetails, Object[] args) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 7[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static enum LogLevel {
        NONE,
        BASIC,
        HEADERS,
        FULL;


        public boolean log() {
            return this != NONE;
        }
    }

    public static interface Log {
        public static final Log NONE = new Log(){

            @Override
            public void log(String message) {
            }
        };

        public void log(String var1);
    }
}

