/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import retrofit.RequestInterceptor;
import retrofit.RestMethodInfo;
import retrofit.client.Header;
import retrofit.client.Request;
import retrofit.converter.Converter;
import retrofit.mime.FormUrlEncodedTypedOutput;
import retrofit.mime.MultipartTypedOutput;
import retrofit.mime.TypedOutput;
import retrofit.mime.TypedString;

final class RequestBuilder
implements RequestInterceptor.RequestFacade {
    private final Converter converter;
    private final List<Header> headers;
    private final StringBuilder queryParams;
    private final String[] paramNames;
    private final RestMethodInfo.ParamUsage[] paramUsages;
    private final String requestMethod;
    private final boolean isSynchronous;
    private final FormUrlEncodedTypedOutput formBody;
    private final MultipartTypedOutput multipartBody;
    private TypedOutput body;
    private String relativeUrl;
    private String apiUrl;

    RequestBuilder(Converter converter, RestMethodInfo methodInfo) {
        this.converter = converter;
        this.paramNames = methodInfo.requestParamNames;
        this.paramUsages = methodInfo.requestParamUsage;
        this.requestMethod = methodInfo.requestMethod;
        this.isSynchronous = methodInfo.isSynchronous;
        this.headers = new ArrayList<Header>();
        if (methodInfo.headers != null) {
            this.headers.addAll(methodInfo.headers);
        }
        this.queryParams = new StringBuilder();
        this.relativeUrl = methodInfo.requestUrl;
        String requestQuery = methodInfo.requestQuery;
        if (requestQuery != null) {
            this.queryParams.append('?').append(requestQuery);
        }
        switch (methodInfo.requestType) {
            case FORM_URL_ENCODED: {
                this.formBody = new FormUrlEncodedTypedOutput();
                this.multipartBody = null;
                this.body = this.formBody;
                break;
            }
            case MULTIPART: {
                this.formBody = null;
                this.multipartBody = new MultipartTypedOutput();
                this.body = this.multipartBody;
                break;
            }
            case SIMPLE: {
                this.formBody = null;
                this.multipartBody = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown request type: " + (Object)((Object)methodInfo.requestType));
            }
        }
    }

    void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    @Override
    public void addHeader(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Header name must not be null.");
        }
        this.headers.add(new Header(name, value));
    }

    @Override
    public void addPathParam(String name, String value) {
        this.addPathParam(name, value, true);
    }

    @Override
    public void addEncodedPathParam(String name, String value) {
        this.addPathParam(name, value, false);
    }

    void addPathParam(String name, String value, boolean urlEncodeValue) {
        if (name == null) {
            throw new IllegalArgumentException("Path replacement name must not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Path replacement \"" + name + "\" value must not be null.");
        }
        try {
            if (urlEncodeValue) {
                String encodedValue = URLEncoder.encode(String.valueOf(value), "UTF-8");
                encodedValue = encodedValue.replace("+", "%20");
                this.relativeUrl = this.relativeUrl.replace("{" + name + "}", encodedValue);
            } else {
                this.relativeUrl = this.relativeUrl.replace("{" + name + "}", String.valueOf(value));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unable to convert path parameter \"" + name + "\" value to UTF-8:" + value, e);
        }
    }

    @Override
    public void addQueryParam(String name, String value) {
        this.addQueryParam(name, value, true);
    }

    @Override
    public void addEncodedQueryParam(String name, String value) {
        this.addQueryParam(name, value, false);
    }

    void addQueryParam(String name, String value, boolean urlEncodeValue) {
        if (name == null) {
            throw new IllegalArgumentException("Query param name must not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Query param \"" + name + "\" value must not be null.");
        }
        try {
            StringBuilder queryParams;
            if (urlEncodeValue) {
                value = URLEncoder.encode(String.valueOf(value), "UTF-8");
            }
            queryParams.append((queryParams = this.queryParams).length() > 0 ? (char)'&' : '?');
            queryParams.append(name).append('=').append(value);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unable to convert query parameter \"" + name + "\" value to UTF-8: " + value, e);
        }
    }

    void setArguments(Object[] args) {
        if (args == null) {
            return;
        }
        int count = args.length;
        if (!this.isSynchronous) {
            --count;
        }
        block10: for (int i = 0; i < count; ++i) {
            String name = this.paramNames[i];
            Object value = args[i];
            RestMethodInfo.ParamUsage paramUsage = this.paramUsages[i];
            switch (paramUsage) {
                case PATH: {
                    if (value == null) {
                        throw new IllegalArgumentException("Path parameter \"" + name + "\" value must not be null.");
                    }
                    this.addPathParam(name, value.toString());
                    continue block10;
                }
                case ENCODED_PATH: {
                    if (value == null) {
                        throw new IllegalArgumentException("Path parameter \"" + name + "\" value must not be null.");
                    }
                    this.addEncodedPathParam(name, value.toString());
                    continue block10;
                }
                case QUERY: {
                    if (value == null) continue block10;
                    this.addQueryParam(name, value.toString());
                    continue block10;
                }
                case ENCODED_QUERY: {
                    if (value == null) continue block10;
                    this.addEncodedQueryParam(name, value.toString());
                    continue block10;
                }
                case HEADER: {
                    if (value == null) continue block10;
                    this.addHeader(name, value.toString());
                    continue block10;
                }
                case FIELD: {
                    if (value == null) continue block10;
                    this.formBody.addField(name, value.toString());
                    continue block10;
                }
                case PART: {
                    if (value == null) continue block10;
                    if (value instanceof TypedOutput) {
                        this.multipartBody.addPart(name, (TypedOutput)value);
                        continue block10;
                    }
                    if (value instanceof String) {
                        this.multipartBody.addPart(name, new TypedString((String)value));
                        continue block10;
                    }
                    this.multipartBody.addPart(name, this.converter.toBody(value));
                    continue block10;
                }
                case BODY: {
                    if (value == null) {
                        throw new IllegalArgumentException("Body parameter value must not be null.");
                    }
                    if (value instanceof TypedOutput) {
                        this.body = (TypedOutput)value;
                        continue block10;
                    }
                    this.body = this.converter.toBody(value);
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("Unknown parameter usage: " + (Object)((Object)paramUsage));
                }
            }
        }
    }

    Request build() throws UnsupportedEncodingException {
        String apiUrl = this.apiUrl;
        StringBuilder url = new StringBuilder(apiUrl);
        if (apiUrl.endsWith("/")) {
            url.deleteCharAt(url.length() - 1);
        }
        url.append(this.relativeUrl);
        StringBuilder queryParams = this.queryParams;
        if (queryParams.length() > 0) {
            url.append((CharSequence)queryParams);
        }
        if (this.multipartBody != null && this.multipartBody.getPartCount() == 0) {
            throw new IllegalStateException("Multipart requests must contain at least one part.");
        }
        return new Request(this.requestMethod, url.toString(), this.headers, this.body);
    }
}

