/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.loaderex;

import android.content.Context;
import java.io.File;
import java.io.IOException;
import net.sqlcipher.database.SQLiteDatabase;

public class SQLCipherUtils {
    public static State getDatabaseState(Context context, String dbName) {
        File dbPath = context.getDatabasePath(dbName);
        if (dbPath.exists()) {
            SQLiteDatabase db = null;
            try {
                db = SQLiteDatabase.openDatabase((String)dbPath.getAbsolutePath(), (String)"", null, (int)1);
                db.getVersion();
                State state = State.UNENCRYPTED;
                return state;
            }
            catch (Exception e) {
                State state = State.ENCRYPTED;
                return state;
            }
            finally {
                if (db != null) {
                    db.close();
                }
            }
        }
        return State.DOES_NOT_EXIST;
    }

    public static void encrypt(Context ctxt, String dbName, String passphrase) throws IOException {
        File originalFile = ctxt.getDatabasePath(dbName);
        if (originalFile.exists()) {
            File newFile = File.createTempFile("sqlcipherutils", "tmp", ctxt.getCacheDir());
            SQLiteDatabase db = SQLiteDatabase.openDatabase((String)originalFile.getAbsolutePath(), (String)"", null, (int)0);
            db.rawExecSQL(String.format("ATTACH DATABASE '%s' AS encrypted KEY '%s';", newFile.getAbsolutePath(), passphrase));
            db.rawExecSQL("SELECT sqlcipher_export('encrypted')");
            db.rawExecSQL("DETACH DATABASE encrypted;");
            int version = db.getVersion();
            db.close();
            db = SQLiteDatabase.openDatabase((String)newFile.getAbsolutePath(), (String)passphrase, null, (int)0);
            db.setVersion(version);
            db.close();
            originalFile.delete();
            newFile.renameTo(originalFile);
        }
    }

    public static enum State {
        DOES_NOT_EXIST,
        UNENCRYPTED,
        ENCRYPTED,
        UNKNOWN;

    }
}

