/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import android.os.Build;
import android.os.Process;
import android.util.Log;
import com.google.gson.Gson;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import retrofit.RestAdapter;
import retrofit.Utils;
import retrofit.android.AndroidApacheClient;
import retrofit.android.MainThreadExecutor;
import retrofit.client.Client;
import retrofit.client.OkClient;
import retrofit.client.UrlConnectionClient;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;

abstract class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();

    Platform() {
    }

    static Platform get() {
        return PLATFORM;
    }

    private static Platform findPlatform() {
        try {
            Class.forName("android.os.Build");
            if (Build.VERSION.SDK_INT != 0) {
                return new Android();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return new Base();
    }

    abstract Converter defaultConverter();

    abstract Client.Provider defaultClient();

    abstract Executor defaultHttpExecutor();

    abstract Executor defaultCallbackExecutor();

    abstract RestAdapter.Log defaultLog();

    private static boolean hasOkHttpOnClasspath() {
        try {
            Class.forName("com.squareup.okhttp.OkHttpClient");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static class OkClientInstantiator {
        private OkClientInstantiator() {
        }

        static Client instantiate() {
            return new OkClient();
        }
    }

    private static class Android
    extends Platform {
        private Android() {
        }

        @Override
        Converter defaultConverter() {
            return new GsonConverter(new Gson());
        }

        @Override
        Client.Provider defaultClient() {
            final Client client = Platform.hasOkHttpOnClasspath() ? OkClientInstantiator.instantiate() : (Build.VERSION.SDK_INT < 9 ? new AndroidApacheClient() : new UrlConnectionClient());
            return new Client.Provider(){

                @Override
                public Client get() {
                    return client;
                }
            };
        }

        @Override
        Executor defaultHttpExecutor() {
            return Executors.newCachedThreadPool(new ThreadFactory(){

                @Override
                public Thread newThread(final Runnable r) {
                    return new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Process.setThreadPriority((int)10);
                            r.run();
                        }
                    }, "Retrofit-Idle");
                }
            });
        }

        @Override
        Executor defaultCallbackExecutor() {
            return new MainThreadExecutor();
        }

        @Override
        RestAdapter.Log defaultLog() {
            return new RestAdapter.Log(){

                @Override
                public void log(String message) {
                    Log.d((String)"Retrofit", (String)message);
                }
            };
        }
    }

    private static class Base
    extends Platform {
        private Base() {
        }

        @Override
        Converter defaultConverter() {
            return new GsonConverter(new Gson());
        }

        @Override
        Client.Provider defaultClient() {
            final Client client = Platform.hasOkHttpOnClasspath() ? OkClientInstantiator.instantiate() : new UrlConnectionClient();
            return new Client.Provider(){

                @Override
                public Client get() {
                    return client;
                }
            };
        }

        @Override
        Executor defaultHttpExecutor() {
            return Executors.newCachedThreadPool(new ThreadFactory(){

                @Override
                public Thread newThread(final Runnable r) {
                    return new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Thread.currentThread().setPriority(1);
                            r.run();
                        }
                    }, "Retrofit-Idle");
                }
            });
        }

        @Override
        Executor defaultCallbackExecutor() {
            return new Utils.SynchronousExecutor();
        }

        @Override
        RestAdapter.Log defaultLog() {
            return new RestAdapter.Log(){

                @Override
                public void log(String message) {
                    System.out.println(message);
                }
            };
        }
    }
}

