/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.wakeful;

import android.app.AlarmManager;
import android.app.IntentService;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.PowerManager;
import com.commonsware.cwac.wakeful.AlarmReceiver;

public abstract class WakefulIntentService
extends IntentService {
    static final String NAME = "com.commonsware.cwac.wakeful.WakefulIntentService";
    static final String LAST_ALARM = "lastAlarm";
    private static volatile PowerManager.WakeLock lockStatic = null;

    protected abstract void doWakefulWork(Intent var1);

    private static synchronized PowerManager.WakeLock getLock(Context context) {
        if (lockStatic == null) {
            PowerManager mgr = (PowerManager)context.getSystemService("power");
            lockStatic = mgr.newWakeLock(1, NAME);
            lockStatic.setReferenceCounted(true);
        }
        return lockStatic;
    }

    public static void sendWakefulWork(Context ctxt, Intent i) {
        WakefulIntentService.getLock(ctxt.getApplicationContext()).acquire();
        ctxt.startService(i);
    }

    public static void sendWakefulWork(Context ctxt, Class<?> clsService) {
        WakefulIntentService.sendWakefulWork(ctxt, new Intent(ctxt, clsService));
    }

    public static void scheduleAlarms(AlarmListener listener, Context ctxt) {
        WakefulIntentService.scheduleAlarms(listener, ctxt, true);
    }

    public static void scheduleAlarms(AlarmListener listener, Context ctxt, boolean force) {
        SharedPreferences prefs = ctxt.getSharedPreferences(NAME, 0);
        long lastAlarm = prefs.getLong(LAST_ALARM, 0L);
        if (lastAlarm == 0L || force || System.currentTimeMillis() > lastAlarm && System.currentTimeMillis() - lastAlarm > listener.getMaxAge()) {
            AlarmManager mgr = (AlarmManager)ctxt.getSystemService("alarm");
            Intent i = new Intent(ctxt, AlarmReceiver.class);
            PendingIntent pi = PendingIntent.getBroadcast((Context)ctxt, (int)0, (Intent)i, (int)0);
            listener.scheduleAlarms(mgr, pi, ctxt);
        }
    }

    public static void cancelAlarms(Context ctxt) {
        AlarmManager mgr = (AlarmManager)ctxt.getSystemService("alarm");
        Intent i = new Intent(ctxt, AlarmReceiver.class);
        PendingIntent pi = PendingIntent.getBroadcast((Context)ctxt, (int)0, (Intent)i, (int)0);
        mgr.cancel(pi);
    }

    public WakefulIntentService(String name) {
        super(name);
        this.setIntentRedelivery(true);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        PowerManager.WakeLock lock = WakefulIntentService.getLock(this.getApplicationContext());
        if (!lock.isHeld() || (flags & 1) != 0) {
            lock.acquire();
        }
        super.onStartCommand(intent, flags, startId);
        return 3;
    }

    protected final void onHandleIntent(Intent intent) {
        try {
            this.doWakefulWork(intent);
        }
        finally {
            PowerManager.WakeLock lock = WakefulIntentService.getLock(this.getApplicationContext());
            if (lock.isHeld()) {
                lock.release();
            }
        }
    }

    public static interface AlarmListener {
        public void scheduleAlarms(AlarmManager var1, PendingIntent var2, Context var3);

        public void sendWakefulWork(Context var1);

        public long getMaxAge();
    }
}

