/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.loaderex;

import android.content.ContentValues;
import android.content.Context;
import android.content.Loader;
import android.database.Cursor;
import android.database.sqlite.SQLiteOpenHelper;
import com.commonsware.cwac.loaderex.AbstractCursorLoader;
import com.commonsware.cwac.loaderex.ContentChangingTask;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Arrays;

public class SQLiteCursorLoader
extends AbstractCursorLoader {
    SQLiteOpenHelper db = null;
    String rawQuery = null;
    String[] args = null;

    public SQLiteCursorLoader(Context context, SQLiteOpenHelper db, String rawQuery, String[] args) {
        super(context);
        this.db = db;
        this.rawQuery = rawQuery;
        this.args = args;
    }

    @Override
    protected Cursor buildCursor() {
        return this.db.getReadableDatabase().rawQuery(this.rawQuery, this.args);
    }

    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        super.dump(prefix, fd, writer, args);
        writer.print(prefix);
        writer.print("rawQuery=");
        writer.println(this.rawQuery);
        writer.print(prefix);
        writer.print("args=");
        writer.println(Arrays.toString(args));
    }

    public void insert(String table, String nullColumnHack, ContentValues values) {
        new InsertTask(this).execute(new Object[]{this.db, table, nullColumnHack, values});
    }

    public void update(String table, ContentValues values, String whereClause, String[] whereArgs) {
        new UpdateTask(this).execute(new Object[]{this.db, table, values, whereClause, whereArgs});
    }

    public void replace(String table, String nullColumnHack, ContentValues values) {
        new ReplaceTask(this).execute(new Object[]{this.db, table, nullColumnHack, values});
    }

    public void delete(String table, String whereClause, String[] whereArgs) {
        new DeleteTask(this).execute(new Object[]{this.db, table, whereClause, whereArgs});
    }

    public void execSQL(String sql, Object[] bindArgs) {
        new ExecSQLTask(this).execute(new Object[]{this.db, sql, bindArgs});
    }

    private class DeleteTask
    extends ContentChangingTask<Object, Void, Void> {
        DeleteTask(SQLiteCursorLoader loader) {
            super((Loader<?>)loader);
        }

        protected Void doInBackground(Object ... params) {
            SQLiteOpenHelper db = (SQLiteOpenHelper)params[0];
            String table = (String)params[1];
            String where = (String)params[2];
            String[] whereParams = (String[])params[3];
            db.getWritableDatabase().delete(table, where, whereParams);
            return null;
        }
    }

    private class ExecSQLTask
    extends ContentChangingTask<Object, Void, Void> {
        ExecSQLTask(SQLiteCursorLoader loader) {
            super((Loader<?>)loader);
        }

        protected Void doInBackground(Object ... params) {
            SQLiteOpenHelper db = (SQLiteOpenHelper)params[0];
            String sql = (String)params[1];
            Object[] bindParams = (Object[])params[2];
            db.getWritableDatabase().execSQL(sql, bindParams);
            return null;
        }
    }

    private class InsertTask
    extends ContentChangingTask<Object, Void, Void> {
        InsertTask(SQLiteCursorLoader loader) {
            super((Loader<?>)loader);
        }

        protected Void doInBackground(Object ... params) {
            SQLiteOpenHelper db = (SQLiteOpenHelper)params[0];
            String table = (String)params[1];
            String nullColumnHack = (String)params[2];
            ContentValues values = (ContentValues)params[3];
            db.getWritableDatabase().insert(table, nullColumnHack, values);
            return null;
        }
    }

    private class ReplaceTask
    extends ContentChangingTask<Object, Void, Void> {
        ReplaceTask(SQLiteCursorLoader loader) {
            super((Loader<?>)loader);
        }

        protected Void doInBackground(Object ... params) {
            SQLiteOpenHelper db = (SQLiteOpenHelper)params[0];
            String table = (String)params[1];
            String nullColumnHack = (String)params[2];
            ContentValues values = (ContentValues)params[3];
            db.getWritableDatabase().replace(table, nullColumnHack, values);
            return null;
        }
    }

    private class UpdateTask
    extends ContentChangingTask<Object, Void, Void> {
        UpdateTask(SQLiteCursorLoader loader) {
            super((Loader<?>)loader);
        }

        protected Void doInBackground(Object ... params) {
            SQLiteOpenHelper db = (SQLiteOpenHelper)params[0];
            String table = (String)params[1];
            ContentValues values = (ContentValues)params[2];
            String where = (String)params[3];
            String[] whereParams = (String[])params[4];
            db.getWritableDatabase().update(table, values, where, whereParams);
            return null;
        }
    }
}

