/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap;

import android.content.ContentResolver;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import com.phonegap.api.PhonegapActivity;
import com.phonegap.api.Plugin;
import com.phonegap.api.PluginResult;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Device
extends Plugin {
    public static String phonegapVersion = "0.9.4";
    public static String platform = "Android";
    public static String uuid;

    public void setContext(PhonegapActivity ctx) {
        super.setContext(ctx);
        uuid = this.getUuid();
    }

    public PluginResult execute(String action, JSONArray args, String callbackId) {
        PluginResult.Status status = PluginResult.Status.OK;
        String result = "";
        try {
            if (action.equals("getDeviceInfo")) {
                JSONObject r = new JSONObject();
                r.put("uuid", (Object)uuid);
                r.put("version", (Object)this.getOSVersion());
                r.put("platform", (Object)platform);
                r.put("name", (Object)this.getProductName());
                r.put("phonegap", (Object)phonegapVersion);
                return new PluginResult(status, r);
            }
            return new PluginResult(status, result);
        }
        catch (JSONException e) {
            return new PluginResult(PluginResult.Status.JSON_EXCEPTION);
        }
    }

    public boolean isSynch(String action) {
        return action.equals("getDeviceInfo");
    }

    public String getPlatform() {
        return platform;
    }

    public String getUuid() {
        String uuid = Settings.Secure.getString((ContentResolver)this.ctx.getContentResolver(), (String)"android_id");
        return uuid;
    }

    public String getPhonegapVersion() {
        return phonegapVersion;
    }

    public String getLine1Number() {
        TelephonyManager operator = (TelephonyManager)this.ctx.getSystemService("phone");
        return operator.getLine1Number();
    }

    public String getDeviceId() {
        TelephonyManager operator = (TelephonyManager)this.ctx.getSystemService("phone");
        return operator.getDeviceId();
    }

    public String getSimSerialNumber() {
        TelephonyManager operator = (TelephonyManager)this.ctx.getSystemService("phone");
        return operator.getSimSerialNumber();
    }

    public String getSubscriberId() {
        TelephonyManager operator = (TelephonyManager)this.ctx.getSystemService("phone");
        return operator.getSubscriberId();
    }

    public String getModel() {
        String model = Build.MODEL;
        return model;
    }

    public String getProductName() {
        String productname = Build.PRODUCT;
        return productname;
    }

    public String getOSVersion() {
        String osversion = Build.VERSION.RELEASE;
        return osversion;
    }

    public String getSDKVersion() {
        String sdkversion = Build.VERSION.SDK;
        return sdkversion;
    }

    public String getTimeZoneID() {
        TimeZone tz = TimeZone.getDefault();
        return tz.getID();
    }
}

