/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xmlimpl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.xmlimpl.XML;
import org.mozilla.javascript.xmlimpl.XMLList;
import org.mozilla.javascript.xmlimpl.XMLName;
import org.mozilla.javascript.xmlimpl.XmlProcessor;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;
import org.xml.sax.SAXException;

class XmlNode
implements Serializable {
    private static final String XML_NAMESPACES_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
    private static final String USER_DATA_XMLNODE_KEY = XmlNode.class.getName();
    private static final boolean DOM_LEVEL_3 = true;
    private static final long serialVersionUID = 1L;
    private UserDataHandler events = new XmlNodeUserDataHandler();
    private Node dom;
    private XML xml;

    private static XmlNode getUserData(Node node) {
        return (XmlNode)node.getUserData(USER_DATA_XMLNODE_KEY);
    }

    private static void setUserData(Node node, XmlNode xmlNode) {
        node.setUserData(USER_DATA_XMLNODE_KEY, xmlNode, xmlNode.events);
    }

    private static XmlNode createImpl(Node node) {
        if (node instanceof Document) {
            throw new IllegalArgumentException();
        }
        XmlNode xmlNode = null;
        if (XmlNode.getUserData(node) == null) {
            xmlNode = new XmlNode();
            xmlNode.dom = node;
            XmlNode.setUserData(node, xmlNode);
        } else {
            xmlNode = XmlNode.getUserData(node);
        }
        return xmlNode;
    }

    static XmlNode newElementWithText(XmlProcessor xmlProcessor, XmlNode xmlNode, QName qName, String string) {
        Element element;
        if (xmlNode instanceof Document) {
            throw new IllegalArgumentException("Cannot use Document node as reference");
        }
        Document document = null;
        document = xmlNode != null ? xmlNode.dom.getOwnerDocument() : xmlProcessor.newDocument();
        Node node = xmlNode != null ? xmlNode.dom : null;
        Namespace namespace = qName.getNamespace();
        Element element2 = element = namespace == null || namespace.getUri().length() == 0 ? document.createElementNS(null, qName.getLocalName()) : document.createElementNS(namespace.getUri(), qName.qualify(node));
        if (string != null) {
            element.appendChild(document.createTextNode(string));
        }
        return XmlNode.createImpl(element);
    }

    static XmlNode createText(XmlProcessor xmlProcessor, String string) {
        return XmlNode.createImpl(xmlProcessor.newDocument().createTextNode(string));
    }

    static XmlNode createElementFromNode(Node node) {
        if (node instanceof Document) {
            node = ((Document)node).getDocumentElement();
        }
        return XmlNode.createImpl(node);
    }

    static XmlNode createElement(XmlProcessor xmlProcessor, String string, String string2) throws SAXException {
        return XmlNode.createImpl(xmlProcessor.toXml(string, string2));
    }

    static XmlNode createEmpty(XmlProcessor xmlProcessor) {
        return XmlNode.createText(xmlProcessor, "");
    }

    private static XmlNode copy(XmlNode xmlNode) {
        return XmlNode.createImpl(xmlNode.dom.cloneNode(true));
    }

    private XmlNode() {
    }

    String debug() {
        XmlProcessor xmlProcessor = new XmlProcessor();
        xmlProcessor.setIgnoreComments(false);
        xmlProcessor.setIgnoreProcessingInstructions(false);
        xmlProcessor.setIgnoreWhitespace(false);
        xmlProcessor.setPrettyPrinting(false);
        return xmlProcessor.ecmaToXmlString(this.dom);
    }

    public String toString() {
        return "XmlNode: type=" + this.dom.getNodeType() + " dom=" + this.dom.toString();
    }

    XML getXml() {
        return this.xml;
    }

    void setXml(XML xML) {
        this.xml = xML;
    }

    int getChildCount() {
        return this.dom.getChildNodes().getLength();
    }

    XmlNode parent() {
        Node node = this.dom.getParentNode();
        if (node instanceof Document) {
            return null;
        }
        if (node == null) {
            return null;
        }
        return XmlNode.createImpl(node);
    }

    int getChildIndex() {
        if (this.isAttributeType()) {
            return -1;
        }
        if (this.parent() == null) {
            return -1;
        }
        NodeList nodeList = this.dom.getParentNode().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i) != this.dom) continue;
            return i;
        }
        throw new RuntimeException("Unreachable.");
    }

    void removeChild(int n) {
        this.dom.removeChild(this.dom.getChildNodes().item(n));
    }

    String toXmlString(XmlProcessor xmlProcessor) {
        return xmlProcessor.ecmaToXmlString(this.dom);
    }

    String ecmaValue() {
        if (this.isTextType()) {
            return ((Text)this.dom).getData();
        }
        if (this.isAttributeType()) {
            return ((Attr)this.dom).getValue();
        }
        if (this.isProcessingInstructionType()) {
            return ((ProcessingInstruction)this.dom).getData();
        }
        if (this.isCommentType()) {
            return ((Comment)this.dom).getNodeValue();
        }
        if (this.isElementType()) {
            throw new RuntimeException("Unimplemented ecmaValue() for elements.");
        }
        throw new RuntimeException("Unimplemented for node " + this.dom);
    }

    void deleteMe() {
        if (this.dom instanceof Attr) {
            Attr attr = (Attr)this.dom;
            attr.getOwnerElement().getAttributes().removeNamedItemNS(attr.getNamespaceURI(), attr.getLocalName());
        } else if (this.dom.getParentNode() != null) {
            this.dom.getParentNode().removeChild(this.dom);
        }
    }

    void normalize() {
        this.dom.normalize();
    }

    void insertChildAt(int n, XmlNode xmlNode) {
        Node node = this.dom;
        Node node2 = node.getOwnerDocument().importNode(xmlNode.dom, true);
        if (node.getChildNodes().getLength() < n) {
            throw new IllegalArgumentException("index=" + n + " length=" + node.getChildNodes().getLength());
        }
        if (node.getChildNodes().getLength() == n) {
            node.appendChild(node2);
        } else {
            node.insertBefore(node2, node.getChildNodes().item(n));
        }
    }

    void insertChildrenAt(int n, XmlNode[] xmlNodeArray) {
        for (int i = 0; i < xmlNodeArray.length; ++i) {
            this.insertChildAt(n + i, xmlNodeArray[i]);
        }
    }

    XmlNode getChild(int n) {
        Node node = this.dom.getChildNodes().item(n);
        return XmlNode.createImpl(node);
    }

    boolean hasChildElement() {
        NodeList nodeList = this.dom.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    boolean isSameNode(XmlNode xmlNode) {
        return this.dom == xmlNode.dom;
    }

    private String toUri(String string) {
        return string == null ? "" : string;
    }

    private void addNamespaces(Namespaces namespaces, Element element) {
        if (element == null) {
            throw new RuntimeException("element must not be null");
        }
        String string = this.toUri(element.lookupNamespaceURI(null));
        String string2 = "";
        if (element.getParentNode() != null) {
            string2 = this.toUri(element.getParentNode().lookupNamespaceURI(null));
        }
        if (!string.equals(string2) || !(element.getParentNode() instanceof Element)) {
            namespaces.declare(Namespace.create("", string));
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (attr.getPrefix() == null || !attr.getPrefix().equals("xmlns")) continue;
            namespaces.declare(Namespace.create(attr.getLocalName(), attr.getValue()));
        }
    }

    private Namespaces getAllNamespaces() {
        Namespaces namespaces = new Namespaces();
        Node node = this.dom;
        if (node instanceof Attr) {
            node = ((Attr)node).getOwnerElement();
        }
        while (node != null) {
            if (node instanceof Element) {
                this.addNamespaces(namespaces, (Element)node);
            }
            node = node.getParentNode();
        }
        namespaces.declare(Namespace.create("", ""));
        return namespaces;
    }

    Namespace[] getInScopeNamespaces() {
        Namespaces namespaces = this.getAllNamespaces();
        return namespaces.getNamespaces();
    }

    Namespace[] getNamespaceDeclarations() {
        if (this.dom instanceof Element) {
            Namespaces namespaces = new Namespaces();
            this.addNamespaces(namespaces, (Element)this.dom);
            return namespaces.getNamespaces();
        }
        return new Namespace[0];
    }

    Namespace getNamespaceDeclaration(String string) {
        if (string.equals("") && this.dom instanceof Attr) {
            return Namespace.create("", "");
        }
        Namespaces namespaces = this.getAllNamespaces();
        return namespaces.getNamespace(string);
    }

    Namespace getNamespaceDeclaration() {
        if (this.dom.getPrefix() == null) {
            return this.getNamespaceDeclaration("");
        }
        return this.getNamespaceDeclaration(this.dom.getPrefix());
    }

    final XmlNode copy() {
        return XmlNode.copy(this);
    }

    final boolean isParentType() {
        return this.isElementType();
    }

    final boolean isTextType() {
        return this.dom.getNodeType() == 3 || this.dom.getNodeType() == 4;
    }

    final boolean isAttributeType() {
        return this.dom.getNodeType() == 2;
    }

    final boolean isProcessingInstructionType() {
        return this.dom.getNodeType() == 7;
    }

    final boolean isCommentType() {
        return this.dom.getNodeType() == 8;
    }

    final boolean isElementType() {
        return this.dom.getNodeType() == 1;
    }

    final void renameNode(QName qName) {
        this.dom = this.dom.getOwnerDocument().renameNode(this.dom, qName.getNamespace().getUri(), qName.qualify(this.dom));
    }

    void invalidateNamespacePrefix() {
        if (!(this.dom instanceof Element)) {
            throw new IllegalStateException();
        }
        String string = this.dom.getPrefix();
        QName qName = QName.create(this.dom.getNamespaceURI(), this.dom.getLocalName(), null);
        this.renameNode(qName);
        NamedNodeMap namedNodeMap = this.dom.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            if (!namedNodeMap.item(i).getPrefix().equals(string)) continue;
            XmlNode.createImpl(namedNodeMap.item(i)).renameNode(QName.create(namedNodeMap.item(i).getNamespaceURI(), namedNodeMap.item(i).getLocalName(), null));
        }
    }

    private void declareNamespace(Element element, String string, String string2) {
        if (string.length() > 0) {
            element.setAttributeNS(XML_NAMESPACES_NAMESPACE_URI, "xmlns:" + string, string2);
        } else {
            element.setAttribute("xmlns", string2);
        }
    }

    void declareNamespace(String string, String string2) {
        if (!(this.dom instanceof Element)) {
            throw new IllegalStateException();
        }
        if (this.dom.lookupNamespaceURI(string2) == null || !this.dom.lookupNamespaceURI(string2).equals(string)) {
            Element element = (Element)this.dom;
            this.declareNamespace(element, string, string2);
        }
    }

    private Namespace getDefaultNamespace() {
        String string = "";
        String string2 = this.dom.lookupNamespaceURI(null) == null ? "" : this.dom.lookupNamespaceURI(null);
        return Namespace.create(string, string2);
    }

    private String getExistingPrefixFor(Namespace namespace) {
        if (this.getDefaultNamespace().getUri().equals(namespace.getUri())) {
            return "";
        }
        return this.dom.lookupPrefix(namespace.getUri());
    }

    private Namespace getNodeNamespace() {
        String string = this.dom.getNamespaceURI();
        String string2 = this.dom.getPrefix();
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        return Namespace.create(string2, string);
    }

    Namespace getNamespace() {
        return this.getNodeNamespace();
    }

    void removeNamespace(Namespace namespace) {
        Namespace namespace2 = this.getNodeNamespace();
        if (namespace.is(namespace2)) {
            return;
        }
        NamedNodeMap namedNodeMap = this.dom.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            XmlNode xmlNode = XmlNode.createImpl(namedNodeMap.item(i));
            if (!namespace.is(xmlNode.getNodeNamespace())) continue;
            return;
        }
        String string = this.getExistingPrefixFor(namespace);
        if (string != null) {
            if (namespace.isUnspecifiedPrefix()) {
                this.declareNamespace(string, this.getDefaultNamespace().getUri());
            } else if (string.equals(namespace.getPrefix())) {
                this.declareNamespace(string, this.getDefaultNamespace().getUri());
            }
        }
    }

    private void setProcessingInstructionName(String string) {
        ProcessingInstruction processingInstruction = (ProcessingInstruction)this.dom;
        processingInstruction.getParentNode().replaceChild(processingInstruction, processingInstruction.getOwnerDocument().createProcessingInstruction(string, processingInstruction.getData()));
    }

    final void setLocalName(String string) {
        if (this.dom instanceof ProcessingInstruction) {
            this.setProcessingInstructionName(string);
        } else {
            String string2 = this.dom.getPrefix();
            if (string2 == null) {
                string2 = "";
            }
            this.dom = this.dom.getOwnerDocument().renameNode(this.dom, this.dom.getNamespaceURI(), QName.qualify(string2, string));
        }
    }

    final QName getQname() {
        String string = this.dom.getNamespaceURI() == null ? "" : this.dom.getNamespaceURI();
        String string2 = this.dom.getPrefix() == null ? "" : this.dom.getPrefix();
        return QName.create(string, this.dom.getLocalName(), string2);
    }

    void addMatchingChildren(XMLList xMLList, Filter filter) {
        Node node = this.dom;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            XmlNode xmlNode = XmlNode.createImpl(node2);
            if (!filter.accept(node2)) continue;
            xMLList.addToList(xmlNode);
        }
    }

    XmlNode[] getMatchingChildren(Filter filter) {
        ArrayList<XmlNode> arrayList = new ArrayList<XmlNode>();
        NodeList nodeList = this.dom.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!filter.accept(node)) continue;
            arrayList.add(XmlNode.createImpl(node));
        }
        return arrayList.toArray(new XmlNode[arrayList.size()]);
    }

    XmlNode[] getAttributes() {
        NamedNodeMap namedNodeMap = this.dom.getAttributes();
        if (namedNodeMap == null) {
            throw new IllegalStateException("Must be element.");
        }
        XmlNode[] xmlNodeArray = new XmlNode[namedNodeMap.getLength()];
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            xmlNodeArray[i] = XmlNode.createImpl(namedNodeMap.item(i));
        }
        return xmlNodeArray;
    }

    String getAttributeValue() {
        return ((Attr)this.dom).getValue();
    }

    void setAttribute(QName qName, String string) {
        if (!(this.dom instanceof Element)) {
            throw new IllegalStateException("Can only set attribute on elements.");
        }
        qName.setAttribute((Element)this.dom, string);
    }

    void replaceWith(XmlNode xmlNode) {
        Node node = xmlNode.dom;
        if (node.getOwnerDocument() != this.dom.getOwnerDocument()) {
            node = this.dom.getOwnerDocument().importNode(node, true);
        }
        this.dom.getParentNode().replaceChild(node, this.dom);
    }

    String ecmaToXMLString(XmlProcessor xmlProcessor) {
        if (this.isElementType()) {
            Element element = (Element)this.dom.cloneNode(true);
            Namespace[] namespaceArray = this.getInScopeNamespaces();
            for (int i = 0; i < namespaceArray.length; ++i) {
                this.declareNamespace(element, namespaceArray[i].getPrefix(), namespaceArray[i].getUri());
            }
            return xmlProcessor.ecmaToXmlString(element);
        }
        return xmlProcessor.ecmaToXmlString(this.dom);
    }

    Node toDomNode() {
        return this.dom;
    }

    static abstract class Filter {
        static final Filter COMMENT = new Filter(){

            boolean accept(Node node) {
                return node.getNodeType() == 8;
            }
        };
        static final Filter TEXT = new Filter(){

            boolean accept(Node node) {
                return node.getNodeType() == 3;
            }
        };
        static Filter ELEMENT = new Filter(){

            boolean accept(Node node) {
                return node.getNodeType() == 1;
            }
        };
        static Filter TRUE = new Filter(){

            boolean accept(Node node) {
                return true;
            }
        };

        Filter() {
        }

        static Filter PROCESSING_INSTRUCTION(final XMLName xMLName) {
            return new Filter(){

                boolean accept(Node node) {
                    if (node.getNodeType() == 7) {
                        ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                        return xMLName.matchesLocalName(processingInstruction.getTarget());
                    }
                    return false;
                }
            };
        }

        abstract boolean accept(Node var1);
    }

    static class InternalList
    implements Serializable {
        private static final long serialVersionUID = -3633151157292048978L;
        private List<XmlNode> list = new ArrayList<XmlNode>();

        InternalList() {
        }

        private void _add(XmlNode xmlNode) {
            this.list.add(xmlNode);
        }

        XmlNode item(int n) {
            return this.list.get(n);
        }

        void remove(int n) {
            this.list.remove(n);
        }

        void add(InternalList internalList) {
            for (int i = 0; i < internalList.length(); ++i) {
                this._add(internalList.item(i));
            }
        }

        void add(InternalList internalList, int n, int n2) {
            for (int i = n; i < n2; ++i) {
                this._add(internalList.item(i));
            }
        }

        void add(XmlNode xmlNode) {
            this._add(xmlNode);
        }

        void add(XML xML) {
            this._add(xML.getAnnotation());
        }

        void addToList(Object object) {
            if (object instanceof Undefined) {
                return;
            }
            if (object instanceof XMLList) {
                XMLList xMLList = (XMLList)object;
                for (int i = 0; i < xMLList.length(); ++i) {
                    this._add(xMLList.item(i).getAnnotation());
                }
            } else if (object instanceof XML) {
                this._add(((XML)object).getAnnotation());
            } else if (object instanceof XmlNode) {
                this._add((XmlNode)object);
            }
        }

        int length() {
            return this.list.size();
        }
    }

    static class QName
    implements Serializable {
        private static final long serialVersionUID = -6587069811691451077L;
        private Namespace namespace;
        private String localName;

        static QName create(Namespace namespace, String string) {
            if (string != null && string.equals("*")) {
                throw new RuntimeException("* is not valid localName");
            }
            QName qName = new QName();
            qName.namespace = namespace;
            qName.localName = string;
            return qName;
        }

        static QName create(String string, String string2, String string3) {
            return QName.create(Namespace.create(string3, string), string2);
        }

        static String qualify(String string, String string2) {
            if (string == null) {
                throw new IllegalArgumentException("prefix must not be null");
            }
            if (string.length() > 0) {
                return string + ":" + string2;
            }
            return string2;
        }

        private QName() {
        }

        public String toString() {
            return "XmlNode.QName [" + this.localName + "," + this.namespace + "]";
        }

        private boolean equals(String string, String string2) {
            if (string == null && string2 == null) {
                return true;
            }
            if (string == null || string2 == null) {
                return false;
            }
            return string.equals(string2);
        }

        private boolean namespacesEqual(Namespace namespace, Namespace namespace2) {
            if (namespace == null && namespace2 == null) {
                return true;
            }
            if (namespace == null || namespace2 == null) {
                return false;
            }
            return this.equals(namespace.getUri(), namespace2.getUri());
        }

        final boolean isEqualTo(QName qName) {
            if (!this.namespacesEqual(this.namespace, qName.namespace)) {
                return false;
            }
            return this.equals(this.localName, qName.localName);
        }

        void lookupPrefix(Node node) {
            String string;
            if (node == null) {
                throw new IllegalArgumentException("node must not be null");
            }
            String string2 = node.lookupPrefix(this.namespace.getUri());
            if (string2 == null) {
                String string3 = node.lookupNamespaceURI(null);
                if (string3 == null) {
                    string3 = "";
                }
                if ((string = this.namespace.getUri()).equals(string3)) {
                    string2 = "";
                }
            }
            int n = 0;
            while (string2 == null) {
                string = "e4x_" + n++;
                String string4 = node.lookupNamespaceURI(string);
                if (string4 != null) continue;
                string2 = string;
                Node node2 = node;
                while (node2.getParentNode() != null && node2.getParentNode() instanceof Element) {
                    node2 = node2.getParentNode();
                }
                ((Element)node2).setAttributeNS(XmlNode.XML_NAMESPACES_NAMESPACE_URI, "xmlns:" + string2, this.namespace.getUri());
            }
            this.namespace.setPrefix(string2);
        }

        String qualify(Node node) {
            if (this.namespace.getPrefix() == null) {
                if (node != null) {
                    this.lookupPrefix(node);
                } else if (this.namespace.getUri().equals("")) {
                    this.namespace.setPrefix("");
                } else {
                    this.namespace.setPrefix("");
                }
            }
            return QName.qualify(this.namespace.getPrefix(), this.localName);
        }

        void setAttribute(Element element, String string) {
            if (this.namespace.getPrefix() == null) {
                this.lookupPrefix(element);
            }
            element.setAttributeNS(this.namespace.getUri(), QName.qualify(this.namespace.getPrefix(), this.localName), string);
        }

        Namespace getNamespace() {
            return this.namespace;
        }

        String getLocalName() {
            return this.localName;
        }
    }

    static class Namespace
    implements Serializable {
        private static final long serialVersionUID = 4073904386884677090L;
        static final Namespace GLOBAL = Namespace.create("", "");
        private String prefix;
        private String uri;

        static Namespace create(String string, String string2) {
            if (string == null) {
                throw new IllegalArgumentException("Empty string represents default namespace prefix");
            }
            if (string2 == null) {
                throw new IllegalArgumentException("Namespace may not lack a URI");
            }
            Namespace namespace = new Namespace();
            namespace.prefix = string;
            namespace.uri = string2;
            return namespace;
        }

        static Namespace create(String string) {
            Namespace namespace = new Namespace();
            namespace.uri = string;
            return namespace;
        }

        private Namespace() {
        }

        public String toString() {
            if (this.prefix == null) {
                return "XmlNode.Namespace [" + this.uri + "]";
            }
            return "XmlNode.Namespace [" + this.prefix + "{" + this.uri + "}]";
        }

        boolean isUnspecifiedPrefix() {
            return this.prefix == null;
        }

        boolean is(Namespace namespace) {
            return this.prefix != null && namespace.prefix != null && this.prefix.equals(namespace.prefix) && this.uri.equals(namespace.uri);
        }

        boolean isEmpty() {
            return this.prefix != null && this.prefix.equals("") && this.uri.equals("");
        }

        boolean isDefault() {
            return this.prefix != null && this.prefix.equals("");
        }

        boolean isGlobal() {
            return this.uri != null && this.uri.equals("");
        }

        private void setPrefix(String string) {
            if (string == null) {
                throw new IllegalArgumentException();
            }
            this.prefix = string;
        }

        String getPrefix() {
            return this.prefix;
        }

        String getUri() {
            return this.uri;
        }
    }

    private static class Namespaces {
        private Map<String, String> map = new HashMap<String, String>();
        private Map<String, String> uriToPrefix = new HashMap<String, String>();

        Namespaces() {
        }

        void declare(Namespace namespace) {
            if (this.map.get(namespace.prefix) == null) {
                this.map.put(namespace.prefix, namespace.uri);
            }
            if (this.uriToPrefix.get(namespace.uri) == null) {
                this.uriToPrefix.put(namespace.uri, namespace.prefix);
            }
        }

        Namespace getNamespaceByUri(String string) {
            if (this.uriToPrefix.get(string) == null) {
                return null;
            }
            return Namespace.create(string, this.uriToPrefix.get(string));
        }

        Namespace getNamespace(String string) {
            if (this.map.get(string) == null) {
                return null;
            }
            return Namespace.create(string, this.map.get(string));
        }

        Namespace[] getNamespaces() {
            ArrayList<Namespace> arrayList = new ArrayList<Namespace>();
            for (String string : this.map.keySet()) {
                String string2;
                Namespace namespace = Namespace.create(string, string2 = this.map.get(string));
                if (namespace.isEmpty()) continue;
                arrayList.add(namespace);
            }
            return arrayList.toArray(new Namespace[arrayList.size()]);
        }
    }

    static class XmlNodeUserDataHandler
    implements UserDataHandler,
    Serializable {
        private static final long serialVersionUID = 4666895518900769588L;

        XmlNodeUserDataHandler() {
        }

        public void handle(short s, String string, Object object, Node node, Node node2) {
        }
    }
}

