/// Generates the root file output of the macro MacroName



void makerootfile(const char *MacroName, const char *IN, const char *OutDir, bool cp, bool py)
{

   // Execute the macro as a C++ one or a Python one.
   if (!py) gROOT->ProcessLine(Form(".x %s",MacroName));
   else     gROOT->ProcessLine(Form("TPython::ExecScript(\"%s\");",MacroName));

   // If needed, copy the macro in the documentation directory.
   if (cp) {
      TString MN = MacroName;
      Int_t i = MN.Index("(");
      Int_t l = MN.Length();
      if (i>0) MN.Remove(i, l);
      gSystem->Exec(TString::Format("cp %s %s/macros", MN.Data(), OutDir));
   }

   // Iterate over all the pads generated by the macro and produce the corresponding pictures.
   TIter iCanvas(gROOT->GetListOfCanvases());
   TCanvas* canvas = 0;
   int ImageNum = 0;

   auto f = new TFile( TString::Format("%s/html/%s.root",OutDir,IN),"RECREATE");

   while ((canvas = (TCanvas*) iCanvas())) {
      ImageNum++;
      canvas->SetName(TString::Format("pict%d_%s",ImageNum,IN));
      canvas->Write();
   }

   f->Close();

   // Build the html file inlining the JS pictures
   int i;
   FILE *fh = fopen(TString::Format("%s/macros/%s.html",OutDir,IN), "w");

   TIter next(gROOT->GetListOfCanvases());
   int cw, ch;
   fprintf(fh,"<center>\n");
   for (i=1; i<=ImageNum; i++) {
      canvas = (TCanvas*)next();
      cw = canvas->GetWindowWidth();
      ch = canvas->GetWindowHeight();
      fprintf(fh,"<div id=\"draw_pict%d_%s\" style=\"width:%dpx; height:%dpx\"></div>\n",
              i,IN,cw,ch);
   }
   fprintf(fh,"</center>\n");
   fprintf(fh,"<script src=\"https://root.cern/js/dev/scripts/JSRootCore.js\" type=\"text/javascript\"></script>\n");
   fprintf(fh,"<script type='text/javascript'>\n");
   fprintf(fh,"JSROOT.OpenFile(\"./%s.root\", function(file) {\n",IN);
   for (i=1; i<=ImageNum; i++) {
      fprintf(fh,"   file.ReadObject(\"pict%d_%s\", function(obj) {JSROOT.draw(\"draw_pict%d_%s\", obj, \"\");});\n",
                 i,IN,i,IN);
   }
   fprintf(fh,"});\n");
   fprintf(fh,"</script>\n");

   fclose(fh);
}
