// @(#)root/memstat:$Id$
// Author: Anar Manafov (A.Manafov@gsi.de) 2008-03-02

/*************************************************************************
* Copyright (C) 1995-2010, Rene Brun and Fons Rademakers.               *
* All rights reserved.                                                  *
*                                                                       *
* For the licensing terms see $ROOTSYS/LICENSE.                         *
* For the list of contributors see $ROOTSYS/README/CREDITS.             *
*************************************************************************/
#ifndef ROOT_TMemStatHelpers
#define ROOT_TMemStatHelpers

// ROOT
#include "TString.h"
#include "TObjString.h"
#include "TCollection.h"
// STD
#include <string>
#include <functional>
#include <algorithm>
#include <cctype>


class TObject;

namespace Memstat {
   std::string dig2bytes(Long64_t bytes);

//______________________________________________________________________________
   struct SFind_t : std::binary_function<TObject*, TString, bool> {
      bool operator()(TObject *_Obj, const TString &_ToFind) const {
         TObjString *str(dynamic_cast<TObjString*>(_Obj));
         if(!str)
            return false;
         return !str->String().CompareTo(_ToFind);
      }
   };

//______________________________________________________________________________
   template<class T>
   Int_t find_string(const T &_Container,  const TString &_ToFind)
   {
      // This function retuns an index in _Container of found element.
      // Returns -1 if there was no element found.

      typedef TIterCategory<T> iterator_t;

      iterator_t iter(&_Container);
      iterator_t found(
         std::find_if(iter.Begin(), iterator_t::End(), std::bind(SFind_t(), std::placeholders::_1, _ToFind))
      );
      return ((!(*found)) ? -1 : std::distance(iter.Begin(), found));
   }

//______________________________________________________________________________
// HACK: because of the bug in gcc 3.3 we need to use this nasty ToLower and ToUpper instead of direct calls of tolower (tolower.. is inline in this version of std lib)...
   struct ToLower_t {
      char operator()(char c) const {
         return std::tolower(c);
      }
   };

}
#endif
