# Contributing to AppFlowy 

Hello, and welcome! Whether you are trying to report a bug, proposing a feature request,  thinking about getting involved in the project ,or submitting a patch, this document is for you! It intends to be both an entry point for newcomers to AppFlowy's community (with various backgrounds), and a guide/reference for contributors. 

Consult the Table of Contents below, and jump to the desired section.

## Table of Contents
- [Contributing](#contributing)
  - [Non-coded Contributions](#non-coded-contributions)
  - [Coding Contributions](#coding-contributions)
    - [Report a Bug](#report-a-bug)
    - [Helping Others](#helping-others)
    - [Submit a Patch](#submit-a-patch)
    - [Tell Us Your Suggestions](#tell-us)
  - [Sponsor](#sponsor)
- [Contributor T-shirt](#contributor-t-shirt)
- [Code of Conduct](#code-of-conduct)
- [Sign the CLA Agreement](#sign-the-cla-agreement)


## Contributing

### Non-coded Contributions

There can help in multiple ways - even if you don't write code, you can still give back your love to our community. Here are a few ideas:

- Answer questions having ""General help wanted" labels on the [forum](https://github.com/AppFlowy-IO/appflowy/discussions)
- Improve the documentation (WIP)
- Submit feature requests on Github ([link](https://github.com/AppFlowy-IO/appflowy/issues))
    - Submit an issue for feature requests. Please include the information listed below in the issue:
        - 1~3 main use cases of the proposed feature
        - what types of users can benefit from using your proposed feature
    - Submit a patch to fix the issue [see this section](#submit-a-patch)
- Report bugs on Github ([link](https://github.com/AppFlowy-IO/appflowy/issues)). Please include relevant information listed below in the ticket:
    - A summary of the issue
    - A list of steps to reproduce the issue
    - The version of AppFlowy you encountered the issue with
    - Your configs (OS, mobile device, network, etc) that are relevant to your issue
- Be an AppFlowy's ambassador or evangelist! Proprietary software companies often have dedicated marketing teams to get more users, but luckily we have something better: you! Share your experience with AppFlowy! This can be anything:
    - Write a life-hacks-style blog post on how you or your company use AppFlowy to get things done
    - Spread the word on the media to get more people to join the community. To name a few channels, Product Hunt, Hacker Noon, Quora, Reddit, and Stack Overflow are good choices.
    - Give a lightning talk at your local hackerspace on why you love AppFlowy
    - Write a review of the pros and cons of similar open source apps

### Coding Contributions

Developers who consider participating in AppFlowy's development, please go here to start:

#### Report a Bug

Please include relevant information listed below in the ticket ([link](https://github.com/AppFlowy-IO/appflowy/issues)):
- A summary of the issue
- A list of steps to reproduce the issue
- The version of AppFlowy you encountered the issue with
- Your configs (OS, mobile device, network, etc) that are relevant to your issue
   
#### Helping Others

Helping other members of the community by answering questions having "Technical help wanted" or "General help wanted" labels on the [forum](https://github.com/AppFlowy-IO/appflowy/discussions)

#### Submit a Patch

We love to receive Pull Requests.
- If you are a beginner or a newcomer, here are some tasks for you to get ramped up:
    - Fix a typo in code
    - Fix a typo in the documentation (WIP)
    - Awesome issues for beginners or newcomers (WIP)
    - Provide feedback on the proposed features ([link](https://github.com/AppFlowy-IO/appflowy/issues))
    - Review Pull Requests ([link](https://github.com/AppFlowy-IO/appflowy/pulls))
- If you are ready to code (maybe a lot), please submit a [patch](https://github.com/AppFlowy-IO/appflowy/pulls)!
    - (WIP: guidelines)
    - (WIP: Code Style)

#### Tell Us

Not feeling quite up to contributing? Tell us your suggestions!
- Submit feature requests ([see this section](#non-coded-contributions))
- Provide your suggestions on the [forum](https://github.com/AppFlowy-IO/appflowy/discussions)
- Review Pull Requests ([link](https://github.com/AppFlowy-IO/appflowy/pulls))
- Provide feedback on the proposed features ([link](https://github.com/AppFlowy-IO/appflowy/issues))

[Back to TOC](#table-of-contents)


### Sponsor

Sponsoring is another great way to contribute to the community. 
- Buy us a coffee on [ko-fi](https://ko-fi.com/appflowy)

[Back to TOC](#table-of-contents)


## Contributor T-Shirt

If your Pull Request was accepted as it fixes a bug, adds functionality, or makes AppFlowy's codebase significantly easier to use or understand, congratulations! You are now an official contributor to AppFlowy. Get in touch with us ([link](https://tally.so/r/mKP5z3)) to receive the very special Contributor T-shirt!

Proudly wear your T-shirt and show it to us by tagging [@appflowy](https://twitter.com/appflowy) on Twitter.

[Back to TOC](#table-of-contents)

## Code of Conduct

Please report a code of conduct violation to annie@appflowy.io.
Let's encourage the behavior we want to see in the world and constantly foster a welcoming environment!

[Contributor Covenant](https://www.contributor-covenant.org/version/2/0/code_of_conduct/)

## Sign the CLA Agreement

That we do not have any potential problems later it is sadly necessary to sign a Contributor License Agreement. That can be done literally with the push of a button.

We used the most simple one that exists. It is from Indie Open Source which uses plain English and is literally only a few lines long.

A bot will automatically comment on the pull request once it got opened asking for the agreement to be signed. Before it did not get signed it is sadly not possible to merge it in.

[Back to TOC](#table-of-contents)
