---
title: Grid React component
components: Grid
---

# Grid

<p class="description">The Material Design responsive layout grid adapts to screen size and orientation, ensuring consistency across layouts.</p>

The [grid](https://material.io/design/layout/responsive-layout-grid.html) creates visual consistency between layouts while allowing flexibility across a wide variety of designs.
Material Design’s responsive UI is based on a 12-column grid layout.

## How it works

The grid system is implemented with the `Grid` component:
- It uses [CSS’s Flexible Box module](https://www.w3.org/TR/css-flexbox-1/) for high flexibility.
- There are two type of layout: *containers* and *items*.
- Item widths are set in percentages, so they’re always fluid and sized relative to their parent element.
- Items have padding to create the spacing between individual items.
- There are five grid breakpoints: xs, sm, md, lg, and xl.

## Spacing

The responsive grid focuses on consistent spacing widths, rather than column width.
Material design margins and columns follow an **8dp** square baseline grid.
Spacing can be 8, 16, 24, 32 or 40dp wide.

{{"demo": "pages/layout/grid/SpacingGrid.js"}}

## Fluid grids

Fluid grids use columns that scale and resize content. A fluid grid’s layout can use breakpoints to determine if the layout needs to change dramatically.

### Basic grid

The column widths apply at all breakpoints (i.e. `xs` and up).

{{"demo": "pages/layout/grid/CenteredGrid.js"}}

### Grid with breakpoints

Some columns have multiple widths defined, causing the layout to change at the defined breakpoint.

{{"demo": "pages/layout/grid/FullWidthGrid.js"}}

## Interactive

Below is an interactive demo that lets you explore the visual results of the different settings:

{{"demo": "pages/layout/grid/InteractiveGrid.js"}}

## Auto-layout

The Auto-layout makes the *items* equitably share the available space.
That also means you can set the width of one *item* and the others will automatically resize around it.

{{"demo": "pages/layout/grid/AutoGrid.js"}}

## CSS Grid Layout

**CSS Grid Layout** excels at dividing a page into major regions, or defining the relationship in terms of size, position, and layer, between parts of a control built from HTML primitives.
Unfortunately, CSS grid is only supported by the most recent browsers.

{{"demo": "pages/layout/grid/CSSGrid.js"}}

## Nested Grid

The `container` and `item` properties are two independant boolean. They can be combined.

> A flex **container** is the box generated by an element with a computed display of `flex` or `inline-flex`. In-flow children of a flex container are called flex **items** and are laid out using the flex layout model.

https://www.w3.org/TR/css-flexbox-1/#box-model

{{"demo": "pages/layout/grid/NestedGrid.js"}}

## Complex Grid

The following demo doesn't follow the Material Design specification, but illustrates how the grid can be used to build complex layouts.

{{"demo": "pages/layout/grid/ComplexGrid.js"}}

## Limitations

### Negative margin

There is one limitation with the negative margin we use to implement the spacing between items.
A horizontal scroll will appear if a negative margin goes beyond the `<body>`.
There are 3 available workarounds:
1. Not using the spacing feature and implementing it in user space `spacing={0}` (default).
2. Adding a padding on the parent with, at least, the spacing value:
```jsx
  <body>
    <div style={{ padding: 20 }}>
      <Grid container spacing={40}>
        //...
      </Grid>
    </div>
  </body>
```
3. Adding `overflow-x: hidden;` on the parent.

### white-space: nowrap;

The initial setting on flex items is `min-width: auto`.
It's causing a positioning conflict when the children is using `white-space: nowrap;`.
You can experience the issue with:
```jsx
<Grid item xs>
  <Typography noWrap>
```

In order for the item to stay within the container you need to set `min-width: 0`.
In practice, you can set the `zeroMinWidth` property:
```jsx
<Grid item xs zeroMinWidth>
  <Typography noWrap>
```

{{"demo": "pages/layout/grid/AutoGridNoWrap.js"}}
