# Mui-Org Governance

<p class="description">Material-UI is an open source project that depends on contributions from the community.</p>

## Overview

Mui-Org houses projects related to [Material-UI](http://www.material-ui.com/), a set of [React](https://reactjs.org/) components
that implement [Google's Material Design](https://material.io/guidelines/material-design/introduction.html)
specification. Our mission is to create a customizable Material Design implementation
for anyone to use. We value an open, collaborative, and diverse community where anyone can join in
discussions, learn from one another, and contribute to the project. This document describes how
we govern ourselves, how decisions are made, and how someone could engage with the project.

## Roles & Responsibilities

### Users

Users are members of the community that are using Material-UI or one of Mui-Org's projects. Anyone
can be a user and we encourage users to participate in the community as much as possible in the
following ways.
- Evangelize Material-UI by [linking to our website](http://www.material-ui.com/),
[following us on twitter](https://twitter.com/i/notifications), or just talking about us with your
friends.
- Tell us what we're doing well or where we can improve.
- Give us moral support. A "Thank You" always brightens our day!
- [Support us on OpenCollective](https://opencollective.com/material-ui).

### Contributors

Contributors are members of the community who contribute to Material-UI or one of Mui-Org's projects
in concrete ways. Anyone can be a contributor. In addition to their participation as a user, they
also contribute in the following ways.
- Support new users by answering questions on
[StackOverflow](https://stackoverflow.com/questions/tagged/material-ui) and
[Gitter](https://gitter.im/mui-org/material-ui).
- Reviewing and commenting on [existing pull requests](https://github.com/mui-org/material-ui/pulls)
and [issues](https://github.com/mui-org/material-ui/issues).
- Reporting bugs or missing features by [creating an issue](https://github.com/mui-org/material-ui/issues/new).
- Fixing bugs, adding features, and
[improving our documentation](https://github.com/mui-org/material-ui/tree/master/docs) by
[submitting a pull request](https://github.com/mui-org/material-ui/pulls).

### Committers

Committers are members of the community who are committed to the development, success, and mission
of Material-UI or one of Mui-Org's projects. New committers are nominated and voted on by existing
committers. Under rare circumstances, the Core Team can vote to revoke a committer's privilege. In
addition to their participation as a contributor, committers have the following privileges.
- Access to a private Gitter room to talk about issues and coordinate development.
- Ability to label, close, and manage [Github issues](https://github.com/mui-org/material-ui/issues).
- Ability to [close and merge pull requests](https://github.com/mui-org/material-ui/pulls?q=is%3Apr+is%3Aclosed).
- Ability to [submit expenses](https://opencollective.com/material-ui/expenses/new) that are
approved by the Core Team.
- Ability to receive payment for work done on Material-UI or one of Mui-Org's projects.
- Nominate and vote on new committers and Core Team members.

### Core Team

Core Team members are individuals that are invested in the success of Mui-Org. Their
administrative responsibilities ensure the sustainability and smooth running of Mui-Org. New
Core Team members are nominated and voted on by existing committers. Under rare circumstances, a
Core Team member can be removed by a two thirds majority vote by the Core Team. Two people
from the same company cannot exist on the Core Team.

At the end of each quarter, the Core Team may issue payments to one or more committers. The amount
issued will be determined by a formula that's transparent to all committers and voted on by the
Core Team. The formula can change at the end of the quarter, but not mid-quarter unless unanimously
agreed upon by the Core Team and all committers with whom any payment may be owed. These payments
are aimed to [increase the sustainability of our organization](https://medium.com/call-em-all/material-ui-the-move-to-a-sustainable-open-source-project-5261d07b5067) by supporting committers.

In addition to their participation as a committer, Core Team members have the following privileges.
- Ability to [publish a release](https://github.com/mui-org/material-ui/releases).
- Access to Material-UI's [Twitter](https://twitter.com/i/notifications) and Medium account.
- Owner access to [mui-org on GitHub](https://github.com/mui-org).
- Admin access to various tools and services ([npm](https://www.npmjs.com/package/@material-ui/core),
[CircleCi](https://circleci.com/gh/mui-org/material-ui),
[BrowserStack](https://www.browserstack.com/), [Gitter](https://gitter.im/mui-org/material-ui)).
- Admin access to all financial accounts.
- Vote on the removal of committers and Core Team members.
- Vote on decisions when consensus cannot be reached by the community.
- Vote on approval of expenses and payments on [OpenCollective](https://opencollective.com/material-ui).
Core Team members cannot vote to approve their own expenses or payments.
- Vote on changes to project governance.

### Core Team Chair

The Core Team Chair is a single individual that's a coordinator and facilitator of the Core Team.
The Chair ensures that all governance processes are followed and has the casting vote in case of a
tie within the Core Team. The Core Team Chair is voted for by the Core Team and can serve as Chair
until they step down or removed by a two thirds majority vote by the Core Team.

## Resources

- Governance Models - [http://oss-watch.ac.uk/resources/governancemodels](http://oss-watch.ac.uk/resources/governancemodels)
- Sustain OSS Report - [https://sustainoss.org/assets/pdf/SustainOSS-west-2017-report.pdf](https://sustainoss.org/assets/pdf/SustainOSS-west-2017-report.pdf)
- Elinor Ostrom's 8 Principles for Managing A Commons - [http://www.onthecommons.org/magazine/elinor-ostroms-8-principles-managing-commmons#sthash.dqF8J3Bs.dpbs](http://www.onthecommons.org/magazine/elinor-ostroms-8-principles-managing-commmons#sthash.dqF8J3Bs.dpbs)
