# Related projects

Because the scope of problems Material-UI solves is limited, we try to play nicely with
other libraries.
We have built a carefully curated collection of libraries that worth giving a look.
Feel free to submit a pull-request to add more projects; we will accept them if they match our criteria.

## Material-UI Specific Projects

- [dx-react-grid-material-ui](https://devexpress.github.io/devextreme-reactive/react/grid/) A data grid for Material-UI with paging, sorting, filtering, grouping and editing features.
- [material-ui-autosuggest](https://github.com/plan-three/material-ui-autosuggest) A fuzzy-search component for React and Material-UI.
- [material-ui-pickers](https://github.com/dmtrKovalenko/material-ui-pickers) Components that implement Material Design date and time pickers for Material-UI.
- [material-ui-time-picker](https://github.com/TeamWertarbyte/material-ui-time-picker) A TimePicker for Material-UI.
- [mui-datatables](https://github.com/gregnb/mui-datatables) Responsive data tables for Material-UI with filtering, sorting, search and more.
- [mui-downshift](https://github.com/techniq/mui-downshift) Thin layer over paypal's downshift to use Material-UI visual components.
- [Wertarbyte](https://mui.wertarbyte.com/) Wertarbyte are using Material-UI for many of their projects. This is a collection of complementary components they have built.

## Complementary Projects

- [react-admin](https://github.com/marmelab/react-admin) An admin framework combining material-ui with Redux, redux-form, redux-saga, and recompose
- [react-autosuggest](https://github.com/moroshko/react-autosuggest) WAI-ARIA compliant React autosuggest component.
- [react-final-form](https://github.com/final-form/react-final-form#material-ui-10) Subscription-based form state management for React.
- [react-most-wanted](https://github.com/TarikHuber/react-most-wanted) Starter kit using Material-UI, CRA, Redux, Firebase and all the "Most Wanted" features.
- [react-number-format](https://github.com/s-yadav/react-number-format) React component to format numbers in an input or as a text.
- [react-popper](https://github.com/FezVrasta/react-popper) React wrapper around PopperJS.
- [react-swipeable-views](https://github.com/oliviertassinari/react-swipeable-views) A React component for swipeable views. Plays well with the `Tabs` component.
- [react-text-mask](https://github.com/text-mask/text-mask) Input mask for React, Angular, Ember, Vue, & plain JavaScript.
- [redux-form](https://redux-form.com/7.3.0/examples/material-ui/) Manage your form state in Redux.
