# Roadmap

The roadmap is a living document, and it is likely that priorities will change, but the list below should give some indication of our plans for the next major release, and for the future.

Our priorities:
1. **Material Design**. The Google Design team has recently released a new iteration on the Material Design specification which is focused on *themability*. This is great news! We will do our best to keep up to date. It also validates that heavily investing in customizability for v1 was a good call. We will continue our efforts in this area.
1. **More utils**. We want to work on new utility components: Spacing, Display, Color, etc.
1. **Performance**. We can’t optimize something we can’t measure, and we don’t currently have a CI performance benchmark, so we will need to build one and start investigating bottlenecks.
1. **Learning materials**. The quality of the documentation is equally as important as the quality of the implementation, and while the reference documentation is comprehensive, we could author a learning tutorial like Next.js has done, or an egghead.io course.
1. **Themes**. We want to provide common layouts example to make getting started even easier. We also plan on adding more premium themes.
1. **Documentation**. We want to translate the documentation into Chinese and other languages. Any help is welcomed!
1. **Bundle size**. The library needs to be as small as possible, so we need to work on solutions to further reduce the bundle size, for example, supporting Preact or Nerv can help.
1. **Type checking**. We will continue to improve the TypeScript and possibly the Flow coverage of the library.
