# Почему Bloc?

> Блок позволяет легко отделить презентационный слой от бизнес-логики, делая ваш код _быстрым_, _простым для тестирования_ и _переиспользуемым_.

При создании качественных приложений управление состоянием становится критическим.

Как разработчики мы хотим:

- знать, в каком состоянии находится наше приложение в любой момент времени.
- легко проверять каждый случай, чтобы убедиться, что наше приложение отвечает должным образом.
- фиксировать все взаимодействие с пользователем в нашем приложении, чтобы мы могли принимать соответствующие решения на основе этих данных.
- работать максимально эффективно и повторно использовать компоненты как в нашем приложении, так и в других приложениях.
- давать возможность разным разработчикам без проблем работать в единой кодовой базе, следуя тем же шаблонам и соглашениям.
- разрабатывать быстрые и реактивные приложения.

`Bloc` был разработан, чтобы удовлетворить все эти и многие другие потребности.

Существует много решений по управлению состоянием и решение о том, какое из них использовать может оказаться сложной задачей.

`Bloc` был разработан с учетом трех основных принципов:

- Простота
  - Легко понимаемым & готовым к использованию разработчиками с различным уровнем квалификации.
- Мощность
  - Помогая создавать удивительные, сложные приложения, компонуя их из более мелких компонентов.
- Тестируемость
  - Позволяя легко тестировать каждый аспект приложения для уверенного продвижения вперед.

`Bloc` пытается сделать изменения состояния предсказуемым, регулируя его изменение и применяя единый подход во всем приложении.
