# Why Bloc?

> Bloc을 이용하면 presentation과 business logic을 쉽게 구분할 수 있어, 코드가 _빠르고_, _테스트하기 쉽고_, _재사용 가능해집니다._

프로덕션 수준의 어플리케이션을 만들 때, 상태 관리는 매우 중요해집니다.

개발자로서 우리는 다음을 원합니다:

- 어느 시점에든지 어플리케이션이 어떤 상태에 있는지 알고 싶습니다.
- 우리의 앱이 어떠한 상황에도 잘 반응하는지 모든 경우를 쉽게 테스트하고 싶습니다.
- 기록을 기반으로 결정을 내리기 위해 모든 유저와의 상호작용을 기록으로 남기고 싶습니다.
- 최대한 효율적으로 일하고 싶고, 우리 어플리캐이션 내부에 있는 컴포넌트나 다른 어플리케이션의 컴포넌트를 재사용하고 싶습니다.
- 많은 개발자가 같은 패턴과 컨벤션을 따르며 하나의 코드 베이스로 일하게 하고 싶습니다.
- 빠르면서 반응형 앱을 만들고 싶습니다.

Bloc은 이러한 필요를 충족시키기 위해 설계되었습니다.

상태 관리 솔루션의 종류가 여럿이기 때문에 하나를 고르는 것은 어려운 일이 될 수도 있습니다.

Bloc은 다음 3가지 가치를 중점으로 설계되었습니다.

- Simple
  - 이해하기 쉽고, 다양한 수준의 개발자가 사용할 수 있게 하기 위해
- Powerful
  - 어플리케이션을 작은 단위의 컴포넌트로 나눠주어 멋지고 복잡한 어플리케이션 개발을 돕기 위해
- Testable
  - 어플리케이션의 모든 부분을 쉽게 테스트 할 수 있게 하여 자신감을 가지고 개발을 진행할 수 있게 위해

Bloc은 상태 변화가 발생할 수 있는 시기를 조정하고 전체 애플리케이션에서 상태를 하나의 방법으로 변경하여 상태 변화를 예측 가능하게 만듭니다.
