import 'package:json_annotation/json_annotation.dart';
import 'package:meta_weather_api/meta_weather_api.dart';
import 'package:test/test.dart';

void main() {
  group('Location', () {
    group('fromJson', () {
      test('throws CheckedFromJsonException when enum is unknown', () {
        expect(
          () => Location.fromJson(<String, dynamic>{
            'title': 'mock-title',
            'location_type': 'Unknown',
            'latt_long': '-34.75,83.28',
            'woeid': 42
          }),
          throwsA(isA<CheckedFromJsonException>()),
        );
      });

      test('throws CheckedFromJsonException when source is null', () {
        expect(
          () => Location.fromJson(null),
          throwsA(isA<CheckedFromJsonException>()),
        );
      });
    });
  });

  group('LatLng', () {
    group('fromJson', () {
      test('throws AssertionError when json is null', () {
        expect(
          () => LatLng.fromJson(null),
          throwsA(isA<AssertionError>()),
        );
      });
    });
  });
}
