# なぜBlocを使う?

> BlocはUI側のコードとビジネスロジックを分け、 _素早く_, _楽にテストし_, そして _再利用しやすく_してくれます。

プロダクション用のアプリケーションを作るときは状態管理がとても大切になってきます。

開発者としては：

- いつアプリケーションがどの状態にあるかを知りたい
- 簡単に全てのケースにおいて正しく挙動しているかをテストしたい
- データを元にプロダクトの開発判断ができるようにユーザーがアプリケーションで何をしているかを一つ残らず把握したい
- 特定のアプリケーションのコンポーネントをほかのアプリケーションでも再利用して効率よく開発をしたい
- 大人数の開発者でも同じ開発パターンに基づき一つのコードベースを構築したい
- サクサク動くリアクティブアプリケーションを開発したい

Blocはそんなニーズに応えるために開発されました。

世の中には多数の状態管理用のソリューションがあり、どれを使うか判断するのは大変ですよね。

Blocはこれら３つのコアバリューを元に作成されました：

- シンプル
  - 簡単に使え、開発者のレベルを問わずに使ってもらえる。
- パワフル
  - 大きく複雑なアプリケーションを小さなコンポーネントに分けることで質の高いアプリケーションを作る。
- 可テスト性
  - 品質に自信を持って開発できるようにアプリケーションを構築する全ての要素をテストできるようにする。

Blocは状態変化がいつどのように起こるかを定義、制限することで状態変化をわかりやすくしてくれます。
