# Input Variables
# THEOS_SHARED_BUNDLE_INSTALL_NAME: bundle name and extension
# THEOS_SHARED_BUNDLE_INSTALL_PATH: bundle install path
# _THEOS_SHARED_BUNDLE_STAGE_PATH: bundle resource path (typically just INSTALL_PATH/INSTALL_NAME)
#
# Instance Variables:
# xxx_RESOURCE_FILES: list of resource files to install (why would you use this in favour of xxx_RESOURCE_DIRS? eh.)
# xxx_RESOURCE_DIRS: folders to copy resources from
# 	note a deviation from gnustep-make's xxx_RESOURCE_DIRS which simply specifies resource subdirectories to create
# 	defaults to Resources/ if it exists.

.PHONY: shared-instance-bundle-stage

ifeq ($(_THEOS_CURRENT_OPERATION),stage)
THEOS_SHARED_BUNDLE_BINARY_PATH = $(_THEOS_SHARED_BUNDLE_STAGE_PATH)/$(_THEOS_TARGET_BUNDLE_BINARY_SUBDIRECTORY)
THEOS_SHARED_BUNDLE_RESOURCE_PATH = $(_THEOS_SHARED_BUNDLE_STAGE_PATH)/$(_THEOS_TARGET_BUNDLE_RESOURCE_SUBDIRECTORY)
THEOS_SHARED_BUNDLE_HEADERS_PATH = $(_THEOS_SHARED_BUNDLE_STAGE_PATH)/$(_THEOS_TARGET_BUNDLE_HEADERS_SUBDIRECTORY)
else
THEOS_SHARED_BUNDLE_BINARY_PATH = $(_THEOS_SHARED_BUNDLE_BUILD_PATH)/$(_THEOS_TARGET_BUNDLE_BINARY_SUBDIRECTORY)
THEOS_SHARED_BUNDLE_RESOURCE_PATH = $(_THEOS_SHARED_BUNDLE_BUILD_PATH)/$(_THEOS_TARGET_BUNDLE_RESOURCE_SUBDIRECTORY)
THEOS_SHARED_BUNDLE_HEADERS_PATH = $(_THEOS_SHARED_BUNDLE_BUILD_PATH)/$(_THEOS_TARGET_BUNDLE_HEADERS_SUBDIRECTORY)
endif

$(_THEOS_SHARED_BUNDLE_BUILD_PATH)/$(_THEOS_TARGET_BUNDLE_BINARY_SUBDIRECTORY) $(_THEOS_SHARED_BUNDLE_BUILD_PATH)/$(_THEOS_TARGET_BUNDLE_RESOURCE_SUBDIRECTORY) $(_THEOS_SHARED_BUNDLE_BUILD_PATH)/$(_THEOS_TARGET_BUNDLE_INFO_PLIST_SUBDIRECTORY)::
	$(ECHO_NOTHING)mkdir -p "$@"$(ECHO_END)

_RESOURCE_FILES := $(or $($(THEOS_CURRENT_INSTANCE)_BUNDLE_RESOURCES),$($(THEOS_CURRENT_INSTANCE)_RESOURCE_FILES))
_RESOURCE_DIRS := $(or $($(THEOS_CURRENT_INSTANCE)_BUNDLE_RESOURCE_DIRS),$($(THEOS_CURRENT_INSTANCE)_RESOURCE_DIRS))
_PUBLIC_HEADERS := $($(THEOS_CURRENT_INSTANCE)_PUBLIC_HEADERS)
ifeq ($(_RESOURCE_DIRS),)
ifeq ($(call __exists,Resources),$(_THEOS_TRUE))
_RESOURCE_DIRS := Resources
else
_RESOURCE_DIRS :=
endif
endif

shared-instance-bundle-all:: $(_THEOS_SHARED_BUNDLE_BUILD_PATH)/$(_THEOS_TARGET_BUNDLE_BINARY_SUBDIRECTORY) $(_THEOS_SHARED_BUNDLE_BUILD_PATH)/$(_THEOS_TARGET_BUNDLE_RESOURCE_SUBDIRECTORY) $(_THEOS_SHARED_BUNDLE_BUILD_PATH)/$(_THEOS_TARGET_BUNDLE_INFO_PLIST_SUBDIRECTORY)
ifneq ($(_RESOURCE_FILES),)
	$(ECHO_COPYING_RESOURCE_FILES)for f in $(_RESOURCE_FILES); do \
		if [[ -f "$$f" || -d "$$f" ]]; then \
			rsync -a "$$f" "$(_THEOS_SHARED_BUNDLE_BUILD_PATH)$(_THEOS_TARGET_BUNDLE_RESOURCE_SUBDIRECTORY)/" $(_THEOS_RSYNC_EXCLUDE_COMMANDLINE); \
		else \
			$(PRINT_FORMAT_WARNING) "Ignoring missing bundle resource $$f." >&2; \
		fi; \
	done$(ECHO_END)
endif
ifneq ($(_RESOURCE_DIRS),)
	$(ECHO_COPYING_RESOURCE_DIRS)for d in $(_RESOURCE_DIRS); do \
		if [[ -d "$$d" ]]; then \
			rsync -a "$$d/" "$(_THEOS_SHARED_BUNDLE_BUILD_PATH)$(_THEOS_TARGET_BUNDLE_RESOURCE_SUBDIRECTORY)/" $(_THEOS_RSYNC_EXCLUDE_COMMANDLINE); \
		else \
			$(PRINT_FORMAT_WARNING) "Ignoring missing bundle resource directory $$d." >&2; \
		fi; \
	done$(ECHO_END)
endif
ifneq ($(_PUBLIC_HEADERS),)
	$(ECHO_COPYING_PUBLIC_HEADERS)for f in $(_PUBLIC_HEADERS); do \
		if [[ -f "$$f" || -d "$$f" ]]; then \
			rsync -a "$$f" "$(_THEOS_SHARED_BUNDLE_BUILD_PATH)$(_THEOS_TARGET_BUNDLE_HEADERS_SUBDIRECTORY)/" $(_THEOS_RSYNC_EXCLUDE_COMMANDLINE); \
		else \
			$(PRINT_FORMAT_WARNING) "Ignoring missing public header $$f." >&2; \
		fi; \
	done$(ECHO_END)
endif
ifneq ($(_THEOS_TARGET_BUNDLE_INFO_PLIST_SUBDIRECTORY),$(_THEOS_TARGET_BUNDLE_RESOURCE_SUBDIRECTORY))
	$(ECHO_NOTHING)if [[ -f "$(_THEOS_SHARED_BUNDLE_BUILD_PATH)$(_THEOS_TARGET_BUNDLE_RESOURCE_SUBDIRECTORY)/Info.plist" ]]; then \
		mv "$(_THEOS_SHARED_BUNDLE_BUILD_PATH)$(_THEOS_TARGET_BUNDLE_RESOURCE_SUBDIRECTORY)/Info.plist" "$(_THEOS_SHARED_BUNDLE_BUILD_PATH)$(_THEOS_TARGET_BUNDLE_INFO_PLIST_SUBDIRECTORY)/Info.plist"; \
	fi$(ECHO_END)
endif

shared-instance-bundle-stage::
ifneq ($($(THEOS_CURRENT_INSTANCE)_INSTALL),0)
	$(ECHO_NOTHING)mkdir -p "$(_THEOS_SHARED_BUNDLE_STAGE_PATH)"$(ECHO_END)
	$(ECHO_NOTHING)rsync -a "$(_THEOS_SHARED_BUNDLE_BUILD_PATH)/" "$(_THEOS_SHARED_BUNDLE_STAGE_PATH)"$(ECHO_END)
endif
