use yazi_config::{open::Opener, popup::InputCfg};
use yazi_shared::event::Exec;

use crate::{input::Input, tab::Tab, tasks::Tasks};

pub struct Opt {
	cmd:     String,
	block:   bool,
	confirm: bool,
}

impl<'a> From<&'a Exec> for Opt {
	fn from(e: &'a Exec) -> Self {
		Self {
			cmd:     e.args.first().map(|e| e.to_owned()).unwrap_or_default(),
			block:   e.named.contains_key("block"),
			confirm: e.named.contains_key("confirm"),
		}
	}
}

impl Tab {
	pub fn shell(&self, opt: impl Into<Opt>) {
		let mut opt = opt.into() as Opt;
		let selected: Vec<_> = self.selected().into_iter().map(|f| f.url()).collect();

		tokio::spawn(async move {
			if !opt.confirm || opt.cmd.is_empty() {
				let mut result = Input::_show(InputCfg::shell(opt.block).with_value(opt.cmd));
				match result.recv().await {
					Some(Ok(e)) => opt.cmd = e,
					_ => return,
				}
			}

			Tasks::_open(selected, Opener {
				exec:   opt.cmd,
				block:  opt.block,
				orphan: false,
				desc:   Default::default(),
				for_:   None,
				spread: true,
			});
		});
	}
}
