#![allow(clippy::unit_arg)]

mod adaptor;
mod emulator;
mod image;
mod iterm2;
mod kitty;
mod kitty_old;
mod sixel;
mod ueberzug;

pub use adaptor::*;
pub use emulator::*;
use iterm2::*;
use kitty::*;
use kitty_old::*;
use sixel::*;
use yazi_shared::{env_exists, RoCell};

pub use crate::image::*;

pub static ADAPTOR: RoCell<Adaptor> = RoCell::new();

// Tmux support
pub static TMUX: RoCell<bool> = RoCell::new();
static ESCAPE: RoCell<&'static str> = RoCell::new();
static START: RoCell<&'static str> = RoCell::new();
static CLOSE: RoCell<&'static str> = RoCell::new();

// Image state
static SHOWN: RoCell<arc_swap::ArcSwapOption<ratatui::layout::Rect>> = RoCell::new();

pub fn init() {
	TMUX.init(env_exists("TMUX"));
	START.init(if *TMUX { "\x1bPtmux;\x1b\x1b" } else { "\x1b" });
	CLOSE.init(if *TMUX { "\x1b\\" } else { "" });
	ESCAPE.init(if *TMUX { "\x1b\x1b" } else { "\x1b" });

	SHOWN.with(Default::default);

	ADAPTOR.init(Adaptor::matches());
	ADAPTOR.start();

	if *TMUX {
		_ = std::process::Command::new("tmux")
			.args(["set", "-p", "allow-passthrough", "on"])
			.stdin(std::process::Stdio::null())
			.stdout(std::process::Stdio::null())
			.stderr(std::process::Stdio::null())
			.spawn();
	}
}
