// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package protocol

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// MasterClient is the client API for Master service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type MasterClient interface {
	// meta distribute
	GetMeta(ctx context.Context, in *NodeInfo, opts ...grpc.CallOption) (*Meta, error)
	// data distribute
	GetUserIndex(ctx context.Context, in *VersionInfo, opts ...grpc.CallOption) (Master_GetUserIndexClient, error)
	GetRankingModel(ctx context.Context, in *VersionInfo, opts ...grpc.CallOption) (Master_GetRankingModelClient, error)
	GetClickModel(ctx context.Context, in *VersionInfo, opts ...grpc.CallOption) (Master_GetClickModelClient, error)
	// task management
	StartTask(ctx context.Context, in *StartTaskRequest, opts ...grpc.CallOption) (*StartTaskResponse, error)
	UpdateTask(ctx context.Context, in *UpdateTaskRequest, opts ...grpc.CallOption) (*UpdateTaskResponse, error)
	FinishTask(ctx context.Context, in *FinishTaskRequest, opts ...grpc.CallOption) (*FinishTaskResponse, error)
}

type masterClient struct {
	cc grpc.ClientConnInterface
}

func NewMasterClient(cc grpc.ClientConnInterface) MasterClient {
	return &masterClient{cc}
}

func (c *masterClient) GetMeta(ctx context.Context, in *NodeInfo, opts ...grpc.CallOption) (*Meta, error) {
	out := new(Meta)
	err := c.cc.Invoke(ctx, "/protocol.Master/GetMeta", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *masterClient) GetUserIndex(ctx context.Context, in *VersionInfo, opts ...grpc.CallOption) (Master_GetUserIndexClient, error) {
	stream, err := c.cc.NewStream(ctx, &Master_ServiceDesc.Streams[0], "/protocol.Master/GetUserIndex", opts...)
	if err != nil {
		return nil, err
	}
	x := &masterGetUserIndexClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Master_GetUserIndexClient interface {
	Recv() (*Fragment, error)
	grpc.ClientStream
}

type masterGetUserIndexClient struct {
	grpc.ClientStream
}

func (x *masterGetUserIndexClient) Recv() (*Fragment, error) {
	m := new(Fragment)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *masterClient) GetRankingModel(ctx context.Context, in *VersionInfo, opts ...grpc.CallOption) (Master_GetRankingModelClient, error) {
	stream, err := c.cc.NewStream(ctx, &Master_ServiceDesc.Streams[1], "/protocol.Master/GetRankingModel", opts...)
	if err != nil {
		return nil, err
	}
	x := &masterGetRankingModelClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Master_GetRankingModelClient interface {
	Recv() (*Fragment, error)
	grpc.ClientStream
}

type masterGetRankingModelClient struct {
	grpc.ClientStream
}

func (x *masterGetRankingModelClient) Recv() (*Fragment, error) {
	m := new(Fragment)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *masterClient) GetClickModel(ctx context.Context, in *VersionInfo, opts ...grpc.CallOption) (Master_GetClickModelClient, error) {
	stream, err := c.cc.NewStream(ctx, &Master_ServiceDesc.Streams[2], "/protocol.Master/GetClickModel", opts...)
	if err != nil {
		return nil, err
	}
	x := &masterGetClickModelClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Master_GetClickModelClient interface {
	Recv() (*Fragment, error)
	grpc.ClientStream
}

type masterGetClickModelClient struct {
	grpc.ClientStream
}

func (x *masterGetClickModelClient) Recv() (*Fragment, error) {
	m := new(Fragment)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *masterClient) StartTask(ctx context.Context, in *StartTaskRequest, opts ...grpc.CallOption) (*StartTaskResponse, error) {
	out := new(StartTaskResponse)
	err := c.cc.Invoke(ctx, "/protocol.Master/StartTask", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *masterClient) UpdateTask(ctx context.Context, in *UpdateTaskRequest, opts ...grpc.CallOption) (*UpdateTaskResponse, error) {
	out := new(UpdateTaskResponse)
	err := c.cc.Invoke(ctx, "/protocol.Master/UpdateTask", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *masterClient) FinishTask(ctx context.Context, in *FinishTaskRequest, opts ...grpc.CallOption) (*FinishTaskResponse, error) {
	out := new(FinishTaskResponse)
	err := c.cc.Invoke(ctx, "/protocol.Master/FinishTask", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MasterServer is the server API for Master service.
// All implementations must embed UnimplementedMasterServer
// for forward compatibility
type MasterServer interface {
	// meta distribute
	GetMeta(context.Context, *NodeInfo) (*Meta, error)
	// data distribute
	GetUserIndex(*VersionInfo, Master_GetUserIndexServer) error
	GetRankingModel(*VersionInfo, Master_GetRankingModelServer) error
	GetClickModel(*VersionInfo, Master_GetClickModelServer) error
	// task management
	StartTask(context.Context, *StartTaskRequest) (*StartTaskResponse, error)
	UpdateTask(context.Context, *UpdateTaskRequest) (*UpdateTaskResponse, error)
	FinishTask(context.Context, *FinishTaskRequest) (*FinishTaskResponse, error)
	mustEmbedUnimplementedMasterServer()
}

// UnimplementedMasterServer must be embedded to have forward compatible implementations.
type UnimplementedMasterServer struct {
}

func (UnimplementedMasterServer) GetMeta(context.Context, *NodeInfo) (*Meta, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMeta not implemented")
}
func (UnimplementedMasterServer) GetUserIndex(*VersionInfo, Master_GetUserIndexServer) error {
	return status.Errorf(codes.Unimplemented, "method GetUserIndex not implemented")
}
func (UnimplementedMasterServer) GetRankingModel(*VersionInfo, Master_GetRankingModelServer) error {
	return status.Errorf(codes.Unimplemented, "method GetRankingModel not implemented")
}
func (UnimplementedMasterServer) GetClickModel(*VersionInfo, Master_GetClickModelServer) error {
	return status.Errorf(codes.Unimplemented, "method GetClickModel not implemented")
}
func (UnimplementedMasterServer) StartTask(context.Context, *StartTaskRequest) (*StartTaskResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartTask not implemented")
}
func (UnimplementedMasterServer) UpdateTask(context.Context, *UpdateTaskRequest) (*UpdateTaskResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTask not implemented")
}
func (UnimplementedMasterServer) FinishTask(context.Context, *FinishTaskRequest) (*FinishTaskResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FinishTask not implemented")
}
func (UnimplementedMasterServer) mustEmbedUnimplementedMasterServer() {}

// UnsafeMasterServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to MasterServer will
// result in compilation errors.
type UnsafeMasterServer interface {
	mustEmbedUnimplementedMasterServer()
}

func RegisterMasterServer(s grpc.ServiceRegistrar, srv MasterServer) {
	s.RegisterService(&Master_ServiceDesc, srv)
}

func _Master_GetMeta_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodeInfo)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MasterServer).GetMeta(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/protocol.Master/GetMeta",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MasterServer).GetMeta(ctx, req.(*NodeInfo))
	}
	return interceptor(ctx, in, info, handler)
}

func _Master_GetUserIndex_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(VersionInfo)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(MasterServer).GetUserIndex(m, &masterGetUserIndexServer{stream})
}

type Master_GetUserIndexServer interface {
	Send(*Fragment) error
	grpc.ServerStream
}

type masterGetUserIndexServer struct {
	grpc.ServerStream
}

func (x *masterGetUserIndexServer) Send(m *Fragment) error {
	return x.ServerStream.SendMsg(m)
}

func _Master_GetRankingModel_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(VersionInfo)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(MasterServer).GetRankingModel(m, &masterGetRankingModelServer{stream})
}

type Master_GetRankingModelServer interface {
	Send(*Fragment) error
	grpc.ServerStream
}

type masterGetRankingModelServer struct {
	grpc.ServerStream
}

func (x *masterGetRankingModelServer) Send(m *Fragment) error {
	return x.ServerStream.SendMsg(m)
}

func _Master_GetClickModel_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(VersionInfo)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(MasterServer).GetClickModel(m, &masterGetClickModelServer{stream})
}

type Master_GetClickModelServer interface {
	Send(*Fragment) error
	grpc.ServerStream
}

type masterGetClickModelServer struct {
	grpc.ServerStream
}

func (x *masterGetClickModelServer) Send(m *Fragment) error {
	return x.ServerStream.SendMsg(m)
}

func _Master_StartTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MasterServer).StartTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/protocol.Master/StartTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MasterServer).StartTask(ctx, req.(*StartTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Master_UpdateTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MasterServer).UpdateTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/protocol.Master/UpdateTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MasterServer).UpdateTask(ctx, req.(*UpdateTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Master_FinishTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FinishTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MasterServer).FinishTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/protocol.Master/FinishTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MasterServer).FinishTask(ctx, req.(*FinishTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Master_ServiceDesc is the grpc.ServiceDesc for Master service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Master_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "protocol.Master",
	HandlerType: (*MasterServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetMeta",
			Handler:    _Master_GetMeta_Handler,
		},
		{
			MethodName: "StartTask",
			Handler:    _Master_StartTask_Handler,
		},
		{
			MethodName: "UpdateTask",
			Handler:    _Master_UpdateTask_Handler,
		},
		{
			MethodName: "FinishTask",
			Handler:    _Master_FinishTask_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetUserIndex",
			Handler:       _Master_GetUserIndex_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetRankingModel",
			Handler:       _Master_GetRankingModel_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetClickModel",
			Handler:       _Master_GetClickModel_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "protocol.proto",
}
