---
title: "Uppy 0.22: Preact, Form, Improved Dashboard, Custom Stores"
date: 2017-12-23
author: arturi
image: "https://uppy.io/images/blog/0.22/uppy-dashboard-updated.jpg"
published: true
---

**Uppy is [featured on Product Hunt](https://www.producthunt.com/posts/uppy-io)! To our fellow hunters: welcome! Quick intro: Uppy is the next open source file uploader for web browsers. We're very close to launching 1.0 and would love to get your feedback in, leave your thoughts on Product Hunt or start a discussion below.**

Hi all! It’s New Year and Christmas time, and this year Santa is brining you Uppy `0.22` 🎁 This release packs a lot of neat stuff, but it also breaks things in quite a few places, so please read on.

And, if you are celebrating, happy holidays from the Uppy Team! 🎄

<!--more-->

## Preact and JSX

We’ve been happy using `yo-yo` and `hyperx` template strings in our views for quite a while, but decided to try something more stable. Preact has most of the great ideas of React, plus smaller file size as well as a few good ideas of its own.

All views have been refactored to utilize JSX. We actually liked hyperx a lot, but JSX has better tooling and syntax highlighting support. It also seems to be the standard in the React community.

See [#451 PR](https://github.com/transloadit/uppy/pull/451) for details on why we switched and discussion around the process.

## Core and plugins refactor

- **⚠️ Breaking** We’ve renamed the `core` object to `uppy` in plugins. So instead of `this.core.state` we now use `this.uppy.state`.
- **⚠️ Breaking** Events have been renamed to remove the `core:` prefix. So `core:success` becomes just `success`, and this also results in now having `error`, `upload-started` and so on. Prefixed event names are used for plugin-specific event sometimes, like `dashboard:file-card`.
- **⚠️ Breaking** CSS class names have been altered to use the `uppy-` namespace, so `.UppyDashboard-files` becomes `.uppy-Dashboard-files` and so on.
- **⚠️ Breaking** `getMetaFromForm` was removed in favor of the new `Form` plugin (see below).
- **⚠️ Breaking** `MetaData` plugin was removed in favor of the `metaFields` option in Dashboard, [see docs](https://uppy.io/docs/dashboard/#metaFields) for more details.
- Plugins now use `this.el` to refer to their UI element instead of `this.target`.
- `setPluginState` and `getPluginState` are now used in Providers.

## Refreshed Dashboard UI

![Uppy Dashboard UI with 3 files selected](/images/blog/0.22/uppy-dashboard-updated.jpg)

- File cards are simpler, we’ve removed the excess white backgrounds, improved the remove icon, reduced paddings, added slight shadows.
- Cicular upload button in the Dashboard has been moved to the StatusBar. It’s also not circular anymore, and there’s no cloud icon. Plain and simple.
- Redesigned “retry” and “add +1 file” buttons.
- Added `metaFields` option: an array of settings for UI field objects, which previousely lived in a separate `MetaData` plugin: `{ id: 'caption', name: 'Caption', placeholder: 'describe what the image is about' }`, [see docs](https://uppy.io/docs/dashboard/#metaFields) for more details.

See [#434 PR](https://github.com/transloadit/uppy/pull/451) for more screenshots and details.

## Select multiple files in providers

Thanks to [@sadovnychyi](https://github.com/sadovnychyi), you can now select multiple files from remote providers like Google Drive and Instagram. You can also select folders, and even range of files by holding `shift` key when clicking on first and last item in range.

![Uppy Dashboard UI with 3 files selected](/images/blog/0.22/uppy-dashboard-provider-select.jpg)

[Check it out →](https://uppy.io/examples/dashboard/)

## Stores

As you know, internally Uppy uses its own simple state management system with `getState` and `setState` methods. In previous releases we’ve added support for Redux via a plugin called `Redux`, which mirrors all Uppy state to your Redux application’s state, and a plugin called `ReduxDevTools` that connects to Redux DevTools and enables all the cool time traveling stuff.

We are excited to tell you that this release makes state management even more flexible by bringing support for external stores! Here’s a quote from the docs:

> By default, Uppy stores its internal state in an object.
> 
> If your app uses a state management library such as Redux, it can be useful to have Uppy store its state there instead—that way, you could write custom uploader UI components in the same way as the other components in the application.

Here’s how that works:

```js
const { createStore } = require('redux')
const ReduxStore = require('uppy/lib/store/ReduxStore')

const reducer = combineReducers({
  ...reducers,
  uppy: ReduxStore.reducer
})
const store = createStore(reducer)

const uppy = Uppy({
  store: ReduxStore({
    store: store // That's a lot of stores!
  })
})
...
```

Now Uppy will use your app’s Redux store instead of its own, so you have a “single source of truth” 🔮

Read [more on stores](https://uppy.io/docs/stores/) in docs.

## Form

`Form` is a new plugin that can be used in conjunction with any other. Here’s what it does: 

1. Acquires metadata from a `<form>` element of your choosing before the upload starts in Uppy.
2. Injects result array of succesful and failed files back into the form.

**⚠️ Breaking** With this plugin we’ve deprecated `getMetaFromForm` option that used to be in all acquire plugins like Dashboard and DragDrop. Now you can just use `Form`.

```js
uppy.use(Form, {
  target: '#my-form'
})
```

Read [more about the Form plugin](https://uppy.io/docs/form/) in docs.

## Encoding support in GoldenRetriever

Our browser crash / page refresh restore plugin `GoldenRetriever` (read [more about it](https://uppy.io/docs/golden-retriever/)) now supports correctly restoring [Transloadit](https://transloadit.com) assemblies!

Also, we’ve fixed restoring from paused state. Now uploads will remain paused and not get out of sync.

## Type-safe Server

Uppy Server now uses TypeScript to do some type checking at compile time. This helps spot some otherwise easy to miss runtime bugs. While the project’s source is still written in JavaScript, the use of [JSDoc specifications is leveraged by TypeScript](https://github.com/Microsoft/TypeScript/wiki/Type-Checking-JavaScript-Files) to detect data types and mistakes with that, within the project.

Thanks to this approach a number of hidden bugs have already been identified and fixed, and it also makes Uppy Server very well documented. :)

## And there’s more

- New `setFileState` method as a nice shorthand to update file-specific state.
- Added more extensions for mimetype detection.
- More plugin documentation 👍
- Misc bugs fixes and improvements in Webcam, Dashboard, Provider, so things should be more stable all around.
- Added an option to limit simultaneous uploads in XHRUpload.
- Fixed remote server error handler for uppy-server.
- Added [Snyk](https://snyk.io/) to uppy-server to aid vulnerability detection.

## Full Changelog

<a id="changelog-toggle" href="javascript:document.getElementById('changelog').style.display = 'block'; document.getElementById('changelog-toggle').style.display = 'none'; false;">&raquo; show</a>

<div id="changelog" style="display: none;" markdown="1">
Here is the full list of changes for version `0.22.0` (and patch `0.21.1`):
 
- **⚠️ Breaking** core: rendering engine switched from `Yo-Yo` to `Preact`, and all views from `html` hyperx template strings to `JSX` (#451 / @arturi)
- **⚠️ Breaking** core: large refactor of Core and Plugins: `setFileState`, merge `MetaData` plugin into `Dashboard`, prefix "private" core methods with underscores (@arturi / #438) 
- **⚠️ Breaking** core: renamed `core` to `uppy` in plugins and what not. So instead of `this.core.state` we now use `this.uppy.state` (#438 / @arturi) 
- **⚠️ Breaking** core: renamed events to remove `core:` prefix, as been suggested already. So: `success`, `error`, `upload-started` and so on, and prefixed event names for plugins sometimes, like `dashboard:file-card` (#438 / @arturi) 
- **⚠️ Breaking** core: CSS class names have been altered to use `uppy-` namespace, so `.UppyDashboard-files` --> `.uppy-Dashboard-files` and so on
- **⚠️ Breaking** dashboard: added `metaFields` option, pass an array of settings for UI field objects `{ id: 'caption', name: 'Caption', placeholder: 'describe what the image is about' }` (#438 / @arturi, @goto-bus-stop)
- **⚠️ Breaking** core: deprecate `getMetaFromForm` in favor of new `Form` plugin (#407 / @arturi)
- form: added `Form`, a new plugin that is used in conjunction with any acquirer, responsible for: 1. acquiring the metadata from `<form>` when upload starts in Uppy; 2. injecting result array of succesful and failed files back into the form (#407 / @arturi)
- core: add more extensions for mimetype detection (#452 / @ifedapoolarewaju)
- docs: more docs for plugins (#456 / @goto-bus-stop)
- core: misc bugs fixes and improvements in Webcam, Dashboard, Provider and others (#451 / @arturi)
- dashboard: improved Dashboard UI (@arturi)
- uppy-server: remove pause/resume socket listeners when upload is done (@ifedapoolarewaju)
- uppy/uppy-server: remote server error handler (#446 / @ifedapoolarewaju)
- provider: fix dropbox thumbnail view (@ifedapoolarewaju)
- uppy-server: link uppy-server with https://snyk.io/ to aid vulnerability spotting (@ifedapoolarewaju)
- **⚠️ Breaking** core: Set `this.el` in `Plugin` class (#425 / @arturi)
- StatusBar, Dashboard and Provider UI improvements place upload button into StatusBar, use Alex’s suggestions for retry button; other UI tweaks (#434 / @arturi)
- XHRUpload: fix fields in XHR remote uploader (#424 / @sadovnychyi)
- XHRUpload: option to limit simultaneous uploads #360 (#427 / goto-bus-stop)
- core: Add `isSupported()` API for providers (#421 / @goto-bus-stop, @arturi)
- core: Add stores. Improve on Redux PR #216 to allow using Redux (or any other solution) for all Uppy state management, instead of proxy-only (#426 / @goto-bus-stop)
- core: add ability to disable thumbnail generation (#432 / @richardwillars)
- core: allow to select multiple files at once from remote providers (#419 / @sadovnychyi)
- core: use `setPluginState` and `getPluginState` in Providers (#436 / @arturi)
- docs: uppy-server docs for s3 `getKey` option (#444 / @goto-bus-stop)
- goldenretriever: Fix IndexedDB store initialisation when not cleaning up (#430 / @goto-bus-stop)
- provider: folder deselection did not remove all files (#439 / @ifedapoolarewaju)
- s3: Use Translator for localised strings (420 / @goto-bus-stop )
- transloadit: Port old tests from tape (#428 / @goto-bus-stop)
- tus: Restore correctly from paused state (#443 / @goto-bus-stop)
- uppy-server: use typescript to compile code for a type safe servers (@ifedapoolarewaju)

</div>

We expect our 1.0 release early next year. Want to impact it? Comment below, in [GitHub issues](https://github.com/transloadit/uppy/issues), or on [Product Hunt](https://www.producthunt.com/posts/uppy-io).

Happy Holidays,

The Uppy Team

<center>
  <iframe src="https://ghbtns.com/github-btn.html?user=transloadit&repo=uppy&type=watch&count=true"
  allowtransparency="true" frameborder="0" scrolling="0" width="100" height="20"></iframe>
</center>
