---
title: "Uppy 0.11: StatusBar, research, https and API docs"
date: 2016-11-15
author: arturi
published: true
---

Hey everyone! It has been a while since we last shared some news about our progress and we can't wait to let you know what’s up(py)!

In October, we have been working hard to get Uppy 0.11 ready for release. This entailed, among other things, doing a write-up of our general architecture, bringing in a friend to look at what we’ve been up to, experimenting with Redux, and updating the Dashboard UI and website example.

Here's what we have been up to, in some more detail.

<!-- more -->

## More research and experiments

- We wrote an [ARCHITECTURE.md](https://github.com/transloadit/uppy/blob/master/ARCHITECTURE.md) document, describing our architecture and APIs.
- Author of [Choo](https://github.com/yoshuawuyts/choo), Yoshua Wuyts, was invited to take a look at the state of things in Uppy, and he came up with a proposal for some changes, which we’ll be considering in the coming releases.
- We also conducted a few Redux experiments on Uppy, in the process of which, no animals were hurt. :dog:

## Dashboard: example features, StatusBar and updated UI

**Dashboard example** [on our website](https://uppy.io/examples/dashboard/) now features several options:

- switchting between “inline” and “modal dialog / popup” mode;
- toggling the `autoProceed` option that starts uploads automatically, without waiting for a click on the “upload” button;
- enabling/disabling acquire plugins, like Google Drive and Webcam.

<img src="/images/blog/0.11/dashboard-example-options.png">

**StatusBar** is a – you guessed it – bar that appears on the bottom of the Dashboard and unifies progress with pause/resume buttons.

**Dashboard UI** has undergone minor improvements, such as: a new “drag files here” icon and tagline. Furthermore, the text before “acquire” icons on the top — Local Disk, Google Drive, Webcam — has been removed (it used to say “Import files from:”). We also added new “remove file” icons. You know, small things, big difference. :sunglasses:

<img src="/images/blog/0.11/uppy-dashboard-oct-2016-1.jpg" alt="Dashboard UI, no files. Text: Drop files here, paste or import from one of the locations above">

<img src="/images/blog/0.11/uppy-dashboard-oct-2016-2.jpg" alt="Dashboard UI, file upload in progress. StatusBar with pause/resume button and progress">

## HTTPS

We have upgraded both [uppy.io](http://uppy.io/) and [tus.io](http://tus.io/) to support HTTPS with Let’s Encrypt. This will ensure that webcam example now works, secure uploads work, and – hopefully – that all will be well.

## And more

- We have renamed FormTag plugin to FileInput and made it pretty by default, with an added option to just show the default browser “choose file”.
- [Fixed a bug](https://github.com/transloadit/uppy/issues/126) with `autoProceed: true` duplicating uploads.
- Refactored Dashboard to only keep active acquire panel in DOM.
- Added PersistentState plugin that saves state to localStorage — which is useful for development.
- [Grand refactor of Uppy Server](https://github.com/transloadit/uppy/pull/131) with dynamic controllers.
- Webcam stream no longer flashes when state is updated.

## Release Notes

Here is the full list of changes for version 0.11:

- core: log method should have an option to throw error in addition to just logging (@arturi)
- experimental: PersistentState plugin that saves state to localStorage — useful for development (@arturi)
- dashboard: implement new StatusBar with progress and pause/resume buttons https://github.com/transloadit/uppy/issues/96#issuecomment-249401532 (@arturi)
- dashboard: attempt to throttle StatusBar, so it doesn’t re-render too often (@arturi)
- dashboard: refactor — only load one acquire panel at a time (activeAcquirer or empty), change focus behavior, utilize onload/onunload
- experimental: create a Dashboard UI for Redux refactor (@hedgerh)
- dashboard: make trigger optional — not needed when rendering inline (@arturi)
- fileinput: pretty input element #93 (@arturi)
- meta: document current Uppy architecture and question about the future (@arturi, @hedgerh)
- test: see about adding tests for autoProceed: true (@arturi)
- website: and ability to toggle options in Dashboard example: inline/modal, autoProceed, which plugins are enabled #89 (@arturi)
- website: finish https upgrade for uppy.io, uppy-server and tus, set up pingdom notifications (@arturi, @kvz, @hedgerh)
- website: update guide, API docs and main page example to match current actual API (@arturi)
- uppy-server: Make uppy server have dynamic controllers (@hedgerh)

We hope you'll enjoy this latest release. We have got a lot more in store for Uppy and we won't wait too long with throwing you a bone again!

The Uppy Team
