---
title: "Uppy 1.0: Your best friend in file uploading"
date: 2019-04-25
author: arturi
image: "https://uppy.io/images/blog/1.0/uppy-dashboard-1.png"
published: true
---

Today, after 3 years of development, we are now launching version 1.0 of Uppy, our file uploader for web browsers.

<img src="/images/blog/1.0/uppy-dashboard-1.png">

## A little history

Three years ago, Transloadit was ready to replace their jQuery-based file uploading & processing plugin for browsers with something more modern. They posted a [job ad](https://transloadit.com/jobs/2015-10-front-end-developer/) in search for people to build it:

> In general, we're looking for polished, well tested, carefully crafted products that are delightful to work with and use. So for this job it's not only important that you know JavaScript, but also how to make things look stunning and work well for end users.
>
> At your disposal are time, focus, and the core team ready to provide feedback, guidance, and anything else you need.

Shortly after, I saw a retweet of this vacancy come across my time line and I decided to apply. That, in a nutshell, is how I got involved with Uppy in the earliest stages of the project.

Initially, the idea was to build a proprietary uploader that would work exclusively with Transloadit’s commercial service, but we quickly turned around on it. We felt our version of a file uploader could have a real impact if we made it more widely available. So, just like Transloadit had done before with [Tus](https://tus.io/), we decided to make Uppy an open-source solution — free for anyone to use and hack on. Transloadit support became an optional plugin.

Three years, [16.000 stargazers](https://github.com/transloadit/uppy/stargazers), getting featured on [Smashing Magazine](https://www.smashingmagazine.com/the-smashing-newsletter/smashing-newsletter-issue-197/), [JavaScript Daily](https://twitter.com/JavaScriptDaily/status/950348390268919809), [Product Hunt](https://www.producthunt.com/posts/uppy-io), [SurviveJS](https://survivejs.com/blog/uppy-interview/), and a thriving community later — and we could not be happier to finally launch Uppy 1.0!

<!--more-->

## Why build Uppy in the first place?

We occasionally get asked why we would even need anything beyond `<input type="file">`. Why bring JS into this at all? The truth is, for many cases, `<input type="file">` is fine.

Sometimes, however, you might like to add a drag-and-drop surface with file previews or upload progress reporting that works well across browsers. Webcam support could be useful. Other than that, picking files directly from your Instagram and Dropbox — without first passing through your mobile phone — can save a lot of bandwidth and battery life (uploads with Uppy and Companion happen server-to-server). In all those cases, you'll need something more than a simple `<input type="file">` command.

<img src="/images/blog/1.0/uppy-dashboard-2.png">

Then there's also the issue of large files, where resumability is essential. It's basically unacceptable in this day and age to still have to restart your upload from scratch, just because your WiFi had a hiccup. That's why Uppy uses Tus, the open protocol for resumable file uploading.

All these things significantly improve the user experience to the point where more files actually make it to your platform, and less users rage-quit and close the tab. These things become important when uploading is a central aspect of your website or app. Uppy can also be deployed with nothing but a JS tag, using an existing `<form>` for fallback (to support IE6! :smile:), and your Apache/Nginx server.

## Building a team to create Uppy

The Uppy team first consisted of [myself](https://github.com/arturi) and [Harry](https://github.com/hedgerh). Since I moved to New York for a while, with most of the team based in Europe, we got used to having some very early (or late) calls with significant time differences.

I was mostly working on the frontend and building what is known today as the [Dashboard](/examples/dashboard/) — the fully-featured and most commonly used Uppy plugin. Harry took on the first version of what was then called Uppy Server (now Companion) — responsible for picking files from Google Drive, Instagram, remote Urls, etc.

In 2016, the Transloadit team had a meetup in Amsterdam, where I ended up being [present](https://mobile.twitter.com/arturi/status/701394760796229632) in a most unusual way (in the center):

<img src="/images/blog/1.0/amsterdam-team-meetup.jpg">

Later that year, [Ife](https://github.com/ifedapoolarewaju) joined the Uppy team as well and took over all Companion work.

Building all of the intended Uppy features properly took a lot of time. So, two years after landing the project at Transloadit, I was [writing a job ad post myself](https://transloadit.com/jobs/2017-02-open-source-frontend-dev/) as Uppy was starting to take on serious proportions. That’s where [Renée](https://github.com/goto-bus-stop) joined the team (funny story — we met through collaborating on GitHub on Choo and Yo-Yo libraries) to help us with Uppy React components, Redux integration, the Golden Retriever plugin and many more cool features.

Around that time, [Alex](https://zaytsev.io/) also joined in to advise us on the UI design, completing the Uppy team as it still stands today.

In the summer of 2017, the Transloadit team had another meeting. This time in Berlin, where we worked on the [Golden Retriever](/docs/golden-retriever/) plugin that helps recover files after browser crashes. We also played Mario Kart (I lost, despite all the practice!) and dressed up as characters from the game:

<img src="/images/blog/1.0/uppy-team-kong.jpg">

Read more [about Golden Retriever and that team meetup](https://uppy.io/blog/2017/07/golden-retriever/). Golden Retriever got good press on Reddit and Hacker News because it goes above and beyond to make things absurdly reliable. In the demo video, you see us `kill -9` our browser, restart, and the upload just picks right up where it left off. A first!

## Challenge accepted: only 30 days to liftoff

We had been postponing the 1.0 release for quite some time. There’s always just one more feature you'd like to add or another bug you want to fix, before calling something ready for a 1.0 release. Truth be told, Uppy has been [used in production](https://github.com/transloadit/uppy#used-by) for a while already, and even though we iterate and change things frequently, the API had mostly stabilized.

So, about a month ago, we decided to pull the trigger and [announced an Uppy Month](https://uppy.io/blog/2019/03/liftoff-01/) within Transloadit. This meant that all team members, including those not working primarily on Uppy — the Tus core team, our SDK teams, as well as our infra and API engineers, designers, content writers, and the founders themselves — all chipped in and did their part to ensure liftoff in thirty days. We also asked [Evgenia](http://github.com/lakesare) to join us for the month to lend a hand with frontend work. Every week, we had a call where we looked at the Uppy 1.0 project board and talked about our progress:

<img src="/images/blog/30daystoliftoff/15-dashboard.png">

Here are some highlights of what we’ve managed to deliver during one month of Everything Uppy:

- A new Uppy website design.
- [Localization support and language packs](https://github.com/transloadit/uppy/pull/1443) for Russian, German, Dutch and French (with more coming from the community). [Kevin](https://github.com/kvz) and I wrote a script that loops through all Uppy plugins in the repo and generates one canonical `en_US` that can be used as a basis for other translations. The script even checks for missing strings accross all translations, so you know which ones to update.
- [Drag and Drop in the Dashboard](https://github.com/transloadit/uppy/pull/1440), being an important part of Uppy, has been significantly improved with support for pasting files and links from both the browser and the device. So you can now, say, drag a link or an image from a different tab to Uppy!
- [Basic React Native support (Beta)](https://github.com/transloadit/uppy/pull/988): Uppy runs in a React Native environment, we have an example with resumable uploads via tus, and `@uppy/react-native` Expo-component support for picking images, videos, documents, and files from remote URLs with the help of Companion.
- [Design facelift](https://github.com/transloadit/uppy/pull/1442): the Dashboard UI has been significantly improved in the past days: new icons have been added, as well as typography polishing, better color organization, enlarged clickable areas, and more.
- Many accessibility issues uncovered.
- [Robodog gained support for an inline Dashboard](https://github.com/transloadit/uppy/pull/1450).
- [The documentation structure has been reworked](https://github.com/transloadit/uppy/pull/1405).
- [Transloadit Assemblies can now be properly canceled](https://github.com/transloadit/uppy/pull/1431).
- [Upload progress is reported more accurately with XHR-upload and Companion](https://github.com/transloadit/uppy/pull/1454).
- [Upload progress is improved in general](https://github.com/transloadit/uppy/pull/1376).
- [npm scripts have been refactored](https://github.com/transloadit/uppy/pull/1392) — yes, that's important!
- And craziest of all: our content team has been on a roll and [released a post *every day*](https://uppy.io/blog/2019/03/liftoff-01/) for the past thirty days to keep you updated on our day-to-day progress.

## Which features made it into 1.0? And which didn’t (yet)?

Uppy 1.0 feature list:

- Sleek user interface
- Lightweight and easy on dependencies
- A small core with modular architecture: everything is a plugin
- Uses modern JavaScript with transpiled ES5 versions available in `lib`, and minified versions for direct use by browsers in `dist`
- Usable as a bundle straight from a CDN, as well as a module to import
- Resumable file uploads via the open Tus standard
- Direct uploads to S3
- Webcam support
- Picking files from Dropbox, Google Drive and Instagram, while letting servers do the heavy lifting via Companion
- Robust: retries for all-the-things
- Built with accessibility in mind (not perfect yet, but we constantly improve)
- File recovery (after a browser crash or accidental navigation) via Golden Retriever
- Locale support: easily switch languages or supply your own copy
- Compatible with React (React Native in beta)
- Works great on mobile
- Works great with Transloadit. Works great without

We also left two features "behind":

> Offering sugared shortcuts for novice users (presets)

We felt that Uppy is straightforward enough to use, and presets could end up making this less clear. Robodog does offer less “boilerplatey” integrations, but this was done as a wrapper instead of a preset.

> Themable UI with a beautiful default

Instead of going for `{ theme: 'dark' }`, we only offer theming via CSS. It is, of course, very feasible to create a `dark.css` file, and maybe we can come up with a section on the site for easily sharing and distributing such files, but we let go of this desire for Uppy 1.0.

Lastly, our “picking files from remote sources” feature isn’t quite as full fledged as we maybe would have liked, since support for, e.g., Google Photos is currently not included. We hope these are things that the community can help with. So, while we didn’t tick all the boxes, for a three-year gameplan, we are very happy with this result.

## What’s next for Uppy?

Does this mean Uppy is perfect? Nope! 

There are still quite a lot of [issues](https://github.com/transloadit/uppy/issues) and items in our backlog, and we are already [planning Uppy 1.1](https://github.com/transloadit/uppy/blob/master/CHANGELOG.md#11). We also want to release a WordPress plugin, add image cropping, and much more, but we are releasing 1.0 today because it contains virtually all of the features that we set out to implement. These features have all been documented and we don't expect their APIs to change. If, at some point, they do need to change, we will have to handle that with care. For instance, by shipping a 2.0 version and making all the noise that comes with it. 

Uppy has already seen serious usage by a seriously large community and by various serious enterprises. So, with 1.0, we're now also signaling to you: Hey, we take this seriously and we won't be swapping things out from under your app, just like that. Also, if you don't yet have Uppy powering your file uploads, now is the best time to give it a shot!

We hope your users will be as delighted by Uppy 1.0 as we have been designing and building it. Seeing your support and contributions while doing so, made all the difference. Thank you so much!
