---
title: "Uppy 0.25: Drag & Drop Links Urls & Images, Improved File Selecting in Providers, Interactive Components In i18n"
date: 2018-06-07
author: arturi
image: "https://uppy.io/images/blog/0.25/new-select-provider.jpg"
published: true
---

Uppy 0.25 comes with a couple of new features, like drag-and-dropping URLs and images with the Url plugin, Dashboard modal animation and interactive components in i18n strings, as well as a ton of under the hood fixes and improvements.

<!--more-->

## Select In Providers

<img src="/images/blog/0.25/new-select-provider.jpg">

Selecting files doesn’t add files to Uppy immediately anymore. Instead a “Select” button appears (with a counter), and pressing that adds all the files with checked checkboxes and closes the Instagram or Google Drive overlay. Cancel discards the selection and also closes the overlay.

This addresses an undesirable case where `autoProceed: true` would begin uploading files the moment you ticked a checkbox, and you couldn’t see what was going on because the provider overlay was still open.

## Drag & Drop or Paste Links And Images with the Url Plugin

If you use the [Url plugin](/docs/url/) with the [Dashboard](/docs/dashboard), you can now drop or paste URLs into the main Dashboard area. They will automatically be imported by the Url plugin:

<figure class="wide"><video alt="Demo video showing Uppy with Url plugin that accepts drag and dropped urls" autoplay loop muted playsinline><source src="/images/blog/0.25/link-drop-demo.mp4" type="video/mp4">Your browser does not support the video tag, you can <a href="/images/blog/0.25/link-drop-demo.mp4">download the video</a> to watch it.</video></figure>

## i18n Strings with Interactive Components

⚠️ **breaking**

We’ve changed how i18n strings work with interactive components. We now use a placeholder for e.g. buttons, so it works nicely in languages that have different word order than English. Example:

```js
dropPasteImport: 'Drop files here, paste, import from one of the locations above or %{browse}'
browse: 'browse'
```

`%{browse}` will be replaced with a button/link. Previously, these two strings were concatenated in the view layer, so the `browse` text would always be last.

Here’s a list of strings that were changed in this release, please update those in your locales:

- core: `failedToUpload` needs to contain `%{file}`, substituted by the name of the file that failed
- dashboard: `dropPaste` and `dropPasteImport` need to contain `%{browse}`, substituted by the "browse" text button
- dashboard: `editing` needs to contain `%{file}`, substituted by the name of the file being edited
- dashboard: `fileSource` and `importFrom` need to contain `%{name}`, substituted by the name of the provider
- dragdrop: `dropHereOr` needs to contain `%{browse}`, substituted by the "browse" text button

The full list of available locale strings for each plugin is now documented in the [Uppy Docs](/docs/).

## React Documentation

React docs have been improved: we now have a [separate page](/docs/react/) for each Uppy React wrapper component that we offer.

Other improvements in docs:

- The `id` option is now listed on each plugin's documentation page.
- The `replaceTargetContent` option is listed on UI plugin documentation pages.
- The `locale` option is described on each plugin documentation page, and includes a short description for each string.

## Typescript Definitions

[@taoqf](https://github.com/taoqf) went ahead and added a lot of type definitions to Uppy in [#834](https://github.com/transloadit/uppy/pull/834). So if you are using TypeScript (and even if not, your code editor / linting tool likely supports type definitions), you are in for a treat!

## No need to `.run()`

⚠️**breaking**

We removed the need to type `uppy.run()` in [#793](https://github.com/transloadit/uppy/pull/793). You now only have to call `.use()` for the plugins that you need (as usual), and everything is then run automatically. It comes with a few tradeoffs but we were getting a big amount of support tickets where people forgot to conclude with `.run()`, and we saw a chance to reduce boilerplate, so we decided to go ahead and pave the cowpath.

## Authorisation tokens in Local Storage

⚠️**breaking**

Authorisation tokens from Uppy Server are now stored in local storage as opposed to cookies. Two primary reasons for this decision are:

1. It avoids CSRF issues which are present when using cookies.
2. It allows for less stringent [CORS policies enforced by browsers](https://github.com/transloadit/uppy/issues/803#issuecomment-386257515), since we are no longer sending cookie credentials via Ajax requests.

This is a breaking change because it requires that the Uppy Server version should also be updated to **0.13.x** otherwise there could be unexpected behaviour.

What’s more about the Authorisation tokens is that they are now encrypted on the server before being sent down to the client. Subsequent requests from the client will then send the token to the server via headers (not via cookies anymore).

## Other Cool Changes

- Fix: Debounce render calls again, fixes #669 (#796)
- Fix: XHRUpload canceled uploads progress events (#864)
- Improvement: Dashboard open/close animation (#852)
- Improvement: You can now hide action buttons in Dashboard and StatusBar (#821)
- Improvement: Pass `allowedFileTypes` and `maxNumberOfFiles` to `input[type=file]` to add restrictions to the system file picking dialog too (#814)
- Improvement: merge meta data when add file (#810)
- Fix: More robust failure handling for Transloadit, closes #708 (#805)
- Feature: display username/email in provider view
- Feature: show message for empty provider files
- Server: Allow custom headers to be set for remote multipart uploads
- Server: Add type to metadata as `filetype`

⚠️**heads up**

In the next release we are planning a [Lerna conversion](https://github.com/transloadit/uppy/pull/906), meaning that each Uppy plugin / module will get its own NPM package. Pretty excited about that one! (but also please refrain from sending us big PRs in the meantime :)

See you in the next one!

The Uppy Team
