---
title: "Uppy version 0.8 released: The Webcam Edition and Meta Data"
date: 2016-08-17
author: arturi
published: true
---

We have just released Uppy 0.8.0 and we can't wait to tell you more about it. Along with various under-the-hood improvements, this release also contains some very visible upgrades. You can read below for further details.

## Including Meta Data

While fetching your files, Uppy is now also able to supply some custom metadata to go along with them. So far, there are three components in place for that: Core API (`core:update-meta` event), `MetaData` plugin, and a new panel in Dashboard UI called File Card, which looks like this:

<img alt="metadata dashboard UI, editing file name, future size and adding description" src="/images/blog/0.8/metadata-dashboard.jpg" class="border">

<!-- more -->

To summon this panel, all you have to do is click the edit button on the Dashboard:

<img alt="metadata dashboard UI, editing file name, future size and adding description" src="/images/blog/0.8/uppy-dashboard-ui.jpg" class="border">

By default, the only active metadata field is `Name`. However, if you want to add other fields you can utilize our new and easy to use `MetaData` plugin:

```javascript
const uppy = new Uppy()
  .use(Dashboard)
  .use(MetaData, {
    fields: [
      { id: 'resizeTo', name: 'Resize to', value: 1200, placeholder: 'specify future image size' },
      { id: 'description', name: 'Description', value: '', placeholder: 'describe what the file is for' }
    ]
  })
```

And just like that, we have added two fields: `Resize` and `Description`. All metadata is sent along with both [tus](http://tus.io) and multipart uploads.

## Webcam Support

We have also added a basic `Webcam` plugin, which allows you to acquire images directly from your own webcam. This is still a work in progress and we will be improving it in the next release.

## Mime Types and File Icons

Uppy now includes a [mime-type](https://www.npmjs.com/package/mime-types) library that helps us figure out file types by extension.

Having proper file types also means that we need the right corresponding file icons for the Dashboard UI. We have already added a few and we will soon supply more icons for audio, video, text, PDF and other common file types.

## Previously on Uppy: File Previews, Remote File Handling, Accessibility and Acceptance Tests Stats

We thought it might be worth taking a moment to list a few highlights from the previous versions as well:

* If a file you selected is an image, its preview thumbnail data URL will be generated and added to `file.preview` in Uppy’s state. This URL can be used later to render a preview with any plugin. Currently, this is done by the mighty Dashboard.
* It is now also possible to select remote files in Uppy. Simply double-click a file from, for instance, Google Drive, and Uppy will then show it in a preview area.
* We have been doing some more work on accessibility: from now on, when you switch tabs in Modal, it will focus on the first input in that tab. We have also added proper labels and titles, and are doing more research in this area.
* Everybody likes to see stats. That is why, on our website, you can now [view stats](http://uppy.io/stats) that show how acceptance tests are performing in various browsers. If a test is successful, that means Uppy will likely be able to load and upload files in that particular browser.
* The Dashboard UI is now way better looking and easier to work with. It replaced the old `Modal` plugin and it can accept files via drag & drop, local disk and paste (experimental, WIP). It has become our main source of truth and the basic acquire plugin for local files. The DragDrop plugin is still available as a lighter alternative.

## Release Notes

Here is the full list of changes for version 0.8.0.

- core: fix bug: no meta information from uppy-server files ([@hedgerh](https://github.com/hedgerh))
- core: fix bug: uppy-server file is treated as local and directly uploaded ([@hedgerh](https://github.com/hedgerh))
- uppy-server: hammering out websockets/oauth ([@hedgerh](https://github.com/hedgerh), [@acconut](https://github.com/acconut))
- debugger: introduce MagicLog as a way to debug state changes in Uppy ([@arturi](https://github.com/arturi))
- modifier: A MetaData plugin to supply meta data (like width, tag, filename, user_id) ([@arturi](https://github.com/arturi))
- modifier: pass custom metadata with non-tus-upload. Maybe mimic meta behavior of tus here, too ([@arturi](https://github.com/arturi))
- modifier: pass custom metadata with tus-upload with tus-js-client ([@arturi](https://github.com/arturi))
- webcam: initial version: webcam light goes on ([@hedgerh](https://github.com/hedgerh))
- progress: better icons, styles ([@arturi](https://github.com/arturi))
- core: better mime/type detection (via mime + extension) ([@arturi](https://github.com/arturi))
- core: add deep-freeze to getState so that we are sure we are not mutating state accidentally ([@arturi](https://github.com/arturi))
- meta: release “Uppy Begins” post ([@arturi](https://github.com/arturi) [@kvz](https://github.com/kvz))
- meta: better readme on GitHub and NPM ([@arturi](https://github.com/arturi))
- test: add pre-commit & lint-staged ([@arturi](https://github.com/arturi))
- test: add next-update https://www.npmjs.com/package/next-update to check if packages we use can be safely updated ([@arturi](https://github.com/arturi))
- website: blog polish — add post authors and their gravatars ([@arturi](https://github.com/arturi))
- dashboard: UI revamp, more prototypes, background image, make dashboard nicer ([@arturi](https://github.com/arturi))
- dashboard: try a workflow where import from external service slides over and takes up the whole dashboard screen ([@arturi](https://github.com/arturi))
- modal: merge modal and dashboard ([@arturi](https://github.com/arturi))

We hope you will enjoy this latest release. Uppy is still improving every day and we hope to bring you more news about our progress soon!

The Uppy Team
