---
title: "Uppy 0.27: First Swing at React Native Support"
date: 2018-08-23
author: ife
image: "https://uppy.io/images/blog/0.27/uppy-add-initial.jpg"
---

<img src="/images/blog/0.27/uppy-add-initial.jpg">

In `0.27`, we have some more iterations on the Dashboard UI for you in store again. We are getting rid of the permanent tab bar and made tons of other improvements!

<!--more-->

## Dashboard UI without tabs

Uppy used to always display the tab bar (the one you use to select between importing files from Instagram, Webcam, local disk, etc.). This ended up not working well with the growing list of supported sources, especially on mobile.

<img src="/images/blog/0.27/uppy-with-tabs.jpg">

So in `0.27`, we are iterating on the UI again:

<img src="/images/blog/0.27/uppy-add-initial.jpg">

The providers are now visible as a list of icons on the initial screen (plus, we’ve added colors!), but when you complete the inital selection, it is hidden behind the “plus” button:

<img src="/images/blog/0.27/uppy-files-selected.jpg">

You can always add more:

<img src="/images/blog/0.27/uppy-add-more.jpg">

The StatusBar that shows progress has been “lightened”:

<img src="/images/blog/0.27/uppy-upload-in-progress.jpg">

<img src="/images/blog/0.27/uppy-upload-complete.jpg">

We have decided to drop multiple-color support, so Informer messages will now always appear in a gray, round bubble. Apart from that, we have made tons of small fixes, such as better animations, colors, font sizes, and more. [Check out the PR #942](https://github.com/transloadit/uppy/pull/942) for details.

We are aiming to make the UI less heavy, so that Uppy can easier fit within your existing site or app design.

The mobile version is now much more refined as well:

<img src="/images/blog/0.27/uppy-mobile.jpg">

As always, feel free to [try Uppy live on the Dashboard example](https://uppy.io/examples/dashboard/).

## `autoProceed: false` by default

⚠️ **breaking**

By default, Uppy used to begin uploading right after you selected a file. If you wanted to let users edit some file metadata or pick and choose from multiple sources first, you had to set `autoProceed: false`:

```js
// this line could be seen in many of the Uppy examples
const uppy = Uppy({ autoProceed: false })
```

Since in most cases we actually wanted `autoProceed: false`, this is now the new default. While it makes Uppy's UI less magical and harder to make irreversible mistakes with, right out of the box, we feel this is the way to go. Make sure you change this in your project if needed. If you weren't setting an `autoProceed` option at all, you will now have to add `autoProceed: true`.

## Progress on React Native

We’ve begun working on supporting React Native in Uppy. Since `0.27`, it should run in a React Native environment — meaning you can use Uppy API (`uppy.addFile()`, `uppy.upload()`) for adding files and uploading, without the UI. `@uppy/xhr-upload` uploader is already supported, and we are working on making `@uppy/tus` (and `tus-js-client` itself) run in React Native as well.

We plan to make sure all non-UI Uppy plugins work in RN, and then provide a few useful components for adding Uppy to your RN apps.

Please head to the [React Native PR #988](https://github.com/transloadit/uppy/pull/988) for details. We'd love to hear what you think and your suggestions for improving the Uppy React Native experience.

Built-in React Native support has been a 1.0 goal from the start. We have had many requests about Angular.js and Vue support. There are already community-built solutions for these platforms that seem to work well, but unfortunately we won't be officially supporting them before our 1.0 milestone. Depending on community input, we might add that later.

## Package sizes

We now have a cool table showing mingzipped bundle sizes for each individual Uppy package, [check it out](https://uppy.io/docs/stats/#bundle-sizes):

<img width="400" src="/images/blog/0.27/uppy-sizes.png">

## "Uppy Server" is now "Companion"

```bash
npm install @uppy/companion
```

Uppy Server is an optional service that Uppy can use to import files from sources like Instagram or Dropbox. However, simply naming it "Server" was quite unclear and has caused some confusion. Many people thought you could upload files to Uppy Server as well, but that is not the case. We recommend uploading to a [tus.io](https://tus.io) server, or — if that's too much for your simple usecase — using your existing webserver to handle the upload. 

So, to hopefully end this confusion once and for all, we are renaming Uppy Server to Companion: an optional tool in the datacenter, which you can use to add more functionality to your Uppy.js client. If nothing else, maybe it will net us some points for having yet another dog-themed name!

Simultaneously, we moved Companion into the main [transloadit/uppy](https://github.com/transloadit/uppy) [monorepo](https://github.com/babel/babel/blob/master/doc/design/monorepo.md). This centralizes Uppy issue reporting and makes it easier to do updates and simultaneous releases of the client and Companion parts.

The first release of `@uppy/companion` is 0.14, and the last `uppy-server` release is 0.13.4. `uppy-server` will be deprecated on npm soon.

Note that despite the rename, configuration for standalone Companion still uses `UPPYSERVER_` environment variables. This should ease the transition, since you will only have to update the package name for now. Once we add `COMPANION_` variable support, we will continue to support `UPPYSERVER_` environment variables to smoothen the transition. And of course, we will notify you here when that time comes!

## Other Cool Changes

- @uppy/core: allow editing plugin titles (names) so that, for instance, “Camera” can be translated into different languages, fixes #920 (#942 / @arturi)
- @uppy/dashboard: fix animation — wait for closing animation to finish before opening modal (#942 / @arturi)
- @uppy/url: fix Url plugin reacting to wrong drop/paste events, add ignoreEvent (#942 / @arturi)
- build: build: Split integration tests and add one using create-react-app (#952 / @goto-bus-stop)
- @uppy/companion: google Drive — move to v3 API (#977 / @pauln)

See [full changelog (0.27 and 0.26.x patches) for more](https://github.com/transloadit/uppy/blob/master/CHANGELOG.md#0270)

See you in the next release!

The Uppy Team
