---
title: "Run RPortd API with HTTPS"
weight: 08
slug: securing-rportd-with-https
aliases:
  - /docs/no08-https-howto.html
  - /docs/get-started/no08-https-howto.md
---
{{< toc >}}

## Enable encryption

Rportd supports HTTPS without the need for a reverse proxy.
{{< hint type=caution title="Always use encryption">}}
Even on your local intranet. Do not run the API with unencrypted plain HTTP. Sniffing HTTP traffic is trivial.
Your credentials might get into wrong hands easily.
{{< /hint >}}

Open the `rportd.conf` file and enter the path to a certificate or certificate chain and a server key. The key must not be password protected.

```text
[api]
  ## Defines the IP address and port the API server listens on
  ## specify non-empty {address} to enable API support
  address = "0.0.0.0:3000"
  ## ..snip ...snap
  ## If both cert_file and key_file are specified, then rportd will use them to serve the API with https.
  ## Intermediate certificates should be included in cert_file if required.
  #cert_file = "/var/lib/rport/server.crt"
  #key_file = "/var/lib/rport/server.key"
```

If a `cert_file` and a `key_file` are specified, the protocol automatically switches from HTTP to HTTPs.

If the IP address of your server has a public domain name you can generate a free certificate quite easily using Let's encrypt.

## Create certificates

Make sure no other software is using the TCP port 80 during the certificate generation and your firewall is not blocking
access to TCP 80. If you run RPort on port 80, stop it while generating the certificates.

```shell
DOMAIN=<YOUR_DOMAIN>
apt install certbot
certbot certonly -d $DOMAIN -n --agree-tos --standalone -m <YOUR_EMAIL>
# Change group ownerships so rport can read the files
chgrp rport /etc/letsencrypt/archive/
chmod g+rx /etc/letsencrypt/archive/
chgrp rport /etc/letsencrypt/live/
chmod g+rx /etc/letsencrypt/live/
chgrp rport /etc/letsencrypt/archive/$DOMAIN/
chmod g+rx /etc/letsencrypt/archive/$DOMAIN/
chgrp rport /etc/letsencrypt/archive/$DOMAIN/privkey1.pem
chmod g+rx /etc/letsencrypt/archive/$DOMAIN/privkey1.pem
chgrp rport /etc/letsencrypt/live/$DOMAIN/
ls -l /etc/letsencrypt/live/$DOMAIN/
```

This will create the server key, certificates, and chains in `/etc/letsencrypt/live/$DOMAIN/`.
Note that the files and folders generated by certbot are readable only by root. So change your ownerships accordingly.

## Use the certificates

Now set up your `rportd.conf` like this.

```text
[api]
  ## Defines the IP address and port the API server listens on
  ## specify non-empty {address} to enable API support
  address = "0.0.0.0:3000"
  ## ..snip ...snap
  ## If both cert_file and key_file are specified, then rportd will use them to serve the API with https.
  ## Intermediate certificates should be included in cert_file if required.
  cert_file = "/etc/letsencrypt/live/<YOUR_DOMAIN>/fullchain.pem"
  key_file = "/etc/letsencrypt/live/<YOUR_DOMAIN>/privkey.pem"
```

Restart rportd after any changes to the configuration file. Check your SSL setup is working properly by executing  
`curl -Iv -u admin:foobaz https://$DOMAIN:3000/api/v1/status`.  
You should not get any errors.

## Auto renewal

On Ubuntu a systemd timer to renew the certificates is created on the installation of the certbot package.
For details look at `/lib/systemd/system/certbot.timer`. On other distribution you might set up a
cron manually that executes `certbot -q renew` every 12 hours.

{{< hint type=Important title="Hooks are missing">}}
**Without proper hook scripts, the renewal will fail.**  
Follow [this guide](https://kb.rport.io/digging-deeper/server-maintenance/renewing-certificates) to properly set up the
needed Let's encrypt hooks.
{{< /hint >}}
