/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import io.swagger.client.model.Application;
import io.swagger.client.model.ApplicationList;
import io.swagger.client.model.ContractCodeList;
import io.swagger.client.model.FileStreamResult;
import io.swagger.client.model.RoleAssignment;
import io.swagger.client.model.RoleAssignmentInput;
import io.swagger.client.model.RoleAssignmentList;
import io.swagger.client.model.Workflow;
import io.swagger.client.model.WorkflowList;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class ApplicationsApi {
    private ApiClient apiClient;

    public ApplicationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call applicationDeleteCall(String applicationID, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/applications/{applicationID}".replaceAll("\\{applicationID\\}", this.apiClient.escapeString(applicationID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call applicationDeleteValidateBeforeCall(String applicationID, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (applicationID == null) {
            throw new ApiException("Missing the required parameter 'applicationID' when calling applicationDelete(Async)");
        }
        Call call = this.applicationDeleteCall(applicationID, progressListener, progressRequestListener);
        return call;
    }

    public void applicationDelete(String applicationID) throws ApiException {
        this.applicationDeleteWithHttpInfo(applicationID);
    }

    public ApiResponse<Void> applicationDeleteWithHttpInfo(String applicationID) throws ApiException {
        Call call = this.applicationDeleteValidateBeforeCall(applicationID, null, null);
        return this.apiClient.execute(call);
    }

    public Call applicationDeleteAsync(String applicationID, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.applicationDeleteValidateBeforeCall(applicationID, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call applicationDisableCall(Integer applicationId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/applications/{applicationID}/disable".replaceAll("\\{applicationId\\}", this.apiClient.escapeString(applicationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call applicationDisableValidateBeforeCall(Integer applicationId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationDisable(Async)");
        }
        Call call = this.applicationDisableCall(applicationId, progressListener, progressRequestListener);
        return call;
    }

    public void applicationDisable(Integer applicationId) throws ApiException {
        this.applicationDisableWithHttpInfo(applicationId);
    }

    public ApiResponse<Void> applicationDisableWithHttpInfo(Integer applicationId) throws ApiException {
        Call call = this.applicationDisableValidateBeforeCall(applicationId, null, null);
        return this.apiClient.execute(call);
    }

    public Call applicationDisableAsync(Integer applicationId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.applicationDisableValidateBeforeCall(applicationId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call applicationEnableCall(Integer applicationId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/applications/{applicationID}/enable".replaceAll("\\{applicationId\\}", this.apiClient.escapeString(applicationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call applicationEnableValidateBeforeCall(Integer applicationId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationEnable(Async)");
        }
        Call call = this.applicationEnableCall(applicationId, progressListener, progressRequestListener);
        return call;
    }

    public void applicationEnable(Integer applicationId) throws ApiException {
        this.applicationEnableWithHttpInfo(applicationId);
    }

    public ApiResponse<Void> applicationEnableWithHttpInfo(Integer applicationId) throws ApiException {
        Call call = this.applicationEnableValidateBeforeCall(applicationId, null, null);
        return this.apiClient.execute(call);
    }

    public Call applicationEnableAsync(Integer applicationId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.applicationEnableValidateBeforeCall(applicationId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call applicationGetCall(Integer applicationId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/applications/{applicationId}".replaceAll("\\{applicationId\\}", this.apiClient.escapeString(applicationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call applicationGetValidateBeforeCall(Integer applicationId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationGet(Async)");
        }
        Call call = this.applicationGetCall(applicationId, progressListener, progressRequestListener);
        return call;
    }

    public Application applicationGet(Integer applicationId) throws ApiException {
        ApiResponse<Application> resp = this.applicationGetWithHttpInfo(applicationId);
        return resp.getData();
    }

    public ApiResponse<Application> applicationGetWithHttpInfo(Integer applicationId) throws ApiException {
        Call call = this.applicationGetValidateBeforeCall(applicationId, null, null);
        Type localVarReturnType = new TypeToken<Application>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call applicationGetAsync(Integer applicationId, final ApiCallback<Application> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.applicationGetValidateBeforeCall(applicationId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Application>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call applicationsGetCall(Integer top, Integer skip, Boolean enabled, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/applications";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (top != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("top", top));
        }
        if (skip != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("skip", skip));
        }
        if (enabled != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("enabled", enabled));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call applicationsGetValidateBeforeCall(Integer top, Integer skip, Boolean enabled, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.applicationsGetCall(top, skip, enabled, progressListener, progressRequestListener);
        return call;
    }

    public ApplicationList applicationsGet(Integer top, Integer skip, Boolean enabled) throws ApiException {
        ApiResponse<ApplicationList> resp = this.applicationsGetWithHttpInfo(top, skip, enabled);
        return resp.getData();
    }

    public ApiResponse<ApplicationList> applicationsGetWithHttpInfo(Integer top, Integer skip, Boolean enabled) throws ApiException {
        Call call = this.applicationsGetValidateBeforeCall(top, skip, enabled, null, null);
        Type localVarReturnType = new TypeToken<ApplicationList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call applicationsGetAsync(Integer top, Integer skip, Boolean enabled, final ApiCallback<ApplicationList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.applicationsGetValidateBeforeCall(top, skip, enabled, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApplicationList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call applicationsPostCall(File file, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/applications";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[0])) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call applicationsPostValidateBeforeCall(File file, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling applicationsPost(Async)");
        }
        Call call = this.applicationsPostCall(file, progressListener, progressRequestListener);
        return call;
    }

    public Integer applicationsPost(File file) throws ApiException {
        ApiResponse<Integer> resp = this.applicationsPostWithHttpInfo(file);
        return resp.getData();
    }

    public ApiResponse<Integer> applicationsPostWithHttpInfo(File file) throws ApiException {
        Call call = this.applicationsPostValidateBeforeCall(file, null, null);
        Type localVarReturnType = new TypeToken<Integer>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call applicationsPostAsync(File file, final ApiCallback<Integer> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.applicationsPostValidateBeforeCall(file, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Integer>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call contractCodeDeleteCall(Integer contractCodeId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/applications/contractCode/{contractCodeId}".replaceAll("\\{contractCodeId\\}", this.apiClient.escapeString(contractCodeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call contractCodeDeleteValidateBeforeCall(Integer contractCodeId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (contractCodeId == null) {
            throw new ApiException("Missing the required parameter 'contractCodeId' when calling contractCodeDelete(Async)");
        }
        Call call = this.contractCodeDeleteCall(contractCodeId, progressListener, progressRequestListener);
        return call;
    }

    public void contractCodeDelete(Integer contractCodeId) throws ApiException {
        this.contractCodeDeleteWithHttpInfo(contractCodeId);
    }

    public ApiResponse<Void> contractCodeDeleteWithHttpInfo(Integer contractCodeId) throws ApiException {
        Call call = this.contractCodeDeleteValidateBeforeCall(contractCodeId, null, null);
        return this.apiClient.execute(call);
    }

    public Call contractCodeDeleteAsync(Integer contractCodeId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.contractCodeDeleteValidateBeforeCall(contractCodeId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call contractCodeGetCall(Integer contractCodeId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/applications/contractCode/{contractCodeId}".replaceAll("\\{contractCodeId\\}", this.apiClient.escapeString(contractCodeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call contractCodeGetValidateBeforeCall(Integer contractCodeId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (contractCodeId == null) {
            throw new ApiException("Missing the required parameter 'contractCodeId' when calling contractCodeGet(Async)");
        }
        Call call = this.contractCodeGetCall(contractCodeId, progressListener, progressRequestListener);
        return call;
    }

    public FileStreamResult contractCodeGet(Integer contractCodeId) throws ApiException {
        ApiResponse<FileStreamResult> resp = this.contractCodeGetWithHttpInfo(contractCodeId);
        return resp.getData();
    }

    public ApiResponse<FileStreamResult> contractCodeGetWithHttpInfo(Integer contractCodeId) throws ApiException {
        Call call = this.contractCodeGetValidateBeforeCall(contractCodeId, null, null);
        Type localVarReturnType = new TypeToken<FileStreamResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call contractCodeGetAsync(Integer contractCodeId, final ApiCallback<FileStreamResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.contractCodeGetValidateBeforeCall(contractCodeId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FileStreamResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call contractCodePostCall(Integer applicationId, File file, Integer ledgerId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/applications/{applicationId}/contractCode".replaceAll("\\{applicationId\\}", this.apiClient.escapeString(applicationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ledgerId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ledgerId", ledgerId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[0])) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call contractCodePostValidateBeforeCall(Integer applicationId, File file, Integer ledgerId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling contractCodePost(Async)");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling contractCodePost(Async)");
        }
        Call call = this.contractCodePostCall(applicationId, file, ledgerId, progressListener, progressRequestListener);
        return call;
    }

    public Integer contractCodePost(Integer applicationId, File file, Integer ledgerId) throws ApiException {
        ApiResponse<Integer> resp = this.contractCodePostWithHttpInfo(applicationId, file, ledgerId);
        return resp.getData();
    }

    public ApiResponse<Integer> contractCodePostWithHttpInfo(Integer applicationId, File file, Integer ledgerId) throws ApiException {
        Call call = this.contractCodePostValidateBeforeCall(applicationId, file, ledgerId, null, null);
        Type localVarReturnType = new TypeToken<Integer>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call contractCodePostAsync(Integer applicationId, File file, Integer ledgerId, final ApiCallback<Integer> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.contractCodePostValidateBeforeCall(applicationId, file, ledgerId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Integer>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call contractCodesGetCall(Integer applicationId, Integer ledgerId, Integer top, Integer skip, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/applications/{applicationID}/contractCode".replaceAll("\\{applicationId\\}", this.apiClient.escapeString(applicationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ledgerId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ledgerId", ledgerId));
        }
        if (top != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("top", top));
        }
        if (skip != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("skip", skip));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call contractCodesGetValidateBeforeCall(Integer applicationId, Integer ledgerId, Integer top, Integer skip, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling contractCodesGet(Async)");
        }
        Call call = this.contractCodesGetCall(applicationId, ledgerId, top, skip, progressListener, progressRequestListener);
        return call;
    }

    public ContractCodeList contractCodesGet(Integer applicationId, Integer ledgerId, Integer top, Integer skip) throws ApiException {
        ApiResponse<ContractCodeList> resp = this.contractCodesGetWithHttpInfo(applicationId, ledgerId, top, skip);
        return resp.getData();
    }

    public ApiResponse<ContractCodeList> contractCodesGetWithHttpInfo(Integer applicationId, Integer ledgerId, Integer top, Integer skip) throws ApiException {
        Call call = this.contractCodesGetValidateBeforeCall(applicationId, ledgerId, top, skip, null, null);
        Type localVarReturnType = new TypeToken<ContractCodeList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call contractCodesGetAsync(Integer applicationId, Integer ledgerId, Integer top, Integer skip, final ApiCallback<ContractCodeList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.contractCodesGetValidateBeforeCall(applicationId, ledgerId, top, skip, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ContractCodeList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call roleAssignmentDeleteCall(Integer applicationId, Integer roleAssignmentId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/applications/{applicationId}/roleAssignments/{roleAssignmentId}".replaceAll("\\{applicationId\\}", this.apiClient.escapeString(applicationId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call roleAssignmentDeleteValidateBeforeCall(Integer applicationId, Integer roleAssignmentId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling roleAssignmentDelete(Async)");
        }
        if (roleAssignmentId == null) {
            throw new ApiException("Missing the required parameter 'roleAssignmentId' when calling roleAssignmentDelete(Async)");
        }
        Call call = this.roleAssignmentDeleteCall(applicationId, roleAssignmentId, progressListener, progressRequestListener);
        return call;
    }

    public void roleAssignmentDelete(Integer applicationId, Integer roleAssignmentId) throws ApiException {
        this.roleAssignmentDeleteWithHttpInfo(applicationId, roleAssignmentId);
    }

    public ApiResponse<Void> roleAssignmentDeleteWithHttpInfo(Integer applicationId, Integer roleAssignmentId) throws ApiException {
        Call call = this.roleAssignmentDeleteValidateBeforeCall(applicationId, roleAssignmentId, null, null);
        return this.apiClient.execute(call);
    }

    public Call roleAssignmentDeleteAsync(Integer applicationId, Integer roleAssignmentId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.roleAssignmentDeleteValidateBeforeCall(applicationId, roleAssignmentId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call roleAssignmentGetCall(Integer applicationId, Integer roleAssignmentId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/applications/{applicationId}/roleAssignments/{roleAssignmentId}".replaceAll("\\{applicationId\\}", this.apiClient.escapeString(applicationId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call roleAssignmentGetValidateBeforeCall(Integer applicationId, Integer roleAssignmentId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling roleAssignmentGet(Async)");
        }
        if (roleAssignmentId == null) {
            throw new ApiException("Missing the required parameter 'roleAssignmentId' when calling roleAssignmentGet(Async)");
        }
        Call call = this.roleAssignmentGetCall(applicationId, roleAssignmentId, progressListener, progressRequestListener);
        return call;
    }

    public RoleAssignment roleAssignmentGet(Integer applicationId, Integer roleAssignmentId) throws ApiException {
        ApiResponse<RoleAssignment> resp = this.roleAssignmentGetWithHttpInfo(applicationId, roleAssignmentId);
        return resp.getData();
    }

    public ApiResponse<RoleAssignment> roleAssignmentGetWithHttpInfo(Integer applicationId, Integer roleAssignmentId) throws ApiException {
        Call call = this.roleAssignmentGetValidateBeforeCall(applicationId, roleAssignmentId, null, null);
        Type localVarReturnType = new TypeToken<RoleAssignment>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call roleAssignmentGetAsync(Integer applicationId, Integer roleAssignmentId, final ApiCallback<RoleAssignment> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.roleAssignmentGetValidateBeforeCall(applicationId, roleAssignmentId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RoleAssignment>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call roleAssignmentsGetCall(Integer applicationId, Integer applicationRoleId, Integer top, Integer skip, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/applications/{applicationId}/roleAssignments".replaceAll("\\{applicationId\\}", this.apiClient.escapeString(applicationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (applicationRoleId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("applicationRoleId", applicationRoleId));
        }
        if (top != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("top", top));
        }
        if (skip != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("skip", skip));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call roleAssignmentsGetValidateBeforeCall(Integer applicationId, Integer applicationRoleId, Integer top, Integer skip, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling roleAssignmentsGet(Async)");
        }
        Call call = this.roleAssignmentsGetCall(applicationId, applicationRoleId, top, skip, progressListener, progressRequestListener);
        return call;
    }

    public RoleAssignmentList roleAssignmentsGet(Integer applicationId, Integer applicationRoleId, Integer top, Integer skip) throws ApiException {
        ApiResponse<RoleAssignmentList> resp = this.roleAssignmentsGetWithHttpInfo(applicationId, applicationRoleId, top, skip);
        return resp.getData();
    }

    public ApiResponse<RoleAssignmentList> roleAssignmentsGetWithHttpInfo(Integer applicationId, Integer applicationRoleId, Integer top, Integer skip) throws ApiException {
        Call call = this.roleAssignmentsGetValidateBeforeCall(applicationId, applicationRoleId, top, skip, null, null);
        Type localVarReturnType = new TypeToken<RoleAssignmentList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call roleAssignmentsGetAsync(Integer applicationId, Integer applicationRoleId, Integer top, Integer skip, final ApiCallback<RoleAssignmentList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.roleAssignmentsGetValidateBeforeCall(applicationId, applicationRoleId, top, skip, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RoleAssignmentList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call roleAssignmentsPostCall(Integer applicationId, RoleAssignmentInput roleAssignment, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RoleAssignmentInput localVarPostBody = roleAssignment;
        String localVarPath = "/api/v1/applications/{applicationId}/roleAssignments".replaceAll("\\{applicationId\\}", this.apiClient.escapeString(applicationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call roleAssignmentsPostValidateBeforeCall(Integer applicationId, RoleAssignmentInput roleAssignment, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling roleAssignmentsPost(Async)");
        }
        Call call = this.roleAssignmentsPostCall(applicationId, roleAssignment, progressListener, progressRequestListener);
        return call;
    }

    public Integer roleAssignmentsPost(Integer applicationId, RoleAssignmentInput roleAssignment) throws ApiException {
        ApiResponse<Integer> resp = this.roleAssignmentsPostWithHttpInfo(applicationId, roleAssignment);
        return resp.getData();
    }

    public ApiResponse<Integer> roleAssignmentsPostWithHttpInfo(Integer applicationId, RoleAssignmentInput roleAssignment) throws ApiException {
        Call call = this.roleAssignmentsPostValidateBeforeCall(applicationId, roleAssignment, null, null);
        Type localVarReturnType = new TypeToken<Integer>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call roleAssignmentsPostAsync(Integer applicationId, RoleAssignmentInput roleAssignment, final ApiCallback<Integer> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.roleAssignmentsPostValidateBeforeCall(applicationId, roleAssignment, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Integer>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call workflowGetCall(Integer workflowId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/applications/workflows/{workflowId}".replaceAll("\\{workflowId\\}", this.apiClient.escapeString(workflowId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call workflowGetValidateBeforeCall(Integer workflowId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (workflowId == null) {
            throw new ApiException("Missing the required parameter 'workflowId' when calling workflowGet(Async)");
        }
        Call call = this.workflowGetCall(workflowId, progressListener, progressRequestListener);
        return call;
    }

    public Workflow workflowGet(Integer workflowId) throws ApiException {
        ApiResponse<Workflow> resp = this.workflowGetWithHttpInfo(workflowId);
        return resp.getData();
    }

    public ApiResponse<Workflow> workflowGetWithHttpInfo(Integer workflowId) throws ApiException {
        Call call = this.workflowGetValidateBeforeCall(workflowId, null, null);
        Type localVarReturnType = new TypeToken<Workflow>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call workflowGetAsync(Integer workflowId, final ApiCallback<Workflow> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.workflowGetValidateBeforeCall(workflowId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Workflow>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call workflowsGetCall(Integer applicationId, Integer top, Integer skip, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/applications/{applicationId}/workflows".replaceAll("\\{applicationId\\}", this.apiClient.escapeString(applicationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (top != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("top", top));
        }
        if (skip != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("skip", skip));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call workflowsGetValidateBeforeCall(Integer applicationId, Integer top, Integer skip, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling workflowsGet(Async)");
        }
        Call call = this.workflowsGetCall(applicationId, top, skip, progressListener, progressRequestListener);
        return call;
    }

    public WorkflowList workflowsGet(Integer applicationId, Integer top, Integer skip) throws ApiException {
        ApiResponse<WorkflowList> resp = this.workflowsGetWithHttpInfo(applicationId, top, skip);
        return resp.getData();
    }

    public ApiResponse<WorkflowList> workflowsGetWithHttpInfo(Integer applicationId, Integer top, Integer skip) throws ApiException {
        Call call = this.workflowsGetValidateBeforeCall(applicationId, top, skip, null, null);
        Type localVarReturnType = new TypeToken<WorkflowList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call workflowsGetAsync(Integer applicationId, Integer top, Integer skip, final ApiCallback<WorkflowList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.workflowsGetValidateBeforeCall(applicationId, top, skip, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WorkflowList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

