# coding: utf-8

"""
    Azure Blockchain Workbench REST API

    The Azure Blockchain Workbench REST API is a Workbench extensibility point, which allows developers to create and manage blockchain applications, manage users and organizations within a consortium, integrate blockchain applications into services and platforms, perform transactions on a blockchain, and retrieve transactional and contract data from a blockchain.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from swagger_client.models.contract_action import ContractAction  # noqa: F401,E501
from swagger_client.models.contract_property import ContractProperty  # noqa: F401,E501
from swagger_client.models.transaction import Transaction  # noqa: F401,E501


class Contract(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'int',
        'provisioning_status': 'int',
        'connection_id': 'int',
        'ledger_identifier': 'str',
        'deployed_by_user_id': 'int',
        'workflow_id': 'int',
        'contract_code_id': 'int',
        'contract_properties': 'list[ContractProperty]',
        'transactions': 'list[Transaction]',
        'contract_actions': 'list[ContractAction]'
    }

    attribute_map = {
        'id': 'id',
        'provisioning_status': 'provisioningStatus',
        'connection_id': 'connectionID',
        'ledger_identifier': 'ledgerIdentifier',
        'deployed_by_user_id': 'deployedByUserId',
        'workflow_id': 'workflowId',
        'contract_code_id': 'contractCodeId',
        'contract_properties': 'contractProperties',
        'transactions': 'transactions',
        'contract_actions': 'contractActions'
    }

    def __init__(self, id=None, provisioning_status=None, connection_id=None, ledger_identifier=None, deployed_by_user_id=None, workflow_id=None, contract_code_id=None, contract_properties=None, transactions=None, contract_actions=None):  # noqa: E501
        """Contract - a model defined in Swagger"""  # noqa: E501

        self._id = None
        self._provisioning_status = None
        self._connection_id = None
        self._ledger_identifier = None
        self._deployed_by_user_id = None
        self._workflow_id = None
        self._contract_code_id = None
        self._contract_properties = None
        self._transactions = None
        self._contract_actions = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if provisioning_status is not None:
            self.provisioning_status = provisioning_status
        if connection_id is not None:
            self.connection_id = connection_id
        if ledger_identifier is not None:
            self.ledger_identifier = ledger_identifier
        if deployed_by_user_id is not None:
            self.deployed_by_user_id = deployed_by_user_id
        if workflow_id is not None:
            self.workflow_id = workflow_id
        if contract_code_id is not None:
            self.contract_code_id = contract_code_id
        if contract_properties is not None:
            self.contract_properties = contract_properties
        if transactions is not None:
            self.transactions = transactions
        if contract_actions is not None:
            self.contract_actions = contract_actions

    @property
    def id(self):
        """Gets the id of this Contract.  # noqa: E501


        :return: The id of this Contract.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Contract.


        :param id: The id of this Contract.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def provisioning_status(self):
        """Gets the provisioning_status of this Contract.  # noqa: E501


        :return: The provisioning_status of this Contract.  # noqa: E501
        :rtype: int
        """
        return self._provisioning_status

    @provisioning_status.setter
    def provisioning_status(self, provisioning_status):
        """Sets the provisioning_status of this Contract.


        :param provisioning_status: The provisioning_status of this Contract.  # noqa: E501
        :type: int
        """

        self._provisioning_status = provisioning_status

    @property
    def connection_id(self):
        """Gets the connection_id of this Contract.  # noqa: E501


        :return: The connection_id of this Contract.  # noqa: E501
        :rtype: int
        """
        return self._connection_id

    @connection_id.setter
    def connection_id(self, connection_id):
        """Sets the connection_id of this Contract.


        :param connection_id: The connection_id of this Contract.  # noqa: E501
        :type: int
        """

        self._connection_id = connection_id

    @property
    def ledger_identifier(self):
        """Gets the ledger_identifier of this Contract.  # noqa: E501


        :return: The ledger_identifier of this Contract.  # noqa: E501
        :rtype: str
        """
        return self._ledger_identifier

    @ledger_identifier.setter
    def ledger_identifier(self, ledger_identifier):
        """Sets the ledger_identifier of this Contract.


        :param ledger_identifier: The ledger_identifier of this Contract.  # noqa: E501
        :type: str
        """

        self._ledger_identifier = ledger_identifier

    @property
    def deployed_by_user_id(self):
        """Gets the deployed_by_user_id of this Contract.  # noqa: E501


        :return: The deployed_by_user_id of this Contract.  # noqa: E501
        :rtype: int
        """
        return self._deployed_by_user_id

    @deployed_by_user_id.setter
    def deployed_by_user_id(self, deployed_by_user_id):
        """Sets the deployed_by_user_id of this Contract.


        :param deployed_by_user_id: The deployed_by_user_id of this Contract.  # noqa: E501
        :type: int
        """

        self._deployed_by_user_id = deployed_by_user_id

    @property
    def workflow_id(self):
        """Gets the workflow_id of this Contract.  # noqa: E501


        :return: The workflow_id of this Contract.  # noqa: E501
        :rtype: int
        """
        return self._workflow_id

    @workflow_id.setter
    def workflow_id(self, workflow_id):
        """Sets the workflow_id of this Contract.


        :param workflow_id: The workflow_id of this Contract.  # noqa: E501
        :type: int
        """

        self._workflow_id = workflow_id

    @property
    def contract_code_id(self):
        """Gets the contract_code_id of this Contract.  # noqa: E501


        :return: The contract_code_id of this Contract.  # noqa: E501
        :rtype: int
        """
        return self._contract_code_id

    @contract_code_id.setter
    def contract_code_id(self, contract_code_id):
        """Sets the contract_code_id of this Contract.


        :param contract_code_id: The contract_code_id of this Contract.  # noqa: E501
        :type: int
        """

        self._contract_code_id = contract_code_id

    @property
    def contract_properties(self):
        """Gets the contract_properties of this Contract.  # noqa: E501


        :return: The contract_properties of this Contract.  # noqa: E501
        :rtype: list[ContractProperty]
        """
        return self._contract_properties

    @contract_properties.setter
    def contract_properties(self, contract_properties):
        """Sets the contract_properties of this Contract.


        :param contract_properties: The contract_properties of this Contract.  # noqa: E501
        :type: list[ContractProperty]
        """

        self._contract_properties = contract_properties

    @property
    def transactions(self):
        """Gets the transactions of this Contract.  # noqa: E501


        :return: The transactions of this Contract.  # noqa: E501
        :rtype: list[Transaction]
        """
        return self._transactions

    @transactions.setter
    def transactions(self, transactions):
        """Sets the transactions of this Contract.


        :param transactions: The transactions of this Contract.  # noqa: E501
        :type: list[Transaction]
        """

        self._transactions = transactions

    @property
    def contract_actions(self):
        """Gets the contract_actions of this Contract.  # noqa: E501


        :return: The contract_actions of this Contract.  # noqa: E501
        :rtype: list[ContractAction]
        """
        return self._contract_actions

    @contract_actions.setter
    def contract_actions(self, contract_actions):
        """Sets the contract_actions of this Contract.


        :param contract_actions: The contract_actions of this Contract.  # noqa: E501
        :type: list[ContractAction]
        """

        self._contract_actions = contract_actions

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Contract):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
