# coding: utf-8

"""
    Azure Blockchain Workbench REST API

    The Azure Blockchain Workbench REST API is a Workbench extensibility point, which allows developers to create and manage blockchain applications, manage users and organizations within a consortium, integrate blockchain applications into services and platforms, perform transactions on a blockchain, and retrieve transactional and contract data from a blockchain.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class CapabilitiesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def can_create_contract(self, workflow_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Checks if user can modify user role mappings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.can_create_contract(workflow_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int workflow_id: The id of the application (required)
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.can_create_contract_with_http_info(workflow_id, **kwargs)  # noqa: E501
        else:
            (data) = self.can_create_contract_with_http_info(workflow_id, **kwargs)  # noqa: E501
            return data

    def can_create_contract_with_http_info(self, workflow_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Checks if user can modify user role mappings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.can_create_contract_with_http_info(workflow_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int workflow_id: The id of the application (required)
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method can_create_contract" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if ('workflow_id' not in params or
                params['workflow_id'] is None):
            raise ValueError("Missing the required parameter `workflow_id` when calling `can_create_contract`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/capabilities/canCreateContract/{workflowId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='bool',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def capabilities_get(self, **kwargs):  # noqa: E501
        """  # noqa: E501

        Checks if user can upload application  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.capabilities_get(async=True)
        >>> result = thread.get()

        :param async bool
        :return: Capabilities
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.capabilities_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.capabilities_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def capabilities_get_with_http_info(self, **kwargs):  # noqa: E501
        """  # noqa: E501

        Checks if user can upload application  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.capabilities_get_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: Capabilities
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method capabilities_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/capabilities', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Capabilities',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
