# swagger-java-client

Azure Blockchain Workbench REST API
- API version: v1

The Azure Blockchain Workbench REST API is a Workbench extensibility point, which allows developers to create and manage blockchain applications, manage users and organizations within a consortium, integrate blockchain applications into services and platforms, perform transactions on a blockchain, and retrieve transactional and contract data from a blockchain.


*Automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen)*

The generated code was augmented to include Microsoft's ADAL4J library to assist with making authenticated calls to Azure Active Directory. 

//ADAL specific
ExecutorService service = Executors.newFixedThreadPool(1);

AuthenticationContext ctx = new AuthenticationContext(authority, false, service);

ClientCredential clientCred = new ClientCredential(client, key);

AuthenticationResult authResult = ctx.acquireToken(client, clientCred,null).get();

//Generated API
UsersApi api = new UsersApi();

api.getApiClient().setBasePath("http://HOST:PORT");

api.getApiClient().addDefaultHeader("Authorization", "Bearer "+ authResult.getAccessToken());

System.out.println(api.meGet());


## Requirements

Building the API client library requires:
1. Java 1.7+
2. Maven/Gradle

## Installation

To install the API client library to your local Maven repository, simply execute:

```shell
mvn clean install
```

To deploy it to a remote Maven repository instead, configure the settings of the repository and execute:

```shell
mvn clean deploy
```

Refer to the [OSSRH Guide](http://central.sonatype.org/pages/ossrh-guide.html) for more information.

### Maven users

Add this dependency to your project's POM:

```xml
<dependency>
  <groupId>io.swagger</groupId>
  <artifactId>swagger-java-client</artifactId>
  <version>1.0.0</version>
  <scope>compile</scope>
</dependency>
```

### Gradle users

Add this dependency to your project's build file:

```groovy
compile "io.swagger:swagger-java-client:1.0.0"
```

### Others

At first generate the JAR by executing:

```shell
mvn clean package
```

Then manually install the following JARs:

* `target/swagger-java-client-1.0.0.jar`
* `target/lib/*.jar`

## Getting Started

Please follow the [installation](#installation) instruction and execute the following Java code:

```java

import io.swagger.client.*;
import io.swagger.client.auth.*;
import io.swagger.client.model.*;
import io.swagger.client.api.ApplicationsApi;

import java.io.File;
import java.util.*;

public class ApplicationsApiExample {

    public static void main(String[] args) {
        
        ApplicationsApi apiInstance = new ApplicationsApi();
        String applicationID = "applicationID_example"; // String | The id of the application.
        try {
            apiInstance.applicationDelete(applicationID);
        } catch (ApiException e) {
            System.err.println("Exception when calling ApplicationsApi#applicationDelete");
            e.printStackTrace();
        }
    }
}

```

## Documentation for API Endpoints

All URIs are relative to *https://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApplicationsApi* | [**applicationDelete**](generated/docs/ApplicationsApi.md#applicationDelete) | **DELETE** /api/v1/applications/{applicationID} | 
*ApplicationsApi* | [**applicationDisable**](generated/docs/ApplicationsApi.md#applicationDisable) | **PATCH** /api/v1/applications/{applicationID}/disable | 
*ApplicationsApi* | [**applicationEnable**](generated/docs/ApplicationsApi.md#applicationEnable) | **PATCH** /api/v1/applications/{applicationID}/enable | 
*ApplicationsApi* | [**applicationGet**](generated/docs/ApplicationsApi.md#applicationGet) | **GET** /api/v1/applications/{applicationId} | 
*ApplicationsApi* | [**applicationsGet**](generated/docs/ApplicationsApi.md#applicationsGet) | **GET** /api/v1/applications | 
*ApplicationsApi* | [**applicationsPost**](generated/docs/ApplicationsApi.md#applicationsPost) | **POST** /api/v1/applications | 
*ApplicationsApi* | [**contractCodeDelete**](generated/docs/ApplicationsApi.md#contractCodeDelete) | **DELETE** /api/v1/applications/contractCode/{contractCodeId} | 
*ApplicationsApi* | [**contractCodeGet**](generated/docs/ApplicationsApi.md#contractCodeGet) | **GET** /api/v1/applications/contractCode/{contractCodeId} | 
*ApplicationsApi* | [**contractCodePost**](generated/docs/ApplicationsApi.md#contractCodePost) | **POST** /api/v1/applications/{applicationId}/contractCode | 
*ApplicationsApi* | [**contractCodesGet**](generated/docs/ApplicationsApi.md#contractCodesGet) | **GET** /api/v1/applications/{applicationID}/contractCode | 
*ApplicationsApi* | [**roleAssignmentDelete**](generated/docs/ApplicationsApi.md#roleAssignmentDelete) | **DELETE** /api/v1/applications/{applicationId}/roleAssignments/{roleAssignmentId} | 
*ApplicationsApi* | [**roleAssignmentGet**](generated/docs/ApplicationsApi.md#roleAssignmentGet) | **GET** /api/v1/applications/{applicationId}/roleAssignments/{roleAssignmentId} | 
*ApplicationsApi* | [**roleAssignmentsGet**](generated/docs/ApplicationsApi.md#roleAssignmentsGet) | **GET** /api/v1/applications/{applicationId}/roleAssignments | 
*ApplicationsApi* | [**roleAssignmentsPost**](generated/docs/ApplicationsApi.md#roleAssignmentsPost) | **POST** /api/v1/applications/{applicationId}/roleAssignments | 
*ApplicationsApi* | [**workflowGet**](generated/docs/ApplicationsApi.md#workflowGet) | **GET** /api/v1/applications/workflows/{workflowId} | 
*ApplicationsApi* | [**workflowsGet**](generated/docs/ApplicationsApi.md#workflowsGet) | **GET** /api/v1/applications/{applicationId}/workflows | 
*CapabilitiesApi* | [**canCreateContract**](generated/docs/CapabilitiesApi.md#canCreateContract) | **GET** /api/v1/capabilities/canCreateContract/{workflowId} | 
*CapabilitiesApi* | [**capabilitiesGet**](generated/docs/CapabilitiesApi.md#capabilitiesGet) | **GET** /api/v1/capabilities | 
*CheckersApi* | [**checkApplicationPost**](generated/docs/CheckersApi.md#checkApplicationPost) | **POST** /api/v1/checkers/checkApplication | Check validity of application configuration for Workbench
*CheckersApi* | [**checkContractCodePost**](generated/docs/CheckersApi.md#checkContractCodePost) | **POST** /api/v1/checkers/checkContractCode | Check validity of application ledger implementation for Workbench
*ConnectionsApi* | [**blockGet**](generated/docs/ConnectionsApi.md#blockGet) | **GET** /api/v1/ledgers/connections/{connectionId}/blocks/{blockId} | 
*ConnectionsApi* | [**blocksGet**](generated/docs/ConnectionsApi.md#blocksGet) | **GET** /api/v1/ledgers/connections/{connectionId}/blocks | 
*ConnectionsApi* | [**connectionGet**](generated/docs/ConnectionsApi.md#connectionGet) | **GET** /api/v1/ledgers/connections/{connectionId} | 
*ConnectionsApi* | [**connectionsGet**](generated/docs/ConnectionsApi.md#connectionsGet) | **GET** /api/v1/ledgers/connections | 
*ConnectionsApi* | [**transactionGet**](generated/docs/ConnectionsApi.md#transactionGet) | **GET** /api/v1/ledgers/connections/{connectionId}/transactions/{transactionId} | 
*ConnectionsApi* | [**transactionsGet**](generated/docs/ConnectionsApi.md#transactionsGet) | **GET** /api/v1/ledgers/connections/{connectionId}/transactions | 
*ContractsApi* | [**contractActionGet**](generated/docs/ContractsApi.md#contractActionGet) | **GET** /api/v1/contracts/{contractId}/actions/{actionId} | 
*ContractsApi* | [**contractActionPost**](generated/docs/ContractsApi.md#contractActionPost) | **POST** /api/v1/contracts/{contractId}/actions | 
*ContractsApi* | [**contractActionsGet**](generated/docs/ContractsApi.md#contractActionsGet) | **GET** /api/v1/contracts/{contractId}/actions | 
*ContractsApi* | [**contractGet**](generated/docs/ContractsApi.md#contractGet) | **GET** /api/v1/contracts/{contractId} | 
*ContractsApi* | [**contractPost**](generated/docs/ContractsApi.md#contractPost) | **POST** /api/v1/contracts | 
*ContractsApi* | [**contractsGet**](generated/docs/ContractsApi.md#contractsGet) | **GET** /api/v1/contracts | 
*GraphProxyApi* | [**graphProxyUsersGet**](generated/docs/GraphProxyApi.md#graphProxyUsersGet) | **GET** /api/v1/graph-proxy/{version}/users | Get Users from AAD Graph
*LedgersApi* | [**ledgersGet**](generated/docs/LedgersApi.md#ledgersGet) | **GET** /api/v1/ledgers | 
*UsersApi* | [**meGet**](generated/docs/UsersApi.md#meGet) | **GET** /api/v1/users/me | 
*UsersApi* | [**userDelete**](generated/docs/UsersApi.md#userDelete) | **DELETE** /api/v1/users/{userID} | 
*UsersApi* | [**userGet**](generated/docs/UsersApi.md#userGet) | **GET** /api/v1/users/{userID} | 
*UsersApi* | [**usersGet**](generated/docs/UsersApi.md#usersGet) | **GET** /api/v1/users | Get Users
*UsersApi* | [**usersPost**](generated/docs/UsersApi.md#usersPost) | **POST** /api/v1/users | 


## Documentation for Models

 - [Application](generated/docs/Application.md)
 - [ApplicationList](generated/docs/ApplicationList.md)
 - [ApplicationRole](generated/docs/ApplicationRole.md)
 - [Block](generated/docs/Block.md)
 - [BlockList](generated/docs/BlockList.md)
 - [Capabilities](generated/docs/Capabilities.md)
 - [Connection](generated/docs/Connection.md)
 - [ConnectionList](generated/docs/ConnectionList.md)
 - [ContentResult](generated/docs/ContentResult.md)
 - [Contract](generated/docs/Contract.md)
 - [ContractAction](generated/docs/ContractAction.md)
 - [ContractActionParameter](generated/docs/ContractActionParameter.md)
 - [ContractCode](generated/docs/ContractCode.md)
 - [ContractCodeList](generated/docs/ContractCodeList.md)
 - [ContractList](generated/docs/ContractList.md)
 - [ContractProperty](generated/docs/ContractProperty.md)
 - [EntityTagHeaderValue](generated/docs/EntityTagHeaderValue.md)
 - [FileStreamResult](generated/docs/FileStreamResult.md)
 - [IFormFile](generated/docs/IFormFile.md)
 - [Ledger](generated/docs/Ledger.md)
 - [LedgerActionOutput](generated/docs/LedgerActionOutput.md)
 - [LedgerList](generated/docs/LedgerList.md)
 - [Me](generated/docs/Me.md)
 - [RoleAssignment](generated/docs/RoleAssignment.md)
 - [RoleAssignmentInput](generated/docs/RoleAssignmentInput.md)
 - [RoleAssignmentList](generated/docs/RoleAssignmentList.md)
 - [Stream](generated/docs/Stream.md)
 - [StringSegment](generated/docs/StringSegment.md)
 - [Transaction](generated/docs/Transaction.md)
 - [TransactionList](generated/docs/TransactionList.md)
 - [User](generated/docs/User.md)
 - [UserChainMapping](generated/docs/UserChainMapping.md)
 - [UserInput](generated/docs/UserInput.md)
 - [UserList](generated/docs/UserList.md)
 - [Workflow](generated/docs/Workflow.md)
 - [WorkflowActionInput](generated/docs/WorkflowActionInput.md)
 - [WorkflowDataType](generated/docs/WorkflowDataType.md)
 - [WorkflowFunction](generated/docs/WorkflowFunction.md)
 - [WorkflowFunctionParameter](generated/docs/WorkflowFunctionParameter.md)
 - [WorkflowList](generated/docs/WorkflowList.md)
 - [WorkflowProperty](generated/docs/WorkflowProperty.md)
 - [WorkflowState](generated/docs/WorkflowState.md)
 - [WorkflowStateTransition](generated/docs/WorkflowStateTransition.md)
 - [WorkflowStateTransitionList](generated/docs/WorkflowStateTransitionList.md)


## Documentation for Authorization

All endpoints do not require authorization.
Authentication schemes defined for the API:

## Recommendation

It's recommended to create an instance of `ApiClient` per thread in a multithreaded environment to avoid any potential issues.

## Author
