---
page_type: sample
languages:
  - csharp
  - java
  - nodejs
  - python
  - rest
  - solidity
products:
  - dotnet
  - azure
  - azure-blockchain-workbench
  - azure-blockchain-service
description: "This repository contains content and samples for the Azure Blockchain Workbench."
urlFragment: blockchain-samples
name: "Microsoft Azure Blockchain Workbench Samples"
---

# ![Microsoft Azure Blockchain Workbench](https://raw.githubusercontent.com/Azure-Samples/blockchain/master/blockchain-workbench/media/logo_small.png) Microsoft Azure Blockchain Workbench

*New!* Version 1.8.0 of Workbench has been released. Please see our [Release Notes](https://github.com/Azure-Samples/blockchain/tree/master/blockchain-workbench/CHANGELOG.md) and [Upgrade Instructions](https://github.com/Azure-Samples/blockchain/tree/master/blockchain-workbench/scripts/upgrade/readme.md) if you're running an older version.



> **Important Notice**
>
> **The Azure Blockchain Development Kit has been moved to its own [repository](https://github.com/azure-samples/blockchain-devkit)
> We are not accepting pull-requests for the development kit on this repository anymore.**
>
>

This repository contains content and samples in number of areas, including:

* [Applications and smart contracts for Azure Blockchain Workbench](https://github.com/Azure-Samples/blockchain/tree/master/blockchain-workbench/application-and-smart-contract-samples/readme.md)
* [Auth Samples](https://github.com/Azure-Samples/blockchain/tree/master/blockchain-workbench/auth-samples)
* [REST API](https://github.com/Azure-Samples/blockchain/tree/master/blockchain-workbench/rest-api-samples/readme.md) (including the swagger file and clients for .NET, Java, and Python)
* [Messaging Integration](https://github.com/Azure-Samples/blockchain/tree/master/blockchain-workbench/messaging-integration-samples/readme.md)
* [IoT Integration](https://github.com/Azure-Samples/blockchain/tree/master/blockchain-workbench/iot-integration-samples/readme.md)
* [Office Integration](https://github.com/Azure-Samples/blockchain/tree/master/blockchain-workbench/office-integration-samples/readme.md)
* [Technology Samples](https://github.com/Azure-Samples/blockchain/tree/master/blockchain-workbench/technology-samples/readme.md)
* [Data and Reporting](https://github.com/Azure-Samples/blockchain/tree/master/blockchain-workbench/data-reporting-samples/readme.md) (including CosmosDB, SQL DB, Excel, and PowerBI)
* [Deployment and Management Scripts and Upgrade Scripts](https://github.com/Azure-Samples/blockchain/tree/master/blockchain-workbench/scripts/readme.md)
* [Frequently Asked Questions](https://github.com/Azure-Samples/blockchain/tree/master/blockchain-workbench/faq/readme.md)

To learn more about Azure Blockchain Workbench, please visit our [product page](https://aka.ms/workbenchdocs) and [documentation](http://azure.microsoft.com/en-us/features/blockchain-workbench/).

## How to provide feedback

To provide feedback on these samples, please see our [Contribution Guidelines](https://github.com/Azure-Samples/blockchain/tree/master/CONTRIBUTING.md).

For general product feedback, please visit our [forum](https://techcommunity.microsoft.com/t5/Blockchain/bd-p/AzureBlockchain).

To request additional features or samples, visit our [UserVoice site](https://feedback.azure.com/forums/586780-blockchain).
