// Code generated by capnpc-go. DO NOT EDIT.

package capnp

import (
	capnp "capnproto.org/go/capnp/v3"
	text "capnproto.org/go/capnp/v3/encoding/text"
	schemas "capnproto.org/go/capnp/v3/schemas"
)

type TaskHashable capnp.Struct

// TaskHashable_TypeID is the unique identifier for the type TaskHashable.
const TaskHashable_TypeID = 0xe1f09ceb4ef5e479

func NewTaskHashable(s *capnp.Segment) (TaskHashable, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 12})
	return TaskHashable(st), err
}

func NewRootTaskHashable(s *capnp.Segment) (TaskHashable, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 12})
	return TaskHashable(st), err
}

func ReadRootTaskHashable(msg *capnp.Message) (TaskHashable, error) {
	root, err := msg.Root()
	return TaskHashable(root.Struct()), err
}

func (s TaskHashable) String() string {
	str, _ := text.Marshal(0xe1f09ceb4ef5e479, capnp.Struct(s))
	return str
}

func (s TaskHashable) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (TaskHashable) DecodeFromPtr(p capnp.Ptr) TaskHashable {
	return TaskHashable(capnp.Struct{}.DecodeFromPtr(p))
}

func (s TaskHashable) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s TaskHashable) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s TaskHashable) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s TaskHashable) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s TaskHashable) GlobalHash() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s TaskHashable) HasGlobalHash() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s TaskHashable) GlobalHashBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s TaskHashable) SetGlobalHash(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

func (s TaskHashable) TaskDependencyHashes() (capnp.TextList, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return capnp.TextList(p.List()), err
}

func (s TaskHashable) HasTaskDependencyHashes() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s TaskHashable) SetTaskDependencyHashes(v capnp.TextList) error {
	return capnp.Struct(s).SetPtr(1, v.ToPtr())
}

// NewTaskDependencyHashes sets the taskDependencyHashes field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s TaskHashable) NewTaskDependencyHashes(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(capnp.Struct(s).Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = capnp.Struct(s).SetPtr(1, l.ToPtr())
	return l, err
}
func (s TaskHashable) PackageDir() (string, error) {
	p, err := capnp.Struct(s).Ptr(2)
	return p.Text(), err
}

func (s TaskHashable) HasPackageDir() bool {
	return capnp.Struct(s).HasPtr(2)
}

func (s TaskHashable) PackageDirBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(2)
	return p.TextBytes(), err
}

func (s TaskHashable) SetPackageDir(v string) error {
	return capnp.Struct(s).SetText(2, v)
}

func (s TaskHashable) HashOfFiles() (string, error) {
	p, err := capnp.Struct(s).Ptr(3)
	return p.Text(), err
}

func (s TaskHashable) HasHashOfFiles() bool {
	return capnp.Struct(s).HasPtr(3)
}

func (s TaskHashable) HashOfFilesBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(3)
	return p.TextBytes(), err
}

func (s TaskHashable) SetHashOfFiles(v string) error {
	return capnp.Struct(s).SetText(3, v)
}

func (s TaskHashable) ExternalDepsHash() (string, error) {
	p, err := capnp.Struct(s).Ptr(4)
	return p.Text(), err
}

func (s TaskHashable) HasExternalDepsHash() bool {
	return capnp.Struct(s).HasPtr(4)
}

func (s TaskHashable) ExternalDepsHashBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(4)
	return p.TextBytes(), err
}

func (s TaskHashable) SetExternalDepsHash(v string) error {
	return capnp.Struct(s).SetText(4, v)
}

func (s TaskHashable) Task() (string, error) {
	p, err := capnp.Struct(s).Ptr(5)
	return p.Text(), err
}

func (s TaskHashable) HasTask() bool {
	return capnp.Struct(s).HasPtr(5)
}

func (s TaskHashable) TaskBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(5)
	return p.TextBytes(), err
}

func (s TaskHashable) SetTask(v string) error {
	return capnp.Struct(s).SetText(5, v)
}

func (s TaskHashable) Outputs() (TaskOutputs, error) {
	p, err := capnp.Struct(s).Ptr(6)
	return TaskOutputs(p.Struct()), err
}

func (s TaskHashable) HasOutputs() bool {
	return capnp.Struct(s).HasPtr(6)
}

func (s TaskHashable) SetOutputs(v TaskOutputs) error {
	return capnp.Struct(s).SetPtr(6, capnp.Struct(v).ToPtr())
}

// NewOutputs sets the outputs field to a newly
// allocated TaskOutputs struct, preferring placement in s's segment.
func (s TaskHashable) NewOutputs() (TaskOutputs, error) {
	ss, err := NewTaskOutputs(capnp.Struct(s).Segment())
	if err != nil {
		return TaskOutputs{}, err
	}
	err = capnp.Struct(s).SetPtr(6, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s TaskHashable) PassThruArgs() (capnp.TextList, error) {
	p, err := capnp.Struct(s).Ptr(7)
	return capnp.TextList(p.List()), err
}

func (s TaskHashable) HasPassThruArgs() bool {
	return capnp.Struct(s).HasPtr(7)
}

func (s TaskHashable) SetPassThruArgs(v capnp.TextList) error {
	return capnp.Struct(s).SetPtr(7, v.ToPtr())
}

// NewPassThruArgs sets the passThruArgs field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s TaskHashable) NewPassThruArgs(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(capnp.Struct(s).Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = capnp.Struct(s).SetPtr(7, l.ToPtr())
	return l, err
}
func (s TaskHashable) Env() (capnp.TextList, error) {
	p, err := capnp.Struct(s).Ptr(8)
	return capnp.TextList(p.List()), err
}

func (s TaskHashable) HasEnv() bool {
	return capnp.Struct(s).HasPtr(8)
}

func (s TaskHashable) SetEnv(v capnp.TextList) error {
	return capnp.Struct(s).SetPtr(8, v.ToPtr())
}

// NewEnv sets the env field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s TaskHashable) NewEnv(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(capnp.Struct(s).Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = capnp.Struct(s).SetPtr(8, l.ToPtr())
	return l, err
}
func (s TaskHashable) ResolvedEnvVars() (capnp.TextList, error) {
	p, err := capnp.Struct(s).Ptr(9)
	return capnp.TextList(p.List()), err
}

func (s TaskHashable) HasResolvedEnvVars() bool {
	return capnp.Struct(s).HasPtr(9)
}

func (s TaskHashable) SetResolvedEnvVars(v capnp.TextList) error {
	return capnp.Struct(s).SetPtr(9, v.ToPtr())
}

// NewResolvedEnvVars sets the resolvedEnvVars field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s TaskHashable) NewResolvedEnvVars(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(capnp.Struct(s).Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = capnp.Struct(s).SetPtr(9, l.ToPtr())
	return l, err
}
func (s TaskHashable) PassThruEnv() (capnp.TextList, error) {
	p, err := capnp.Struct(s).Ptr(10)
	return capnp.TextList(p.List()), err
}

func (s TaskHashable) HasPassThruEnv() bool {
	return capnp.Struct(s).HasPtr(10)
}

func (s TaskHashable) SetPassThruEnv(v capnp.TextList) error {
	return capnp.Struct(s).SetPtr(10, v.ToPtr())
}

// NewPassThruEnv sets the passThruEnv field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s TaskHashable) NewPassThruEnv(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(capnp.Struct(s).Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = capnp.Struct(s).SetPtr(10, l.ToPtr())
	return l, err
}
func (s TaskHashable) EnvMode() TaskHashable_EnvMode {
	return TaskHashable_EnvMode(capnp.Struct(s).Uint16(0))
}

func (s TaskHashable) SetEnvMode(v TaskHashable_EnvMode) {
	capnp.Struct(s).SetUint16(0, uint16(v))
}

func (s TaskHashable) DotEnv() (capnp.TextList, error) {
	p, err := capnp.Struct(s).Ptr(11)
	return capnp.TextList(p.List()), err
}

func (s TaskHashable) HasDotEnv() bool {
	return capnp.Struct(s).HasPtr(11)
}

func (s TaskHashable) SetDotEnv(v capnp.TextList) error {
	return capnp.Struct(s).SetPtr(11, v.ToPtr())
}

// NewDotEnv sets the dotEnv field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s TaskHashable) NewDotEnv(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(capnp.Struct(s).Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = capnp.Struct(s).SetPtr(11, l.ToPtr())
	return l, err
}

// TaskHashable_List is a list of TaskHashable.
type TaskHashable_List = capnp.StructList[TaskHashable]

// NewTaskHashable creates a new list of TaskHashable.
func NewTaskHashable_List(s *capnp.Segment, sz int32) (TaskHashable_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 12}, sz)
	return capnp.StructList[TaskHashable](l), err
}

// TaskHashable_Future is a wrapper for a TaskHashable promised by a client call.
type TaskHashable_Future struct{ *capnp.Future }

func (f TaskHashable_Future) Struct() (TaskHashable, error) {
	p, err := f.Future.Ptr()
	return TaskHashable(p.Struct()), err
}
func (p TaskHashable_Future) Outputs() TaskOutputs_Future {
	return TaskOutputs_Future{Future: p.Future.Field(6, nil)}
}

type TaskHashable_EnvMode uint16

// TaskHashable_EnvMode_TypeID is the unique identifier for the type TaskHashable_EnvMode.
const TaskHashable_EnvMode_TypeID = 0x8dc08a1d29f69b16

// Values of TaskHashable_EnvMode.
const (
	TaskHashable_EnvMode_loose  TaskHashable_EnvMode = 0
	TaskHashable_EnvMode_strict TaskHashable_EnvMode = 1
)

// String returns the enum's constant name.
func (c TaskHashable_EnvMode) String() string {
	switch c {
	case TaskHashable_EnvMode_loose:
		return "loose"
	case TaskHashable_EnvMode_strict:
		return "strict"

	default:
		return ""
	}
}

// TaskHashable_EnvModeFromString returns the enum value with a name,
// or the zero value if there's no such value.
func TaskHashable_EnvModeFromString(c string) TaskHashable_EnvMode {
	switch c {
	case "loose":
		return TaskHashable_EnvMode_loose
	case "strict":
		return TaskHashable_EnvMode_strict

	default:
		return 0
	}
}

type TaskHashable_EnvMode_List = capnp.EnumList[TaskHashable_EnvMode]

func NewTaskHashable_EnvMode_List(s *capnp.Segment, sz int32) (TaskHashable_EnvMode_List, error) {
	return capnp.NewEnumList[TaskHashable_EnvMode](s, sz)
}

type TaskOutputs capnp.Struct

// TaskOutputs_TypeID is the unique identifier for the type TaskOutputs.
const TaskOutputs_TypeID = 0xd58300fce8aba267

func NewTaskOutputs(s *capnp.Segment) (TaskOutputs, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return TaskOutputs(st), err
}

func NewRootTaskOutputs(s *capnp.Segment) (TaskOutputs, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return TaskOutputs(st), err
}

func ReadRootTaskOutputs(msg *capnp.Message) (TaskOutputs, error) {
	root, err := msg.Root()
	return TaskOutputs(root.Struct()), err
}

func (s TaskOutputs) String() string {
	str, _ := text.Marshal(0xd58300fce8aba267, capnp.Struct(s))
	return str
}

func (s TaskOutputs) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (TaskOutputs) DecodeFromPtr(p capnp.Ptr) TaskOutputs {
	return TaskOutputs(capnp.Struct{}.DecodeFromPtr(p))
}

func (s TaskOutputs) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s TaskOutputs) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s TaskOutputs) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s TaskOutputs) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s TaskOutputs) Inclusions() (capnp.TextList, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return capnp.TextList(p.List()), err
}

func (s TaskOutputs) HasInclusions() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s TaskOutputs) SetInclusions(v capnp.TextList) error {
	return capnp.Struct(s).SetPtr(0, v.ToPtr())
}

// NewInclusions sets the inclusions field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s TaskOutputs) NewInclusions(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(capnp.Struct(s).Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = capnp.Struct(s).SetPtr(0, l.ToPtr())
	return l, err
}
func (s TaskOutputs) Exclusions() (capnp.TextList, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return capnp.TextList(p.List()), err
}

func (s TaskOutputs) HasExclusions() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s TaskOutputs) SetExclusions(v capnp.TextList) error {
	return capnp.Struct(s).SetPtr(1, v.ToPtr())
}

// NewExclusions sets the exclusions field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s TaskOutputs) NewExclusions(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(capnp.Struct(s).Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = capnp.Struct(s).SetPtr(1, l.ToPtr())
	return l, err
}

// TaskOutputs_List is a list of TaskOutputs.
type TaskOutputs_List = capnp.StructList[TaskOutputs]

// NewTaskOutputs creates a new list of TaskOutputs.
func NewTaskOutputs_List(s *capnp.Segment, sz int32) (TaskOutputs_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return capnp.StructList[TaskOutputs](l), err
}

// TaskOutputs_Future is a wrapper for a TaskOutputs promised by a client call.
type TaskOutputs_Future struct{ *capnp.Future }

func (f TaskOutputs_Future) Struct() (TaskOutputs, error) {
	p, err := f.Future.Ptr()
	return TaskOutputs(p.Struct()), err
}

type GlobalHashable capnp.Struct

// GlobalHashable_TypeID is the unique identifier for the type GlobalHashable.
const GlobalHashable_TypeID = 0xea0b3688577e30b4

func NewGlobalHashable(s *capnp.Segment) (GlobalHashable, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 7})
	return GlobalHashable(st), err
}

func NewRootGlobalHashable(s *capnp.Segment) (GlobalHashable, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 7})
	return GlobalHashable(st), err
}

func ReadRootGlobalHashable(msg *capnp.Message) (GlobalHashable, error) {
	root, err := msg.Root()
	return GlobalHashable(root.Struct()), err
}

func (s GlobalHashable) String() string {
	str, _ := text.Marshal(0xea0b3688577e30b4, capnp.Struct(s))
	return str
}

func (s GlobalHashable) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (GlobalHashable) DecodeFromPtr(p capnp.Ptr) GlobalHashable {
	return GlobalHashable(capnp.Struct{}.DecodeFromPtr(p))
}

func (s GlobalHashable) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s GlobalHashable) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s GlobalHashable) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s GlobalHashable) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s GlobalHashable) GlobalCacheKey() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s GlobalHashable) HasGlobalCacheKey() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s GlobalHashable) GlobalCacheKeyBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s GlobalHashable) SetGlobalCacheKey(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

func (s GlobalHashable) GlobalFileHashMap() (GlobalHashable_Entry_List, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return GlobalHashable_Entry_List(p.List()), err
}

func (s GlobalHashable) HasGlobalFileHashMap() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s GlobalHashable) SetGlobalFileHashMap(v GlobalHashable_Entry_List) error {
	return capnp.Struct(s).SetPtr(1, v.ToPtr())
}

// NewGlobalFileHashMap sets the globalFileHashMap field to a newly
// allocated GlobalHashable_Entry_List, preferring placement in s's segment.
func (s GlobalHashable) NewGlobalFileHashMap(n int32) (GlobalHashable_Entry_List, error) {
	l, err := NewGlobalHashable_Entry_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return GlobalHashable_Entry_List{}, err
	}
	err = capnp.Struct(s).SetPtr(1, l.ToPtr())
	return l, err
}
func (s GlobalHashable) RootExternalDepsHash() (string, error) {
	p, err := capnp.Struct(s).Ptr(2)
	return p.Text(), err
}

func (s GlobalHashable) HasRootExternalDepsHash() bool {
	return capnp.Struct(s).HasPtr(2)
}

func (s GlobalHashable) RootExternalDepsHashBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(2)
	return p.TextBytes(), err
}

func (s GlobalHashable) SetRootExternalDepsHash(v string) error {
	return capnp.Struct(s).SetText(2, v)
}

func (s GlobalHashable) Env() (capnp.TextList, error) {
	p, err := capnp.Struct(s).Ptr(3)
	return capnp.TextList(p.List()), err
}

func (s GlobalHashable) HasEnv() bool {
	return capnp.Struct(s).HasPtr(3)
}

func (s GlobalHashable) SetEnv(v capnp.TextList) error {
	return capnp.Struct(s).SetPtr(3, v.ToPtr())
}

// NewEnv sets the env field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s GlobalHashable) NewEnv(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(capnp.Struct(s).Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = capnp.Struct(s).SetPtr(3, l.ToPtr())
	return l, err
}
func (s GlobalHashable) ResolvedEnvVars() (capnp.TextList, error) {
	p, err := capnp.Struct(s).Ptr(4)
	return capnp.TextList(p.List()), err
}

func (s GlobalHashable) HasResolvedEnvVars() bool {
	return capnp.Struct(s).HasPtr(4)
}

func (s GlobalHashable) SetResolvedEnvVars(v capnp.TextList) error {
	return capnp.Struct(s).SetPtr(4, v.ToPtr())
}

// NewResolvedEnvVars sets the resolvedEnvVars field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s GlobalHashable) NewResolvedEnvVars(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(capnp.Struct(s).Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = capnp.Struct(s).SetPtr(4, l.ToPtr())
	return l, err
}
func (s GlobalHashable) PassThroughEnv() (capnp.TextList, error) {
	p, err := capnp.Struct(s).Ptr(5)
	return capnp.TextList(p.List()), err
}

func (s GlobalHashable) HasPassThroughEnv() bool {
	return capnp.Struct(s).HasPtr(5)
}

func (s GlobalHashable) SetPassThroughEnv(v capnp.TextList) error {
	return capnp.Struct(s).SetPtr(5, v.ToPtr())
}

// NewPassThroughEnv sets the passThroughEnv field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s GlobalHashable) NewPassThroughEnv(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(capnp.Struct(s).Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = capnp.Struct(s).SetPtr(5, l.ToPtr())
	return l, err
}
func (s GlobalHashable) EnvMode() GlobalHashable_EnvMode {
	return GlobalHashable_EnvMode(capnp.Struct(s).Uint16(0))
}

func (s GlobalHashable) SetEnvMode(v GlobalHashable_EnvMode) {
	capnp.Struct(s).SetUint16(0, uint16(v))
}

func (s GlobalHashable) FrameworkInference() bool {
	return capnp.Struct(s).Bit(16)
}

func (s GlobalHashable) SetFrameworkInference(v bool) {
	capnp.Struct(s).SetBit(16, v)
}

func (s GlobalHashable) DotEnv() (capnp.TextList, error) {
	p, err := capnp.Struct(s).Ptr(6)
	return capnp.TextList(p.List()), err
}

func (s GlobalHashable) HasDotEnv() bool {
	return capnp.Struct(s).HasPtr(6)
}

func (s GlobalHashable) SetDotEnv(v capnp.TextList) error {
	return capnp.Struct(s).SetPtr(6, v.ToPtr())
}

// NewDotEnv sets the dotEnv field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s GlobalHashable) NewDotEnv(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(capnp.Struct(s).Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = capnp.Struct(s).SetPtr(6, l.ToPtr())
	return l, err
}

// GlobalHashable_List is a list of GlobalHashable.
type GlobalHashable_List = capnp.StructList[GlobalHashable]

// NewGlobalHashable creates a new list of GlobalHashable.
func NewGlobalHashable_List(s *capnp.Segment, sz int32) (GlobalHashable_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 7}, sz)
	return capnp.StructList[GlobalHashable](l), err
}

// GlobalHashable_Future is a wrapper for a GlobalHashable promised by a client call.
type GlobalHashable_Future struct{ *capnp.Future }

func (f GlobalHashable_Future) Struct() (GlobalHashable, error) {
	p, err := f.Future.Ptr()
	return GlobalHashable(p.Struct()), err
}

type GlobalHashable_EnvMode uint16

// GlobalHashable_EnvMode_TypeID is the unique identifier for the type GlobalHashable_EnvMode.
const GlobalHashable_EnvMode_TypeID = 0xab4200df8263c5d4

// Values of GlobalHashable_EnvMode.
const (
	GlobalHashable_EnvMode_infer  GlobalHashable_EnvMode = 0
	GlobalHashable_EnvMode_loose  GlobalHashable_EnvMode = 1
	GlobalHashable_EnvMode_strict GlobalHashable_EnvMode = 2
)

// String returns the enum's constant name.
func (c GlobalHashable_EnvMode) String() string {
	switch c {
	case GlobalHashable_EnvMode_infer:
		return "infer"
	case GlobalHashable_EnvMode_loose:
		return "loose"
	case GlobalHashable_EnvMode_strict:
		return "strict"

	default:
		return ""
	}
}

// GlobalHashable_EnvModeFromString returns the enum value with a name,
// or the zero value if there's no such value.
func GlobalHashable_EnvModeFromString(c string) GlobalHashable_EnvMode {
	switch c {
	case "infer":
		return GlobalHashable_EnvMode_infer
	case "loose":
		return GlobalHashable_EnvMode_loose
	case "strict":
		return GlobalHashable_EnvMode_strict

	default:
		return 0
	}
}

type GlobalHashable_EnvMode_List = capnp.EnumList[GlobalHashable_EnvMode]

func NewGlobalHashable_EnvMode_List(s *capnp.Segment, sz int32) (GlobalHashable_EnvMode_List, error) {
	return capnp.NewEnumList[GlobalHashable_EnvMode](s, sz)
}

type GlobalHashable_Entry capnp.Struct

// GlobalHashable_Entry_TypeID is the unique identifier for the type GlobalHashable_Entry.
const GlobalHashable_Entry_TypeID = 0xdd6c3d394436cf49

func NewGlobalHashable_Entry(s *capnp.Segment) (GlobalHashable_Entry, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return GlobalHashable_Entry(st), err
}

func NewRootGlobalHashable_Entry(s *capnp.Segment) (GlobalHashable_Entry, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return GlobalHashable_Entry(st), err
}

func ReadRootGlobalHashable_Entry(msg *capnp.Message) (GlobalHashable_Entry, error) {
	root, err := msg.Root()
	return GlobalHashable_Entry(root.Struct()), err
}

func (s GlobalHashable_Entry) String() string {
	str, _ := text.Marshal(0xdd6c3d394436cf49, capnp.Struct(s))
	return str
}

func (s GlobalHashable_Entry) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (GlobalHashable_Entry) DecodeFromPtr(p capnp.Ptr) GlobalHashable_Entry {
	return GlobalHashable_Entry(capnp.Struct{}.DecodeFromPtr(p))
}

func (s GlobalHashable_Entry) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s GlobalHashable_Entry) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s GlobalHashable_Entry) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s GlobalHashable_Entry) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s GlobalHashable_Entry) Key() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s GlobalHashable_Entry) HasKey() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s GlobalHashable_Entry) KeyBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s GlobalHashable_Entry) SetKey(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

func (s GlobalHashable_Entry) Value() (string, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return p.Text(), err
}

func (s GlobalHashable_Entry) HasValue() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s GlobalHashable_Entry) ValueBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return p.TextBytes(), err
}

func (s GlobalHashable_Entry) SetValue(v string) error {
	return capnp.Struct(s).SetText(1, v)
}

// GlobalHashable_Entry_List is a list of GlobalHashable_Entry.
type GlobalHashable_Entry_List = capnp.StructList[GlobalHashable_Entry]

// NewGlobalHashable_Entry creates a new list of GlobalHashable_Entry.
func NewGlobalHashable_Entry_List(s *capnp.Segment, sz int32) (GlobalHashable_Entry_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return capnp.StructList[GlobalHashable_Entry](l), err
}

// GlobalHashable_Entry_Future is a wrapper for a GlobalHashable_Entry promised by a client call.
type GlobalHashable_Entry_Future struct{ *capnp.Future }

func (f GlobalHashable_Entry_Future) Struct() (GlobalHashable_Entry, error) {
	p, err := f.Future.Ptr()
	return GlobalHashable_Entry(p.Struct()), err
}

type LockFilePackages capnp.Struct

// LockFilePackages_TypeID is the unique identifier for the type LockFilePackages.
const LockFilePackages_TypeID = 0xb470b49a14912305

func NewLockFilePackages(s *capnp.Segment) (LockFilePackages, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return LockFilePackages(st), err
}

func NewRootLockFilePackages(s *capnp.Segment) (LockFilePackages, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return LockFilePackages(st), err
}

func ReadRootLockFilePackages(msg *capnp.Message) (LockFilePackages, error) {
	root, err := msg.Root()
	return LockFilePackages(root.Struct()), err
}

func (s LockFilePackages) String() string {
	str, _ := text.Marshal(0xb470b49a14912305, capnp.Struct(s))
	return str
}

func (s LockFilePackages) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (LockFilePackages) DecodeFromPtr(p capnp.Ptr) LockFilePackages {
	return LockFilePackages(capnp.Struct{}.DecodeFromPtr(p))
}

func (s LockFilePackages) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s LockFilePackages) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s LockFilePackages) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s LockFilePackages) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s LockFilePackages) Packages() (Package_List, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Package_List(p.List()), err
}

func (s LockFilePackages) HasPackages() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s LockFilePackages) SetPackages(v Package_List) error {
	return capnp.Struct(s).SetPtr(0, v.ToPtr())
}

// NewPackages sets the packages field to a newly
// allocated Package_List, preferring placement in s's segment.
func (s LockFilePackages) NewPackages(n int32) (Package_List, error) {
	l, err := NewPackage_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return Package_List{}, err
	}
	err = capnp.Struct(s).SetPtr(0, l.ToPtr())
	return l, err
}

// LockFilePackages_List is a list of LockFilePackages.
type LockFilePackages_List = capnp.StructList[LockFilePackages]

// NewLockFilePackages creates a new list of LockFilePackages.
func NewLockFilePackages_List(s *capnp.Segment, sz int32) (LockFilePackages_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[LockFilePackages](l), err
}

// LockFilePackages_Future is a wrapper for a LockFilePackages promised by a client call.
type LockFilePackages_Future struct{ *capnp.Future }

func (f LockFilePackages_Future) Struct() (LockFilePackages, error) {
	p, err := f.Future.Ptr()
	return LockFilePackages(p.Struct()), err
}

type Package capnp.Struct

// Package_TypeID is the unique identifier for the type Package.
const Package_TypeID = 0xc2d08935698f1b78

func NewPackage(s *capnp.Segment) (Package, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Package(st), err
}

func NewRootPackage(s *capnp.Segment) (Package, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Package(st), err
}

func ReadRootPackage(msg *capnp.Message) (Package, error) {
	root, err := msg.Root()
	return Package(root.Struct()), err
}

func (s Package) String() string {
	str, _ := text.Marshal(0xc2d08935698f1b78, capnp.Struct(s))
	return str
}

func (s Package) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Package) DecodeFromPtr(p capnp.Ptr) Package {
	return Package(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Package) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Package) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Package) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Package) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Package) Key() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s Package) HasKey() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Package) KeyBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s Package) SetKey(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

func (s Package) Version() (string, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return p.Text(), err
}

func (s Package) HasVersion() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Package) VersionBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return p.TextBytes(), err
}

func (s Package) SetVersion(v string) error {
	return capnp.Struct(s).SetText(1, v)
}

func (s Package) Found() bool {
	return capnp.Struct(s).Bit(0)
}

func (s Package) SetFound(v bool) {
	capnp.Struct(s).SetBit(0, v)
}

// Package_List is a list of Package.
type Package_List = capnp.StructList[Package]

// NewPackage creates a new list of Package.
func NewPackage_List(s *capnp.Segment, sz int32) (Package_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2}, sz)
	return capnp.StructList[Package](l), err
}

// Package_Future is a wrapper for a Package promised by a client call.
type Package_Future struct{ *capnp.Future }

func (f Package_Future) Struct() (Package, error) {
	p, err := f.Future.Ptr()
	return Package(p.Struct()), err
}

type FileHashes capnp.Struct

// FileHashes_TypeID is the unique identifier for the type FileHashes.
const FileHashes_TypeID = 0xed110dc172c21b8f

func NewFileHashes(s *capnp.Segment) (FileHashes, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return FileHashes(st), err
}

func NewRootFileHashes(s *capnp.Segment) (FileHashes, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return FileHashes(st), err
}

func ReadRootFileHashes(msg *capnp.Message) (FileHashes, error) {
	root, err := msg.Root()
	return FileHashes(root.Struct()), err
}

func (s FileHashes) String() string {
	str, _ := text.Marshal(0xed110dc172c21b8f, capnp.Struct(s))
	return str
}

func (s FileHashes) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (FileHashes) DecodeFromPtr(p capnp.Ptr) FileHashes {
	return FileHashes(capnp.Struct{}.DecodeFromPtr(p))
}

func (s FileHashes) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s FileHashes) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s FileHashes) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s FileHashes) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s FileHashes) FileHashes() (FileHashes_Entry_List, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return FileHashes_Entry_List(p.List()), err
}

func (s FileHashes) HasFileHashes() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s FileHashes) SetFileHashes(v FileHashes_Entry_List) error {
	return capnp.Struct(s).SetPtr(0, v.ToPtr())
}

// NewFileHashes sets the fileHashes field to a newly
// allocated FileHashes_Entry_List, preferring placement in s's segment.
func (s FileHashes) NewFileHashes(n int32) (FileHashes_Entry_List, error) {
	l, err := NewFileHashes_Entry_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return FileHashes_Entry_List{}, err
	}
	err = capnp.Struct(s).SetPtr(0, l.ToPtr())
	return l, err
}

// FileHashes_List is a list of FileHashes.
type FileHashes_List = capnp.StructList[FileHashes]

// NewFileHashes creates a new list of FileHashes.
func NewFileHashes_List(s *capnp.Segment, sz int32) (FileHashes_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[FileHashes](l), err
}

// FileHashes_Future is a wrapper for a FileHashes promised by a client call.
type FileHashes_Future struct{ *capnp.Future }

func (f FileHashes_Future) Struct() (FileHashes, error) {
	p, err := f.Future.Ptr()
	return FileHashes(p.Struct()), err
}

type FileHashes_Entry capnp.Struct

// FileHashes_Entry_TypeID is the unique identifier for the type FileHashes_Entry.
const FileHashes_Entry_TypeID = 0x8932f7433db89d99

func NewFileHashes_Entry(s *capnp.Segment) (FileHashes_Entry, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return FileHashes_Entry(st), err
}

func NewRootFileHashes_Entry(s *capnp.Segment) (FileHashes_Entry, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return FileHashes_Entry(st), err
}

func ReadRootFileHashes_Entry(msg *capnp.Message) (FileHashes_Entry, error) {
	root, err := msg.Root()
	return FileHashes_Entry(root.Struct()), err
}

func (s FileHashes_Entry) String() string {
	str, _ := text.Marshal(0x8932f7433db89d99, capnp.Struct(s))
	return str
}

func (s FileHashes_Entry) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (FileHashes_Entry) DecodeFromPtr(p capnp.Ptr) FileHashes_Entry {
	return FileHashes_Entry(capnp.Struct{}.DecodeFromPtr(p))
}

func (s FileHashes_Entry) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s FileHashes_Entry) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s FileHashes_Entry) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s FileHashes_Entry) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s FileHashes_Entry) Key() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s FileHashes_Entry) HasKey() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s FileHashes_Entry) KeyBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s FileHashes_Entry) SetKey(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

func (s FileHashes_Entry) Value() (string, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return p.Text(), err
}

func (s FileHashes_Entry) HasValue() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s FileHashes_Entry) ValueBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return p.TextBytes(), err
}

func (s FileHashes_Entry) SetValue(v string) error {
	return capnp.Struct(s).SetText(1, v)
}

// FileHashes_Entry_List is a list of FileHashes_Entry.
type FileHashes_Entry_List = capnp.StructList[FileHashes_Entry]

// NewFileHashes_Entry creates a new list of FileHashes_Entry.
func NewFileHashes_Entry_List(s *capnp.Segment, sz int32) (FileHashes_Entry_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return capnp.StructList[FileHashes_Entry](l), err
}

// FileHashes_Entry_Future is a wrapper for a FileHashes_Entry promised by a client call.
type FileHashes_Entry_Future struct{ *capnp.Future }

func (f FileHashes_Entry_Future) Struct() (FileHashes_Entry, error) {
	p, err := f.Future.Ptr()
	return FileHashes_Entry(p.Struct()), err
}

const schema_e1dde60149aeb063 = "x\xda\xacV]l\x14U\x14\xfe\xce\xbd\xb3\xdd\xedv" +
	"\xebv3\xa3\xa8\x95\xa0\x88\x11L \xa5E\x94&X" +
	"(]l\x15\xa4\xe3\xa2\x86\x06\x1e\x86\xedmw\xed:" +
	"\xb3\xce\xec\x96\x96\x07Q\xf4\x01\x88\x86`xP\x84D" +
	"\x09&F\xe2\xcf\x03&hbBI\xfabb\xc4\x04" +
	"bbB\x1a\x125\x88\x90\xe8\x03\xca\x03\xc9\x983\xfb" +
	"7m\x11\x1f\xf4\xa9\xd3o\xbe\xf9\xce\xb9\xe7~\xe7\x9c" +
	"\xedxB\xae\xd3V\xb6\xfe\xa0A\x98\x8fG\x9a\xfcw" +
	"\x8f\x9d^\xbb\xe1\xaf\xce\xfdH- \xff`\xfbYw" +
	"\xaa5u\x0d\x11\x11\x05tS\\\xd1w\x04O\xdb\xc4" +
	".\x90\x7f\xd7{\x7f.[x\xe0\xcc[H\xdd#\xfc" +
	"\xc9\x9f\xae?\xf3\xdb\xd1\xdf/\x01\xd4\xf5\x85\x88\x93>" +
	"\x1d0\xa7\xc4c\xa0\x99\xf3\xd3\xd9\xbd3\xbd'S\xed" +
	"\xc2?\xd5\xf1\xca\x0b\xfbV\xb7\\a\xde\xb4\xb8\x97\xf4" +
	"\x0b\x01\xef{\xb1\x05\xe4G\x1e<d\x1c9U<\x85" +
	"T\x82\xfc\xec\xe7\x9f\x0e\xd0/\x17/!B\xcc\xf8Y" +
	"\\\xd1\xff\x08\xb8\xd7D\x0f\xc8\x9fh?\x98\x7ft\xff" +
	"\xb9\xb30\x13\x14&\x07\x94\x07\xe4q}\x99\xe4\xa7\x87" +
	"\xe4g\xa0\x99\xd1\xe3'/\xdf|\xfd\xc2l\xd9\x80\xf9" +
	"\xb5<\xabO\x07\xcc)\xc9\x87\x1a\xf8nu\xdf\x9a\xb5" +
	"\x85\x8bH\xb5S#\xd9\x80\xdb\x95\xd6\xe2\xa4?\xa7\x05" +
	"\xb5\xd0\x98\\?\xf4\x9c\x1c\x12L\xf9D\xfbF\xffR" +
	"[\x00tMi3\x02!\xb59\xec(\xb3\xd7\xc4~" +
	"\xd4\xd3\xb1\x87\x81\xaem1\x9f\x10*\xfe-j\xf1m" +
	"\xfc+\xfdB|\x01\xa0_\x8c\xf7`\xb9_t\x9d\x92" +
	"\xb3\"k\x89\xa2]\xec\xde\x98/\xa8~\xcb\xcb)o" +
	"E:i\x97\xdc\xc9A\"3&5@# \xb5l" +
	"1`.\x91dv\x08J\x11\x19\xc4\xe0\xf2N\xc0\\" +
	"*\xc9\\%(:\xa6&)\x01A\x09\xd0\xa2q\xab" +
	"PV\xb5\xff\xeaq$\xc7\xd9jyc\x1c\xc7\xdaY" +
	"P+\xd2\xf6\xf8fgX\x01A0\x12@*\xd5\x09" +
	"\x10\xa5\x9a\xbb\x81E\x05\xc7\xf1T\x8fWr\xf3\xd9\xd2" +
	"l\x95'\x0b\xceN\xab0[G\x0e+\x96I\x042" +
	"\x0b+2w\xf2\x1f\x91je\xb5\xbc=\xa2\xdc[k" +
	"\x06\x15\xd8\xe4d\xc7\xb8\x0a\x83Vv,i\x8d*\x8f" +
	"\xd5\xb4z\x05Z\x9f\x02\xcc\x84$s\xa9 \xbfhe" +
	"\xc7\x98\x02\x80\xee\x00\x0dJ\xa2\xb6\x86\xb7@\x0c\xd6\xd5" +
	"\x89\xd5Y5j\x8dVR\xac\x8b\xa6\xb9\xac\xeb$\x99" +
	"\x9bBe\x1d\xe8\x05\xcc>I\xe6\xa0 \x12Fp\x9e" +
	"\xcd\\\xea~I\xe6\xd6\xd9\xa5\xde3\xae\\/\xef\xd8" +
	"\xf5\xd2\x8f8e{\x98\x08\x82(\x94\x82\xa8\x95~K" +
	"\xb9T,\x97<\xcc\xb9\xdd\xa1\xeaE\xf6\x85\xd2X?" +
	"T\xcdm\xbb ?og\x0be/\xef@\xda^\xed" +
	"\xc4\x1c\x92\xcf\xa9&\xfe\xf9\xdd\xedo\xad\xe4N\x02\xff" +
	"\xbf\xd1\xc4\\\xa3\x01\xa6F\xe1\xd1C\xbd{\xaa\xde3" +
	"W\xd5B\xeb;h\x08\xc8l'I\x99\x1c5\xa2\xeb" +
	"\x8a>\x0629\xc6\xdf`\\T\xeeD\x7f-\xe0\xbf" +
	"\xca\xf8\x9b\x8cKi\x90\x04\xf4\xfd\xb4\x13\xc8\xecc\xfc" +
	"0\xe3\x9af\x90\x06\xe8\x87\xe8\x00\x909\xcc\xf8\xfb\x8c" +
	"G\"\x06E\x00\xfd\x18=\x02d\xdea\xfc\x04\xe3M" +
	"M\x065\x01\xfa\x07\xd4\x0bd\x8e2\xfe\x11\xe3\xd1\xa8" +
	"\x11\xf4\xf1\x87\xf4\"\x909\xc1\xf8\x19\xc6c1\x83b" +
	"<\x94h1\x909\xcd\xf8y\xc6\x9b\x9b\x0dj\xe6)" +
	"I{\x81\xcc9\xc6\xaf2\x1e\x8f\x1b\x14\x07\xf4_\x83" +
	"</3\xae\x09A\xd4bP\x0b\xa0\x93\xe0\xb07\x19" +
	"\x8e\x09A\xa9D\x8bA\x09@\x8f\x88n\xe0Y!)" +
	"s\x9f\x10\xe4\x8fV/\x13\xd2\xcb\xd5o\xa0dyc" +
	"}\xaa\xa8\xc8\x1eVvv\xb2\xdfJ\xf2D\x99g\x8a" +
	"J\xf7\xf4A\xe6\xdd\xfa\xa79\xcb\xcbm\x19\xd9\x98G" +
	"\xb4\xa0\xbc:\xaa&J\xca\xb5\xad\x02\xf5\xa9\xa2\xc7\xd7" +
	"\x09\xd4\xde%9X\xbd\x0f\x9c\x8a\xb1\xa9\xad6\xb5A" +
	"\xd4\x16\xc4\xf2\xbc\xad9\xb7\x8c\xe4zwtn&Q" +
	"e\x8f\xcfM\xceU\x9eS\x18W\xc3\x94\xb6\xc7\x9f\xb7" +
	"\\\x0f\xf3\xb3\xaf*F\xd3\xf3\xbe\xde\xa3*\xae\xa2d" +
	"\xc3l J\x82z\x86\x9d\xd2|\xfel\xcb\x86\xfbC" +
	"\x16\x94\x19\xa3\xc6\x12l\xee\x0d-\x99Hg\xcd\xbe\x8b" +
	"\x82&2\x97\xd4\xfb\xe7\xdan\xc0\xbc*\xc9\xbc\x11\xea" +
	"\x9f\xebo\x03\xe6\x0dI\x19#\xec\xdfT\xe0k\x83/" +
	"\xfa\xfe\xb0\x7f\x17\x06>\xba\x9b\xf1Ua\xff\xae\x0c|" +
	"\xd4\xc1\xf8\xa6\xb0\x7f\x07h7\x90\xe9g|\x98\x04Q" +
	"\xd5\xbeV`\xdfF;E\xdb*\xf6Ut\xa4\xd6N" +
	"\xa5\xc0\xbeM\x15\xfb\xbeL\xdd@\xa6\xc0\xf8>\xaa\x1b" +
	"l\x83\x85\x9elN=\xddh\xfa\xea\x8b\x8dy\xaal" +
	"\xac\xcd\x16\x15\x1bC\xb8^\xa4\xea\x10v\x1d\xa7\x94\x9e" +
	"()b\x17\xb1\x89\x92\xfcMM\xeb\xbf\x18\xc0AO" +
	"y4w;\x0f\xd4.\xaf\xe2\x00\x7f\xc4\xb5^R\xbb" +
	"\x1c\x97\xc6\x06x\x15)[fUmR\xff\x8b=\xa8" +
	"\xb6\xa2{*;:\x18g\x8d_]\xd4Y\xf5Ah" +
	"]\x0d\x85\xd6\xd5Hu\xb9C6\x9a\xb1\xad\xf1}\xa5" +
	"T\x7f\x07\x00\x00\xff\xffy\xdeB\xa6"

func RegisterSchema(reg *schemas.Registry) {
	reg.Register(&schemas.Schema{
		String: schema_e1dde60149aeb063,
		Nodes: []uint64{
			0x8932f7433db89d99,
			0x8dc08a1d29f69b16,
			0xab4200df8263c5d4,
			0xb470b49a14912305,
			0xc2d08935698f1b78,
			0xd58300fce8aba267,
			0xdd6c3d394436cf49,
			0xe1f09ceb4ef5e479,
			0xea0b3688577e30b4,
			0xed110dc172c21b8f,
		},
		Compressed: true,
	})
}
