package com.logseq.app;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.os.Build;
import android.provider.DocumentsContract;
import android.provider.Settings;
import android.util.Log;

import androidx.activity.result.ActivityResult;
import androidx.documentfile.provider.DocumentFile;

import com.getcapacitor.JSObject;
import com.getcapacitor.Plugin;
import com.getcapacitor.annotation.ActivityCallback;
import com.getcapacitor.annotation.CapacitorPlugin;
import com.getcapacitor.PluginCall;
import com.getcapacitor.PluginMethod;

import java.io.File;


@CapacitorPlugin(name = "FolderPicker")
public class FolderPicker extends Plugin {
    public static boolean FileAccessAllowed()
        {
            if (Build.VERSION.SDK_INT < Build.VERSION_CODES.R) {
                return true;
            } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.R) {
                return (Environment.isExternalStorageManager());
            }
            return false;
        }

    @PluginMethod()
    public void pickFolder(PluginCall call) {
        if (FileAccessAllowed()) {
            Intent i = new Intent(Intent.ACTION_OPEN_DOCUMENT_TREE);
            i.addCategory(Intent.CATEGORY_DEFAULT);
            startActivityForResult(call, i, "folderPickerResult");
        } else {
            Intent intent = new Intent(Settings.ACTION_MANAGE_APP_ALL_FILES_ACCESS_PERMISSION);
            Uri uri = Uri.fromParts("package", BuildConfig.APPLICATION_ID, null);
            intent.setData(uri);
            startActivityForResult(call, intent, 20);
        }
    }

    @ActivityCallback
    private void folderPickerResult(PluginCall call, ActivityResult result) {
        if (call == null) {
            return;
        }
        JSObject ret = new JSObject();
        Context context = this.getContext();
        Uri treeUri = result.getData().getData();
        Uri docUri = DocumentsContract.buildDocumentUriUsingTree(treeUri,
                DocumentsContract.getTreeDocumentId(treeUri));
        Log.i("Logseq/FolderPicker", "Got uri " + docUri);
        String path = FileUtil.getPath(context, docUri);
        Log.i("Logseq/FolderPicker", "Convert to path " + FileUtil.getPath(context, docUri));
        if (path == null || path.isEmpty()) {
            call.reject("Cannot support this directory type: " + docUri);
        } else {
            Uri folderUri = Uri.fromFile(new File(path));
            ret.put("path", folderUri.toString());
            call.resolve(ret);
        }
    }
}
