(ns ^:bb-compatible frontend.dicts
  "Provides dictionary entries for most of the application"
  #?(:cljs (:require [shadow.resource :as rc])))

(def ^:large-vars/data-var dicts
  {:en {:tutorial/text #?(:cljs (rc/inline "tutorial-en.md")
                          :default "tutorial-en.md")
        :tutorial/dummy-notes #?(:cljs (rc/inline "dummy-notes-en.md")
                                 :default "dummy-notes-en.md")
        :on-boarding/demo-graph "This is a demo graph, changes will not be saved until you open a local folder."
        :on-boarding/add-graph "Add a graph"
        :on-boarding/open-local-dir "Open a local directory"
        :on-boarding/new-graph-desc-1 "Logseq supports both Markdown and Org-mode. You can open an existing directory or create a new one on your device, a directory is also known simply as a folder. Your data will be stored only on this device."
        :on-boarding/new-graph-desc-2 "After you have opened your directory, it will create three folders in that directory:"
        :on-boarding/new-graph-desc-3 "/journals - store your journal pages"
        :on-boarding/new-graph-desc-4 "/pages - store the other pages"
        :on-boarding/new-graph-desc-5 "/logseq - store configuration, custom.css, and some metadata."
        :help/start "Getting started"
        :help/about "About Logseq"
        :help/roadmap "Roadmap"
        :help/bug "Bug report"
        :help/feature "Feature request"
        :help/changelog "Changelog"
        :help/blog "Logseq blog"
        :help/docs "Documentation"
        :help/privacy "Privacy policy"
        :help/terms "Terms"
        :help/community "Discord community"
        :help/forum-community "Forum community"
        :help/awesome-logseq "Awesome Logseq"
        :help/shortcuts "Keyboard shortcuts"
        :help/shortcuts-triggers "Triggers"
        :help/shortcut "Shortcut"
        :help/slash-autocomplete "Slash autocomplete"
        :help/block-content-autocomplete "Block content autocomplete"
        :help/reference-autocomplete "Page reference autocomplete"
        :help/block-reference "Block reference"
        :help/key-commands "Key commands"
        :help/working-with-lists " (working with lists)"
        :help/select-nfs-browser "Please use another browser (like latest chrome) which support NFS features to open local directory."
        :undo "Undo"
        :redo "Redo"
        :general "General"
        :more "More"
        :search/result-for "Search result for "
        :search/items "items"
        :search/page-names "Search page names"
        :help/context-menu "Block context menu"
        :help/fold-unfold "Fold/unfold blocks (when not in edit mode)"
        :help/markdown-syntax "Markdown syntax"
        :help/org-mode-syntax "Org mode syntax"
        :bold "Bold"
        :italics "Italics"
        :html-link "Html Link"
        :highlight "Highlight"
        :strikethrough "Strikethrough"
        :code "Code"
        :right-side-bar/help "Help"
        :right-side-bar/switch-theme "Theme modes"
        :right-side-bar/theme "{1} theme"
        :right-side-bar/page "Page graph"
        :right-side-bar/recent "Recent"
        :right-side-bar/contents "Contents"
        :right-side-bar/favorites "Favorites"
        :right-side-bar/page-graph "Page graph"
        :right-side-bar/block-ref "Block references"
        :right-side-bar/graph-view "Graph view"
        :right-side-bar/all-pages "All pages"
        :right-side-bar/flashcards "Flashcards"
        :right-side-bar/new-page "New page"
        :right-side-bar/show-journals "Show Journals"
        :left-side-bar/journals "Journals"
        :left-side-bar/new-page "New page"
        :left-side-bar/nav-favorites "Favorites"
        :left-side-bar/nav-shortcuts "Shortcuts"
        :left-side-bar/nav-recent-pages "Recent"
        :format/preferred-mode "What's your preferred mode?"
        :format/markdown "Markdown"
        :format/org-mode "Org mode"
        :reference/linked "Linked reference"
        :reference/unlinked-ref "Unlinked references"
        :page/presentation-mode "Presentation"
        :page/edit-properties-placeholder "Properties"
        :page/delete-success "Page {1} was deleted successfully!"
        :page/delete-confirmation "Are you sure you want to delete this page and its file?"
        :page/rename-to "Rename \"{1}\" to:"
        :page/priority "Priority \"{1}\""
        :page/copy-to-json "Copy the whole page as JSON"
        :page/rename "Rename page"
        :page/open-in-finder "Open in directory"
        :page/open-with-default-app "Open with default app"
        :page/action-publish "Publish"
        :page/make-public "Make it public for publishing"
        :page/version-history "Check page history"
        :page/open-backup-directory "Open page backups directory"
        :page/file-sync-versions "Page versions"
        :page/make-private "Make it private"
        :page/delete "Delete page"
        :page/add-to-favorites "Add to Favorites"
        :page/unfavorite "Unfavorite page"
        :page/show-journals "Show journals"
        :page/show-name "Show page name"
        :page/hide-name "Hide page name"
        :block/name "Page name"
        :page/last-modified "Last modified at"
        :page/new-title "What's your new page title?"
        :page/earlier "Earlier"
        :page/no-more-journals "No more journals"
        :page/copy-page-url "Copy page URL"
        :journal/multiple-files-with-different-formats "It seems that you have multiple journal files (with different formats) for the same month, please only keep one journal file for each month."
        :journal/go-to "Go to files"
        :file/name "File name"
        :file/file "File: "
        :file/last-modified-at "Last modified at"
        :file/no-data "No data"
        :file/format-not-supported "Format .{1} is not supported."
        :page/created-at "Created At"
        :page/updated-at "Updated At"
        :page/backlinks "Back Links"
        :linked-references/filter-search "Search in linked pages"
        :editor/block-search "Search for a block"
        :editor/image-uploading "Uploading"
        :draw/invalid-file "Could not load this invalid excalidraw file"
        :draw/specify-title "Please specify a title first!"
        :draw/rename-success "File was renamed successfully!"
        :draw/rename-failure "Rename file failed, reason: "
        :draw/title-placeholder "Untitled"
        :draw/save "Save"
        :draw/save-changes "Save changes"
        :draw/new-file "New file"
        :draw/list-files "List files"
        :draw/delete "Delete"
        :draw/more-options "More options"
        :draw/back-to-logseq "Back to logseq"
        :text/image "Image"
        :asset/confirm-delete "Are you sure you want to delete this {1}?"
        :asset/physical-delete "Remove the file too (notice it can't be restored)"
        :content/copy "Copy"
        :content/cut "Cut"
        :content/make-todos "Make {1}s"
        :content/copy-block-ref "Copy block ref"
        :content/copy-block-emebed "Copy block embed"
        :content/focus-on-block "Focus on block"
        :content/open-in-sidebar "Open in sidebar"
        :content/copy-as-json "Copy as JSON"
        :content/click-to-edit "Click to edit"
        :settings-page/git-desc "is used for pages version control, you can click the vertical three dots menu to check the page's history."
        :settings-page/git-confirm "You need to restart the app after updating the Git settings."
        :settings-page/git-switcher-label "Enable Git auto commit"
        :settings-page/git-commit-delay "Git auto commit seconds"
        :settings-page/edit-config-edn "Edit config.edn"
        :settings-page/edit-custom-css "Edit custom.css"
        :settings-page/edit-export-css "Edit export.css"
        :settings-page/custom-configuration "Custom configuration"
        :settings-page/custom-theme "Custom theme"
        :settings-page/export-theme "Export theme"
        :settings-page/show-brackets "Show brackets"
        :settings-page/spell-checker "Spell checker"
        :settings-page/auto-updater "Auto updater"
        :settings-page/disable-sentry "Send usage data and diagnostics to Logseq"
        :settings-page/preferred-outdenting "Logical outdenting"
        :settings-page/custom-date-format "Preferred date format"
        :settings-page/preferred-file-format "Preferred file format"
        :settings-page/preferred-workflow "Preferred workflow"
        :settings-page/enable-shortcut-tooltip "Enable shortcut tooltip"
        :settings-page/enable-timetracking "Timetracking"
        :settings-page/enable-tooltip "Tooltips"
        :settings-page/enable-journals "Journals"
        :settings-page/enable-all-pages-public "All pages public when publishing"
        :settings-page/enable-encryption "Encryption"
        :settings-page/customize-shortcuts "Keyboard shortcuts"
        :settings-page/shortcut-settings "Customize shortcuts"
        :settings-page/home-default-page "Set the default home page"
        :settings-page/enable-block-time "Block timestamps"
        :settings-page/clear-cache "Clear cache"
        :settings-page/clear "Clear"
        :settings-page/developer-mode "Developer mode"
        :settings-page/enable-developer-mode "Developer mode"
        :settings-page/disable-developer-mode "Disable developer mode"
        :settings-page/developer-mode-desc "Developer mode helps contributors and extension developers test their integrations with Logseq more efficiently."
        :settings-page/current-version "Current version"
        :settings-page/current-graph "Current graph"
        :settings-page/tab-general "General"
        :settings-page/tab-editor "Editor"
        :settings-page/tab-shortcuts "Shortcuts"
        :settings-page/tab-version-control "Version control"
        :settings-page/tab-advanced "Advanced"
        :settings-page/plugin-system "Plug-in system"
        :settings-page/enable-flashcards "Flashcards"
        :settings-page/network-proxy "Network proxy"
        :logseq "Logseq"
        :on "ON"
        :more-options "More options"
        :to "to"
        :yes "Yes"
        :no "No"
        :submit "Submit"
        :cancel "Cancel"
        :close "Close"
        :delete "Delete"
        :save "Save"
        :type "Type"
        :host "Host"
        :port "Port"
        :re-index "Re-index"
        :re-index-detail "Rebuild the graph"
        :re-index-multiple-windows-warning "You need to close the other windows before re-index this graph."
        :re-index-discard-unsaved-changes-warning "Re-index will discard the current graph, and then processes all the files again as they are currently stored on disk. You will lose unsaved changes and it might take a while. Continue?"
        :open-new-window "New window"
        :sync-from-local-files "Refresh"
        :sync-from-local-files-detail "Import changes from local files"
        :sync-from-local-changes-detected "Refresh detects and processes files modified on your disk and diverged from the actual Logseq page content. Continue?"

        :unlink "unlink"
        :search/publishing "Search"
        :search "Search or create page"
        :page-search "Search in the current page"
        :graph-search "Search graph"
        :new-page "New page"
        :new-file "New file"
        :new-graph "Add new graph"
        :graph "Graph"
        :graph-view "View graph"
        :graph/persist "Logseq is syncing internal status, please wait for several seconds."
        :graph/persist-error "Internal status sync failed."
        :graph/save "Saving..."
        :graph/save-success "Saved successfully"
        :graph/save-error "Save failed"
        :cards-view "View cards"
        :publishing "Publishing"
        :export "Export"
        :export-graph "Export graph"
        :export-page "Export page"
        :export-markdown "Export as standard Markdown (no block properties)"
        :export-opml "Export as OPML"
        :export-public-pages "Export public pages"
        :export-json "Export as JSON"
        :export-roam-json "Export as Roam JSON"
        :export-edn "Export as EDN"
        :export-datascript-edn "Export datascript EDN"
        :convert-markdown "Convert Markdown headings to unordered lists (# -> -)"
        :all-graphs "All graphs"
        :all-pages "All pages"
        :all-files "All files"
        :remove-orphaned-pages "Remove orphaned pages"
        :all-journals "All journals"
        :my-publishing "My publishing"
        :settings "Settings"
        :settings-of-plugins "Plugin Settings"
        :plugins "Plugins"
        :themes "Themes"
        :developer-mode-alert "You need to restart the app to enable the plugin system. Do you want to restart it now?"
        :relaunch-confirm-to-work "Should relaunch app to make it work. Do you want to restart it now?"
        :import "Import"
        :join-community "Join the community"
        :sponsor-us "Sponsor Us"
        :discourse-title "Our forum!"
        :discord-title "Our discord group!" ;; unused
        :help-shortcut-title "Click to check shortcuts and other tips"
        :loading "Loading"
        :cloning "Cloning"
        :parsing-files "Parsing files"
        :loading-files "Loading files"
        :login "Login"
        :logout "Logout"
        :go-to "Go to "
        :or "or"
        :download "Download"
        :repo/download-zip "Download all files as a zip"
        :language "Language"
        :white "Light"
        :dark "Dark"
        :remove-background "Remove background"
        :open "Open"
        :open-a-directory "Open a local directory"
        :user/delete-account "Delete account"
        :user/delete-your-account "Delete your account"
        :user/delete-account-notice "All your published pages on logseq.com will be deleted."

        :help/shortcut-page-title "Keyboard shortcuts"

        :plugin/installed "Installed"
        :plugin/not-installed "Not installed"
        :plugin/installing "Installing"
        :plugin/install "Install"
        :plugin/reload "Reload"
        :plugin/update "Update"
        :plugin/check-update "Check update"
        :plugin/check-all-updates "Check all updates"
        :plugin/refresh-lists "Refresh lists"
        :plugin/enabled "Enabled"
        :plugin/disabled "Disabled"
        :plugin/update-available "Update available"
        :plugin/updating "Updating"
        :plugin/uninstall "Uninstall"
        :plugin/marketplace "Marketplace"
        :plugin/downloads "Downloads"
        :plugin/stars "Stars"
        :plugin/title "Title"
        :plugin/all "All"
        :plugin/unpacked "Unpacked"
        :plugin/delete-alert "Are you sure uninstall plugin [{1}]?"
        :plugin/open-settings "Open settings"
        :plugin/open-package "Open package"
        :plugin/load-unpacked "Load unpacked plugin"
        :plugin/open-preferences "Open plugin preferences file"
        :plugin/restart "Restart App"
        :plugin/unpacked-tips "Select the plugin directory"
        :plugin/contribute "✨ Write and submit new plugin"
        :plugin/marketplace-tips "If the plugin doesn't work correctly when first installed, try to restart Logseq."
        :plugin/up-to-date "It's up to date"
        :plugin/custom-js-alert "Found the custom.js file, is it allowed to execute? (If you don't understand the content of this file, it is recommended not to allow execution, which has certain security risks.)"

        :pdf/copy-ref "Copy ref"
        :pdf/copy-text "Copy text"
        :pdf/linked-ref "Linked references"
        :pdf/toggle-dashed "Dashed style for area highlight"

        :updater/new-version-install "A new version has been downloaded."
        :updater/quit-and-install "Restart to install"

        :paginates/pages "Total {1} pages"
        :paginates/prev "Prev"
        :paginates/next "Next"

        :tips/all-done "All Done"

        :command-palette/prompt "Type a command"
        :select/default-prompt "Select one"
        :select.graph/prompt "Select a graph"
        :select.graph/empty-placeholder-description "No matched graphs. Do you want to add another one?"
        :select.graph/add-graph "Yes, add another graph"

        :file-sync/other-user-graph "Current local graph is bound to other user's remote graph. So can't start syncing."
        :file-sync/graph-deleted "Current remote graph has been deleted"
        }

   :de {:help/about "Über Logseq"
        :on-boarding/demo-graph "Dies ist ein Demo-Graph. Änderungen werden nicht gespeichert, solange Sie kein lokales Verzeichnis öffnen."
        :on-boarding/add-graph "Graph hinzufügen"
        :on-boarding/open-local-dir "Lokales Verzeichnis öffnen"
        :on-boarding/new-graph-desc-1 "Logseq unterstützt sowohl Markdown als auch Org-mode. Sie können ein bestehendes Verzeichnis öffnen oder auf Ihrem Rechner ein neues Verzeichnis anlegen. Ein Verzeichnis wird auch als Ordner bezeichnet. Ihre Daten werden nur auf diesem Gerät gespeichert."
        :on-boarding/new-graph-desc-2 "Nachdem Sie ein Verzeichnis geöffnet haben, werden darin drei Ordner angelegt:"
        :on-boarding/new-graph-desc-3 "/journals - enthält Ihre Journal-Seiten"
        :on-boarding/new-graph-desc-4 "/pages - enthält die anderen Seiten"
        :on-boarding/new-graph-desc-5 "/logseq - enthält die Konfiguration, custom.css und Metadaten."
        :help/bug "Fehlerbericht"
        :help/feature "Feature-Anfrage"
        :help/changelog "Änderungsprotokoll"
        :help/blog "Logseq Blog"
        :help/docs "Dokumentation"
        :help/privacy "Datenschutzrichtlinie"
        :help/terms "Bedingungen"
        :help/community "Discord-Community"
        :help/shortcuts "Tastaturkürzel"
        :help/shortcuts-triggers "Auslöser"
        :help/shortcut "Tastaturkürzel"
        :help/slash-autocomplete "/-Autovervollständigung"
        :help/block-content-autocomplete "Blockinhalt (Quelltext, Zitate, Abfragen, etc.) Autovervollständigung"
        :help/reference-autocomplete "Seitenverweis Autovervollständigung"
        :help/block-reference "Blockverweis"
        :help/key-commands "Tastenbefehle"
        :help/working-with-lists " (mit Listen arbeiten)"
        :help/select-nfs-browser "Bitte einen anderen Browser verwenden (z. B. den neuesten Chrome), der NFS-Funktionen unterstützt, um lokale Verzeichnisse zu öffnen."
        :undo "Rückgängig machen"
        :redo "Wiederholen"
        :general "Allgemein"
        :help/context-menu "Kontextmenü"
        :help/fold-unfold "Blöcke ein-/ausklappen (wenn nicht im Bearbeitungsmodus)"
        :help/markdown-syntax "Markdown-Syntax"
        :help/org-mode-syntax "Org-Mode-Syntax"
        :new-graph "Neuen Graphen hinzufügen"
        :bold "Fett"
        :italics "Kursiv"
        :html-link "HTML-Link"
        :highlight "Hervorhebung"
        :strikethrough "Durchstreichung"
        :code "Quelltext"
        :right-side-bar/help "Hilfe"
        :right-side-bar/switch-theme "Zu {1} Thema wechseln"
        :right-side-bar/theme "{1} Thema"
        :right-side-bar/page "Seiten-Graph"
        :right-side-bar/recent "Neueste"
        :right-side-bar/contents "Inhalt"
        :right-side-bar/block-ref "Blockreferenz"
        :right-side-bar/graph-view "Graph View"
        :right-side-bar/all-pages "Alle Seiten"
        :right-side-bar/flashcards "Flashcards"
        :right-side-bar/new-page "Neue Seite"
        :left-side-bar/journals "Journale"
        :format/preferred-mode "Was ist Ihr bevorzugter Modus?"
        :format/markdown "Markdown"
        :format/org-mode "Org-Mode"
        :reference/linked "Verknüpfte Referenz"
        :reference/unlinked-ref "Unverknüpfte Referenz"
        :page/presentation-mode "Präsentationsmodus"
        :page/edit-properties-placeholder "Klicken Sie hier, um die Eigenschaften dieser Seite zu bearbeiten"
        :page/delete-success "Die Seite {1} wurde erfolgreich gelöscht!"
        :page/delete-confirmation "Diese Seite und die zugehörige Datei löschen?"
        :page/rename-to "\"{1}\" umbenennen nach:"
        :page/priority "Priorität \"{1}\""
        :page/copy-to-json "Gesamte Seite als JSON kopieren"
        :page/rename "Seite umbenennen"
        :page/open-in-finder "Im Verzeichnis öffnen"
        :page/open-with-default-app "Mit Standard-Anwendung öffnen"
        :page/action-publish "Veröffentlichen"
        :page/make-public "Beim Export in HTML veröffentlichen"
        :page/make-private "Privat machen"
        :page/delete "Seite löschen"
        :page/show-journals "Journal anzeigen"
        :page/show-name "Seitennamen anzeigen"
        :page/hide-name "Seitennamen verbergen"
        :block/name "Seitenname"
        :page/last-modified "Zuletzt geändert am"
        :page/new-title "Wie lautet der neue Seitenname?"
        :journal/multiple-files-with-different-formats "Es scheint, dass Sie mehrere Journaldateien (mit unterschiedlichen Formaten) für denselben Monat haben, bitte führen Sie nur eine Journaldatei für jeden Monat."
        :journal/go-to "Zu Dateien gehen"
        :file/name "Dateinamen"
        :file/file "Datei: "
        :file/last-modified-at "Zuletzt geändert am"
        :file/no-data "Keine Daten"
        :file/format-not-supported "Format .{1} wird nicht unterstützt."
        :editor/block-search "Nach einem Block suchen"
        :editor/image-uploading "Hochladen"
        :draw/invalid-file "Diese ungültige Excalidraw-Datei konnte nicht geladen werden"
        :draw/specify-title "Bitte zuerst einen Titel angeben!"
        :draw/rename-success "Die Datei wurde erfolgreich umbenannt!"
        :draw/rename-failure "Umbennenung der Datei fehlgeschlagen, Grund: "
        :draw/title-placeholder "Unbenannt"
        :draw/save "Speichern"
        :draw/save-changes "Änderungen speichern"
        :draw/new-file "Neue Datei"
        :draw/list-files "Dateien auflisten"
        :draw/delete "Löschen"
        :draw/more-options "Weitere Optionen"
        :draw/back-to-logseq "Zurück zu Logseq"
        :text/image "Bild"
        :asset/confirm-delete "{1} wirklich löschen?"
        :asset/physical-delete "Datei ebenfalls entfernen (Achtung: die Datei kann nicht wiederhergestellt werden)"
        :content/copy "Kopieren"
        :content/cut "Ausschneiden"
        :content/make-todos "{1}s erstellen"
        :content/copy-block-ref "Blockreferenz kopieren"
        :content/focus-on-block "Auf Block fokussieren"
        :content/open-in-sidebar "In Seitenleiste öffnen"
        :content/copy-as-json "Als JSON kopieren"
        :content/click-to-edit "Klicken zum bearbeiten"
        :settings-page/edit-config-edn "config.edn bearbeiten (im aktuellen Repository)"
        :settings-page/git-desc "wird für die Seiten-Versionskontrolle benutzt. Sie können das Menü mit den drei vertikalen Punkten anklicken, um den Änderungsverlauf der Seite zu sehen."
        :settings-page/git-confirm "Sie müssen die App neu starten, nachdem Sie die Git-Einstellungen angepasst haben."
        :settings-page/git-switcher-label "Git Auto Commit aktivieren"
        :settings-page/git-commit-delay "Anzahl Sekunden für Git Auto Commit"
        :settings-page/show-brackets "Klammern anzeigen"
        :settings-page/preferred-file-format "Bevorzugtes Datei-Format"
        :settings-page/preferred-workflow "Bevorzugter Workflow"
        :settings-page/enable-timetracking "Zeiterfassung einschalten"
        :settings-page/enable-journals "Journale einschalten"
        :settings-page/home-default-page "Standard-Homepage einrichten"
        :settings-page/enable-block-time "Zeitstempel für Blöcke aktivieren"
        :settings-page/developer-mode "Entwicklermodus"
        :settings-page/enable-developer-mode "Entwicklermodus aktivieren"
        :settings-page/disable-developer-mode "Entwicklermodus deaktivieren"
        :settings-page/developer-mode-desc "Der Entwicklermodus hilft Mitwirkenden und Erweiterungsentwicklern, ihre Integration mit Logseq effizienter zu testen."
        :settings-page/current-version "Aktuelle Version"
        :logseq "Logseq"
        :on "AN"
        :more-options "Weitere Optionen"
        :to "zu"
        :yes "Ja"
        :submit "Senden"
        :cancel "Abbrechen"
        :re-index "Neu indizieren"
        :export-json "Als JSON exportieren"
        :unlink "Verknüpfung aufheben"
        :search/publishing "Suchen"
        :search "Suchen oder Seite erstellen"
        :new-page "Neue Seite"
        :new-file "Neue Datei"
        :graph "Graph"
        :publishing "Veröffentlichung"
        :export "Exportieren"
        :all-graphs "Alle Graphen"
        :all-pages "Alle Seiten"
        :all-files "Alle Dateien"
        :all-journals "Alle Journale"
        :my-publishing "Meine Veröffentlichungen"
        :settings "Einstellungen"
        :import "Importieren"
        :join-community "Community"
        :sponsor-us "Sponsern"
        :discord-title "Unsere Discord-Gruppe!"
        :help-shortcut-title "Hier klicken, um Tastenkombinationen und weitere Tipps zu sehen"
        :loading "Laden"
        :cloning "Klonen"
        :parsing-files "Dateien analysieren"
        :loading-files "Dateien laden"
        :login "Einloggen"
        :logout "Ausloggen"
        :go-to "Gehe zu "
        :or "oder"
        :download "Herunterladen"
        :repo/download-zip "Alle Dateien als Zip herunterladen"
        :language "Sprache"
        :white "Hell"
        :dark "Dunkel"
        :remove-background "Hintergrund entfernen"
        :open "Öffnen"
        :open-a-directory "Öffne ein lokales Verzeichnis"
        :cards-view "Cards anzeigen"
        :close "Schließen"
        :delete "Löschen"
        :export-datascript-edn "Datascript EDN exportieren"
        :export-edn "Als EDN exportieren"
        :export-graph "Graph exportieren"
        :export-markdown "Als Standard-Markdown exportieren (ohne Block-Eigenschaften)"
        :export-opml "Als OPML exportieren"
        :export-page "Seite exportieren"
        :export-public-pages "Öffentliche Seiten exportieren"
        :export-roam-json "Als Roam JSON exportieren"
        :graph-search "Graph durchsuchen"
        :graph-view "Graph anzeigen"
        :more "Mehr"
        :no "Nein"
        :open-new-window "Neues Fenster"
        :page-search "In der aktuellen Seite suchen"
        :plugins "Plugins"
        :re-index-detail "Graph neu aufbauen"
        :remove-orphaned-pages "Verweiste Seiten entfernen"
        :sync-from-local-files "Aktualisieren"
        :sync-from-local-files-detail "Änderungen aus lokalen Dateien importieren"
        :themes "Themes"
        :command-palette/prompt "Befehl eingeben"
        :content/copy-block-emebed "Blockeinbettung kopieren"
        :help/awesome-logseq "Awesome Logseq"
        :help/roadmap "Roadmap"
        :help/shortcut-page-title "Tastaturbefehl"
        :help/start "Einstieg"
        :left-side-bar/nav-favorites "Favoriten"
        :left-side-bar/nav-recent-pages "Neuste"
        :left-side-bar/nav-shortcuts "Verknüpfungen"
        :left-side-bar/new-page "Neue Seite"
        :page/add-to-favorites "Zu Favoriten hinzufügen"
        :page/backlinks "Backlinks"
        :page/created-at "Erstellt am"
        :page/earlier "Früher"
        :page/no-more-journals "Keine weiteren Journale"
        :page/unfavorite "Seite aus Favoriten entfernen"
        :page/updated-at "Aktualisiert am"
        :page/version-history "Seitenverlauf anzeigen"
        :paginates/next "Weiter"
        :paginates/pages "Total {1} Seiten"
        :paginates/prev "Zurück"
        :pdf/copy-ref "Referenz kopieren"
        :pdf/copy-text "Text kopieren"
        :pdf/linked-ref "Verlinkte Referenzen"
        :plugin/all "Alle"
        :plugin/check-all-updates "Alle Updates überprüfen"
        :plugin/check-update "Update überprüfen"
        :plugin/contribute "✨ Schreiben und veröffentlichen Sie ein neues Plugin"
        :plugin/delete-alert "Wollen Sie wirklich das Plugin [{1}] deinstallieren?"
        :plugin/disabled "Deaktiviert"
        :plugin/downloads "Downloads"
        :plugin/enabled "Aktiviert"
        :plugin/install "Installieren"
        :plugin/installed "Installiert"
        :plugin/installing "Installiere"
        :plugin/marketplace "Marketplace"
        :plugin/open-package "Paket öffnen"
        :plugin/open-preferences "Datei mit Plugin-Präferenzen öffnen"
        :plugin/open-settings "Einstellungen öffnen"
        :plugin/refresh-lists "Liste aktualisieren"
        :plugin/reload "Neu laden"
        :plugin/restart "App neu starten"
        :plugin/stars "Sterne"
        :plugin/title "Titel"
        :plugin/uninstall "Deinstallieren"
        :plugin/unpacked-tips "Plugin-Verzeichnis auswählen"
        :plugin/update "Update"
        :plugin/update-available "Update verfügbar"
        :plugin/updating "Aktualisiere"
        :right-side-bar/favorites "Favoriten"
        :search/page-names "In Seitennamen suchen"
        :search/result-for "Suchresultate für"
        :select.graph/add-graph "Ja, weiteren Graphen hinzufügen"
        :select.graph/prompt "Einen Graphen auswählen"
        :settings-page/auto-updater "Automatisches Update"
        :settings-page/clear "Löschen"
        :settings-page/clear-cache "Cache löschen"
        :settings-page/current-graph "Aktueller Graph"
        :settings-page/custom-configuration "Individuelle Konfiguration"
        :settings-page/custom-date-format "Bevorzugtes Datumsformat"
        :settings-page/custom-theme "Individuelles Theme"
        :settings-page/customize-shortcuts "Tastaturbefehle"
        :settings-page/disable-sentry "Nutzungs- und Diagnostik-Daten an Logseq senden"
        :settings-page/edit-custom-css "custom.css bearbeiten"
        :settings-page/enable-encryption "Verschlüsselung"
        :settings-page/enable-shortcut-tooltip "Tooltips für Verknüpfungen aktivieren"
        :settings-page/enable-tooltip "Tooltips"
        :settings-page/shortcut-settings "Verknüpfungen anpassen"
        :settings-page/spell-checker "Rechtschreibprüfung"
        :settings-page/tab-advanced "Erweitert"
        :settings-page/tab-editor "Editor"
        :settings-page/tab-general "Allgemein"
        :settings-page/tab-shortcuts "Verknüpfungen"
        :settings-page/tab-version-control "Versionskontrolle"
        :tips/all-done "Alles erledigt"
        :updater/new-version-install "Eine neue Version wurde heruntergeladen."
        :updater/quit-and-install "Neu starten, um zu installieren"
        :user/delete-account "Konto löschen"
        :user/delete-your-account "Ihr Konto löschen"

        :file-sync/other-user-graph "Aktuelle lokale Grafik ist an das Remote-Graph des anderen Benutzers gebunden. Kann also nicht mit der Synchronisierung beginnen."
        :file-sync/graph-deleted "Das aktuelle Ferndiagramm wurde gelöscht"
        }

   :fr {:help/about "A propos de Logseq"
        :help/bug "Signaler une anomalie"
        :help/feature "Demander une fonctionnalité"
        :help/changelog "Journal des modifications"
        :help/blog "Blog de Logseq"
        :help/docs "Documentation"
        :help/privacy "Politique de confidentialité"
        :help/terms "Conditions d'utilisation"
        :help/community "Communauté Discord"
        :help/shortcuts "Raccourcis clavier"
        :help/shortcuts-triggers "Actions déclenchées"
        :help/shortcut "Raccourcis"
        :help/slash-autocomplete "Slash Autocomplétion"
        :help/block-content-autocomplete "Autocomplétion du contenu du Bloc (Src, Quote, Query, etc)"
        :help/reference-autocomplete "Autocomplétion des références à une Page"
        :help/block-reference "Référence à un Bloc"
        :help/key-commands "Key Commands"
        :undo "Annuler"
        :redo "Redo"
        :general "Général"
        :help/context-menu "Menu contextuel"
        :help/fold-unfold "Plier/Déplier les blocs (hors mode édition)"
        :help/markdown-syntax "Syntaxe Markdown"
        :help/org-mode-syntax "Syntaxe Org mode"
        :bold "Gras"
        :italics "Italique"
        :html-link "Lien HTML"
        :highlight "Surligner"
        :strikethrough "Barré"
        :code "Code"
        :right-side-bar/help "Aide"
        :right-side-bar/switch-theme "Basculer sur le thème {1}"
        :right-side-bar/theme "Thème {1}"
        :right-side-bar/page "Graphe de la page"
        :right-side-bar/recent "Récents"
        :right-side-bar/contents "Contenus"
        :right-side-bar/block-ref "Référence des blocs"
        :right-side-bar/graph-view "Graph view"
        :right-side-bar/all-pages "Toutes les pages"
        :right-side-bar/flashcards "Flashcards"
        :right-side-bar/new-page "Nouvelle page"
        :left-side-bar/journals "Journals"
        :format/preferred-mode "Quel est votre format préféré ?"
        :format/markdown "Markdown"
        :format/org-mode "Org Mode"
        :reference/linked "Références liées"
        :reference/unlinked-ref "Références non liées"
        :page/presentation-mode "Mode présentation"
        :page/delete-success "Page {1} supprimée !"
        :page/delete-confirmation "Etes-vous sûr de vouloir supprimer la page ?"
        :page/rename-to "Renommer \"{1}\" en:"
        :page/priority "Priorité \"{1}\""
        :page/copy-to-json "Copier la page au format JSON"
        :page/rename "Renommer la page"
        :page/make-public "Rendre la page publique"
        :page/make-private "Rendre la page privée"
        :page/delete "Supprimer la page (supprime le fichier)"
        :page/show-journals "Afficher le Journal"
        :page/show-name "Afficher le nom de la page"
        :page/hide-name "Cacher le nom de la page"
        :block/name "Nom de la page"
        :page/last-modified "Dernières modifications à"
        :page/new-title "Quel est le nouveau titre de la page ?"
        :journal/multiple-files-with-different-formats "Il semble que vous avez plusieurs fichier de journal (sous différents formats) pour le même mois, veuillez ne conserver qu'un fichier par mois."
        :journal/go-to "Voir les fichiers"
        :file/name "Nom de fichier"
        :file/file "Fichier: "
        :file/last-modified-at "Dernières modifications à"
        :file/no-data "Aucune donnée"
        :file/format-not-supported "Le format .{1} n'est pas supporté."
        :editor/block-search "Rechercher un bloc"
        :editor/image-uploading "Envoi en cours"
        :draw/invalid-file "Impossible de charger ce fichier excalidraw"
        :draw/specify-title "Veuillez préciser un titre"
        :draw/rename-success "Le fichier a été renommé !"
        :draw/rename-failure "Le fichier n'a pas pu être renommé : "
        :draw/title-placeholder "Sans titre"
        :draw/save "Enregistrer"
        :draw/save-changes "Enregistrer les modifications"
        :draw/new-file "Nouveau fichier"
        :draw/list-files "Liste des fichiers"
        :draw/delete "Supprimer"
        :draw/more-options "Plus d'options"
        :draw/back-to-logseq "Retourner sur logseq"
        :content/copy "Copier"
        :content/cut "Couper"
        :content/make-todos "Faire {1}s"
        :content/copy-block-ref "Copier la référence du bloc"
        :content/focus-on-block "Focus sur le bloc"
        :content/open-in-sidebar "Ouvrir dans la barre latérale"
        :content/copy-as-json "Copier au format JSON"
        :content/click-to-edit "Cliquer pour éditer"
        :settings-page/edit-config-edn "Editer config.edn (pour le repo actuel)"
        :settings-page/preferred-file-format "Format de fichier préféré"
        :settings-page/preferred-workflow "Workflow préféré"
        :settings-page/enable-timetracking "Activer le suivi de temps des tâches"
        :settings-page/developer-mode "Le mode développeur"
        :settings-page/enable-developer-mode "Activer le mode développeur"
        :settings-page/disable-developer-mode "Désactiver le mode développeur"
        :settings-page/developer-mode-desc "Le mode développeur aide les contributeurs et les développeurs d'extension à tester leur intégration avec Logseq."
        :logseq "Logseq"
        :on "ON"
        :more-options "Plus d'options"
        :to "à"
        :yes "Oui"
        :submit "Envoyer"
        :cancel "Annuler"
        :re-index "Ré-indexer"
        :export-json "Exporter au format JSON"
        :unlink "délier"
        :search/publishing "Rechercher"
        :search "Rechercher ou Créer la Page"
        :new-page "Nouvelle page"
        :new-file "Nouveau fichier"
        :graph "Graphe"
        :publishing "Publication"
        :all-pages "Toutes les pages"
        :all-files "Tous les fichiers"
        :all-journals "Tous les journaux"
        :my-publishing "My publishing"
        :settings "Préférences"
        :import "Importer"
        :join-community "Rejoindre la communauté"
        :discord-title "Notre groupe Discord !"
        :loading "Chargement en cours"
        :cloning "Clonage en cours"
        :parsing-files "Analyse des fichiers"
        :loading-files "Chargement des fichiers"
        :go-to "Aller à "
        :or "ou"
        :download "Télécharger"
        :language "Langage"
        :white "Clair"
        :dark "Foncé"
        :remove-background "Retirer le fond"

        :file-sync/other-user-graph "Le graphique local actuel est lié à l'autre graphique à distance de l'utilisateur. Alors ne peut pas commencer à la synchroniser."
        :file-sync/graph-deleted "Le graphe distant actuel a été supprimé"}

   :zh-CN {:on-boarding/demo-graph "这是一个图谱的样例，在上面做的修改不会被保存，除非打开本地文件夹"
           :on-boarding/add-graph "添加图谱"
           :on-boarding/open-local-dir "打开本地文件夹"
           :on-boarding/new-graph-desc-1 "Logseq 同时支持 Markdown 和 Org-mode，你可以在设备上打开现有目录或创建新目录，目录也简称为文件夹。你的数据将仅存储在此设备上"
           :on-boarding/new-graph-desc-2 "文件夹打开后，将会在里面创建 3 个目录："
           :on-boarding/new-graph-desc-3 "/journals - 保存你的日记"
           :on-boarding/new-graph-desc-4 "/pages - 保存其他页面"
           :on-boarding/new-graph-desc-5 "/logseq - 保存配置，custom.css 和一些元数据"
           :help/start "入门"
           :help/roadmap "路线图"
           :help/about "关于 Logseq"
           :help/bug "Bug 反馈"
           :help/feature "功能建议"
           :help/changelog "更新日志"
           :help/blog "Logseq 博客"
           :help/docs "文档"
           :help/privacy "隐私声明"
           :help/terms "服务条款"
           :help/community "Discord 社区"
           :help/shortcuts "快捷键"
           :help/shortcuts-triggers "触发"
           :help/shortcut "快捷键"
           :help/shortcut-page-title "完整快捷键"
           :help/slash-autocomplete "Slash 自动提示"
           :help/block-content-autocomplete "块内容 (Src, Quote, Query 等) 自动完成"
           :help/reference-autocomplete "页面引用自动补全"
           :help/block-reference "块引用"
           :help/key-commands "关键命令"
           :help/working-with-lists " (与列表相关)"
           :help/select-nfs-browser "请选择支持nfs的浏览来使用logseq本地文件夹功能, 如最新的Chrome浏览器."
           :text/image "图片"
           :asset/confirm-delete "确定要删除{1}吗?"
           :asset/physical-delete "同时删除本地文件（目前不可撤销）"
           :undo "撤销"
           :redo "重做"
           :general "常规​​​​​"
           :more "更多"
           :search/result-for "更多搜索结果 "
           :search/items "条目"
           :search/page-names "搜索页面名称"
           :help/context-menu "右键菜单"
           :help/fold-unfold "折叠/展开方块(不在编辑模式中)"
           :help/markdown-syntax "Markdown 语法"
           :help/org-mode-syntax "Org Mode 语法"
           :bold "粗体"
           :italics "斜体"
           :html-link "Html 链接"
           :highlight "高亮"
           :strikethrough "删除线"
           :code "代码"
           :right-side-bar/help "帮助"
           :right-side-bar/switch-theme "主题模式"
           :right-side-bar/theme "{1}主题"
           :right-side-bar/page "页面图谱"
           :right-side-bar/recent "最近"
           :right-side-bar/contents "目录"
           :right-side-bar/favorites "收藏"
           :right-side-bar/page-graph "页面图谱："
           :right-side-bar/block-ref "块引用"
           :right-side-bar/graph-view "图谱视角"
           :right-side-bar/all-pages "全部页面"
           :right-side-bar/flashcards "记忆卡片"
           :right-side-bar/new-page "新页面"
           :left-side-bar/journals "日志"
           :left-side-bar/new-page "新页面"
           :left-side-bar/nav-favorites "收藏页面"
           :left-side-bar/nav-shortcuts "快捷导航"
           :left-side-bar/nav-recent-pages "最近使用"
           :format/preferred-mode "请选择偏好格式"
           :format/markdown "Markdown"
           :format/org-mode "Org Mode"
           :reference/linked "已链接的引用"
           :reference/unlinked-ref "未链接的引用"
           :page/edit-properties-placeholder "点击这里编辑当前页面的属性 (标签，别名等)"
           :page/presentation-mode "打开幻灯片"
           :page/delete-success "页面 {1} 删除成功！"
           :page/delete-confirmation "您确定要删除此页面和文件吗？"
           :page/rename-to "重命名 \"{1}\" 至："
           :page/priority "优先级 \"{1}\""
           :page/copy-to-json "将整页以 JSON 格式复制"
           :page/rename "重命名本页"
           :page/open-in-finder "打开文件对应目录"
           :page/open-with-default-app "用默认应用打开文件"
           :page/action-publish "发布"
           :page/make-public "导出 HTML 时发布本页面"
           :page/version-history "查看页面历史记录"
           :page/open-backup-directory "打开页面备份文件夹"
           :page/file-sync-versions "页面历史"
           :page/make-private "导出 HTML 时取消发布本页面"
           :page/delete "删除本页"
           :page/add-to-favorites "添加收藏"
           :page/unfavorite "取消收藏"
           :page/show-journals "显示日志"
           :page/show-name "显示页面名"
           :page/hide-name "隐藏页面名"
           :block/name "页面名称"
           :page/last-modified "最后更改于"
           :page/new-title "请输入新页面的名字:"
           :page/earlier "之前"
           :page/no-more-journals "没有更多了"
           :journal/multiple-files-with-different-formats "你似乎在同一个月有多个日记文件(格式不同)，请每个月只保留一个日记文件。"
           :journal/go-to "前往所有文件"
           :file/name "文件名"
           :file/file "文件："
           :file/last-modified-at "最后更改于"
           :file/no-data "没有数据"
           :page/created-at "创建日期"
           :page/updated-at "更新日期"
           :page/backlinks "双向链接"
           :file/format-not-supported "格式 .{1} 目前不支持."
           :editor/block-search "搜索块"
           :editor/image-uploading "上传中"
           :draw/invalid-file "无法加载此无效的 excalidraw 文件"
           :draw/specify-title "请先指定标题!"
           :draw/rename-success "文件重命名成功!"
           :draw/rename-failure "文件重命名失败，原因是："
           :draw/title-placeholder "未命名"
           :draw/save "保存"
           :draw/save-changes "保存更改"
           :draw/new-file "新文件"
           :draw/list-files "所有文件"
           :draw/delete "删除"
           :draw/more-options "更多选项"
           :draw/back-to-logseq "返回 logseq"
           :content/copy "复制"
           :content/cut "剪切"
           :content/make-todos "格式化为 {1}"
           :content/copy-block-ref "复制块引用"
           :content/focus-on-block "聚焦在此块"
           :content/open-in-sidebar "在侧边栏打开"
           :content/copy-as-json "复制为 JSON"
           :content/click-to-edit "点击以编辑"
           :settings-page/edit-config-edn "编辑 config.edn (当前库)"
           :settings-page/edit-custom-css "编辑 custom.css (当前库)"
           :settings-page/custom-configuration "自定义配置"
           :settings-page/custom-theme "自定义主题"
           :settings-page/git-desc "用于页面的版本管理，可以单击顶部右侧菜单来查看页面的历史记录"
           :settings-page/git-confirm "更新 Git 设置后，需要重启应用"
           :settings-page/git-switcher-label "开启 Git 自动 commit"
           :settings-page/git-commit-delay "Git 自动 commit 间隔"
           :settings-page/preferred-outdenting "逻辑缩进"
           :settings-page/show-brackets "显示括号 [[]]"
           :settings-page/spell-checker "单词拼写检查"
           :settings-page/auto-updater "自动更新"
           :settings-page/disable-sentry "向 Logseq 提供使用情况和诊断信息"
           :settings-page/custom-date-format "首选日期页面格式"
           :settings-page/preferred-file-format "首选文件格式"
           :settings-page/preferred-workflow "首选工作流"
           :settings-page/enable-timetracking "开启 timetracking"
           :settings-page/enable-tooltip "开启提示框"
           :settings-page/enable-journals "开启日记"
           :settings-page/enable-all-pages-public "发布所有页面"
           :settings-page/enable-encryption "激活加密功能"
           :settings-page/customize-shortcuts "自定义快捷键"
           :settings-page/shortcut-settings "快捷键设置"
           :settings-page/home-default-page "设置首页默认页面"
           :settings-page/enable-block-time "记录 block 创建/修改时间"
           :settings-page/clear-cache "清除缓存"
           :settings-page/clear "清除"
           :settings-page/developer-mode "开发者模式"
           :settings-page/enable-developer-mode "启用开发者模式"
           :settings-page/disable-developer-mode "禁用开发者模式"
           :settings-page/developer-mode-desc "开发者模式帮助贡献者和扩展开发者更有效地测试他们与 Logseq 的集成。"
           :settings-page/current-version "当前版本"
           :settings-page/current-graph "当前仓库"
           :settings-page/tab-general "常规"
           :settings-page/tab-editor "编辑器"
           :settings-page/tab-shortcuts "快捷键"
           :settings-page/tab-advanced "高级设置"
           :settings-page/tab-version-control "多版本控制"
           :settings-page/plugin-system "插件系统"
           :settings-page/network-proxy "网络代理"
           :logseq "Logseq"
           :on "已打开"
           :more-options "更多选项"
           :to "至"
           :yes "是"
           :no "否"
           :submit "提交"
           :cancel "取消"
           :new-graph "添加图谱"
           :re-index "重新建立索引"
           :re-index-detail "重新建立索引"
           :re-index-multiple-windows-warning "在重建当前图谱索引前，你需要先关闭其它窗口"
           :re-index-discard-unsaved-changes-warning "重建索引将丢弃当前图谱，之后重新导入保存在磁盘上的所有文件。此操作将丢弃未保存的更改，同时可能需要一段时间。是否继续？"
           :open-new-window "打开新窗口"
           :sync-from-local-files "刷新（读取本地最新文件）"
           :sync-from-local-files-detail "读取本地最新文件"
           :sync-from-local-changes-detected "执行刷新操作将会导入磁盘上修改过的、或是与实际Logseq页面内容不同的文件。是否继续？"
           :export-graph "导出图谱"
           :export-page "导出当前页面"
           :export-json "以 JSON 格式导出"
           :export-roam-json "以 Roam JSON 格式导出"
           :export-markdown "以 Markdown 格式导出"
           :export-opml "以 OPML 格式导出"
           :convert-markdown "转换 Markdown 格式(Unordered list 或 Heading)"
           :unlink "解除绑定"
           :search/publishing "搜索"
           :search "搜索或者创建新页面"
           :page-search "在当前页面搜索"
           :graph-search "搜索图谱"
           :new-page "新页面"
           :new-file "新文件"
           :graph "图谱"
           :graph/persist "打开新窗口前，Logseq正在同步内部状态，请等待片刻。"
           :graph/persist-error "内部状态同步失败。无法打开新窗口。"
           :graph/save "保存中……"
           :graph/save-success "保存成功"
           :graph/save-error "保存失败"
           :graph-view "全局图谱"
           :cards-view "卡片组"
           :all-journals "日记"
           :publishing "发布"
           :export "导出"
           :all-graphs "所有图谱"
           :all-pages "所有页面"
           :all-files "所有文件"
           :remove-orphaned-pages "删除空页面"
           :my-publishing "我的发布"
           :settings "设置"
           :settings-of-plugins "插件设置"
           :plugins "插件"
           :themes "主题"
           :developer-mode-alert "如果希望插件功能立刻生效, 请重启应用。是否现在重启?"
           :relaunch-confirm-to-work "如果希望立刻生效, 请重启应用。是否现在重启?"
           :import "导入"
           :join-community "加入社区"
           :sponsor-us "赞助我们!"
           :discord-title "我们的 Discord 社群!"
           :help-shortcut-title "点此查看快捷方式和更多有用帮助"
           :loading "加载中"
           :cloning "Clone 中"
           :close "关闭"
           :delete "删除"
           :save "保存"
           :type "类型"
           :host "主机"
           :port "端口"
           :parsing-files "正在解析文件"
           :loading-files "正在加载文件"
           :login "登录"
           :logout "登出"
           :go-to "转到"
           :or "或"
           :download "下载"
           :repo/download-zip "下载所有文件"
           :language "语言"
           :white "亮色"
           :dark "暗黑"
           :remove-background "去除背景"
           :open "打开"
           :open-a-directory "打开本地文件夹"
           :user/delete-account "删除帐号"
           :user/delete-your-account "删除你的帐号"
           :user/delete-account-notice "你在 logseq.com 发布的页面（假如有的话）也会被删除。"

           :plugin/installed "已安装"
           :plugin/not-installed "未安装"
           :plugin/installing "安装中"
           :plugin/install "安装"
           :plugin/reload "重载"
           :plugin/update "更新"
           :plugin/check-update "检查更新"
           :plugin/check-all-updates "一键检查更新"
           :plugin/refresh-lists "刷新插件列表"
           :plugin/delete-alert "确定删除插件 [{1}]?"
           :plugin/enabled "已开启"
           :plugin/disabled "未开启"
           :plugin/update-available "待更新"
           :plugin/updating "更新中"
           :plugin/uninstall "卸载"
           :plugin/marketplace "插件市场"
           :plugin/downloads "下载量"
           :plugin/stars "收藏数"
           :plugin/title "名称"
           :plugin/all "全部"
           :plugin/unpacked "未打包"
           :plugin/open-settings "打开配置项"
           :plugin/open-package "打开包目录"
           :plugin/load-unpacked "手动载入插件"
           :plugin/open-preferences "打开预设配置文件"
           :plugin/restart "重启应用"
           :plugin/marketplace-tips "如果首次从市场安装或更新的插件，遇到非预期工作情况，可以尝试重启应用。"
           :plugin/unpacked-tips "用于开发目的或者从本地磁盘载入可信的社区插件。"
           :plugin/up-to-date "已经是最新了"
           :plugin/custom-js-alert "发现 custom.js 自定义脚本，是否允许执行? (如果您对该文件的内容不了解 或 来源不可靠，建议不要允许执行)"

           :pdf/copy-ref "复制引用"
           :pdf/copy-text "复制文本"
           :pdf/linked-ref "转到注解"
           :pdf/toggle-dashed "区域选取为虚线"

           :updater/new-version-install "新版本已经准备就绪，重启应用即可更新。"
           :updater/quit-and-install "现在安装"

           :paginates/pages "共计 {1} 页面"
           :paginates/prev "上一页"
           :paginates/next "下一页"

           :tips/all-done "处理完成"

           :command-palette/prompt "输入指令"

           :file-sync/other-user-graph "当前本地 graph 绑定在其他用户的远程 graph 上。因此无法启动同步。"
           :file-sync/graph-deleted "当前远程 graph 已经删除"}

   :zh-Hant {:on-boarding/demo-graph "This is a demo graph, changes will not be saved until you open a local folder."
             :on-boarding/add-graph "Add a graph"
             :on-boarding/open-local-dir "Open a local directory"
             :on-boarding/new-graph-desc-1 "Logseq supports both Markdown and Org-mode. You can open an existing directory or create a new one on your device, a directory is also known simply as a folder. Your data will be stored only on this device."
             :on-boarding/new-graph-desc-2 "After you have opened your directory, it will create three folders in that directory:"
             :on-boarding/new-graph-desc-3 "/journals - store your journal pages"
             :on-boarding/new-graph-desc-4 "/pages - store the other pages"
             :on-boarding/new-graph-desc-5 "/logseq - store configuration, custom.css, and some metadata."
             :help/about "關於 Logseq"
             :help/bug "Bug 反饋"
             :help/feature "功能建議"
             :help/changelog "更新日志"
             :help/blog "Logseq 博客"
             :help/privacy "隱私聲明"
             :help/terms "服務條款"
             :help/community "Discord 社區"
             :help/shortcuts "快捷鍵"
             :help/shortcuts-triggers "觸發"
             :help/shortcut "快捷鍵"
             :help/slash-autocomplete "Slash 自動提示"
             :help/block-content-autocomplete "塊內容 (Src, Quote, Query 等) 自動完成"
             :help/reference-autocomplete "頁面引用自動補全"
             :help/block-reference "塊引用"
             :help/key-commands "關鍵命令"
             :help/working-with-lists " (與列表相關)"
             :help/select-nfs-browser "Please use another browser (like latest chrome) which support NFS features to open local directory."
             :undo "撤銷"
             :redo "重做"
             :general "常規​​​​​"
             :help/context-menu "右鍵菜單"
             :help/fold-unfold "折疊/展開方塊(不在編輯模式中)"
             :help/markdown-syntax "Markdown 語法"
             :help/org-mode-syntax "Org Mode 語法"
             :bold "粗體"
             :italics "斜體"
             :html-link "Html 鏈接"
             :highlight "高亮"
             :strikethrough "刪除線"
             :code "代碼"
             :close "關閉"
             :delete "删除"
             :right-side-bar/help "幫助"
             :right-side-bar/switch-theme "主題模式"
             :right-side-bar/theme "{1}主題"
             :right-side-bar/page "頁面圖譜"
             :right-side-bar/recent "最近"
             :right-side-bar/contents "目錄"
             :right-side-bar/block-ref "塊引用"
             :right-side-bar/graph-view "圖譜視角"
             :right-side-bar/all-pages "全部頁面"
             :right-side-bar/flashcards "記憶卡片"
             :right-side-bar/new-page "新頁面"
             :left-side-bar/journals "日誌"
             :format/preferred-mode "請選擇偏好格式"
             :format/markdown "Markdown"
             :format/org-mode "Org Mode"
             :reference/linked "已鏈接的引用"
             :reference/unlinked-ref "未鏈接的引用"
             :page/presentation-mode "演講模式"
             :page/delete-success "頁面 {1} 刪除成功！"
             :page/delete-confirmation "您確定要刪除此頁面嗎？"
             :page/rename-to "重命名 \"{1}\" 至："
             :page/priority "優先級 \"{1}\""
             :page/copy-to-json "將整頁以 JSON 格式復制"
             :page/rename "重命名本頁"
             :page/make-public "導出 HTML 時發布本頁面"
             :page/make-private "導出 HTML 時取消發布本頁面"
             :page/delete "刪除本頁（並刪除文件）"
             :page/show-journals "顯示日志"
             :page/show-name "顯示頁面名"
             :page/hide-name "隱藏頁面名"
             :block/name "頁面名稱："
             :page/last-modified "最後更改於"
             :page/new-title "請輸入新頁面的名字:"
             :page/earlier "之前"
             :page/no-more-journals "沒有更多了"
             :journal/multiple-files-with-different-formats "你似乎在同一個月有多個日記文件(格式不同)，請每個月只保留一個日記文件。"
             :journal/go-to "前往所有文件"
             :file/name "文件名"
             :file/file "文件："
             :file/last-modified-at "最後更改於"
             :file/no-data "沒有數據"
             :file/format-not-supported "格式 .{1} 目前不支持."
             :editor/block-search "搜索塊"
             :editor/image-uploading "上傳中"
             :draw/invalid-file "無法加載此無效的 excalidraw 文件"
             :draw/specify-title "請先指定標題!"
             :draw/rename-success "文件重命名成功!"
             :draw/rename-failure "文件重命名失敗，原因是："
             :draw/title-placeholder "未命名"
             :draw/save "保存"
             :draw/save-changes "保存更改"
             :draw/new-file "新文件"
             :draw/list-files "所有文件"
             :draw/delete "刪除"
             :draw/more-options "更多選項"
             :draw/back-to-logseq "返回 logseq"
             :content/copy "復制"
             :content/cut "剪切"
             :content/make-todos "格式化為 {1}"
             :content/copy-block-ref "復制塊引用"
             :content/focus-on-block "聚焦在此塊"
             :content/open-in-sidebar "在側邊欄打開"
             :content/copy-as-json "復制為 JSON"
             :content/click-to-edit "點擊以編輯"
             :settings-page/edit-config-edn "編輯 config.edn (當前庫)"
             :settings-page/git-desc "is used for pages version control, you can click the vertical three dots menu to check the page's history."
             :settings-page/git-confirm "You need to restart the app after updating the Git settings."
             :settings-page/git-switcher-label "Enable Git auto commit"
             :settings-page/git-commit-delay "Git auto commit seconds"
             :settings-page/preferred-file-format "首選文件格式"
             :settings-page/preferred-workflow "首選工作流"
             :settings-page/developer-mode "開發者模式"
             :settings-page/enable-developer-mode "啟用開發者模式"
             :settings-page/disable-developer-mode "禁用開發者模式"
             :settings-page/developer-mode-desc "開發者模式幫助貢獻者和擴展開發者更有效地測試他們與 Logseq 的集成。"
             :settings-page/tab-general "常規"
             :settings-page/tab-editor "編輯器"
             :settings-page/tab-shortcuts "快捷鍵"
             :settings-page/tab-advanced "高級設置"
             :logseq "Logseq"
             :on "已打開"
             :more-options "更多選項"
             :to "至"
             :yes "是"
             :submit "提交"
             :cancel "取消"
             :re-index "重新建立索引"
             :export-json "以 JSON 格式導出"
             :export-markdown "以 Markdown 格式導出"
             :export-opml "以 OPML 格式導出"
             :convert-markdown "轉換 Markdown 格式(Unordered list 或 Heading)"
             :unlink "解除綁定"
             :search/publishing "搜索"
             :search "搜索或者創建新頁面"
             :new-page "新頁面"
             :graph "圖譜"
             :publishing "發布/下載 HTML 文件"
             :all-pages "所有頁面"
             :all-files "所有文件"
             :my-publishing "My publishing"
             :settings "設置"
             :import "導入"
             :join-community "加入社區"
             :discord-title "我們的 Discord 社群!"
             :help-shortcut-title "點此查看快捷方式和更多有用幫助"
             :loading "加載中"
             :cloning "Clone 中"
             :parsing-files "正在解析文件"
             :loading-files "正在加載文件"
             :go-to "轉到"
             :or "或"
             :download "下載"
             :language "語言"
             :white "亮色"
             :dark "暗黑"
             :remove-background "去除背景"

             :pdf/copy-ref "復製引用"
             :pdf/copy-text "復製文本"
             :pdf/linked-ref "轉到註解"

             :file-sync/other-user-graph "當前本地 graph 綁定到其他用戶的遠程 graph 上。因此無法啟動同步。"
             :file-sync/graph-deleted "當前遠程 graph 已被刪除"}

   :af {:on-boarding/demo-graph "This is a demo graph, changes will not be saved until you open a local folder."
        :on-boarding/add-graph "Add a graph"
        :on-boarding/open-local-dir "Open a local directory"
        :on-boarding/new-graph-desc-1 "Logseq supports both Markdown and Org-mode. You can open an existing directory or create a new one on your device, a directory is also known simply as a folder. Your data will be stored only on this device."
        :on-boarding/new-graph-desc-2 "After you have opened your directory, it will create three folders in that directory:"
        :on-boarding/new-graph-desc-3 "/journals - store your journal pages"
        :on-boarding/new-graph-desc-4 "/pages - store the other pages"
        :on-boarding/new-graph-desc-5 "/logseq - store configuration, custom.css, and some metadata."
        :help/about "Oor Logseq"
        :help/bug "Fout verslag"
        :help/feature "Funksie versoek"
        :help/changelog "Verandering-dagboek"
        :help/blog "Logseq blog"
        :help/privacy "Privaatheidsbeleid"
        :help/terms "Terme"
        :help/community "Discord gemeenskap"
        :help/shortcuts "Sleutelbord kortpaaie"
        :help/shortcuts-triggers "Snellers"
        :help/shortcut "Kortpad"
        :help/slash-autocomplete "Slash outovoltooi"
        :help/block-content-autocomplete "Blokkeer inhoud (Oorsprong, kwotasie, navrae ens.) Voltooi outomaties"
        :help/reference-autocomplete "Blad verwysing Outovoltooi"
        :help/block-reference "Blok verwysing"
        :help/key-commands "Sleutel instruksies"
        :help/working-with-lists " (werk met lyste)"
        :help/select-nfs-browser "Please use another browser (like latest chrome) which support NFS features to open local directory."
        :undo "Ontdoen"
        :redo "Herdoen"
        :general "Algemeen"
        :help/context-menu "Konteks kaart"
        :help/fold-unfold "Vou/ontvou blokke (wanneer nie in wysigings modus)"
        :help/markdown-syntax "Markdown sintaksis"
        :help/org-mode-syntax "Org mode sintaksis"
        :bold "Vetdruk"
        :italics "Skuinsdruk"
        :html-link "Html Skakel"
        :highlight "Beklemtoon"
        :strikethrough "Deurstreep"
        :code "Kode"
        :right-side-bar/help "Hulp"
        :right-side-bar/switch-theme "Skakel oor na die {1} tema"
        :right-side-bar/theme "{1} tema"
        :right-side-bar/page "Grafiek bladsy"
        :right-side-bar/recent "Onlangs"
        :right-side-bar/contents "Inhoud"
        :right-side-bar/block-ref "Blok verwysing"
        :right-side-bar/graph-view "Graph view"
        :right-side-bar/all-pages "All pages"
        :right-side-bar/flashcards "Flashcards"
        :right-side-bar/new-page "New page"
        :left-side-bar/journals "Journals"
        :format/preferred-mode "Wat is jou voorkeur model?"
        :format/markdown "Markdown"
        :format/org-mode "Org Mode"
        :reference/linked "Gekoppelde Verwysing"
        :reference/unlinked-ref "Ongekoppelde Verwysing"
        :page/presentation-mode "Aanbiedings modus"
        :page/delete-success "Bladsy {1} is suksesvol uitgevee!"
        :page/delete-confirmation "Is jy seker jy wil die bladsy uitvee?"
        :page/rename-to "Hernoem \"{1}\" na:"
        :page/priority "Prioriteit \"{1}\""
        :page/copy-to-json "Kopieer die hele bladsy as JSON"
        :page/rename "Hernoem die bladsy"
        :page/delete "Delete page (will delete the file too)"
        :page/show-journals "Wys joernale"
        :page/show-name "Wys blad naam"
        :page/hide-name "Steek bladnaam weg"
        :block/name "Page name"
        :page/last-modified "Laaste verander op"
        :page/new-title "Wat is die nuwe blad se titel?"
        :journal/multiple-files-with-different-formats "Dit wil voorkom asof jy verskeie journaal (met verskeie formate) vir dieselfde maand het, onderhou asb need een journaal lêer vir elke maand."
        :journal/go-to "Go to files"
        :file/name "Lêer naam"
        :file/file "Lêer: "
        :file/last-modified-at "Laas verander op"
        :file/no-data "Geen data"
        :file/format-not-supported "Formaat .{1} word nie ondersteun nie."
        :editor/block-search "Soek vir 'n blok"
        :editor/image-uploading "Laai tans op"
        :draw/invalid-file "Kon nie die ongeldige excalidraw lêer laai nie"
        :draw/specify-title "Spesifiseer asseblief eers a titel!"
        :draw/rename-success "Lêer is suksesvol verwyder!"
        :draw/rename-failure "Die lêer kon nie hernoem word nie, rede: "
        :draw/title-placeholder "Naamloos"
        :draw/save "Stoor"
        :draw/save-changes "Bewaar veranderinge"
        :draw/new-file "Nuwe lêer"
        :draw/list-files "Lys lêers"
        :draw/delete "Vee uit"
        :draw/more-options "Meer opsies"
        :draw/back-to-logseq "Terug na logseq"
        :content/copy "Kopieer"
        :content/cut "Sny"
        :content/make-todos "Maak {1}"
        :content/copy-block-ref "Kopieer blok verwysing"
        :content/focus-on-block "Fokus op blok"
        :content/open-in-sidebar "Maak in kantlys oop"
        :content/copy-as-json "Kopieer na JSON"
        :content/click-to-edit "Kliek om te wysig"
        :settings-page/edit-config-edn "Wysig config.edn (vir huidige stoor)"
        :settings-page/git-desc "is used for pages version control, you can click the vertical three dots menu to check the page's history."
        :settings-page/git-confirm "You need to restart the app after updating the Git settings."
        :settings-page/git-switcher-label "Enable Git auto commit"
        :settings-page/git-commit-delay "Git auto commit seconds"
        :settings-page/preferred-file-format "Voorkeur lêer formaat"
        :settings-page/preferred-workflow "Voorkeur werkstroom"
        :settings-page/developer-mode "Ontwikkelaar modus"
        :settings-page/enable-developer-mode "Skakel ontwikkelaar modus aan"
        :settings-page/disable-developer-mode "Skakel ontwikkelaars modus af"
        :settings-page/developer-mode-desc "Ontwikkelaarmodus help bydraers en ontwikkelaars van uitbreidings om hul integrasie met Logseq doeltreffender te toets."
        :logseq "Logseq"
        :on "AAN"
        :more-options "More options"
        :to "na"
        :yes "Ja"
        :submit "Stuur"
        :cancel "Kanselleer"
        :re-index "Herindekseer"
        :export-json "Uitvoer as JSON"
        :unlink "ontkoppel"
        :search "Soek"
        :new-page "Nuwe bladsy"
        :graph "Grafiek"
        :all-pages "Alle blaaie"
        :all-files "Alle lêers"
        :settings "Verstellings"
        :import "Invoer"
        :join-community "Sluit by die gemeenskap aan"
        :help-shortcut-title "Kliek op die kortpad en ander wenke"
        :loading "Laai tans"
        :cloning "Kloning"
        :parsing-files "Lêer ontleding"
        :loading-files "Laai lêers"
        :go-to "Gaan na "
        :or "of"
        :download "Laai af"
        :language "Taal"
        :white "Wit"
        :dark "Swart"

        :file-sync/other-user-graph "Huidige plaaslike grafiek is gebonde aan ander gebruiker se afgeleë grafiek. So kan nie begin om te sinkroniseer nie."
        :file-sync/graph-deleted "Huidige afstandgrafiek is geskrap"}

   :es {:on-boarding/add-graph "Añade un grafo"
        :help/about "Acerca de Logseq"
        :help/roadmap "Hoja de ruta"
        :help/bug "Reportar un error"
        :help/feature "Solicitar una función"
        :help/changelog "Registro de cambios"
        :help/blog "Blog de Logseq"
        :help/docs "Documentación"
        :help/privacy "Política de privacidad"
        :help/terms "Términos"
        :help/community "Comunidad de Discord"
        :help/shortcuts "Atajos de teclado"
        :help/shortcuts-triggers "Iniciadores"
        :help/shortcut "Atajo"
        :help/slash-autocomplete "Autocompletado Slash"
        :help/block-content-autocomplete "Autocompletado bloque de contenido (Src, Quote, Query, etc)"
        :help/reference-autocomplete "Referencia de página"
        :help/block-reference "Referencia de bloque"
        :help/key-commands "Comandos clave"
        :help/working-with-lists " (trabajar con listas)"
        :help/select-nfs-browser "Por favor use otro navegador (ej. la última versión de Chrome) que soporte funciones de NFS para abrir el directorio local."
        :undo "Deshacer"
        :redo "Rehacer"
        :general "General"
        :more "Más"
        :search/result-for "Resultado de búsqueda para "
        :search/items "elementos"
        :help/context-menu "Menú contextual"
        :help/fold-unfold "Ocultar/Expandir bloques (fuera del modo edición)"
        :help/markdown-syntax "Sintaxis de Markdown"
        :help/org-mode-syntax "Sintaxis del modo Org"
        :bold "Negrita"
        :italics "Cursiva"
        :html-link "Enlace html"
        :highlight "Resaltado"
        :strikethrough "Tachado"
        :code "Código"
        :right-side-bar/help "Ayuda"
        :right-side-bar/switch-theme "Temas"
        :right-side-bar/page "Gráfico de la página"
        :right-side-bar/recent "Reciente"
        :right-side-bar/contents "Contenido"
        :right-side-bar/favorites "Favoritos"
        :right-side-bar/page-graph "Vista gráfica"
        :right-side-bar/block-ref "Referencia de bloque"
        :right-side-bar/graph-view "Graph view"
        :right-side-bar/all-pages "Lista de páginas"
        :right-side-bar/flashcards "Flashcards"
        :right-side-bar/new-page "Nueva pagina"
        :left-side-bar/journals "Diarios"
        :format/preferred-mode "¿Cuál es su modo preferido?"
        :format/markdown "Markdown"
        :format/org-mode "Modo Org"
        :reference/linked "Referencia enlazada"
        :reference/unlinked-ref "Referencias sin enlazar"
        :page/presentation-mode "Modo presentación"
        :page/edit-properties-placeholder "Propiedades"
        :page/delete-success "¡Página {1} eliminada con éxito!"
        :page/delete-confirmation "¿Está seguro que desea eliminar esta página y su archivo?"
        :page/rename-to "Cambiar nombre de \"{1}\" a:"
        :page/priority "Prioridad \"{1}\""
        :page/copy-to-json "Copiar la página completa como JSON"
        :page/rename "Cambiar nombre de la página"
        :page/open-in-finder "Abrir ubicación del archivo"
        :page/open-with-default-app "Abrir con la aplicación predeterminada"
        :page/action-publish "Publicar"
        :page/make-public "Hacer pública al publicar"
        :page/make-private "Hacer privada"
        :page/delete "Eliminar página"
        :page/add-to-favorites "Añadir a Favoritos"
        :page/show-journals "Mostrar diarios"
        :page/show-name "Mostar nombre de página"
        :page/hide-name "Ocultar nombre de página"
        :block/name "Nombre de página"
        :page/last-modified "Fecha de modificación"
        :page/new-title "¿Cuál es el título de su nueva página?"
        :page/earlier "Anteriormente"
        :page/no-more-journals "No hay más diarios"
        :journal/multiple-files-with-different-formats "Parece que tiene varios archivos de diario (con diferentes formatos) para el mismo mes, por favor guarde solo un archivo de diario para cada mes."
        :journal/go-to "Ir a Archivos"
        :file/name "Nombre del archivo"
        :file/file "Archivos: "
        :file/last-modified-at "Fecha de modificación"
        :file/no-data "No hay datos"
        :file/format-not-supported "Formato .{1} no soportado."
        :editor/block-search "Buscar un bloque"
        :editor/image-uploading "Subiendo"
        :draw/invalid-file "No se pudo cargar este archivo inválido de excalidraw"
        :draw/specify-title "¡Por favor, especifique primero un título!"
        :draw/rename-success "¡Cambio de nombre del archivo con éxito!"
        :draw/rename-failure "Fallo al cambiar de nombre del archivo, motivo: "
        :draw/title-placeholder "Sin título"
        :draw/save "Guardar"
        :draw/save-changes "Guardar cambios"
        :draw/new-file "Nuevo archivo file"
        :draw/list-files "Listado de archivos"
        :draw/delete "Eliminar"
        :draw/more-options "Más opciones"
        :draw/back-to-logseq "Volver a logseq"
        :text/image "Imagen"
        :asset/confirm-delete "¿Está seguro que desea eliminar este {1}?"
        :asset/physical-delete "Eliminar también el archivo (esta acción no se puede deshacer)"
        :content/copy "Copiar"
        :content/cut "Cortar"
        :content/make-todos "Hacer {1}s"
        :content/copy-block-ref "Copiar referencia de bloque"
        :content/focus-on-block "Enfocar bloque"
        :content/open-in-sidebar "Abrir en barra lateral"
        :content/copy-as-json "Copiar como JSON"
        :content/click-to-edit "Clic para editar"
        :settings-page/edit-config-edn "Editar config.edn (para este repositorio)"
        :settings-page/show-brackets "Mostrar corchetes"
        :settings-page/disable-sentry "Enviar datos de uso y diagnósticos a Logseq"
        :settings-page/preferred-outdenting "Disminución lógica de sangría"
        :settings-page/custom-date-format "Formato de diario preferido"
        :settings-page/preferred-file-format "Formato de archivo preferido"
        :settings-page/preferred-workflow "Flujo de trabajo preferido"
        :settings-page/enable-timetracking "Habilitar rastreo de tiempo"
        :settings-page/enable-tooltip "Habilitar descripción emergente"
        :settings-page/enable-journals "Habilitar diarios"
        :settings-page/enable-encryption "Habilitar función de cifrado"
        :settings-page/home-default-page "Establecer página de inicio"
        :settings-page/enable-block-time "Habilitar marcas temporales de bloque"
        :settings-page/clear-cache "Limpiar caché"
        :settings-page/clear "Limpiar"
        :settings-page/developer-mode "Modo desarrollador"
        :settings-page/enable-developer-mode "Habilitar modo desarrollador"
        :settings-page/disable-developer-mode "Deshabilitar modo desarrollador"
        :settings-page/developer-mode-desc "El modo desarrollado permite que los colaboradores y desarrolladore de extensiones probar sus integraciones con Logseq más eficientemente."
        :settings-page/current-version "Versión actual"
        :logseq "Logseq"
        :on "ON"
        :more-options "Más opciones"
        :to "a"
        :yes "Sí"
        :no "No"
        :submit "Enviar"
        :cancel "Cancelar"
        :close "Cerrar"
        :re-index "Reindexar"
        :unlink "desenlazar"
        :search/publishing "Buscar"
        :search "Buscar o Crear Página"
        :page-search "Buscar en la página actual"
        :new-page "Nueva página"
        :new-file "Nuevo archivo"
        :new-graph "Añadir nuevo grafo"
        :graph "Grafo"
        :graph-view "Vista gráfica"
        :publishing "Publicar"
        :export "Exportar"
        :export-markdown "Exportar como Markdown estándar (sin propiedades de bloque)"
        :export-opml "Exportar a OPML"
        :export-public-pages "Exportar páginas públicas"
        :export-json "Exportar a JSON"
        :export-roam-json "Export a Roam JSON"
        :export-edn "Exportar a EDN"
        :export-datascript-edn "Exportar a EDN de datascript"
        :convert-markdown "Convertir encabezados de Markdown a listas sin orden (# -> -)"
        :all-graphs "Lista de grafos"
        :all-pages "Lista de páginas"
        :all-files "Lista de archivos"
        :all-journals "Lista de diarios"
        :my-publishing "Mi publicación"
        :settings "Opciones"
        :plugins "Extensiones"
        :themes "Temas"
        :developer-mode-alert "Debe reiniciar la aplicación para habilitar las extensiones. ¿Desea reiniciarla ahora?"
        :import "Importar"
        :join-community "Unirse a la comunidad"
        :sponsor-us "Hazte patrocinador"
        :discord-title "¡Nuestro grupo de Discord!"
        :help-shortcut-title "Clic para ver atajos y otras sugerencias"
        :loading "Cargando"
        :cloning "Clonando"
        :parsing-files "Analizando archivos"
        :loading-files "Cargando archivos"
        :login "Iniciar sesión"
        :logout "Cerrar sesión"
        :go-to "Ir a "
        :or "o"
        :download "Descargar"
        :repo/download-zip "Descargar todos los archivos como zip"
        :language "Idioma"
        :white "Claro"
        :dark "Oscuro"
        :remove-background "Remover el fondo"
        :open "Abrir"
        :open-a-directory "Abrir un directorio local"
        :user/delete-account "Eliminar cuenta"
        :user/delete-your-account "Eliminar su cuenta"
        :user/delete-account-notice "Todas sus páginas publicadas en Logseq serán eliminadas."

        :help/shortcut-page-title "Atajos personalizados"

        :select/default-prompt "Seleccione uno"
        :select.graph/prompt "Seleccione un grafo"
        :select.graph/empty-placeholder-description "No encontramos un grafo. Queries añadir otro?"
        :select.graph/add-graph "Si, añadame otro grafo"
        :file-sync/other-user-graph "El gráfico local actual está unido al gráfico remoto de otro usuario. Así que no se puede empezar a sincronizar"
        :file-sync/graph-deleted "El gráfico remoto actual se ha eliminado"}

   :nb-NO {:tutorial/text #?(:cljs (rc/inline "tutorial-no.md")
                             :default "tutorial-no.md")
           :tutorial/dummy-notes #?(:cljs (rc/inline "dummy-notes-no.md")
                                    :default "dummy-notes-no.md")
           :on-boarding/demo-graph "Dette er en demo graf, endringer vil ikke bli lagret før du åpner en lokal mappe."
           :on-boarding/add-graph "Legg til en graf"
           :on-boarding/open-local-dir "Åpne en lokal mappe"
           :on-boarding/new-graph-desc-1 "Logseq støtter både Markdown og Org-mode. Du kan åpne en eksisterende mappe eller lage en ny på din enhet. Dine data vil bare bli lagret på denne enheten."
           :on-boarding/new-graph-desc-2 "Etter at du har åpnet en mappe vil det blir opprettet tre undermapper i denne:"
           :on-boarding/new-graph-desc-3 "/journals - lagrer dine dagboknotater"
           :on-boarding/new-graph-desc-4 "/pages - lagrer andre sider"
           :on-boarding/new-graph-desc-5 "/logseq - lagrer konfigurasjon, custom.css og noe metadata."
           :help/start "Kom i gang"
           :help/about "Om Logseq"
           :help/roadmap "Veikart"
           :help/bug "Feilrapport"
           :help/feature "Funksjonsforespørsel"
           :help/changelog "Endringslogg"
           :help/blog "Logseq Blogg"
           :help/docs "Dokumentasjon"
           :help/privacy "Personvernerklæring"
           :help/terms "Vilkår"
           :help/community "Discord samfunn"
           :help/awesome-logseq "Fantastiske Logseq"
           :help/shortcuts "Tastatursnarveier"
           :help/shortcuts-triggers "Utløsere"
           :help/shortcut "Snarvei"
           :help/slash-autocomplete "Skråstrek Autofullføring"
           :help/block-content-autocomplete "Blokkinnhold (Src, Quote, Query, etc) Autofullføring"
           :help/reference-autocomplete "Sidereferanse Autofullføring"
           :help/block-reference "Blokkreferanse"
           :help/key-commands "Nøkkelkommandoer"
           :help/working-with-lists " (arbeide med lister)"
           :help/select-nfs-browser " Vennligst bruk en annen nettleser (f.eks. siste Chrome) som støtter NFS for å åpne en lokal mappe."
           :undo "Angre"
           :redo "Gjør om"
           :general "Generell"
           :more "Mer"
           :search/result-for "Søkeresultat for "
           :search/items "elementer"
           :search/page-names "Søk i navn på sider"
           :help/context-menu "Kontekstmeny"
           :help/fold-unfold "Brett/brett ut blokker (når du ikke er i redigeringsmodus)"
           :help/markdown-syntax "Markdown syntaks"
           :help/org-mode-syntax "Org mode syntaks"
           :bold "Fet"
           :italics "Kursiv"
           :html-link "Html Lenke"
           :highlight "Markering"
           :strikethrough "Gjennomstreking"
           :code "Kode"
           :right-side-bar/help "Hjelp"
           :right-side-bar/switch-theme "Tema moduser"
           :right-side-bar/theme "{1} tema"
           :right-side-bar/page "Sidegraf"
           :right-side-bar/recent "Siste"
           :right-side-bar/contents "Innhold"
           :right-side-bar/favorites "Favoritter"
           :right-side-bar/page-graph "Sidegraf"
           :right-side-bar/block-ref "Blokkreferanse"
           :right-side-bar/graph-view "Grafvisning"
           :right-side-bar/all-pages "Alle sider"
           :right-side-bar/flashcards "Flashcards"
           :right-side-bar/new-page "Ny side"
           :left-side-bar/journals "Dagbøker"
           :left-side-bar/new-page "Ny side"
           :left-side-bar/nav-favorites "Favoritter"
           :left-side-bar/nav-shortcuts "Snarveier"
           :left-side-bar/nav-recent-pages "Nylig"
           :format/preferred-mode "Hva er dine foretrukne modus?"
           :format/markdown "Markdown"
           :format/org-mode "Org Mode"
           :reference/linked "Lenket referanse"
           :reference/unlinked-ref "Ulenket referanse"
           :page/presentation-mode "Presentasjonsmodus"
           :page/edit-properties-placeholder "Egenskaper"
           :page/delete-success "Side {1} ble vellykket slettet!"
           :page/delete-confirmation "Er du sikker på at du vil slette denne siden og filen dens?"
           :page/rename-to "Gi nytt navn \"{1}\" til:"
           :page/priority "Prioritet \"{1}\""
           :page/copy-to-json "Kopier hele siden som JSON"
           :page/rename "Gi siden nytt navn"
           :page/open-in-finder "Åpne i mappe"
           :page/open-with-default-app "Åpne med forhåndsvalgt app"
           :page/action-publish "Publiser"
           :page/make-public "Gjør den offentlig for publisering"
           :page/version-history "Sjekk sidehistorikk"
           :page/make-private "Gjør den privat"
           :page/delete "Slett side"
           :page/add-to-favorites "Legg til i Favoritter"
           :page/unfavorite "Fjern side fra Faoritter"
           :page/show-journals "Vis Dagbøker"
           :page/show-name "Vis navn på siden"
           :page/hide-name "Skjul navn på siden"
           :block/name "Navn på siden"
           :page/last-modified "Sist endret"
           :page/new-title "Tittel på den nye siden din?"
           :page/earlier "Tidligere"
           :page/no-more-journals "Ikke flere dagbøker"
           :journal/multiple-files-with-different-formats "Det ser ut som du har flere dagbokfiler (med forskjellig format) for den samme måneden. Vennligst ha bare en fil for hver måned."
           :journal/go-to "Gå til filer"
           :file/name "Filnavn"
           :file/file "Fil: "
           :file/last-modified-at "Sist endret"
           :file/no-data "Ingen data"
           :file/format-not-supported "Format .{1} er ikke støttet."
           :page/created-at "Opprettet"
           :page/updated-at "Oppdatert"
           :page/backlinks "Tilbakekoblinger"
           :editor/block-search "Søk etter en blokk"
           :editor/image-uploading "Laster opp"
           :draw/invalid-file "Kunne ikke laste inn den ugyldige excalidraw-filen"
           :draw/specify-title "Vennligst spesifiser en tittel først!"
           :draw/rename-success "Filen ble omdøpt!"
           :draw/rename-failure "Omdøping av fil feilet, årsak: "
           :draw/title-placeholder "Uten navn"
           :draw/save "Lagre"
           :draw/save-changes "Lagre endringer"
           :draw/new-file "Ny fil"
           :draw/list-files "Opplist filer"
           :draw/delete "Slett"
           :draw/more-options "Flere valg"
           :draw/back-to-logseq "Tilbake til logseq"
           :text/image "Bilde"
           :asset/confirm-delete "Er du sikker på at du vil slette denne {1}?"
           :asset/physical-delete "Fjerner også filen (merk at den ikke kan gjenopprettes)"
           :content/copy "Kopier"
           :content/cut "Klipp ut"
           :content/make-todos "Lag {1}s"
           :content/copy-block-ref "Kopier blokkreferanse"
           :content/copy-block-emebed "Kopier innebygging av blokk"
           :content/focus-on-block "Fokuser på blokk"
           :content/open-in-sidebar "Åpne i sidefeltet"
           :content/copy-as-json "Kopier som JSON"
           :content/click-to-edit "Klikk for å redigere"
           :settings-page/git-desc "brukes for versjonskontroll av sider. Du kan klikke på ...-menyen for å sjekke sidens historikk."
           :settings-page/git-confirm "Du må starte appen på nytt etter å ha oppdatert Git innstillingene."
           :settings-page/git-switcher-label "Skru på Git auto commit"
           :settings-page/git-commit-delay "Git auto commit sekunder"
           :settings-page/edit-config-edn "Rediger config.edn for nåværende repo"
           :settings-page/edit-custom-css "Rediger custom.css"
           :settings-page/custom-configuration "Tilpasset konfigurasjon"
           :settings-page/custom-theme "Tilpasset tema"
           :settings-page/show-brackets "Vis klammer"
           :settings-page/spell-checker "Stavekontroll"
           :settings-page/auto-updater "Automatisk oppdatering"
           :settings-page/disable-sentry "Send bruksdata og diagnostikk til Logseq"
           :settings-page/preferred-outdenting "Skru på logiske innrykk"
           :settings-page/custom-date-format "Foretrukket datoformat"
           :settings-page/preferred-file-format "Foretrukket filformat"
           :settings-page/preferred-workflow "Foretrukket arbeidslflyt"
           :settings-page/enable-shortcut-tooltip "Skru på tooltip for snarveier"
           :settings-page/enable-timetracking "Aktiver tidssporing"
           :settings-page/enable-encryption "Aktiver kryptering"
           :settings-page/enable-tooltip "Aktiver verktøytips"
           :settings-page/enable-journals "Aktiver dagbøker"
           :settings-page/enable-all-pages-public "Aktiver alle sider som offentlige ved publisering"
           :settings-page/customize-shortcuts "Tastatursnarveier"
           :settings-page/shortcut-settings "Tilpass snarveier"
           :settings-page/home-default-page "Angi standard hjemmeside"
           :settings-page/enable-block-time "Aktiver tidsstempel for blokker"
           :settings-page/clear-cache "Slett hurtigbuffer"
           :settings-page/clear "Slett"
           :settings-page/developer-mode "Utviklermodus"
           :settings-page/enable-developer-mode "Aktiver utviklermodus"
           :settings-page/disable-developer-mode "Deaktiver utviklermodus"
           :settings-page/developer-mode-desc "Utviklermodus hjelper bidragsytere og tilleggsutviklere med å teste sine integrasjoner mot Logseq mer effektivt."
           :settings-page/current-version "Nåværende versjon"
           :settings-page/current-graph "Nåværende graf"
           :settings-page/tab-general "Generelt"
           :settings-page/tab-editor "Editor"
           :settings-page/tab-shortcuts "Snarveier"
           :settings-page/tab-version-control "Versjonskontroll"
           :settings-page/tab-advanced "Avansert"
           :logseq "Logseq"
           :on "PÅ"
           :more-options "Flere valg"
           :to "til"
           :yes "Ja"
           :no "Nei"
           :submit "Send inn"
           :cancel "Avbryt"
           :close "Lukk"
           :delete "Slett"
           :re-index "Indekser på nytt"
           :re-index-detail "Bygg grafen på nytt"
           :open-new-window "Nytt vindu"
           :sync-from-local-files "Oppfrisk"
           :sync-from-local-files-detail "Importer endringer fra lokale filer"
           :unlink "koble fra"
           :search/publishing "Søk"
           :search "Søk eller Opprett Side"
           :page-search "Søk i denne siden"
           :graph-search "Søk graf"
           :new-page "Ny side"
           :new-file "Ny fil"
           :new-graph "Legg til ny graf"
           :graph "Graf"
           :graph-view "Vis graf"
           :cards-view "Vis kort"
           :publishing "Publisering"
           :export "Eksport"
           :export-graph "Eksporter graf"
           :export-page "Eksporter side"
           :export-markdown "Eksporter som standard Markdown (ingen blokk-egenskaper)"
           :export-opml "Eksporter som OPML"
           :export-public-pages "Eksporter offentlige sider"
           :export-json "Eksporter som JSON"
           :export-roam-json "Eksporter som Roam JSON"
           :export-edn "Eksporter som EDN"
           :export-datascript-edn "Eksporter datascript EDN"
           :convert-markdown "Konverter Markdown overskrifter til uordnede lister (# -> -)"
           :all-graphs "Alle grafer"
           :all-pages "Alle sider"
           :all-files "Alle filer"
           :remove-orphaned-pages "Fjern foreldreløse sider"
           :all-journals "Alle dagbøker"
           :my-publishing "Min publisering"
           :settings "Innstillinger"
           :plugins "Utvidelser"
           :themes "Tema"
           :developer-mode-alert "Du må starte appen på nytt for å skru på plugin-systemet. Vil du starte på nytt nå?"
           :relaunch-confirm-to-work "Appen må startes på nytt for at dette skal virke. Vil du starte på nytt nå?"
           :import "Importer"
           :join-community "Bli med i samfunnet"
           :sponsor-us "Spons oss"
           :discord-title "Vår discord gruppe!"
           :help-shortcut-title "Klikk for å sjekke snarveier og andre tips"
           :loading "Laster"
           :cloning "Kloner"
           :parsing-files "Analyserer filer"
           :loading-files "Laster filer"
           :login "Logg inn"
           :logout "Logg ut"
           :go-to "Gå til "
           :or "eller"
           :download "Last ned"
           :repo/download-zip "Last ned alle filer som en zip"
           :language "Språk"
           :white "Lys"
           :dark "Mørk"
           :remove-background "Fjern bakgrunn"
           :open "Åpne"
           :open-a-directory "Åpne en lokal mappe"
           :user/delete-account "Slett konto"
           :user/delete-your-account "Slett din konto"
           :user/delete-account-notice "Alle dine publiserte sider på logseq.com vil bli slettet."

           :help/shortcut-page-title "Tastatursnarveier"

           :plugin/installed "Installert"
           :plugin/installing "Innstallerer"
           :plugin/install "Innstaller"
           :plugin/reload "Last på nytt"
           :plugin/update "Oppdater"
           :plugin/check-update "Se etter oppdatering"
           :plugin/check-all-updates "Se etter alle oppdateringer"
           :plugin/refresh-lists "Oppfrisk lister"
           :plugin/enabled "Aktivert"
           :plugin/disabled "Deaktivert"
           :plugin/update-available "Oppdatering tilgjengelig"
           :plugin/updating "Oppdaterer"
           :plugin/uninstall "Avinstaller"
           :plugin/marketplace "Markedsplass"
           :plugin/downloads "Nedlastinger"
           :plugin/stars "Stjerner"
           :plugin/title "Tittel"
           :plugin/all "Alle"
           :plugin/unpacked "Utpakket"
           :plugin/delete-alert "Vil du avinstallere utvidelse [{1}]?"
           :plugin/open-settings "Åpne innstillinger"
           :plugin/open-package "Åpne pakke"
           :plugin/load-unpacked "Last inn utpakket utvidelse"
           :plugin/open-preferences "Åpne innstillingsfil for utvidelsen"
           :plugin/restart "Start App på nytt"
           :plugin/unpacked-tips "Velg mappe for utvidelse"
           :plugin/contribute "✨ Skriv og send inn en ny utvidelse"
           :plugin/marketplace-tips "Hvis utvidelsen ikke fungerer når du installerer den, prøv å restarte Logseq."
           :plugin/up-to-date "Den er oppdatert"
           :plugin/custom-js-alert "Fant custom.js fil, får den lov til å kjøre? (Hvis du ikke forstår innholdet i denne filen er det anbefalt å ikke la den kjøre. Dette kan ha sikkerhetsrisiko.)"

           :pdf/copy-ref "Kopier ref"
           :pdf/copy-text "Kopier tekst"
           :pdf/linked-ref "Lenkede referanser"
           :pdf/toggle-dashed "Stiplet stil for utheving av område"

           :updater/new-version-install "En ny versjon er lastet ned. Start applikasjonen på nytt for å installere."
           :updater/quit-and-install "Start på nytt for å installere"

           :paginates/pages "Totalt {1} sider"
           :paginates/prev "Forrige"
           :paginates/next "Neste"

           :tips/all-done "Alt ferdig"

           :command-palette/prompt "Skriv en kommando"
           :select/default-prompt "Velg en"
           :select.graph/prompt "Velg en graf"
           :select.graph/empty-placeholder-description "Ingen grafer matcher. Vil du legge til en ny?"
           :select.graph/add-graph "Ja, legg til en ny graf"

           :file-sync/other-user-graph "Nåværende lokal graf er bundet til annen brukers fjerngraf. Kan ikke begynne å synkronisere."
           :file-sync/graph-deleted "Nåværende fjerngraf er slettet"
           :host "Vert"
           :port "Port"
           :re-index-discard-unsaved-changes-warning "Reindeksering vil forkaste nåværende graf, og deretter prosessere alle filene på nytt slik de er på disk akkurat nå. Du vil miste ulagrede endringer, og det kan ta litt tid. Forsette?"
           :re-index-multiple-windows-warning "Du må lukke de andre vinduene før du kan reindeksere denne grafen"
           :save "Lagrer..."
           :settings-of-plugins "Innstillinger for utvidelser"
           :sync-from-local-changes-detected "Oppfrisk oppdager og prosesserer filer på disk som er modifiserte og avviker fra sideinnholdet som vises i Logseq. Fortsett?"
           :type "Type"
           :graph/persist "Logeq synkroniserer intern status, vennligst vent i flere sekunder."
           :graph/persist-error "Intern status synk feilet"
           :graph/save "Lagrer..."
           :graph/save-error "Lagring feilet"
           :graph/save-success "Lagring vellykket"
           :page/copy-page-url "Kopier side URL"
           :page/file-sync-versions "Versjoner av siden"
           :page/open-backup-directory "Åpne mappe med sidens sikkerhetskopier"
           :plugin/not-installed "Ikke installert"
           :settings-page/edit-export-css "Rediger export.css"
           :settings-page/network-proxy "Nettverksproxy"
           :settings-page/plugin-system "System for utvidelser"}

   :pt-BR {:on-boarding/demo-graph "Esse é um gráfico de demonstração, mudanças não serão salvas enquanto uma pasta local não for aberta."
           :on-boarding/add-graph "Adicionar gráfico"
           :on-boarding/open-local-dir "Abrir pasta local"
           :on-boarding/new-graph-desc-1 "Logseq funciona com Markdown e Org-mode. Você pode abrir uma pasta existente ou criar uma nova em seu dispositivo. Seus dados serão armazenados apenas neste dispositivo."
           :on-boarding/new-graph-desc-2 "Após abrir sua pasta, três pastas serão criadas nela:"
           :on-boarding/new-graph-desc-3 "/journals - armazena suas páginas diárias"
           :on-boarding/new-graph-desc-4 "/pages - armazena as outras páginas"
           :on-boarding/new-graph-desc-5 "/logseq - armazena configuração, custom.css e metadados."
           :help/start "Começar a usar"
           :help/about "Sobre o Logseq"
           :help/roadmap "Plano de implementação"
           :help/bug "Relato de erros"
           :help/feature "Pedido de funcionalidades"
           :help/changelog "Registo de alterações"
           :help/blog "Blog do Logseq"
           :help/docs "Documentação"
           :help/privacy "Política de privacidade"
           :help/terms "Termos"
           :help/community "Comunidade de Discord"
           :help/awesome-logseq "Incrível Logseq"
           :help/shortcuts "Atalhos de Teclado"
           :help/shortcuts-triggers "Gatilhos"
           :help/shortcut "Atalho"
           :help/slash-autocomplete "Auto-completar com a barra"
           :help/block-content-autocomplete "Auto-completar conteúdo de bloco (Src, Quote, Query, etc)"
           :help/reference-autocomplete "Auto-completar referência de páginas"
           :help/block-reference "Referência de bloco"
           :help/key-commands "Comandos chave"
           :help/working-with-lists " (trabalhando com listas)"
           :help/select-nfs-browser "Por favor use outro navegador (como o Chrome mais recente) com suporte para funcionalidades NFS para abrir pastas locais."
           :undo "Desfazer"
           :redo "Refazer"
           :general "Geral"
           :more "Mais"
           :search/result-for "Resultado da pesquisa para "
           :search/items "itens"
           :help/context-menu "Menu contextual"
           :help/fold-unfold "Ocultar/Expandir blocos (fora do modo de edição)"
           :help/markdown-syntax "Sintaxe de Markdown"
           :help/org-mode-syntax "Sintaxe de modo Org"
           :bold "Negrito"
           :italics "Itálico"
           :html-link "Link Html"
           :highlight "Realçado"
           :strikethrough "Rasurado"
           :code "Código"
           :right-side-bar/help "Ajuda"
           :right-side-bar/switch-theme "Temas"
           :right-side-bar/theme "Tema {1}"
           :right-side-bar/page "Gráfico da página"
           :right-side-bar/recent "Recente"
           :right-side-bar/contents "Conteúdo"
           :right-side-bar/favorites "Favoritos"
           :right-side-bar/page-graph "Gráfico da página"
           :right-side-bar/block-ref "Referência de bloco"
           :right-side-bar/flashcards "Flashcards"
           :right-side-bar/new-page "Nova página"
           :left-side-bar/journals "Diários"
           :format/preferred-mode "Qual o seu modo preferido?"
           :format/markdown "Markdown"
           :format/org-mode "Modo Org"
           :reference/linked "Referência ligada"
           :reference/unlinked-ref "Referências não ligadas"
           :page/presentation-mode "Modo de apresentação"
           :page/edit-properties-placeholder "Propriedades"
           :page/delete-success "Página {1} apagada com sucesso!"
           :page/delete-confirmation "Tem certeza que quer apagar esta página e o arquivo associado?"
           :page/rename-to "Renomear \"{1}\" como:"
           :page/priority "Prioridade \"{1}\""
           :page/copy-to-json "Copiar a página inteira como JSON"
           :page/rename "Renomear página"
           :page/open-in-finder "Abrir em pasta"
           :page/open-with-default-app "Abrir com a aplicação por omissão"
           :page/action-publish "Publicar"
           :page/make-public "Tornar pública para publicação"
           :page/version-history "Ver histórico da página"
           :page/make-private "Tornar privada"
           :page/delete "Excluir página"
           :page/add-to-favorites "Adicionar aos Favoritos"
           :page/show-journals "Mostrar Diários"
           :page/show-name "Mostrar nome da página"
           :page/hide-name "Esconder nome da página"
           :block/name "Nome da página"
           :page/last-modified "Última modificação em"
           :page/new-title "Qual o novo título da página?"
           :page/earlier "Antes"
           :page/no-more-journals "Não há mais diários"
           :journal/multiple-files-with-different-formats "Parece que tem vários arquivos (em vários formatos) de diário para o mesmo mês, por favor salve apenas um arquivo de diário para cada mês."
           :journal/go-to "Ir para arquivos"
           :file/name "Nome do arquivo"
           :file/file "Arquivo: "
           :file/last-modified-at "Última modificação em"
           :file/no-data "Sem dados"
           :file/format-not-supported "Formato .{1} não suportado."
           :page/created-at "Criado em"
           :page/updated-at "Atualizado em"
           :page/backlinks "Back Links"
           :editor/block-search "Pesquisar por um bloco"
           :editor/image-uploading "Enviando"
           :draw/invalid-file "Não foi possível carregar. Arquivo Excalidraw inválido."
           :draw/specify-title "Por favor indique um título primeiro!"
           :draw/rename-success "Arquivo foi renomeado com sucesso!"
           :draw/rename-failure "Falha ao renomear, motivo: "
           :draw/title-placeholder "Sem título"
           :draw/save "Salvar"
           :draw/save-changes "Salvar alterações"
           :draw/new-file "Novo arquivo"
           :draw/list-files "Listar arquivos"
           :draw/delete "Excluir"
           :draw/more-options "Mais opções"
           :draw/back-to-logseq "Voltar a logseq"
           :text/image "Imagem"
           :asset/confirm-delete "Tem certeza que quer excluir este {1}?"
           :asset/physical-delete "Remover também o arquivo (não poderá ser restaurado)"
           :content/copy "Copiar"
           :content/cut "Cortar"
           :content/make-todos "Fazer {1}s"
           :content/copy-block-ref "Copiar referência do bloco"
           :content/focus-on-block "Focar no bloco"
           :content/open-in-sidebar "Abrir na barra lateral"
           :content/copy-as-json "Copiar como JSON"
           :content/click-to-edit "Clicar para editar"
           :settings-page/edit-config-edn "Editar config.edn para o repositório atual"
           :settings-page/git-desc "é usado para controle de versão das páginas, você pode clicar no menu de três pontos para verificar o histórico da página."
           :settings-page/git-confirm "É necessário reiniciar a aplicação após atualizar as configurações do Git."
           :settings-page/git-switcher-label "Habilitar auto-consolidação no Git"
           :settings-page/git-commit-delay "Intervalo em segundos para auto-consolidação"
           :settings-page/show-brackets "Mostrar parênteses retos"
           :settings-page/spell-checker "Verificador ortográfico"
           :settings-page/disable-sentry "Enviar dados de utilização e diagnósticos para Logseq"
           :settings-page/preferred-outdenting "Ativar dedentação lógica"
           :settings-page/custom-date-format "Formato de data preferido"
           :settings-page/preferred-file-format "Formato de Arquivo preferido"
           :settings-page/preferred-workflow "Fluxo de trabalho preferido"
           :settings-page/enable-timetracking "Ativar controle de tempo"
           :settings-page/enable-tooltip "Ativar dicas de ferramentas"
           :settings-page/enable-journals "Ativar diários"
           :settings-page/enable-all-pages-public "Ativar todas as páginas públicas ao publicar"
           :settings-page/enable-encryption "Ativar funcionalidade de criptografia"
           :settings-page/customize-shortcuts "Atalhos de teclado"
           :settings-page/shortcut-settings "Personalizar atalhos"
           :settings-page/home-default-page "Definir a página inicial padrão"
           :settings-page/enable-block-time "Ativar carimbos temporais nos blocos"
           :settings-page/clear-cache "Limpar cache"
           :settings-page/clear "Limpar"
           :settings-page/developer-mode "Modo de desenvolvimento"
           :settings-page/enable-developer-mode "Ativar modo de desenvolvimento"
           :settings-page/disable-developer-mode "Desativar modo de desenvolvimento"
           :settings-page/developer-mode-desc "O modo de desenvolvimento ajuda os contribuidores e programadores de extensões a testar as suas integrações com o Logseq de forma eficiente."
           :settings-page/current-version "Versão atual"
           :settings-page/current-graph "Gráfico atual"
           :settings-page/tab-general "Geral"
           :settings-page/tab-editor "Editor"
           :settings-page/tab-shortcuts "Atalhos"
           :settings-page/tab-advanced "Avançado"
           :settings-page/tab-version-control "Controle de Versões"
           :logseq "Logseq"
           :on "Ligado"
           :more-options "Mais opções"
           :to "para"
           :yes "Sim"
           :no "Não"
           :submit "Submeter"
           :cancel "Cancelar"
           :close "Fechar"
           :delete "Excluir"
           :re-index "Re-indexar"
           :unlink "remover ligação"
           :search/publishing "Pesquisar"
           :search "Pesquisar ou Criar Página"
           :page-search "Pesquisar na página atual"
           :graph-search "Pesquisar gráfico"
           :new-page "Nova página"
           :new-file "Novo arquivo"
           :new-graph "Adicionar novo gráfico"
           :graph "Gráfico"
           :graph-view "Ver Gráfico"
           :cards-view "Ver Cartões"
           :publishing "Publicando"
           :export "Exportar"
           :export-graph "Exportar Gráfico"
           :export-markdown "Exportar como Markdown padrão (sem propriedades de bloco)"
           :export-opml "Exportar como OPML"
           :export-page "Exportar página"
           :export-public-pages "Exportar páginas públicas"
           :export-json "Exportar como JSON"
           :export-roam-json "Exportar como Roam JSON"
           :export-edn "Exportar como EDN"
           :export-datascript-edn "Exportar datascript EDN"
           :convert-markdown "Converter cabeçalhos Markdown para listas não-ordenadas (# -> -)"
           :all-graphs "Todos os gráficos"
           :all-pages "Todas as páginas"
           :all-files "Todos os arquivos"
           :all-journals "Todos os diários"
           :my-publishing "Minhas publicações"
           :settings "Configurações"
           :plugins "Plugins"
           :themes "Temas"
           :developer-mode-alert "É necessário reiniciar a aplicação para ativar o sistema de plugins. Quer reiniciar agora?"
           :relaunch-confirm-to-work "Deve reiniciar a aplicação para fazê-lo funcionar. Quer reiniciar agora?"
           :import "Importar"
           :join-community "Junte-se à comunidade"
           :sponsor-us "Seja um patrocinador"
           :discord-title "O nosso grupo de discord!"
           :help-shortcut-title "Clique para ver atalhos e outras dicas"
           :loading "Carregando"
           :cloning "Clonando"
           :parsing-files "Analisando arquivos"
           :loading-files "Carregando arquivos"
           :login "Iniciar sessão"
           :logout "Sessão final"
           :go-to "Ir para "
           :or "ou"
           :download "Baixar"
           :repo/download-zip "Baixar um zip com todos os arquivos"
           :language "Idioma"
           :white "Claro"
           :dark "Escuro"
           :remove-background "Remover fundo"
           :re-index-detail "Re-indexar gráfico"
           :open "Abrir"
           :open-a-directory "Abrir uma pasta local"
           :open-new-window "Nova janela"
           :user/delete-account "Excluir conta"
           :user/delete-your-account "Apague a sua conta"
           :user/delete-account-notice "Todas as suas páginas publicadas em logseq.com serão apagadas."

           :help/shortcut-page-title "Atalhos de teclado"

           :pdf/copy-ref "Copiar referência"
           :pdf/copy-text "Copiar texto"
           :pdf/linked-ref "Referências ligadas"
           :command-palette/prompt "Digite um comando"
           :remove-orphaned-pages "Remover páginas órfãs"
           :sync-from-local-files "Recarregar arquivos"
           :sync-from-local-files-detail "Importar modificações de arquivos"
           :content/copy-block-emebed "Copiar bloco para incorporar"
           :left-side-bar/nav-favorites "Favoritos"
           :left-side-bar/nav-recent-pages "Recentes"
           :left-side-bar/nav-shortcuts "Atalhos"
           :left-side-bar/new-page "Nova página"
           :page/unfavorite "Tirar página dos favoritos"
           :paginates/next "Próximo"
           :paginates/prev "Anterior"
           :pdf/toggle-dashed "Destaque estilo pontilhado"
           :plugin/all "Todos"
           :plugin/check-all-updates "Verificar atualizações"
           :plugin/check-update "Verificar atualização"
           :plugin/contribute "✨ Crie e envie um novo plugin"
           :plugin/custom-js-alert "Arquivo custom.js encontrado, deseja habilitar sua execução? (A execução deste arquivo pode trazer riscos, se você não conhece o conteúdo do arquivo é recomendado que você não ative esta opção.)"

           :plugin/delete-alert "Certeza que deseja excluir o plugin? [{1}]?"
           :plugin/disabled "Desabilitado"
           :plugin/downloads "Baixados"
           :plugin/enabled "Habilitado"
           :plugin/install "Instalar"
           :plugin/installed "Instalado"
           :plugin/installing "Instalando"
           :plugin/load-unpacked "Carregar plugin descompactado"
           :plugin/marketplace "Loja"
           :plugin/marketplace-tips "Se o plugin não funcionar direito depois de instalado, tente reiniciar o Logseq."
           :plugin/open-preferences "Abrir o arquivo de preferências do plguin"
           :plugin/open-settings "Abrir configurações"
           :plugin/refresh-lists "Recarregar lista"
           :plugin/restart "Reiniciar o App"
           :plugin/title "Título"
           :plugin/uninstall "Desinstalar"
           :plugin/unpacked-tips "Selecione a pasta do plugin"
           :plugin/up-to-date "Está atualizado"
           :plugin/update "Atualizar"
           :plugin/update-available "Atualização disponível"
           :plugin/updating "Atualizando"
           :right-side-bar/all-pages "Todas as páginas"
           :right-side-bar/graph-view "Ver gráfico"
           :search/page-names "Procurar nome da página"
           :plugin/stars "Estrelas"
           :select/default-prompt "Selecione um"
           :select.graph/prompt "Selecione um gráfico"
           :select.graph/add-graph "Sim, adicionar outro gráfico"
           :select.graph/empty-placeholder-description "Nenhum gráfico encontrado. Deseja adicionar um novo?"
           :settings-page/enable-shortcut-tooltip "Habilitar dicas de atalho"
           :tips/all-done "Tudo certo"
           :updater/new-version-install "Uma nova versão foi baixada"
           :updater/quit-and-install "Reinicie para instalar"
           :paginates/pages "Total de {1} paginas"
           :plugin/open-package "Abrir pacote"
           :plugin/reload "Reiniciar"
           :plugin/unpacked "Descompactado"
           :settings-page/auto-updater "Auto atualizar"
           :settings-page/custom-configuration "Configuração personalizada"
           :settings-page/custom-theme "Tema personalizado"
           :settings-page/edit-custom-css "Editar custom.css"
           :re-index-multiple-windows-warning "Você precisa fechar as outras janelas antes de reindexar este gráfico."
           :re-index-discard-unsaved-changes-warning "A reindexação descartará o gráfico atual e processará todos os arquivos novamente conforme estão armazenados no disco. Você perderá as alterações não salvas e pode demorar um pouco. Continuar?"
           :sync-from-local-changes-detected "Atualizar detecta e processa arquivos modificados em seu disco e que são diferentes do conteúdo atual da página do Logseq. Continuar?"
           :page/open-backup-directory "Abra a listagem de backups de página"
           :save "Salvar"
           :type "Tipo"
           :host "Host"
           :port "Porta"
           :settings-of-plugins "Configurações de Plugin"
           :graph/persist "O Logseq está sincronizando seu status interno, aguarde alguns segundos."
           :graph/persist-error "Falha na sincronização do status interno."
           :graph/save "Salvando..."
           :graph/save-success "Salvo com sucesso"
           :graph/save-error "Falha ao salvar"
           :settings-page/plugin-system "Sistema de Plugins"
           :settings-page/network-proxy "Proxy de Rede"

           :file-sync/other-user-graph "O gráfico local atual é obrigado ao gráfico remoto de outro usuário. Portanto, não consigo iniciar a sincronização."
           :file-sync/graph-deleted "O gráfico remoto atual foi excluído"

           :page/copy-page-url "Copiar URL da página"
           :page/file-sync-versions "Versões da página"
           :plugin/not-installed "Não instalado"
           :tutorial/dummy-notes "dummy-notes-en.md"
           :tutorial/text "tutorial-en.md"
           :settings-page/edit-export-css "Editar export.css"
           :settings-page/enable-flashcards "Flashcards"
           :settings-page/export-theme "Exportar Tema"}

   :pt-PT {:on-boarding/demo-graph "Isto é um grafo de demonstração, nenhuma mudança será guardada até abrir uma pasta local."
           :on-boarding/add-graph "Adicionar grafo"
           :on-boarding/open-local-dir "Abrir uma pasta local"
           :on-boarding/new-graph-desc-1 "O Logseq suporta ambos os modos de Markdown e Org. Pode abrir uma pasta existente ou criar uma nova no seu dispositivo. Os seus dados serão guardados apenas neste dispositivo."
           :on-boarding/new-graph-desc-2 "Após criar uma nova pasta, três novas pastas serão criadas dentro dessa pasta:"
           :on-boarding/new-graph-desc-3 "/journals - armazena as suas páginas diárias"
           :on-boarding/new-graph-desc-4 "/pages - armazena todas as outras páginas"
           :on-boarding/new-graph-desc-5 "/logseq - armazena as configurações, custom.css, e alguns metadados."
           :help/start "Começar a usar"
           :help/about "Sobre o Logseq"
           :help/roadmap "Plano de implementação"
           :help/bug "Reportar um erro"
           :help/feature "Pedir uma funcionalidade"
           :help/changelog "Registo de alterações"
           :help/blog "Blogue do Logseq"
           :help/docs "Documentação"
           :help/privacy "Política de privacidade"
           :help/terms "Termos"
           :help/community "Comunidade do Discord"
           :help/awesome-logseq "Awesome Logseq"
           :help/shortcuts "Atalhos de Teclado"
           :help/shortcuts-triggers "Iniciadores"
           :help/shortcut "Atalho"
           :help/slash-autocomplete "Auto-completar com barra"
           :help/block-content-autocomplete "Autocompletar conteúdo de bloco"
           :help/reference-autocomplete "Autocompletar referência de página"
           :help/block-reference "Referência de bloco"
           :help/key-commands "Comandos chave"
           :help/working-with-lists " (trabalhar com listas)"
           :help/select-nfs-browser "Por favor use outro navegador (como o Chrome mais recente) com suporte para funcionalidades NFS para abrir pastas locais."
           :undo "Desfazer"
           :redo "Refazer"
           :general "Geral"
           :more "Mais"
           :search/result-for "Resultado da pesquisa para "
           :search/items "itens"
           :help/context-menu "Menu contextual"
           :help/fold-unfold "Ocultar/Expandir blocos (fora do modo de edição)"
           :help/markdown-syntax "Sintaxe de Markdown"
           :help/org-mode-syntax "Sintaxe do modo Org"
           :bold "Negrito"
           :italics "Itálico"
           :html-link "Link Html"
           :highlight "Realçado"
           :strikethrough "Rasurado"
           :code "Código"
           :right-side-bar/help "Ajuda"
           :right-side-bar/switch-theme "Temas"
           :right-side-bar/theme "Tema {1}"
           :right-side-bar/page "Grafo da página"
           :right-side-bar/recent "Recente"
           :right-side-bar/contents "Conteúdo"
           :right-side-bar/favorites "Favoritos"
           :right-side-bar/page-graph "Grafo da página"
           :right-side-bar/block-ref "Referência de bloco"
           :right-side-bar/graph-view "Vista do grafo"
           :right-side-bar/all-pages "Todas as páginas"
           :right-side-bar/flashcards "Flashcards"
           :right-side-bar/new-page "Nova página"
           :left-side-bar/journals "Diários"
           :left-side-bar/new-page "Nova página"
           :left-side-bar/nav-favorites "Favoritos"
           :left-side-bar/nav-shortcuts "Atalhos"
           :left-side-bar/nav-recent-pages "Recente"
           :format/preferred-mode "Qual o seu modo preferido?"
           :format/markdown "Markdown"
           :format/org-mode "Modo Org"
           :reference/linked "Referência ligada"
           :reference/unlinked-ref "Referências não ligadas"
           :page/presentation-mode "Modo de apresentação"
           :page/edit-properties-placeholder "Propriedades"
           :page/delete-success "Página {1} apagada com sucesso!"
           :page/delete-confirmation "Tem a certeza de que quer apagar esta página e o respetivo ficheiro?"
           :page/rename-to "Renomear \"{1}\" como:"
           :page/priority "Prioridade \"{1}\""
           :page/copy-to-json "Copiar a página inteira como JSON"
           :page/rename "Renomear página"
           :page/open-in-finder "Abrir em pasta"
           :page/open-with-default-app "Abrir com a aplicação predefinida"
           :page/action-publish "Publicar"
           :page/make-public "Tornar pública para publicação"
           :page/version-history "Ver histórico da página"
           :page/make-private "Tornar privada"
           :page/delete "Apagar página"
           :page/add-to-favorites "Adicionar aos Favoritos"
           :page/show-journals "Mostrar Diários"
           :page/show-name "Mostrar nome da página"
           :page/hide-name "Esconder nome da página"
           :block/name "Nome da página"
           :page/last-modified "Última modificação em"
           :page/new-title "Qual é o título da sua nova página?"
           :page/earlier "Antes"
           :page/no-more-journals "Não há mais diários"
           :journal/multiple-files-with-different-formats "Parece que tem vários ficheiros de diário (com diferentes formatos) para o mesmo mês, por favor apenas guarde um ficheiro de diário para cada mês."
           :journal/go-to "Ir para ficheiros"
           :file/name "Nome do ficheiro"
           :file/file "Ficheiro: "
           :file/last-modified-at "Última modificação em"
           :file/no-data "Sem dados"
           :file/format-not-supported "Formato .{1} não suportado."
           :page/created-at "Criada Em"
           :page/updated-at "Atualizada Em"
           :page/backlinks "Back Links"
           :editor/block-search "Pesquisar por um bloco"
           :editor/image-uploading "A enviar"
           :draw/invalid-file "Não foi possível carregar este ficheiro excalidraw inválido"
           :draw/specify-title "Por favor, indique um título primeiro!"
           :draw/rename-success "O ficheiro foi renomeado com sucesso!"
           :draw/rename-failure "Renomear ficheiro falhou, razão: "
           :draw/title-placeholder "Sem título"
           :draw/save "Guardar"
           :draw/save-changes "Guardar alterações"
           :draw/new-file "Novo ficheiro"
           :draw/list-files "Listar ficheiros"
           :draw/delete "Apagar"
           :draw/more-options "Mais opções"
           :draw/back-to-logseq "Voltar ao logseq"
           :text/image "Imagem"
           :asset/confirm-delete "Tem a certeza de que quer apagar este {1}?"
           :asset/physical-delete "Remover também o ficheiro (note que não pode ser restaurado)"
           :content/copy "Copiar"
           :content/cut "Cortar"
           :content/make-todos "Fazer {1}s"
           :content/copy-block-ref "Copiar referência do bloco"
           :content/focus-on-block "Focar no bloco"
           :content/open-in-sidebar "Abrir na barra lateral"
           :content/copy-as-json "Copiar como JSON"
           :content/click-to-edit "Clicar para editar"
           :settings-page/git-desc "é usado para o controlo de versões de páginas, pode clicar no menu de três pontos verticais para ver o histórico da página."
           :settings-page/git-confirm "É necessário reiniciar a aplicação após atualizar as definições do Git."
           :settings-page/git-switcher-label "Ativar o auto commit do Git"
           :settings-page/git-commit-delay "Segundos entre cada auto commit"
           :settings-page/edit-config-edn "Editar config.edn"
           :settings-page/edit-custom-css "Editar custom.css"
           :settings-page/custom-configuration "Configuração personalizada"
           :settings-page/custom-theme "Tema personalizado"
           :settings-page/show-brackets "Mostrar parênteses retos"
           :settings-page/spell-checker "Verificador ortográfico"
           :settings-page/disable-sentry "Enviar dados de utilização e diagnósticos para Logseq"
           :settings-page/preferred-outdenting "Desindentação lógica"
           :settings-page/custom-date-format "Formato de data preferido"
           :settings-page/preferred-file-format "Formato de ficheiro preferido"
           :settings-page/preferred-workflow "Workflow preferido"
           :settings-page/enable-shortcut-tooltip "Ativar dicas de atalhos"
           :settings-page/enable-timetracking "Registo de tempo"
           :settings-page/enable-tooltip "Dicas de atalhos"
           :settings-page/enable-journals "Diários"
           :settings-page/enable-all-pages-public "Todas as páginas públicas ao publicar"
           :settings-page/enable-encryption "Encriptação"
           :settings-page/customize-shortcuts "Atalhos de teclado"
           :settings-page/shortcut-settings "Personalizar atalhos"
           :settings-page/home-default-page "Definir a página inicial predefinida"
           :settings-page/enable-block-time "Carimbos temporais nos blocos"
           :settings-page/clear-cache "Limpar cache"
           :settings-page/clear "Limpar"
           :settings-page/developer-mode "Modo de desenvolvedor"
           :settings-page/enable-developer-mode "Modo de desenvolvedor"
           :settings-page/disable-developer-mode "Desativar modo de desenvolvedor"
           :settings-page/developer-mode-desc "O modo de desenvolvedor ajuda os contribuidores e programadores de extensões a testar as suas integrações com o Logseq mais eficientemente."
           :settings-page/current-version "Versão atual"
           :settings-page/current-graph "Grafo atual"
           :settings-page/tab-general "Geral"
           :settings-page/tab-editor "Editor"
           :settings-page/tab-shortcuts "Atalhos"
           :settings-page/tab-version-control "Controlo de Versões"
           :settings-page/tab-advanced "Avançado"
           :logseq "Logseq"
           :on "ON"
           :more-options "Mais opções"
           :to "para"
           :yes "Sim"
           :no "Não"
           :submit "Submeter"
           :cancel "Cancelar"
           :close "Fechar"
           :delete "Apagar"
           :re-index "Re-indexar"
           :re-index-detail "Reconstruir o grafo"
           :open-new-window "Nova Janela"
           :sync-from-local-files "Atualizar"
           :sync-from-local-files-detail "Importar alterações de ficheiros locais"
           :unlink "remover ligação"
           :search/publishing "Pesquisar"
           :search "Pesquisar ou Criar Página"
           :page-search "Pesquisar na página atual"
           :graph-search "Pesquisar grafo"
           :new-page "Nova página"
           :new-file "Novo ficheiro"
           :new-graph "Adicionar novo grafo"
           :graph "Grafo"
           :graph-view "Ver Grafo"
           :cards-view "Ver Cartões"
           :publishing "Publicar"
           :export "Exportar"
           :export-markdown "Exportar como Markdown padrão (sem propriedades de bloco)"
           :export-opml "Exportar como OPML"
           :export-public-pages "Exportar páginas públicas"
           :export-json "Exportar como JSON"
           :export-roam-json "Exportar como JSON Roam"
           :export-edn "Exportar como EDN"
           :export-datascript-edn "Exportar datascript EDN"
           :convert-markdown "Converter cabeçalhos Markdown para listas não-ordenadas (# -> -)"
           :all-graphs "Todos os grafos"
           :all-pages "Todas as páginas"
           :all-files "Todos os ficheiros"
           :remove-orphaned-pages "Remover páginas órfãs"
           :all-journals "Todos os diários"
           :my-publishing "As minhas publicações"
           :settings "Definições"
           :plugins "Plugins"
           :themes "Temas"
           :developer-mode-alert "É necessário reiniciar a aplicação para ativar o sistema de plugins. Quer reiniciar agora?"
           :relaunch-confirm-to-work "Deve reiniciar a aplicação para fazê-lo funcionar. Quer reiniciar agora?"
           :import "Importar"
           :join-community "Junte-se à comunidade"
           :sponsor-us "Seja um patrocinador"
           :discord-title "O nosso grupo de discord!"
           :help-shortcut-title "Clique para ver atalhos e outras dicas"
           :loading "A carregar"
           :cloning "A clonar"
           :parsing-files "A analisar ficheiros"
           :loading-files "A carregar ficheiros"
           :login "Iniciar sessão"
           :logout "Sessão final"
           :go-to "Ir para "
           :or "ou"
           :download "Descarregar"
           :repo/download-zip "Descarregar todos os ficheiros como zip"
           :language "Idioma"
           :white "Claro"
           :dark "Escuro"
           :remove-background "Remover fundo"
           :open "Abrir"
           :open-a-directory "Abrir uma pasta local"
           :user/delete-account "Apagar conta"
           :user/delete-your-account "Apague a sua conta"
           :user/delete-account-notice "Todas as suas páginas publicadas em logseq.com serão apagadas."

           :help/shortcut-page-title "Atalhos de teclado"

           :plugin/installed "Instalado"
        :plugin/installing "A instalar"
        :plugin/install "Instalar"
        :plugin/reload "Recarregar"
        :plugin/update "Atualizar"
        :plugin/check-update "Procurar por atualizações"
        :plugin/check-all-updates "Procurar por todas as atualizações"
        :plugin/refresh-lists "Atualizar listas"
        :plugin/enabled "Ativado"
        :plugin/disabled "Desativado"
        :plugin/update-available "Atualização disponível"
        :plugin/updating "A atualizar"
        :plugin/uninstall "Desinstalar"
        :plugin/marketplace "Mercado"
        :plugin/downloads "Downloads"
        :plugin/stars "Estrelas"
        :plugin/title "Título"
        :plugin/all "Todos"
        :plugin/unpacked "Desempacotado"
        :plugin/delete-alert "Tem a certeza de quer desinstalar o plugin [{1}]?"
        :plugin/open-settings "Abrir definições"
        :plugin/open-package "Abrir pacote"
        :plugin/load-unpacked "Carregar plugin desempacotado"
        :plugin/open-preferences "Abrir o ficheiro de prefs do plugin"
        :plugin/restart "Reiniciar a App"
        :plugin/unpacked-tips "Selecionar a pasta de plugins"
        :plugin/contribute "✨ Escreva e submeta um novo plugin"
        :plugin/marketplace-tips "Se o plugin não funcionar corretamente quando instalado pela 1ª vez, tente reiniciar o Logseq."
        :plugin/up-to-date "Está atualizado"
        :plugin/custom-js-alert "Ficheiro custom.js encontrado, quer executá-lo? (Se não compreender o conteúdo do ficheiro, é melhor não executá-lo, pois há certos riscos de segurança ao fazê-lo.)"

        :pdf/copy-ref "Copiar referência"
        :pdf/copy-text "Copiar texto"
        :pdf/linked-ref "Referências ligadas"
        :pdf/toggle-dashed "Estilo tracejado para realce de área"

        :updater/new-version-install "Uma nova versão foi descarregada."
        :updater/quit-and-install "Reiniciar para instalar"

        :paginates/pages "{1} págs. no total"
        :paginates/prev "Ant."
        :paginates/next "Próx."

        :tips/all-done "Tudo feito"

        :command-palette/prompt "Introduza um comando"
        :select/default-prompt "Selecione um"
        :select.graph/prompt "Selecione um grafo"
        :select.graph/empty-placeholder-description "Sem grafos correspondentes. Quer adicionar outro?"
        :select.graph/add-graph "Sim, adicionar outro grafo"

        :file-sync/other-user-graph "O gráfico local atual é obrigado ao gráfico remoto de outro usuário. Portanto, não consigo iniciar a sincronização."
        :file-sync/graph-deleted "O gráfico remoto atual foi excluído"
        :export-graph "Exportar gráfico"
        :export-page "Exportar Página"
        :host "Host"
        :port "Port"
        :re-index-discard-unsaved-changes-warning "A reindexação descartará o gráfico atual e processará todos os arquivos novamente conforme estão armazenados no disco. Você perderá as alterações não salvas e pode demorar um pouco. Continuar?"
        :re-index-multiple-windows-warning "Você precisa fechar as outras janelas antes de reindexar este gráfico."
        :save "Salvar"
        :settings-of-plugins "Configurações dos plugins"
        :sync-from-local-changes-detected "Atualizar detecta e processa arquivos modificados em seu disco e que são diferentes do conteúdo atual da página do Logseq. Continuar?"
        :type "Tipo"
        :content/copy-block-emebed "Copiar bloco para incorporar"

        :graph/persist "O Logseq está sincronizando seu status interno, aguarde alguns segundos."
        :graph/persist-error "Falha na sincronização do status interno."
        :graph/save "Salvando..."
        :graph/save-success "Salvo com sucesso"
        :graph/save-error "Falha ao salvar"

        :page/copy-page-url "Copiar URL da página"
        :page/file-sync-versions "Versões da Página"
        :page/open-backup-directory "Abra a listagem de backups de página"
        :page/unfavorite "Desfavoritar página"
        :plugin/not-installed "Não instalado"
        :search/page-names "Procurar nome da página"
        :settings-page/auto-updater "Auto atualizar"
        :tutorial/dummy-notes "dummy-notes-en.md"
        :tutorial/text "tutorial-en.md"
        :settings-page/edit-export-css "Editar export.css"
        :settings-page/enable-flashcards "Flashcards"
        :settings-page/export-theme "Exportar tema"
        :settings-page/network-proxy "Proxy de rede"
        :settings-page/plugin-system "Sistema de plugins"}

   :ru {:on-boarding/demo-graph "Это демонстрационный граф, изменения не будут сохранены, пока вы не откроете локальный файл."
        :on-boarding/add-graph "Добавить новый граф"
        :on-boarding/open-local-dir "Открыть локальный каталог"
        :on-boarding/new-graph-desc-1 "Logseq поддерживает Markdown and Org-mode. Вы можете открыть существующий каталог или создать новый на вашем устройства, каталог также можно назвать просто папкой. Ваши данные будут храниться только на вашем устройстве."
        :on-boarding/new-graph-desc-2 "После того, как вы укажете каталог, в нём будут созданы три папки:"
        :on-boarding/new-graph-desc-3 "/journals - хранит страницы ваших дневников"
        :on-boarding/new-graph-desc-4 "/pages - хранит остальные страницы"
        :on-boarding/new-graph-desc-5 "/logseq - хранит конфигурации, custom.css, и другие метаданные."
        :help/start "Начало работы"
        :help/about "О Logseq"
        :help/roadmap "Дорожная карта"
        :help/bug "Сообщить об ошибке"
        :help/feature "Запрос функционала"
        :help/changelog "Журнал изменений"
        :help/blog "Logseq блог"
        :help/docs "Документация"
        :help/privacy "Политика конфендициальности"
        :help/terms "Условия"
        :help/community "Discord сообщество"
        :help/awesome-logseq "Потрясающий Logseq"
        :help/shortcuts "Горячие клавиши"
        :help/shortcuts-triggers "Действия"
        :help/shortcut "Горячие клавиши"
        :help/slash-autocomplete "Слэш - автодополнение"
        :help/block-content-autocomplete "Блок контента - автодополнение"
        :help/reference-autocomplete "Ссылка на страницу - автодополнение"
        :help/block-reference "Ссылка на блок"
        :help/key-commands "Key commands"
        :help/working-with-lists " (работа со списками)"
        :help/select-nfs-browser "Пожалуйста, используйте другой браузер (например, последний Chrome), который поддерживает NFS функционал, для работы с локальными файлами."
        :undo "Отменить"
        :redo "Вернуть"
        :general "Общий"
        :more "Больше"
        :search/result-for "Искать результат для "
        :search/items "элементы"
        :search/page-names "Искать имена страниц"
        :help/context-menu "Контекстное меню блока"
        :help/fold-unfold "Свернуть/развернуть блоки (когда не в режиме редактирования)"
        :help/markdown-syntax "Markdown синтаксис"
        :help/org-mode-syntax "Org mode синтаксис"
        :bold "Жирный"
        :italics "Курсив"
        :html-link "HTML ссылка"
        :highlight "Выделение"
        :strikethrough "Перечёркнутый"
        :code "Код"
        :right-side-bar/help "Справка"
        :right-side-bar/switch-theme "Тема"
        :right-side-bar/theme "{1} тема"
        :right-side-bar/page "Граф страницы"
        :right-side-bar/recent "Недавние"
        :right-side-bar/contents "Содержание"
        :right-side-bar/favorites "Избранные"
        :right-side-bar/page-graph "Граф страницы"
        :right-side-bar/block-ref "Ссылка на блок"
        :left-side-bar/new-page "Новая страница"
        :left-side-bar/nav-favorites "Избранное"
        :left-side-bar/nav-shortcuts "Горячие клавиши"
        :left-side-bar/nav-recent-pages "Недавнее"
        :right-side-bar/graph-view "Визуальный граф"
        :right-side-bar/all-pages "Все страницы"
        :right-side-bar/flashcards "Слайды"
        :right-side-bar/new-page "Новая страница"
        :left-side-bar/journals "Дневники"
        :format/preferred-mode "Какой режим вы предпочитаете?"
        :format/markdown "Markdown"
        :format/org-mode "Org mode"
        :reference/linked "Связанные ссылки"
        :reference/unlinked-ref "Несвязанные ссылки"
        :page/presentation-mode "Презентация"
        :page/edit-properties-placeholder "Свойства"
        :page/delete-success "Страница {1} была успешно удалена!"
        :page/delete-confirmation "Вы уверены, что хотите удалить эту страницу и ее файл?"
        :page/rename-to "Переименовать \"{1}\" в:"
        :page/priority "Приоритет \"{1}\""
        :page/copy-to-json "Скопировать всю страницу как JSON"
        :page/rename "Переименовать страницу"
        :page/open-in-finder "Открыть в каталоге"
        :page/open-with-default-app "Открыть через приложение по умолчанию"
        :page/action-publish "Опубликовать"
        :page/make-public "Сделать доступным для публикации"
        :page/version-history "проверить историю git страницы"
        :page/file-sync-versions "история страницы"
        :page/make-private "Сделать приватным"
        :page/delete "Удалить страницу"
        :page/add-to-favorites "Добавить в Избранное"
        :page/unfavorite "Удалить страницу из Избранного"
        :page/show-journals "Показать Дневники"
        :page/show-name "Показать имя страницы"
        :page/hide-name "Скрыть имя страницы"
        :block/name "Имя страницы"
        :page/last-modified "Последнее изменение"
        :page/new-title "Какой заголовок у вашей новой страницы?"
        :page/earlier "Ранее"
        :page/no-more-journals "Дневников больше нет"
        :journal/multiple-files-with-different-formats "Похоже, что у вас несколько файлов Дневника (с разными форматами) для одного месяца. Пожалуйста, используйста только один файл Дневника для каждого месяца."
        :journal/go-to "Перейти к файлам"
        :file/name "Имя файла"
        :file/file "Файл: "
        :file/last-modified-at "Последнее изменение"
        :file/no-data "Нет данных"
        :file/format-not-supported "Расширение .{1} не поддерживается."
        :page/created-at "Создан"
        :page/updated-at "Обновлен"
        :page/backlinks "Обратная ссылка"
        :editor/block-search "Искать блок"
        :editor/image-uploading "Загрузка"
        :draw/invalid-file "Не удалось загрузить недопустимый excalidraw файл"
        :draw/specify-title "Пожалуйста, сначала укажите заголовок!"
        :draw/rename-success "Файл был успешно переименован!"
        :draw/rename-failure "Переименовать файл не удлось, причина: "
        :draw/title-placeholder "Без названия"
        :draw/save "Сохранить"
        :draw/save-changes "Сохранить изменения"
        :draw/new-file "Новый файл"
        :draw/list-files "Список файлов"
        :draw/delete "Удалить"
        :draw/more-options "Больше опций"
        :draw/back-to-logseq "Вернуться к logseq"
        :text/image "Изображение"
        :asset/confirm-delete "Вы уверены, что хотите удалить {1}?"
        :asset/physical-delete "Также удалить файл (обратите внимание, восстановить его будет невозможно)"
        :content/copy "Копировать"
        :content/cut "Вырезать"
        :content/make-todos "Make {1}s"
        :content/copy-block-ref "Копировать ссылку блока"
        :content/copy-block-emebed "Копировать встроенный блок"
        :content/focus-on-block "Фокус на блоке"
        :content/open-in-sidebar "Открыть в боковой панели"
        :content/copy-as-json "Копировать как JSON"
        :content/click-to-edit "Нажмите для редактирования"
        :settings-page/edit-config-edn "Редактировать config.edn для текущего графа"
        :settings-page/git-desc " используется для контроля версий страниы. Вы можете кликнуть на меню 'три точки' чтобы проверить историю страницы."
        :settings-page/git-confirm "Необходимо перезапустить приложение после изменения настроек Git."
        :settings-page/git-switcher-label "Автокоммит в Git"
        :settings-page/git-commit-delay "Git автокоммит после сек."
        :settings-page/show-brackets "Показывать скобки"
        :settings-page/spell-checker "Проверка орфограции"
        :settings-page/auto-updater "Автообновление"
        :settings-page/disable-sentry "Отправлять данные использования и диагностику в Logseq"
        :settings-page/preferred-outdenting "Логические отступы"
        :settings-page/custom-date-format "Формат дат"
        :settings-page/preferred-file-format "Формат файлов"
        :settings-page/preferred-workflow "Рабочий процесс"
        :settings-page/enable-timetracking "Отслеживание времени"
        :settings-page/enable-tooltip "Всплывающие подсказки"
        :settings-page/enable-shortcut-tooltip "Всплывающие подсказки горячих клавиш"
        :settings-page/enable-journals "Включить Дневники"
        :settings-page/enable-all-pages-public "Все страницы общедоступны при публикации"
        :settings-page/enable-encryption "Функции шифрования"
        :settings-page/customize-shortcuts "Горячие клавиши"
        :settings-page/shortcut-settings "Настроить горячие клавиши"
        :settings-page/home-default-page "Установить домашнюю страницу по умолчанию"
        :settings-page/enable-block-time "Временные метки блока"
        :settings-page/clear-cache "Отчистить кэш"
        :settings-page/clear "Отчистить"
        :settings-page/developer-mode "Режим разработчика"
        :settings-page/enable-developer-mode "Включить режим разработчика"
        :settings-page/disable-developer-mode "Выключить режим разработчика"
        :settings-page/developer-mode-desc "Режим разработчика помогает людям, участвующим в разработке приложения и расширений, тестировать их интеграции с Logseq более эффективно."
        :settings-page/current-version "Версия"
        :settings-page/current-graph "Текущий граф"
        :settings-page/tab-general "Общие"
        :settings-page/tab-editor "Редактор"
        :settings-page/tab-shortcuts "Горячие клавиши"
        :settings-page/tab-version-control "Контроль версий"
        :settings-page/tab-advanced "Расширенные"
        :logseq "Logseq"
        :on "ON"
        :more-options "Больше опций"
        :to "to"
        :yes "Да"
        :no "Нет"
        :submit "Подтвердить"
        :cancel "Отмена"
        :close "Закрыть"
        :delete "Удалить"
        :re-index "Переиндексировать (перестроить граф)"
        :sync-from-local-files "Обновить (импортировать изменния из локальных файлов)"
        :unlink "отвязать"
        :search/publishing "Искать"
        :search "Искать или создать страницу"
        :page-search "Искать на текущей странице"
        :graph-search "Искать граф"
        :new-page "Новая страница"
        :new-file "Новый файл"
        :new-graph "Добавить новый граф"
        :graph "Граф"
        :graph-view "Смотреть граф"
        :cards-view "Смотреть карточки"
        :publishing "Публикация"
        :export "Экспорт"
        :export-graph "Экспортировать граф"
        :export-page "Экспортировать страницу"
        :export-markdown "Экспортировать как стандартный Markdown (без свойств блока)"
        :export-opml "Экспортировать как OPML"
        :export-public-pages "Экспорт публичных страниц"
        :export-json "Экспортировать как JSON"
        :export-roam-json "Экспортировать как Roam JSON"
        :export-edn "Экспортировать как EDN"
        :export-datascript-edn "Экспорт данных EDN"
        :convert-markdown "Преобразовать Markdown заголовки в обычный список (# -> -)"
        :all-graphs "Все графы"
        :all-pages "Все страницы"
        :all-files "Все файлы"
        :remove-orphaned-pages "Удалить страницы без родителя"
        :all-journals "Все журналы"
        :my-publishing "Мои публикации"
        :settings "Настройки"
        :plugins "Расширения"
        :themes "Темы"
        :developer-mode-alert "Необходимо перезагрузить приложение для активации системы плагинов. Хотите сделать это сейчас?"
        :relaunch-confirm-to-work "Необходимо перезапустить приложение. Сделать это сейчас?"
        :import "Импорт"
        :join-community "Присоединиться к сообществу"
        :sponsor-us "Стать спонсором"
        :discord-title "Наша группа в Дискорде!"
        :help-shortcut-title "Нажмите для просмотра горячих клавиш и других полезностей"
        :loading "Загрузка"
        :cloning "Клонирование"
        :parsing-files "Парсинг файлов"
        :loading-files "Загрузка файлов"
        :login "Логин"
        :logout "Выйти"
        :go-to "Go to "
        :or "или"
        :download "Скачать"
        :repo/download-zip "Скачать все файлы как архив"
        :language "Язык"
        :white "Светлый"
        :dark "Темный"
        :remove-background "Удалить фон"
        :open "Открыть"
        :open-a-directory "Открыть локальную папку"
        :user/delete-account "Удалить аккаунт"
        :user/delete-your-account "Удалить ваш аккаунт"
        :user/delete-account-notice "Все ваши опубликованные страницы на logseq.com будут удалены."

        :help/shortcut-page-title "Горячие клавиши"

        :plugin/installed "Установленно"
        :plugin/installing "Установка"
        :plugin/install "Установить"
        :plugin/reload "Перезагрузить"
        :plugin/update "Обновить"
        :plugin/updating "Обновление"
        :plugin/uninstall "Удаление"
        :plugin/marketplace "Маркетплейс"
        :plugin/open-settings "Открыть настройки"
        :plugin/open-package "Открыть пакет"
        :plugin/load-unpacked "Загрузить распакованные расширения"
        :plugin/open-preferences "Открыть файл настроек плагина"
        :plugin/restart "Перезапустить приложение"
        :plugin/unpacked-tips "Выбрать папку для расширений"
        :plugin/contribute "✨ Написать и подтвердить новое расширение"
        :plugin/marketplace-tips "Если расширение работает некорректно после установки, попробуйте перезапустить Logseq."
        :plugin/up-to-date "Обновлено"
        :plugin/custom-js-alert "Найден файл custom.js, выполнить его? (Если вы не понимаете содержимое этого файла, рекомендуем не разрешать выполнение, т.к. это несет риски безопасности.)"

        :pdf/copy-ref "Копировать ссылку"
        :pdf/copy-text "Копировать текст"
        :pdf/linked-ref "Связанные ссылки"
        :pdf/toggle-dashed "Пунктир для выделения области"

        :updater/new-version-install "Новая версия загружена. Перезапустите приложения для завершения обновления."
        :updater/quit-and-install "Перезапустить для установки"

        :paginates/pages "Всего {1} стр."
        :paginates/prev "Предыдушая"
        :paginates/next "Следующая"

        :tips/all-done "Все сделано"

        :command-palette/prompt "Набери команду"

        :file-sync/other-user-graph "Текущий локальный график привязан к удаленному диаграмму другого пользователя. Так что не могу начать синхронизирование"
        :file-sync/graph-deleted "Текущий удаленный график был удален"}

   :ja {:tutorial/text #?(:cljs (rc/inline "tutorial-ja.md")
                                :default "tutorial-ja.md")
        :tutorial/dummy-notes #?(:cljs (rc/inline "dummy-notes-ja.md")
                                       :default "dummy-notes-ja.md")
        :on-boarding/demo-graph "これはデモ用のグラフなので変更内容は保存されません。保存するにはローカルフォルダを選んで新規グラフを追加してください。"
        :on-boarding/add-graph "新規グラフを追加"
        :on-boarding/open-local-dir "ここをクリックして、データ保存先のローカルフォルダを選んでください"
        :on-boarding/new-graph-desc-1 "LogseqはMarkdownとOrg-modeの両方をサポートしています。あなたのPC端末上の既存のフォルダ（ディレクトリ）を選ぶか新しいフォルダを作成してください。データはあなたのPC端末上にのみ保存されます。"
        :on-boarding/new-graph-desc-2 "フォルダを選ぶと、その中に3つのフォルダが作成されます："
        :on-boarding/new-graph-desc-3 "/journals - あなたの日誌が保存されます"
        :on-boarding/new-graph-desc-4 "/pages - その他のページが保存されます"
        :on-boarding/new-graph-desc-5 "/logseq - 設定ファイル、custom.css、その他のメタデータを保存します"
        :help/start "はじめに"
        :help/about "Logseqについて"
        :help/roadmap "ロードマップ"
        :help/bug "バグ報告"
        :help/feature "機能リクエスト"
        :help/changelog "更新履歴"
        :help/blog "Logseq ブログ"
        :help/docs "ドキュメント"
        :help/privacy "プライバシーポリシー"
        :help/terms "利用規約"
        :help/community "Discord community"
        :help/awesome-logseq "Awesome Logseq"
        :help/shortcuts "キーボードショートカット"
        :help/shortcuts-triggers "Triggers"
        :help/shortcut "ショートカット"
        :help/slash-autocomplete "スラッシュで自動補完"
        :help/block-content-autocomplete "ブロックコンテンツの自動補完"
        :help/reference-autocomplete "ページ参照の自動補完"
        :help/block-reference "ブロック参照"
        :help/key-commands "キーコマンド"
        :help/working-with-lists " (working with lists)"
        :help/select-nfs-browser "ローカルディレクトリを開くために、NFSをサポートする別のブラウザ（最新版の Chromeなど）を利用してください。"
        :undo "元に戻す"
        :redo "やり直し"
        :general "一般"
        :more "詳細"
        :search/result-for "Search result for "
        :search/items "items"
        :search/page-names "ページ名で検索"
        :help/context-menu "ブロックのコンテキストメニュー"
        :help/fold-unfold "ブロックの折りたたみ／展開 （編集モードでないとき）"
        :help/markdown-syntax "マークダウン文法"
        :help/org-mode-syntax "Org mode 文法"
        :bold "太字"
        :italics "斜体"
        :html-link "Html リンク"
        :highlight "ハイライト"
        :strikethrough "取り消し線"
        :code "コード"
        :right-side-bar/help "ヘルプ"
        :right-side-bar/switch-theme "テーマ"
        :right-side-bar/theme "{1} テーマ"
        :right-side-bar/page "ページグラフ"
        :right-side-bar/recent "最新"
        :right-side-bar/contents "目次"
        :right-side-bar/favorites "Favorites"
        :right-side-bar/page-graph "ページグラフ"
        :right-side-bar/block-ref "ブロック参照"
        :right-side-bar/graph-view "グラフビュー"
        :right-side-bar/all-pages "全ページ"
        :right-side-bar/flashcards "フラッシュカード"
        :right-side-bar/new-page "新規ページ"
        :left-side-bar/journals "日誌"
        :left-side-bar/new-page "新規ページ"
        :left-side-bar/nav-favorites "お気に入り"
        :left-side-bar/nav-shortcuts "ショートカット"
        :left-side-bar/nav-recent-pages "最新"
        :format/preferred-mode "What's your preferred mode?"
        :format/markdown "Markdown"
        :format/org-mode "Org mode"
        :reference/linked "リンクありの参照元"
        :reference/unlinked-ref "リンクなしの参照元"
        :page/presentation-mode "プレゼンテーション"
        :page/edit-properties-placeholder "プロパティ"
        :page/delete-success "ページ {1} は削除されました！"
        :page/delete-confirmation "このページとページのファイルを削除してもよいですか？"
        :page/rename-to "\"{1}\" の名前を変更:"
        :page/priority "優先度 \"{1}\""
        :page/copy-to-json "ページ全体をJSON形式でコピー"
        :page/rename "ページの名前変更"
        :page/open-in-finder "ディレクトリで開く"
        :page/open-with-default-app "デフォルトのアプリで開く"
        :page/action-publish "パブリッシュする"
        :page/make-public "パブリッシュのため公開する"
        :page/version-history "ページ履歴の確認"
        :page/open-backup-directory "ページのバックアップディレクトリを開く"
        :page/file-sync-versions "Page versions"
        :page/make-private "非公開にする"
        :page/delete "ページ削除"
        :page/add-to-favorites "お気に入りへ追加"
        :page/unfavorite "お気に入りを解除"
        :page/show-journals "日誌を表示"
        :page/show-name "ページ名を表示"
        :page/hide-name "ページ名を隠す"
        :block/name "ページ名"
        :page/last-modified "最終更新日時 "
        :page/new-title "新規ページのタイトル？"
        :page/earlier "もっと前へ"
        :page/no-more-journals "これ以上日誌はありません"
        :page/copy-page-url "ページの URL をコピー"
        :journal/multiple-files-with-different-formats "異なるフォーマットの日誌ファイルが同じ月にあるようです。各月には一つの日誌ファイルだけを置くようにしてください。"
        :journal/go-to "ファイルへ"
        :file/name "ファイル名"
        :file/file "ファイル： "
        :file/last-modified-at "最終更新日時 "
        :file/no-data "データがありません"
        :file/format-not-supported ".{1} 形式はサポートされていません。"
        :page/created-at "作成日時 "
        :page/updated-at "更新日時 "
        :page/backlinks "バックリンク"
        :editor/block-search "ブロックを検索"
        :editor/image-uploading "アップロード中"
        :draw/invalid-file "この excalidraw ファイルは正しくないためロードできません。"
        :draw/specify-title "はじめにタイトルを指定してください。"
        :draw/rename-success "ファイル名を変更しました。"
        :draw/rename-failure "ファイル名の変更に失敗しました。理由： "
        :draw/title-placeholder "無題"
        :draw/save "保存"
        :draw/save-changes "変更内容を保存"
        :draw/new-file "新規ファイル"
        :draw/list-files "List files"
        :draw/delete "削除"
        :draw/more-options "More options"
        :draw/back-to-logseq "Logseqへ戻る"
        :text/image "画像"
        :asset/confirm-delete "この {1} を削除してもよろしいですか？"
        :asset/physical-delete "ファイルも削除します（元に戻せないことにご注意ください）"
        :content/copy "コピー"
        :content/cut "カット"
        :content/make-todos "Make {1}s"
        :content/copy-block-ref "ブロック参照をコピー"
        :content/copy-block-emebed "ブロック埋め込みをコピー"
        :content/focus-on-block "ブロック上でフォーカス"
        :content/open-in-sidebar "サイドバーで開く"
        :content/copy-as-json "JSON形式でコピー"
        :content/click-to-edit "クリックで編集"
        :settings-page/git-desc "is used for pages version control, you can click the vertical three dots menu to check the page's history."
        :settings-page/git-confirm "Git設定を更新するにはアプリを再起動する必要があります。"
        :settings-page/git-switcher-label "Gitの自動コミットを有効化"
        :settings-page/git-commit-delay "Gitの自動コミット間隔（秒）"
        :settings-page/edit-config-edn "config.ednを編集"
        :settings-page/edit-custom-css "custom.cssを編集"
        :settings-page/custom-configuration "カスタム設定"
        :settings-page/custom-theme "カスタムテーマ"
        :settings-page/show-brackets "ブラケットを表示"
        :settings-page/spell-checker "スペルチェッカー"
        :settings-page/auto-updater "自動更新"
        :settings-page/disable-sentry "使用状況データと診断内容をLogseqへ送信します。"
        :settings-page/preferred-outdenting "論理的なアウトデント"
        :settings-page/custom-date-format "日時の表示形式"
        :settings-page/preferred-file-format "ファイル形式"
        :settings-page/preferred-workflow "ワークフローの表示方法"
        :settings-page/enable-shortcut-tooltip "ショートカットのツールチップを表示"
        :settings-page/enable-timetracking "タイムトラッキング"
        :settings-page/enable-tooltip "ツールチップ"
        :settings-page/enable-journals "日誌"
        :settings-page/enable-all-pages-public "パブリッシュ時には全てのページを公開する"
        :settings-page/enable-encryption "暗号化"
        :settings-page/customize-shortcuts "キーボードショートカット"
        :settings-page/shortcut-settings "ショートカットをカスタマイズ"
        :settings-page/home-default-page "デフォルトのホームページを設定"
        :settings-page/enable-block-time "ブロックタイムスタンプ"
        :settings-page/clear-cache "キャッシュをクリア"
        :settings-page/clear "クリア"
        :settings-page/developer-mode "開発者モード"
        :settings-page/enable-developer-mode "開発者モード"
        :settings-page/disable-developer-mode "開発者モードを無効化"
        :settings-page/developer-mode-desc "開発者モードはコントリビューターと機能拡張の開発者がLogseqとの統合をより効率的にテストする助けになります。"
        :settings-page/current-version "現在のバージョン"
        :settings-page/current-graph "現在のグラフ"
        :settings-page/tab-general "一般"
        :settings-page/tab-editor "エディタ"
        :settings-page/tab-shortcuts "ショートカット"
        :settings-page/tab-version-control "バージョンコントロール"
        :settings-page/tab-advanced "高度な設定"
        :settings-page/plugin-system "プラグインシステム"
        :settings-page/network-proxy "ネットワークプロキシ"
        :logseq "Logseq"
        :on "ON"
        :more-options "他のオプション"
        :to "to"
        :yes "はい"
        :no "いいえ"
        :submit "投稿"
        :cancel "キャンセル"
        :close "閉じる"
        :delete "削除"
        :save "保存"
        :type "種別"
        :host "ホスト"
        :port "ポート"
        :re-index "インデックス再構築"
        :re-index-detail "グラフ再構築"
        :re-index-multiple-windows-warning "このグラフのインデックスを再構築する前に、Logseq で開いている他のウィンドウを閉じる必要があります。"
        :re-index-discard-unsaved-changes-warning "インデックスの再構築は現在のグラフをいったん破棄し、現在ディスク上にある全てのファイルから再構築します。未保存の内容は失われます。また、少し時間がかかります。実行してもよいですか？"
        :open-new-window "新規ウィンドウ"
        :sync-from-local-files "再表示"
        :sync-from-local-files-detail "ローカルファイルの変更点をインポート"
        :sync-from-local-changes-detected " 再表示は、ディスク上で変更されて Logseq 上のページと内容が変わってしまったファイルを検出し、読み込みます。実行してもよいですか？"
        :unlink "リンク解除"
        :search/publishing "検索"
        :search "検索／新規ページ名"
        :page-search "現在のページを検索"
        :graph-search "グラフを検索"
        :new-page "新規ページ"
        :new-file "新規ファイル"
        :new-graph "新規グラフを追加"
        :graph "グラフ"
        :graph-view "グラフを見る"
        :graph/persist "Logseq の内部状態を同期中です。少々お待ちください。"
        :graph/persist-error "内部状態の同期に失敗しました。"
        :graph/save "保存中..."
        :graph/save-success "保存に成功しました"
        :graph/save-error "保存に失敗しました"
        :cards-view "カードを見る"
        :publishing "パブリッシング"
        :export "エクスポート"
        :export-graph "グラフをエクスポート"
        :export-page "ページをエクスポート"
        :export-markdown "標準Markdownでエクスポート(blockプロパティなし)"
        :export-opml "OPML形式でエクスポート"
        :export-public-pages "公開ページのエクスポート"
        :export-json "JSON形式でエクスポート"
        :export-roam-json "Roam JSON形式でエクスポート"
        :export-edn "EDN形式でエクスポート"
        :export-datascript-edn "datascript EDN形式でエクスポート"
        :convert-markdown "Markdown の headings を順序なしリストへ変換 (# -> -)"
        :all-graphs "全グラフ"
        :all-pages "全ページ"
        :all-files "全ファイル"
        :remove-orphaned-pages "孤立ページを削除"
        :all-journals "全日誌"
        :my-publishing "パブリッシング"
        :settings "設定"
        :settings-of-plugins "プラグイン設定"
        :plugins "プラグイン"
        :themes "テーマ"
        :developer-mode-alert "プラグインシステムを有効化するにはアプリを再起動が必要です。いますぐ再起動しますか？"
        :relaunch-confirm-to-work "動作させるには再起動が必要です。いますぐ再起動しますか？"
        :import "インポート"
        :join-community "コミュニティへ参加"
        :sponsor-us "スポンサー求む"
        :discord-title "Discord グループ"
        :help-shortcut-title "クリックしてショートカットと他のTipsを確認"
        :loading "ロード中"
        :cloning "クローン中"
        :parsing-files "ファイル解析中"
        :loading-files "ファイルロード中"
        :login "ログイン"
        :logout "ログアウト"
        :go-to "Go to "
        :or "or"
        :download "ダウンロード"
        :repo/download-zip "全ファイルをZipでダウンロード"
        :language "言語"
        :white "ライト"
        :dark "ダーク"
        :remove-background "背景を消去"
        :open "開く"
        :open-a-directory "ローカルディレクトリを開く"
        :user/delete-account "アカウント削除"
        :user/delete-your-account "あなたのアカウントを削除"
        :user/delete-account-notice "logseq.com へ公開されたあなたの全てのページが削除されます。"

        :help/shortcut-page-title "キーボードショートカット"

        :plugin/installed "インストール済"
        :plugin/not-installed "未インストール"
        :plugin/installing "インストール中"
        :plugin/install "インストール"
        :plugin/reload "リロード"
        :plugin/update "更新"
        :plugin/check-update "更新を確認"
        :plugin/check-all-updates "全ての更新を確認"
        :plugin/refresh-lists "リスト更新"
        :plugin/enabled "有効化"
        :plugin/disabled "無効化"
        :plugin/update-available "利用可能な更新を適用"
        :plugin/updating "更新中"
        :plugin/uninstall "アンインストール"
        :plugin/marketplace "マーケットプレース"
        :plugin/downloads "ダウンロード"
        :plugin/stars "スター"
        :plugin/title "タイトル"
        :plugin/all "全て"
        :plugin/unpacked "展開済"
        :plugin/delete-alert "プラグイン [{1}]　をアンインストールしてもよいですか？"
        :plugin/open-settings "設定を開く"
        :plugin/open-package "パッケージを開く"
        :plugin/load-unpacked "展開されたプラグインをロード"
        :plugin/open-preferences "プラグイン設定ファイルを開く"
        :plugin/restart "アプリを再起動"
        :plugin/unpacked-tips "プラグインディレクトリを選択"
        :plugin/contribute "✨ 新規プラグインの作成とサブミット"
        :plugin/marketplace-tips "プラグインがインストール直後に正しく動作しない場合、Logseq を再起動してください。"
        :plugin/up-to-date "最新の状態です"
        :plugin/custom-js-alert "custom.js ファイルを見つけました。実行を許可しますか？ （もしあなたがこのファイルの内容を理解していない場合、セキュリティのリスクがあるため許可しないことをお勧めします。）"

        :pdf/copy-ref "参照をコピー"
        :pdf/copy-text "テキストをコピー"
        :pdf/linked-ref "リンクありの参照元"
        :pdf/toggle-dashed "破線で Area highlight"

        :updater/new-version-install "新しいバージョンがダウンロードされました。"
        :updater/quit-and-install "インストールのためアプリを再起動してください。"

        :paginates/pages "全 {1} ページ"
        :paginates/prev "前"
        :paginates/next "次"

        :tips/all-done "All Done"

        :command-palette/prompt "コマンドを入力"
        :select/default-prompt "選択してください"
        :select.graph/prompt "グラフを選んでください"
        :select.graph/empty-placeholder-description "マッチするグラフがありません。新しいグラフを追加しますか？"
        :select.graph/add-graph "はい、新規グラフを追加します。"

        :file-sync/other-user-graph "現在のローカルグラフは他のユーザーのリモートグラフにバインドされています。同期を開始できません。"
        :file-sync/graph-deleted "現在のリモートグラフが削除されました"}

   :it {:tutorial/text #?(:cljs (rc/inline "tutorial-en.md")
                          :default "tutorial-en.md")
        :tutorial/dummy-notes #?(:cljs (rc/inline "dummy-notes-en.md")
                                 :default "dummy-notes-en.md")
        :on-boarding/demo-graph "Questo è un grafo dimostrativo, le modifiche non saranno salvate finché non aprirai una cartella locale."
        :on-boarding/add-graph "Aggiungi un grafo"
        :on-boarding/open-local-dir "Apri una cartella locale"
        :on-boarding/new-graph-desc-1 "Logseq supporta sia Markdown che Org-mode. Puoi aprire una cartella esistente o crearne una nuova sul tuo dispositivo. I tuoi dati saranno salvati solo sul tuo dispositivo."
        :on-boarding/new-graph-desc-2 "Dopo che hai aperto la tua cartella, saranno create al suo interno tre cartelle:"
        :on-boarding/new-graph-desc-3 "/journals - contiene le pagine del diario giornaliero"
        :on-boarding/new-graph-desc-4 "/pages - contiene le altre pagine"
        :on-boarding/new-graph-desc-5 "/logseq - contiene i dati di configurazione, custom.css, e alcuni metadati."
        :help/start "Per iniziare"
        :help/about "Informazioni su Logseq"
        :help/roadmap "Roadmap"
        :help/bug "Segnala un problema"
        :help/feature "Richiedi una funzionalità"
        :help/changelog "Registro delle modifiche"
        :help/blog "blog di Logseq"
        :help/docs "Documentazione"
        :help/privacy "Politica sulla riservatezza"
        :help/terms "Termini di Servizio"
        :help/community "Comunità su Discord"
        :help/awesome-logseq "Awesome Logseq"
        :help/shortcuts "Scorciatoie da tastiera"
        :help/shortcuts-triggers "Attivazione delle scorciatoie"
        :help/shortcut "Scorciatoia"
        :help/slash-autocomplete "Barra di completamento automatico"
        :help/block-content-autocomplete "Autocompletamento del contenuto di blocco"
        :help/reference-autocomplete "Autocompletamente del riferimento di pagina"
        :help/block-reference "Riferimento di blocco"
        :help/key-commands "Comandi dei tasti"
        :help/working-with-lists " (lavorare con le liste)"
        :help/select-nfs-browser "Per favore utilizza un altro browser (come la versione chrome più recente) che supporta funzioni NFS per aprire la cartella locale."
        :undo "Annulla"
        :redo "Ripeti"
        :general "Generale"
        :more "Altro"
        :search/result-for "Cerca i risultati per "
        :search/items "oggetti"
        :search/page-names "Cerca pagine per nome"
        :help/context-menu "Menu contestuale del blocco"
        :help/fold-unfold "Comprimi/Espandi blocchi (quando non sei in modalità di modifica)"
        :help/markdown-syntax "Sintassi Markdown"
        :help/org-mode-syntax "Sintassi Org mode"
        :bold "Grassetto"
        :italics "Corsivo"
        :html-link "Link Html"
        :highlight "Evidenzia"
        :strikethrough "Barrato"
        :code "Codice"
        :right-side-bar/help "Aiuto"
        :right-side-bar/switch-theme "Modalità tema"
        :right-side-bar/theme "{1} tema"
        :right-side-bar/page "Grafico della pagina"
        :right-side-bar/recent "Recenti"
        :right-side-bar/contents "Contenuti"
        :right-side-bar/favorites "Preferiti"
        :right-side-bar/page-graph "Grafico della pagina"
        :right-side-bar/block-ref "Riferimento di Blocco"
        :right-side-bar/graph-view "Vista del grafico"
        :right-side-bar/all-pages "Tutte le pagine"
        :right-side-bar/flashcards "Flashcard"
        :right-side-bar/new-page "Nuova pagina"
        :right-side-bar/show-journals "Mostra diari"
        :left-side-bar/journals "Diario"
        :left-side-bar/new-page "Nuova pagina"
        :left-side-bar/nav-favorites "Preferiti"
        :left-side-bar/nav-shortcuts "Scorciatoie"
        :left-side-bar/nav-recent-pages "Recenti"
        :format/preferred-mode "Qual è la tua modalità preferita?"
        :format/markdown "Markdown"
        :format/org-mode "Org mode"
        :reference/linked "Riferimenti collegati"
        :reference/unlinked-ref "Riferimenti non collegati"
        :page/presentation-mode "Presentazione"
        :page/edit-properties-placeholder "Proprietà"
        :page/delete-success "La pagina {1} è stata eliminata con successo!"
        :page/delete-confirmation "Sei sicuro di voler eliminare questa pagina e i suoi dati?"
        :page/rename-to "Rinomina \"{1}\" in:"
        :page/priority "Priorità \"{1}\""
        :page/copy-to-json "Copia l'intera pagina in JSON"
        :page/rename "Rinomina pagina"
        :page/open-in-finder "Apri nella cartella"
        :page/open-with-default-app "Apri con l'app predefinita"
        :page/action-publish "Pubblica"
        :page/make-public "Segna come pubblico per la pubblicazione"
        :page/version-history "Controlla la cronologia della pagina"
        :page/open-backup-directory "Apri la cartella dei backup delle pagine"
        :page/file-sync-versions "Versioni delle pagine"
        :page/make-private "Segna come privato"
        :page/delete "Elimina pagina"
        :page/add-to-favorites "Aggiungi ai Preferiti"
        :page/unfavorite "Rimuovi la pagina dai Preferiti"
        :page/show-journals "Mostra diario"
        :page/show-name "Mostra il nome della pagina"
        :page/hide-name "Nascondi il nome della pagina"
        :block/name "Nome pagina"
        :page/last-modified "Ultima modifica alle"
        :page/new-title "Qual è il titolo della tua nuova pagina?"
        :page/earlier "Prima"
        :page/no-more-journals "Non ci sono altri diari"
        :page/copy-page-url "Copia URL pagina"
        :journal/multiple-files-with-different-formats "Sembra che tu abbia più file diario (con formati diversi) per lo stesso mese, per favore conserva un solo file diario per ogni mese."
        :journal/go-to "Vai ai file"
        :file/name "Nome File"
        :file/file "File: "
        :file/last-modified-at "Ultima modifica alle"
        :file/no-data "Nessun dato"
        :file/format-not-supported "Il formato .{1} non è supportato."
        :page/created-at "Creato alle"
        :page/updated-at "Aggiornato alle"
        :page/backlinks "Collegamenti a ritroso"
        :editor/block-search "Cerca un blocco"
        :editor/image-uploading "Caricamento"
        :draw/invalid-file "Non ho potuto caricare questo file excalidraw"
        :draw/specify-title "Per favore specifica un titolo prima!"
        :draw/rename-success "Il file è stato rinominato con successo!"
        :draw/rename-failure "La rinominazione del file è fallita, ragione: "
        :draw/title-placeholder "Senza titolo"
        :draw/save "Salva"
        :draw/save-changes "Salva modifiche"
        :draw/new-file "Nuovo file"
        :draw/list-files "Elenca i file"
        :draw/delete "Elimina"
        :draw/more-options "Altre opzioni"
        :draw/back-to-logseq "Torna a logseq"
        :text/image "Immagine"
        :asset/confirm-delete "Sei sicuro di voler eliminare questo {1}?"
        :asset/physical-delete "Rimuovi anche i file (non possono essere ripristinati)"
        :content/copy "Copia"
        :content/cut "Taglia"
        :content/make-todos "Crea {1}"
        :content/copy-block-ref "Copia riferimento di blocco"
        :content/copy-block-emebed "Copia blocco incorporato"
        :content/focus-on-block "Focus sul blocco"
        :content/open-in-sidebar "Apri nella barra laterale"
        :content/copy-as-json "Copia come JSON"
        :content/click-to-edit "Clicca per modificare"
        :settings-page/git-desc "viene utilizzato per il controllo della versione delle pagine, puoi fare clic sul menu a tre punti verticali per controllare la cronologia della pagina."
        :settings-page/git-confirm "Devi riavviare l'app dopo aver aggiornato le impostazioni di Git."
        :settings-page/git-switcher-label "Abilita Git auto commit"
        :settings-page/git-commit-delay "Secondi per Git auto commit"
        :settings-page/edit-config-edn "Modifica config.edn"
        :settings-page/edit-custom-css "Modifica custom.css"
        :settings-page/custom-configuration "Configurazione personalizzata"
        :settings-page/custom-theme "Tema personalizzato"
        :settings-page/show-brackets "Mostra parentesi"
        :settings-page/spell-checker "Correttore ortografico"
        :settings-page/auto-updater "Aggiornamento automatico"
        :settings-page/disable-sentry "Invia dati di utilizzo e diagnostica a Logseq"
        :settings-page/preferred-outdenting "Indentamento logico"
        :settings-page/custom-date-format "Formato data preferito"
        :settings-page/preferred-file-format "Formato file preferito"
        :settings-page/preferred-workflow "Flusso di lavoro preferito"
        :settings-page/enable-shortcut-tooltip "Abilita suggerimenti scorciatoie"
        :settings-page/enable-timetracking "Tracciamento del tempo"
        :settings-page/enable-tooltip "Suggerimenti"
        :settings-page/enable-journals "Diario"
        :settings-page/enable-all-pages-public "Tutte le pagine pubbliche durante la pubblicazione"
        :settings-page/customize-shortcuts "Scorciatoie da tastiera"
        :settings-page/shortcut-settings "Personalizza scorciatoie"
        :settings-page/home-default-page "Imposta la home page predefinita"
        :settings-page/enable-block-time "Indicatori temporali sui blocchi"
        :settings-page/clear-cache "Pulisci cache"
        :settings-page/clear "Pulisci"
        :settings-page/developer-mode "Modalità sviluppatore"
        :settings-page/enable-developer-mode "Modalità sviluppatore"
        :settings-page/disable-developer-mode "Disabilita modalità sviluppatore"
        :settings-page/developer-mode-desc "La modalità sviluppatore aiuta i contributori e gli sviluppatori di estensioni a testare le loro integrazioni con Logseq in modo più efficiente."
        :settings-page/current-version "Versione attuale"
        :settings-page/current-graph "Grafo attuale"
        :settings-page/tab-general "Generale"
        :settings-page/tab-editor "Editor"
        :settings-page/tab-shortcuts "Scorciatoie"
        :settings-page/tab-version-control "Controllo di versione"
        :settings-page/tab-advanced "Avanzate"
        :settings-page/plugin-system "Sistema di plugin"
        :settings-page/network-proxy "Proxy di rete"
        :logseq "Logseq"
        :on "ON"
        :more-options "Più opzioni"
        :to "a"
        :yes "Sì"
        :no "No"
        :submit "Invia"
        :cancel "Annulla"
        :close "Chiudi"
        :delete "Elimina"
        :save "Salva"
        :type "Tipo"
        :host "Host"
        :port "Porta"
        :re-index "Re-indicizza"
        :re-index-detail "Ricostruisci il grafo"
        :re-index-multiple-windows-warning "È necessario chiudere le altre finestre prima di reindicizzare questo grafo."
        :re-index-discard-unsaved-changes-warning "La reindicizzazione elimina il grafo corrente, quindi elabora nuovamente tutti i file poiché sono attualmente archiviati su disco. Perderai le modifiche non salvate e potrebbe volerci del tempo. Continuare?"
        :open-new-window "Nuova finestra"
        :sync-from-local-files "Ricarica"
        :sync-from-local-files-detail "Importa cambiamenti da un file locale"
        :sync-from-local-changes-detected "Il ricaricamento rileva ed elabora i file modificati sul disco e divergenti dal contenuto effettivo della pagina Logseq. Continuare?"

        :unlink "disconnetti"
        :search/publishing "Cerca"
        :search "Cerca o crea una pagina"
        :page-search "Cerca nella pagina corrente"
        :graph-search "Cerca nel grafo"
        :new-page "Nuova pagina"
        :new-file "Nuovo file"
        :new-graph "Aggiungi nuovo grafo"
        :graph "Grafo"
        :graph-view "Visualizza grafo"
        :graph/persist "Logseq sta sincronizzando lo stato interno, per favore attendi alcuni secondi."
        :graph/persist-error "Sincronizzazione dello stato interno fallita."
        :graph/save "Salvataggio..."
        :graph/save-success "Salvato con successo"
        :graph/save-error "Salvataggio fallito"
        :cards-view "Visualizza flashcard"
        :publishing "Pubblicazione"
        :export "Esporta"
        :export-graph "Esporta grafo"
        :export-page "Esporta pagina"
        :export-markdown "Esporta come Markdown standard (senza le proprietà dei blocchi)"
        :export-opml "Esporta come OPML"
        :export-public-pages "Esporta le pagine pubbliche"
        :export-json "Esporta come JSON"
        :export-roam-json "Esporta come Roam JSON"
        :export-edn "Esporta come EDN"
        :export-datascript-edn "Esporta datascript EDN"
        :convert-markdown "Converti le intestazioni di Markdown in elenchi non ordinati (# -> -)"
        :all-graphs "Tutti i grafi"
        :all-pages "Tutte le pagine"
        :all-files "Tutti i file"
        :remove-orphaned-pages "Rimuovi pagine orfane"
        :all-journals "Tutte le pagine di diario"
        :my-publishing "Le mie pubblicazioni"
        :settings "Impostazioni"
        :settings-of-plugins "Impostazioni plugin"
        :plugins "Plugin"
        :themes "Temi"
        :developer-mode-alert "È necessario riavviare l'app per abilitare il plugin. Vuoi riavviarla ora?"
        :relaunch-confirm-to-work "È necessario riavviare l'app per farla funzionare. Vuoi riavviarla ora?"
        :import "Importa"
        :join-community "Unisciti alla comunità"
        :sponsor-us "Supportaci"
        :discord-title "Il nostro gruppo Discord!"
        :help-shortcut-title "Clicca per conoscere le scorciatoie e altri suggerimenti"
        :loading "Caricamento"
        :cloning "Clonazione"
        :parsing-files "Analisi dei file"
        :loading-files "Caricamento dei file"
        :login "Accedi"
        :logout "Esci"
        :go-to "Vai a "
        :or "o"
        :download "Scarica"
        :repo/download-zip "Scarica tutti i file come zip"
        :language "Lingua"
        :white "Chiaro"
        :dark "Scuro"
        :remove-background "Rimuovi lo sfondo"
        :open "Apri"
        :open-a-directory "Apri una cartella locale"
        :user/delete-account "Elimina profilo"
        :user/delete-your-account "Elimina il tuo profilo"
        :user/delete-account-notice "Tutte le tue pagine pubblicate su logseq.com saranno eliminate."

        :help/shortcut-page-title "Scorciatoie da tastiera"

        :plugin/installed "Installato"
        :plugin/not-installed "Non installato"
        :plugin/installing "Installazione"
        :plugin/install "Installa"
        :plugin/reload "Ricarica"
        :plugin/update "Aggiorna"
        :plugin/check-update "Controlla aggiornamenti"
        :plugin/check-all-updates "Controlla tutti gli aggiornamenti"
        :plugin/refresh-lists "Ricarica lista"
        :plugin/enabled "Abilitato"
        :plugin/disabled "Disabilitato"
        :plugin/update-available "Aggiornamento disponibile"
        :plugin/updating "Aggiornamento"
        :plugin/uninstall "Disinstalla"
        :plugin/marketplace "Libreria"
        :plugin/downloads "Numero di scaricamenti"
        :plugin/stars "Stelle"
        :plugin/title "Titolo"
        :plugin/all "Tutti"
        :plugin/unpacked "Non pacchettizzati"
        :plugin/delete-alert "Sei sicuro di voler disinstallare [{1}]?"
        :plugin/open-settings "Apri impostazioni"
        :plugin/open-package "Apri pacchetto"
        :plugin/load-unpacked "Carica plugin non pacchettizzato"
        :plugin/open-preferences "Apri il file delle preferenze del plugin"
        :plugin/restart "Riavvia app"
        :plugin/unpacked-tips "Seleziona la cartella del plugin"
        :plugin/contribute "✨ Svilupppa e sottoponici un nuovo plugin"
        :plugin/marketplace-tips "Se il plugin non funziona correttamente alla prima installazione, provare a riavviare Logseq."
        :plugin/up-to-date "È aggiornato"
        :plugin/custom-js-alert "Trovato il file custom.js, è consentito eseguirlo? (Se non si comprende il contenuto di questo file, si consiglia di non consentire l'esecuzione, che presenta alcuni rischi per la sicurezza.)"

        :pdf/copy-ref "Copia riferimenti"
        :pdf/copy-text "Copia testo"
        :pdf/linked-ref "Riferimenti collegati"
        :pdf/toggle-dashed "Stile tratteggiato per evidenziare l'area"

        :updater/new-version-install "Una nuova versione è stata scaricata."
        :updater/quit-and-install "Riavvia per installarla"

        :paginates/pages "Totale {1} pagine"
        :paginates/prev "Precedente"
        :paginates/next "Successivo"

        :tips/all-done "Completato"

        :command-palette/prompt "Digita un comando"
        :select/default-prompt "Selezionane uno"
        :select.graph/prompt "Seleziona un grafo"
        :select.graph/empty-placeholder-description "Non ci sono grafi corrispondenti. Vuoi aggiungerne uno nuovo?"
        :select.graph/add-graph "Sì, aggiungi un nuovo grafo"

        :file-sync/other-user-graph "Il grafo locale attuale è associato al grafo remoto di un altro utente. Non è quindi possibile avviare la sincronizzazione."
        :file-sync/graph-deleted "Il grafo attuale è stato eliminato"
        :settings-page/enable-encryption "Crittografia"
        :settings-page/edit-export-css "Modificare export.css"
        :settings-page/enable-flashcards "Flashcard"
        :settings-page/export-theme "Esporta tema"}

   :tr {:tutorial/text #?(:cljs (rc/inline "tutorial-tr.md")
                                :default "tutorial-tr.md")
        :tutorial/dummy-notes #?(:cljs (rc/inline "dummy-notes-tr.md")
                                       :default "dummy-notes-tr.md")
        :on-boarding/demo-graph "Bu bir demo grafiktir, yerel bir klasör açana kadar değişiklikler kaydedilmeyecektir."
        :on-boarding/add-graph "Bir grafik ekle"
        :on-boarding/open-local-dir "Yerel bir dizin açın"
        :on-boarding/new-graph-desc-1 "Logseq, hem Markdown hem de Org modunu destekler. Cihazınızda var olan bir dizini (klasörü) açabilir veya yeni bir tane oluşturabilirsiniz. Verileriniz yalnızca bu cihazda saklanacaktır."
        :on-boarding/new-graph-desc-2 "Dizininizi açtıktan sonra, o dizinde üç klasör oluşturacaktır:"
        :on-boarding/new-graph-desc-3 "/journals - günlük sayfalarınız saklanır"
        :on-boarding/new-graph-desc-4 "/pages - diğer sayfalarınız saklanır"
        :on-boarding/new-graph-desc-5 "/logseq - yapılandırma, custom.css ve bazı meta veriler saklanır."
        :help/start "Başlarken"
        :help/about "Logseq hakkında"
        :help/roadmap "Yol haritası"
        :help/bug "Hata raporu"
        :help/feature "Özellik talebi"
        :help/changelog "Değişiklik günlüğü"
        :help/blog "Logseq blogu"
        :help/docs "Belgeler"
        :help/privacy "Gizlilik ilkesi"
        :help/terms "Koşullar"
        :help/community "Discord topluluğu"
        :help/forum-community "Forum topluluğu"
        :help/awesome-logseq "Awesome Logseq"
        :help/shortcuts "Klavye kısayolları"
        :help/shortcuts-triggers "Tetikleyiciler"
        :help/shortcut "Kısayol"
        :help/slash-autocomplete "Eğik çizgi otomatik tamamlama"
        :help/block-content-autocomplete "Blok içeriği otomatik tamamlama"
        :help/reference-autocomplete "Sayfa referansı otomatik tamamlama"
        :help/block-reference "Blok referansı"
        :help/key-commands "Tuş komutları"
        :help/working-with-lists " (listelerle çalışır)"
        :help/select-nfs-browser "Lütfen yerel dizini açmak için NFS özelliklerini destekleyen başka bir tarayıcı (en son chrome gibi) kullanın."
        :undo "Geri al"
        :redo "Yinele"
        :general "Genel"
        :more "Daha fazla"
        :search/result-for "Arama sonucu: "
        :search/items "öğe"
        :search/page-names "Sayfa adlarında ara"
        :help/context-menu "Blok kısayol menüsü"
        :help/fold-unfold "Blokları katla/aç  (düzenleme modunda değilken)"
        :help/markdown-syntax "Markdown sözdizimi"
        :help/org-mode-syntax "Org modu sözdizimi"
        :bold "Kalın"
        :italics "İtalik"
        :html-link "Html Bağlantısı"
        :highlight "Vurgulu"
        :strikethrough "Üstü çizili"
        :code "Kod"
        :right-side-bar/help "Yardım"
        :right-side-bar/switch-theme "Tema modları"
        :right-side-bar/theme "{1} tema"
        :right-side-bar/page "Sayfa grafiği"
        :right-side-bar/recent "En son"
        :right-side-bar/contents "İçindekiler"
        :right-side-bar/favorites "Sık kullanılanlar"
        :right-side-bar/page-graph "Sayfa grafiği"
        :right-side-bar/block-ref "Blok referansı"
        :right-side-bar/graph-view "Grafik görünümü"
        :right-side-bar/all-pages "Bütün sayfalar"
        :right-side-bar/flashcards "Bilgi kartları"
        :right-side-bar/new-page "Yeni sayfa"
        :left-side-bar/journals "Günlük"
        :left-side-bar/new-page "Yeni sayfa"
        :left-side-bar/nav-favorites "Sık kullanılanlar"
        :left-side-bar/nav-shortcuts "Kısa yollar"
        :left-side-bar/nav-recent-pages "En son"
        :format/preferred-mode "Tercih ettiğiniz mod nedir?"
        :format/markdown "Markdown"
        :format/org-mode "Org modu"
        :reference/linked "Bağlantılı referans"
        :reference/unlinked-ref "Bağlantısız referanslar"
        :page/presentation-mode "Sunu"
        :page/edit-properties-placeholder "Özellikler"
        :page/delete-success "{1} sayfası başarıyla silindi!"
        :page/delete-confirmation "Bu sayfayı ve dosyasını silmek istediğinizden emin misiniz?"
        :page/rename-to "\"{1}\" öğesini yeniden adlandır:"
        :page/priority "Öncelik \"{1}\""
        :page/copy-to-json "Tüm sayfayı JSON olarak kopyala"
        :page/rename "Sayfayı yeniden adlandır"
        :page/open-in-finder "Dizini aç"
        :page/open-with-default-app "Varsayılan uygulamayla aç"
        :page/action-publish "Yayımla"
        :page/make-public "Yayımlamak için herkese açık hale getir"
        :page/version-history "Sayfa geçmişini kontrol et"
        :page/open-backup-directory "Sayfa yedekleme dizinini aç"
        :page/file-sync-versions "Sayfa sürümleri"
        :page/make-private "Özel yap"
        :page/delete "Sayfayı sil"
        :page/add-to-favorites "Sık kullanılanlara ekle"
        :page/unfavorite "Sayfayı sık kullanılanlardan kaldır"
        :page/show-journals "Günlükleri göster"
        :page/show-name "Sayfa adını göster"
        :page/hide-name "Sayfa adını gizle"
        :block/name "Sayfa adı"
        :page/last-modified "Son değiştirilme tarihi"
        :page/new-title "Yeni sayfa başlığınız nedir?"
        :page/earlier "Daha önce"
        :page/no-more-journals "Başka günlük yok"
        :page/copy-page-url "Sayfa URL adresini kopyala"
        :journal/multiple-files-with-different-formats "Aynı ay için birden fazla günlük dosyanız (farklı formatlarda) var gibi görünüyor, lütfen her ay için yalnızca bir günlük dosyası tutun."
        :journal/go-to "Dosyalara git"
        :file/name "Dosya adı"
        :file/file "Dosya: "
        :file/last-modified-at "Son değiştirilme tarihi"
        :file/no-data "Veri yok"
        :file/format-not-supported ".{1} biçimi desteklenmiyor."
        :page/created-at "Oluşturulma Zamanı"
        :page/updated-at "Güncellenme Zamanı"
        :page/backlinks "Geri Bağlantılar"
        :editor/block-search "Blok ara"
        :editor/image-uploading "Karşıya yükleniyor"
        :draw/invalid-file "Bu geçersiz excalidraw dosyası yüklenemedi"
        :draw/specify-title "Lütfen önce bir başlık belirtin!"
        :draw/rename-success "Dosya başarıyla yeniden adlandırıldı!"
        :draw/rename-failure "Dosya yeniden adlandırılamadı, nedeni: "
        :draw/title-placeholder "Adsız"
        :draw/save "Kaydet"
        :draw/save-changes "Değişiklikleri kaydet"
        :draw/new-file "Yeni dosya"
        :draw/list-files "Dosyaları listele"
        :draw/delete "Sil"
        :draw/more-options "Diğer seçenekler"
        :draw/back-to-logseq "Logseq'e geri dön"
        :text/image "Resim"
        :asset/confirm-delete "Bu resmi silmek istediğinizden emin misiniz?"
        :asset/physical-delete "Dosyayı da kaldırın (geri getirilemeyeceğine dikkat edin)"
        :content/copy "Kopyala"
        :content/cut "Kes"
        :content/make-todos "{1} yap"
        :content/copy-block-ref "Blok referansını kopyala"
        :content/copy-block-emebed "Blok eklemesini kopyala"
        :content/focus-on-block "Bloğa odaklan"
        :content/open-in-sidebar "Kenar çubuğunda aç"
        :content/copy-as-json "JSON olarak kopyala"
        :content/click-to-edit "Düzenlemek için tıklayın"
        :settings-page/git-desc "sayfaların sürüm kontrolü için kullanılır, sayfanın geçmişini kontrol etmek için dikey üç nokta menüsüne tıklayabilirsiniz."
        :settings-page/git-confirm "Git ayarlarını güncelledikten sonra uygulamayı yeniden başlatmanız gerekiyor."
        :settings-page/git-switcher-label "Git otomatik commit'i etkinleştir"
        :settings-page/git-commit-delay "Git otomatik commit saniyesi"
        :settings-page/edit-config-edn "config.edn dosyasını düzenle"
        :settings-page/edit-custom-css "custom.css dosyasını düzenle"
        :settings-page/edit-export-css "export.css dosyasını düzenle"
        :settings-page/custom-configuration "Özel yapılandırma"
        :settings-page/custom-theme "Özel tema"
        :settings-page/export-theme "Temayı dışarı aktar"
        :settings-page/show-brackets "Köşeli ayraçları göster"
        :settings-page/spell-checker "Yazım denetleyici"
        :settings-page/auto-updater "Otomatik güncelleme"
        :settings-page/disable-sentry "Kullanım verilerini ve tanılamayı Logseq'e gönderin"
        :settings-page/preferred-outdenting "Mantıksal girinti"
        :settings-page/custom-date-format "Tercih edilen tarih biçimi"
        :settings-page/preferred-file-format "Tercih edilen dosya biçimi"
        :settings-page/preferred-workflow "Tercih edilen iş akışı"
        :settings-page/enable-shortcut-tooltip "Kısayol araç ipuçlarını etkinleştir"
        :settings-page/enable-timetracking "Zaman takibi"
        :settings-page/enable-tooltip "Araç ipuçları"
        :settings-page/enable-journals "Günlük"
        :settings-page/enable-all-pages-public "Yayımlanan tüm sayfaları herkese açık yap"
        :settings-page/enable-encryption "Şifreleme"
        :settings-page/customize-shortcuts "Klavye kısayolları"
        :settings-page/shortcut-settings "Kısayolları özelleştir"
        :settings-page/home-default-page "Varsayılan ana sayfayı ayarla"
        :settings-page/enable-block-time "Blok zaman damgaları"
        :settings-page/clear-cache "Önbelleği temizle"
        :settings-page/clear "Temizle"
        :settings-page/developer-mode "Geliştirici modu"
        :settings-page/enable-developer-mode "Geliştirici modu"
        :settings-page/disable-developer-mode "Geliştirici modunu devre dışı bırak"
        :settings-page/developer-mode-desc "Geliştirici modu, katkıda bulunanların ve eklenti geliştiricilerinin Logseq ile entegrasyonlarını daha verimli bir şekilde test etmesine yardımcı olur."
        :settings-page/current-version "Geçerli sürüm"
        :settings-page/current-graph "Geçerli grafik"
        :settings-page/tab-general "Genel"
        :settings-page/tab-editor "Düzenleyici"
        :settings-page/tab-shortcuts "Kısayollar"
        :settings-page/tab-version-control "Sürüm denetimi"
        :settings-page/tab-advanced "Gelişmiş"
        :settings-page/plugin-system "Eklenti sistemi"
        :settings-page/enable-flashcards "Bilgi kartları"
        :settings-page/network-proxy "Ağ ara sunucusu"
        :logseq "Logseq"
        :on "AÇIK"
        :more-options "Diğer seçenekler"
        :to "hedef:"
        :yes "Evet"
        :no "Hayır"
        :submit "Onayla"
        :cancel "İptal"
        :close "Kapat"
        :delete "Sil"
        :save "Kaydet"
        :type "Tür"
        :host "Ana Bilgisayar"
        :port "Bağlantı Noktası"
        :re-index "Yeniden dizin oluştur"
        :re-index-detail "Grafiği yeniden oluştur"
        :re-index-multiple-windows-warning "Bu grafik için yeniden dizin oluşturmadan önce diğer pencereleri kapatmanız gerekiyor."
        :re-index-discard-unsaved-changes-warning "Yeniden dizin oluşturmak mevcut grafiği siler ve ardından tüm dosyaları o anda diskte depolandıkları şekilde yeniden işler. Kaydedilmemiş değişiklikleri kaybedeceksiniz ve bu biraz zaman alabilir. Devam edilsin mi?"
        :open-new-window "Yeni pencere"
        :sync-from-local-files "Yenile"
        :sync-from-local-files-detail "Yerel dosyalardan değişiklikleri içeri aktarın"
        :sync-from-local-changes-detected "Yenile, diskinizde değiştirilen ve gerçek Logseq sayfa içeriğinden ayrılan dosyaları algılar ve işler. Devam edilsin mi?"

        :unlink "bağlantıyı kaldır"
        :search/publishing "Ara"
        :search "Ara veya sayfa oluştur"
        :page-search "Geçerli sayfada ara"
        :graph-search "Grafikte ara"
        :new-page "Yeni sayfa"
        :new-file "Yeni dosya"
        :new-graph "Yeni grafik ekle"
        :graph "Grafik"
        :graph-view "Grafiği görüntüle"
        :graph/persist "Logseq dahili durumu senkronize ediyor, lütfen birkaç saniye bekleyin."
        :graph/persist-error "Dahili durum senkronize edilemedi."
        :graph/save "Kaydediliyor..."
        :graph/save-success "Başarıyla Kaydedildi"
        :graph/save-error "Kaydedilemedi"
        :cards-view "Kartları görüntüle"
        :publishing "Yayımlama"
        :export "Dışarı aktar"
        :export-graph "Grafiği dışarı aktar"
        :export-page "Sayfayı dışarı aktar"
        :export-markdown "Standart Markdown olarak dışarı aktar (blok özelliği yok)"
        :export-opml "OPML olarak dışarı aktar"
        :export-public-pages "Herkese açık sayfaları dışarı aktar"
        :export-json "JSON olarak dışarı aktar"
        :export-roam-json "Roam JSON olarak dışarı aktar"
        :export-edn "EDN olarak dışarı aktar"
        :export-datascript-edn "EDN datascript öğesini dışarı aktar"
        :convert-markdown "Markdown başlıklarını sırasız listelere dönüştürün (# -> -)"
        :all-graphs "Tüm grafikler"
        :all-pages "Tüm sayfalar"
        :all-files "Tüm dosyalar"
        :remove-orphaned-pages "Yalnız bırakılmış sayfaları kaldır"
        :all-journals "Bütün günlükler"
        :my-publishing "Yayımlarım"
        :settings "Ayarlar"
        :settings-of-plugins "Eklenti ayarları"
        :plugins "Eklentiler"
        :themes "Temelar"
        :developer-mode-alert "Eklenti sistemini etkinleştirmek için uygulamayı yeniden başlatmanız gerekir. Şimdi yeniden başlatmak istiyor musunuz?"
        :relaunch-confirm-to-work "Çalışması için uygulama yeniden başlatılmalı. Şimdi yeniden başlatmak istiyor musunuz?"
        :import "İçe aktar"
        :join-community "Topluluğa katıl"
        :sponsor-us "Bize Sponsor Olun"
        :discourse-title "Forum sayfamız!"
        :discord-title "Discord grubumuz!" ;; unused
        :help-shortcut-title "Kısayolları ve diğer ipuçlarını kontrol etmek için tıklayın"
        :loading "Yükleniyor"
        :cloning "Kopyalanıyor"
        :parsing-files "Dosyalar ayrıştırılıyor"
        :loading-files "Dosyalar yükleniyor"
        :login "Oturum aç"
        :logout "Oturumu kapat"
        :go-to "Git: "
        :or "veya"
        :download "İndir"
        :repo/download-zip "Tüm dosyaları zip olarak indir"
        :language "Dil"
        :white "Açık"
        :dark "Koyu"
        :remove-background "Arka planı kaldır"
        :open "Aç"
        :open-a-directory "Yerel bir dizin aç"
        :user/delete-account "Hesabı sil"
        :user/delete-your-account "Hesabınızı silin"
        :user/delete-account-notice "logseq.com adresinde yayımlanan tüm sayfalarınız silinecek."

        :help/shortcut-page-title "Klavye kısayolları"

        :plugin/installed "Yüklü"
        :plugin/not-installed "Yüklü olmayan"
        :plugin/installing "Yükleniyor"
        :plugin/install "Yükle"
        :plugin/reload "Yeniden yükle"
        :plugin/update "Güncelle"
        :plugin/check-update "Güncellemeyi denetle"
        :plugin/check-all-updates "Tüm güncellemeleri denetle"
        :plugin/refresh-lists "Listeleri yenile"
        :plugin/enabled "Etkin"
        :plugin/disabled "Devre dışı"
        :plugin/update-available "Güncelleme var"
        :plugin/updating "Güncelleniyor"
        :plugin/uninstall "Kaldır"
        :plugin/marketplace "Market"
        :plugin/downloads "İndirilme"
        :plugin/stars "Yıldızlar"
        :plugin/title "Başlık"
        :plugin/all "Tümü"
        :plugin/unpacked "Çıkarılmamış"
        :plugin/delete-alert "[{1}] eklentisini kaldırmak istediğinizden emin misiniz?"
        :plugin/open-settings "Ayarları aç"
        :plugin/open-package "Eklentinin içeriğini aç"
        :plugin/load-unpacked "Çıkarılmamış eklentiyi yükle"
        :plugin/open-preferences "Eklenti tercihleri dosyasını açın"
        :plugin/restart "Uygulamayı Yeniden Başlat"
        :plugin/unpacked-tips "Eklenti dizinini seçin"
        :plugin/contribute "✨ Yeni eklenti yaz ve gönder"
        :plugin/marketplace-tips "Eklenti ilk kurulduğunda düzgün çalışmıyorsa Logseq'i yeniden başlatmayı deneyin."
        :plugin/up-to-date "Güncel"
        :plugin/custom-js-alert "custom.js dosyası bulundu, çalıştırılmasına izin veriliyor mu? (Bu dosyanın içeriğini anlamadıysanız, belirli güvenlik riskleri olduğu için çalıştırmaya izin vermemeniz önerilir.)"

        :pdf/copy-ref "Referansı kopyala"
        :pdf/copy-text "Metni kopyala"
        :pdf/linked-ref "Bağlantılı referans"
        :pdf/toggle-dashed "Alan vurgusu için çizgili stil"

        :updater/new-version-install "Yeni bir sürüm indirildi."
        :updater/quit-and-install "Yüklemek için yeniden başlatın"

        :paginates/pages "Toplam {1} sayfa"
        :paginates/prev "Önceki"
        :paginates/next "Sonraki"

        :tips/all-done "Tamamlandı"

        :command-palette/prompt "Bir komut yazın"
        :select/default-prompt "Birini seçin"
        :select.graph/prompt "Bir grafik seçin"
        :select.graph/empty-placeholder-description "Eşleşen grafik yok. Bir tane daha eklemek ister misin?"
        :select.graph/add-graph "Evet, başka bir grafik ekle"

        :file-sync/other-user-graph "Geçerli yerel grafik, diğer kullanıcının uzak grafiğine bağlıdır. Bu yüzden senkronizasyon başlatılamıyor."
        :file-sync/graph-deleted "Geçerli uzak grafik silindi"}

   :ko {:tutorial/text #?(:cljs (rc/inline "tutorial-ko.md")
                          :default "tutorial-ko.md")
        :tutorial/dummy-notes #?(:cljs (rc/inline "dummy-notes-ko.md")
                                 :default "dummy-notes-ko.md")
        :on-boarding/demo-graph "이 그래프는 데모 그래프입니다. 로컬 폴더를 열기 전까지 변경 사항은 저장되지 않습니다."
        :on-boarding/add-graph "그래프 추가"
        :on-boarding/open-local-dir "로컬 폴더 열기"
        :on-boarding/new-graph-desc-1 "Logseq은 Markdown과 Org-Mode를 모두 지원합니다. 기기에서 존재하는 디렉토리(폴더)를 열거나 새 디렉토리를 만들 수 있습니다. 사용자의 데이터는 오직 이 기기에만 저장됩니다."
        :on-boarding/new-graph-desc-2 "디렉토리를 열면 Logseq은 3가지 폴더를 만들 것입니다:"
        :on-boarding/new-graph-desc-3 "/journals - 일지 페이지들을 저장합니다."
        :on-boarding/new-graph-desc-4 "/pages - 기타 페이지들을 저장합니다."
        :on-boarding/new-graph-desc-5 "/logseq - 사용자 설정과 custom.css, 그리고 몇 가지 메타데이터를 저장합니다."
        :help/start "시작"
        :help/about "Logseq에 대하여"
        :help/roadmap "로드맵"
        :help/bug "오류 제보"
        :help/feature "기능 제안"
        :help/changelog "변경 사항"
        :help/blog "Logseq 블로그"
        :help/docs "안내 문서"
        :help/privacy "개인정보 보호정책"
        :help/terms "약관"
        :help/community "디스코드 커뮤니티"
        :help/awesome-logseq "Awesome Logseq"
        :help/shortcuts "키보드 단축키"
        :help/shortcuts-triggers "트리거"
        :help/shortcut "단축키"
        :help/slash-autocomplete "Slash 자동 완성"
        :help/block-content-autocomplete "블록 콘텐츠 자동 완성"
        :help/reference-autocomplete "페이지 레퍼런스 자동 완성"
        :help/block-reference "블록 레퍼런스"
        :help/key-commands "키 커맨드"
        :help/working-with-lists " (목록을 사용하는 법)"
        :help/select-nfs-browser "최신 Chrome과 같이, NFS 기능을 지원하여 로컬 디렉토리를 열 수 있는 기타 브라우저에서 사용할 수 있습니다."
        :undo "실행 취소"
        :redo "다시 실행"
        :general "일반"
        :more "더 보기"
        :search/result-for "검색 결과: "
        :search/items "항목"
        :search/page-names "페이지 이름 검색"
        :help/context-menu "블록 컨텍스트 메뉴"
        :help/fold-unfold "블록 접기/열기 (편집 모드가 아닐 때)"
        :help/markdown-syntax "Markdown 문법"
        :help/org-mode-syntax "Org mode 문법"
        :bold "볼드체"
        :italics "이탤릭체"
        :html-link "HTML 링크"
        :highlight "하이라이트"
        :strikethrough "취소선"
        :code "코드"
        :right-side-bar/help "도움말"
        :right-side-bar/switch-theme "테마 모드"
        :right-side-bar/theme "{1} 테마"
        :right-side-bar/page "페이지 그래프"
        :right-side-bar/recent "최근 페이지"
        :right-side-bar/contents "콘텐츠"
        :right-side-bar/favorites "즐겨찾기"
        :right-side-bar/page-graph "페이지 그래프"
        :right-side-bar/block-ref "블록 레퍼런스"
        :right-side-bar/graph-view "그래프 뷰"
        :right-side-bar/all-pages "모든 페이지"
        :right-side-bar/flashcards "플래시 카드"
        :right-side-bar/new-page "새 페이지"
        :left-side-bar/journals "일지"
        :left-side-bar/new-page "새 페이지"
        :left-side-bar/nav-favorites "즐겨찾기"
        :left-side-bar/nav-shortcuts "단축키"
        :left-side-bar/nav-recent-pages "최근 페이지"
        :format/preferred-mode "어떤 모드를 사용하시겠습니까?"
        :format/markdown "Markdown"
        :format/org-mode "Org mode"
        :reference/linked "링크된 레퍼런스"
        :reference/unlinked-ref "링크되지 않은 레퍼런스"
        :page/presentation-mode "프레젠테이션 모드"
        :page/edit-properties-placeholder "속성"
        :page/delete-success "{1} 페이지가 성공적으로 삭제되었습니다."
        :page/delete-confirmation "이 페이지와 페이지의 파일들을 삭제하시겠습니까?"
        :page/rename-to "\"{1}\" 페이지의 이름을 무엇으로 바꾸시겠습니까?"
        :page/priority "중요도 \"{1}\""
        :page/copy-to-json "전체 페이지를 JSON으로 복사"
        :page/rename "페이지 이름 바꾸기"
        :page/open-in-finder "디렉토리에서 열기"
        :page/open-with-default-app "기본 앱으로 열기"
        :page/action-publish "출판"
        :page/make-public "출판 전 공개 상태로 만들기"
        :page/version-history "페이지 편집 기록 확인"
        :page/open-backup-directory "페이지 백업 디렉토리 열기"
        :page/file-sync-versions "페이지 버전"
        :page/make-private "비공개 상태로 만들기"
        :page/delete "페이지 삭제"
        :page/add-to-favorites "즐겨찾기에 추가"
        :page/unfavorite "즐겨찾기에서 삭제"
        :page/show-journals "일지 보기"
        :page/show-name "페이지 이름 보기"
        :page/hide-name "페이지 이름 숨기기"
        :block/name "페이지 이름"
        :page/last-modified "마지막 편집 시간:"
        :page/new-title "새 문서의 제목이 무엇입니까?"
        :page/earlier "이전"
        :page/no-more-journals "일지 더 없음"
        :page/copy-page-url "페이지 URL 복사"
        :journal/multiple-files-with-different-formats "같은 달에 여러 포맷의 일지 파일이 확인되었습니다. 각 달마다 하나의 일지 파일만 사용하시기 바랍니다."
        :journal/go-to "파일로 가기"
        :file/name "파일 이름"
        :file/file "파일: "
        :file/last-modified-at "마지막 편집 시간:"
        :file/no-data "데이터 없음"
        :file/format-not-supported "확장자 .{1} 형태의 파일은 지원되지 않습니다."
        :page/created-at "생성 시간:"
        :page/updated-at "수정 시간:"
        :page/backlinks "역링크"
        :editor/block-search "블록 검색"
        :editor/image-uploading "업로드 중"
        :draw/invalid-file "유효하지 않은 excalidraw 파일을 불러올 수 없습니다."
        :draw/specify-title "제목을 먼저 입력하십시오."
        :draw/rename-success "파일 이름이 성공적으로 변경되었습니다."
        :draw/rename-failure "파일 이름 변경이 다음 이유로 실패하였습니다: "
        :draw/title-placeholder "무제"
        :draw/save "저장"
        :draw/save-changes "변경사항 저장"
        :draw/new-file "새 파일"
        :draw/list-files "파일 목록"
        :draw/delete "삭제"
        :draw/more-options "더 보기"
        :draw/back-to-logseq "Logseq으로 돌아가기"
        :text/image "이미지"
        :asset/confirm-delete "정말 {1} 을/를 삭제하겠습니까?"
        :asset/physical-delete "파일 또한 삭제 (복구 불가능)"
        :content/copy "복사"
        :content/cut "잘라내기"
        :content/make-todos "{1} 만들기"
        :content/copy-block-ref "블록 주소 복사"
        :content/copy-block-emebed "블록 임베드 복사"
        :content/focus-on-block "블록 포커스"
        :content/open-in-sidebar "사이드바에서 열기"
        :content/copy-as-json "JSON으로 복사"
        :content/click-to-edit "클릭하여 수정"
        :settings-page/git-desc "페이지 버전 컨트롤을 위해 사용되며, 점 세개 메뉴를 클릭하여 페이지의 변경 기록을 확인할 수 있습니다."
        :settings-page/git-confirm "Git 설정을 변경한 뒤 앱을 재시작해야 합니다."
        :settings-page/git-switcher-label "Git 자동 커밋 설정"
        :settings-page/git-commit-delay "Git 자동 커밋 간격 (초)"
        :settings-page/edit-config-edn "config.edn 수정"
        :settings-page/edit-custom-css "custom.css 수정"
        :settings-page/edit-export-css "export.css 수정"
        :settings-page/custom-configuration "사용자 설정"
        :settings-page/custom-theme "사용자 테마"
        :settings-page/export-theme "테마 내보내기"
        :settings-page/show-brackets "대괄호 표시"
        :settings-page/spell-checker "문법 검사"
        :settings-page/auto-updater "자동 업데이트"
        :settings-page/disable-sentry "사용 통계와 분석을 Logseq에 전송"
        :settings-page/preferred-outdenting "논리적 아웃덴팅"
        :settings-page/custom-date-format "선호하는 날짜 형식"
        :settings-page/preferred-file-format "선호하는 파일 형식"
        :settings-page/preferred-workflow "선호하는 워크플로우"
        :settings-page/enable-shortcut-tooltip "단축키 툴팁 활성화"
        :settings-page/enable-timetracking "시간 추적 활성화"
        :settings-page/enable-tooltip "툴팁 활성화"
        :settings-page/enable-journals "일지 활성화"
        :settings-page/enable-all-pages-public "출판할 때 모든 페이지 공개로 설정"
        :settings-page/enable-encryption "암호화"
        :settings-page/customize-shortcuts "키보드 단축키"
        :settings-page/shortcut-settings "단축키 설정"
        :settings-page/home-default-page "기본 홈 페이지 설정"
        :settings-page/enable-block-time "블록 타임스탬프"
        :settings-page/clear-cache "캐시 지우기"
        :settings-page/clear "지우기"
        :settings-page/developer-mode "개발자 모드"
        :settings-page/enable-developer-mode "개발자 모드 활성화"
        :settings-page/disable-developer-mode "개발자 모드 비활성화"
        :settings-page/developer-mode-desc "개발자 모드는 컨트리뷰터와 확장 프로그램 개발자들이 Logseq과의 연동을 더 쉽고 효율적으로 테스트할 수 있게 도와줍니다."
        :settings-page/current-version "현재 버전"
        :settings-page/current-graph "현재 그래프"
        :settings-page/tab-general "일반"
        :settings-page/tab-editor "에디터"
        :settings-page/tab-shortcuts "단축키"
        :settings-page/tab-version-control "버전 컨트롤"
        :settings-page/tab-advanced "고급"
        :settings-page/plugin-system "플러그인 시스템"
        :settings-page/network-proxy "네트워크 프록시"
        :logseq "Logseq"
        :on "ON"
        :more-options "더 많은 옵션"
        :to "to"
        :yes "예"
        :no "아니오"
        :submit "제출"
        :cancel "취소"
        :close "닫기"
        :delete "삭제"
        :save "저장"
        :type "타입"
        :host "호스트"
        :port "포트"
        :re-index "인덱스 재생성"
        :re-index-detail "그래프 다시 빌드"
        :re-index-multiple-windows-warning "그래프를 다시 인덱싱 전 다른 윈도우를 모두 닫아야 합니다."
        :re-index-discard-unsaved-changes-warning "인덱싱을 다시 하게 되면 현재 나타나 있는 그래프가 사라지며, 하드 디스크에 저장된 파일대로 그래프를 재구성하게 됩니다. 저장되지 않은 변경사항들이 삭제되며 약간의 시간이 걸릴 수 있습니다. 계속하시겠습니까?"
        :open-new-window "새 창"
        :sync-from-local-files "새로고침"
        :sync-from-local-files-detail "로컬 파일로부터 변경 사항 불러오기"
        :sync-from-local-changes-detected "그래프를 새로 고치면 로컬 디스크에서 Logseq과는 다르게 변경된 파일들을 감지하고 처리합니다. 계속하시겠습니까?"

        :unlink "링크 해제"
        :search/publishing "검색"
        :search "페이지를 검색하거나 생성"
        :page-search "현재 페이지에서 검색"
        :graph-search "그래프 검색"
        :new-page "새 페이지"
        :new-file "새 파일"
        :new-graph "새 그래프"
        :graph "그래프"
        :graph-view "그래프 보기"
        :graph/persist "Logseq가 내부 상태를 동기화 중입니다. 잠시만 기다려주십시오."
        :graph/persist-error "내부 상태 동기화에 실패했습니다."
        :graph/save "저장 중..."
        :graph/save-success "저장 완료"
        :graph/save-error "저장 실패"
        :cards-view "카드 보기"
        :publishing "출판"
        :export "내보내기"
        :export-graph "그래프 내보내기"
        :export-page "페이지 내보내기"
        :export-markdown "표준 Markdown으로 내보내기 (블록 속성 미포함)"
        :export-opml "OPML으로 내보내기"
        :export-public-pages "공개 페이지 내보내기"
        :export-json "JSON으로 내보내기"
        :export-roam-json "Roam JSON으로 내보내기"
        :export-edn "EDN으로 내보내기"
        :export-datascript-edn "Datascript EDN으로 내보내기"
        :convert-markdown "Markdown 헤딩을 Unordered List들로 내보내기 (# -> -)"
        :all-graphs "모든 그래프"
        :all-pages "모든 페이지"
        :all-files "모든 파일"
        :remove-orphaned-pages "고립된 페이지 삭제"
        :all-journals "모든 일지"
        :my-publishing "나의 출판"
        :settings "설정"
        :settings-of-plugins "플러그인 설정"
        :plugins "플러그인"
        :themes "테마"
        :developer-mode-alert "플러그인 시스템을 활성화하려면 앱을 재시작해야 합니다. 지금 재시작하시겠습니까?"
        :relaunch-confirm-to-work "완료하려면 앱을 재시작해야 합니다. 지금 재시작하시겠습니까?"
        :import "불러오기"
        :join-community "커뮤니티에 참여"
        :sponsor-us "후원"
        :discord-title "디스코드"
        :help-shortcut-title "다른 단축키와 도움말 확인하기"
        :loading "로딩 중"
        :cloning "복제 중"
        :parsing-files "파일 파싱 중"
        :loading-files "파일 로딩 중"
        :login "로그인"
        :logout "로그아웃"
        :go-to "다음으로 이동: "
        :or "또는"
        :download "다운로드"
        :repo/download-zip "ZIP 다운로드"
        :language "언어"
        :white "라이트 모드"
        :dark "다크 모드"
        :remove-background "배경 제거"
        :open "열기"
        :open-a-directory "로컬 디렉토리 열기"
        :user/delete-account "계정 삭제"
        :user/delete-your-account "사용자의 계정 삭제"
        :user/delete-account-notice "logseq.com에 출판된 모든 문서가 삭제됩니다."

        :help/shortcut-page-title "키보드 단축키"

        :plugin/installed "설치됨"
        :plugin/not-installed "설치되지 않음"
        :plugin/installing "설치 중"
        :plugin/install "설치"
        :plugin/reload "다시 불러오기"
        :plugin/update "업데이트"
        :plugin/check-update "업데이트 확인"
        :plugin/check-all-updates "모든 업데이트 확인"
        :plugin/refresh-lists "리스트 새로고침"
        :plugin/enabled "활성화됨"
        :plugin/disabled "비활성화됨"
        :plugin/update-available "업데이트 가능"
        :plugin/updating "업데이트 중"
        :plugin/uninstall "설지 제거"
        :plugin/marketplace "마켓플레이스"
        :plugin/downloads "다운로드"
        :plugin/stars "스타"
        :plugin/title "제목"
        :plugin/all "전체"
        :plugin/unpacked "압축 해제됨"
        :plugin/delete-alert "다음 [{1}] 플러그인을 삭제하시겠습니까?"
        :plugin/open-settings "설정 열기"
        :plugin/open-package "패키지 열기"
        :plugin/load-unpacked "압축 해제된 플러그인 불러오기"
        :plugin/open-preferences "플러그인 설정 열기"
        :plugin/restart "앱 다시 시작"
        :plugin/unpacked-tips "플러그인 디렉토리 열기"
        :plugin/contribute "✨ 새 플러그인을 만들고 기여하기"
        :plugin/marketplace-tips "플러그인을 처음 설치하고 정상적으로 동작하지 않으면 Logseq를 다시 시작해 보십시오."
        :plugin/up-to-date "최신 상태입니다."
        :plugin/custom-js-alert "custom.js 파일을 감지했습니다. 실행을 허용하겠습니까? (파일의 내용을 이해하지 못한다면 보안과 안전 상의 이유로 실행하지 않는 것이 권장됩니다."

        :pdf/copy-ref "레퍼런스 복사하기"
        :pdf/copy-text "텍스트 복사하기"
        :pdf/linked-ref "링크된 레퍼런스"
        :pdf/toggle-dashed "영역 하이라이트를 위해 Dashed style 사용"

        :updater/new-version-install "새 버전이 다운로드되었습니다."
        :updater/quit-and-install "다시 시작하여 설치하십시오."

        :paginates/pages "총 {1} 페이지"
        :paginates/prev "이전"
        :paginates/next "다음"

        :tips/all-done "모두 완료"

        :command-palette/prompt "커맨드를 입력하십시오"
        :select/default-prompt "하나를 선택하십시오"
        :select.graph/prompt "그래프를 선택하십시오."
        :select.graph/empty-placeholder-description "일치하는 그래프가 없습니다. 새로 추가하시겠습니까?"
        :select.graph/add-graph "네, 새 그래프를 추가합니다"

        :file-sync/other-user-graph "현재 로컬 그래프가 다른 유저의 리모트 그래프와 충돌합니다. 동기화를 시작할 수 없습니다."
        :file-sync/graph-deleted "현재 리모트 그래프를 삭제했습니다."
        }

     :tongue/fallback :en})

(def languages [{:label "English" :value :en}
                {:label "Français" :value :fr}
                {:label "Deutsch" :value :de}
                {:label "简体中文" :value :zh-CN}
                {:label "繁體中文" :value :zh-Hant}
                {:label "Afrikaans" :value :af}
                {:label "Español" :value :es}
                {:label "Norsk (bokmål)" :value :nb-NO}
                {:label "Português (Brasileiro)" :value :pt-BR}
                {:label "Português (Europeu)" :value :pt-PT}
                {:label "Русский" :value :ru}
                {:label "日本語" :value :ja}
                {:label "Italiano" :value :it}
                {:label "Türkçe" :value :tr}
                {:label "한국어" :value :ko}])
