(ns ^:bb-compatible frontend.modules.shortcut.dicts
  "Provides dictionary entries for shortcuts")

(defn- decorate-namespace [k]
  (let [n (name k)
        ns (namespace k)]
    (keyword (str "command." ns) n)))

(def ^:large-vars/data-var all-default-keyboard-shortcuts
  {:date-picker/complete         "Date picker: Choose selected day"
   :date-picker/prev-day         "Date picker: Select previous day"
   :date-picker/next-day         "Date picker: Select next day"
   :date-picker/prev-week        "Date picker: Select previous week"
   :date-picker/next-week        "Date picker: Select next week"
   :pdf/previous-page            "Previous page of current pdf doc"
   :pdf/next-page                "Next page of current pdf doc"
   :auto-complete/complete       "Auto-complete: Choose selected item"
   :auto-complete/prev           "Auto-complete: Select previous item"
   :auto-complete/next           "Auto-complete: Select next item"
   :auto-complete/shift-complete "Auto-complete: Open selected item in sidebar"
   :auto-complete/open-link      "Auto-complete: Open selected item in browser"
   :cards/toggle-answers         "Cards: show/hide answers/clozes"
   :cards/next-card              "Cards: next card"
   :cards/forgotten              "Cards: forgotten"
   :cards/remembered             "Cards: remembered"
   :cards/recall                 "Cards: take a while to recall"
   :editor/escape-editing        "Escape editing"
   :editor/backspace             "Backspace / Delete backwards"
   :editor/delete                "Delete / Delete forwards"
   :editor/new-block             "Create new block"
   :editor/new-line              "New line in current block"
   :editor/follow-link           "Follow link under cursor"
   :editor/open-link-in-sidebar  "Open link in sidebar"
   :editor/bold                  "Bold"
   :editor/italics               "Italics"
   :editor/highlight             "Highlight"
   :editor/strike-through        "Strikethrough"
   :editor/clear-block           "Delete entire block content"
   :editor/kill-line-before      "Delete line before cursor position"
   :editor/kill-line-after       "Delete line after cursor position"
   :editor/beginning-of-block    "Move cursor to the beginning of a block"
   :editor/end-of-block          "Move cursor to the end of a block"
   :editor/forward-word          "Move cursor forward a word"
   :editor/backward-word         "Move cursor backward a word"
   :editor/forward-kill-word     "Delete a word forwards"
   :editor/backward-kill-word    "Delete a word backwards"
   :editor/replace-block-reference-at-point "Replace block reference with its content at point"
   :editor/paste-text-in-one-block-at-point "Paste text into one block at point"
   :editor/insert-youtube-timestamp         "Insert youtube timestamp"
   :editor/cycle-todo              "Rotate the TODO state of the current item"
   :editor/up                      "Move cursor up / Select up"
   :editor/down                    "Move cursor down / Select down"
   :editor/left                    "Move cursor left / Open selected block at beginning"
   :editor/right                   "Move cursor right / Open selected block at end"
   :editor/select-up               "Select content above"
   :editor/select-down             "Select content below"
   :editor/move-block-up           "Move block up"
   :editor/move-block-down         "Move block down"
   :editor/open-edit               "Edit selected block"
   :editor/select-block-up         "Select block above"
   :editor/select-block-down       "Select block below"
   :editor/delete-selection        "Delete selected blocks"
   :editor/expand-block-children   "Expand"
   :editor/collapse-block-children "Collapse"
   :editor/indent                  "Indent block"
   :editor/outdent                 "Outdent block"
   :editor/copy                    "Copy (copies either selection, or block reference)"
   :editor/cut                     "Cut"
   :editor/undo                    "Undo"
   :editor/redo                    "Redo"
   :editor/insert-link             "HTML Link"
   :editor/select-all-blocks       "Select all blocks"
   :editor/zoom-in                 "Zoom in editing block / Forwards otherwise"
   :editor/zoom-out                "Zoom out editing block / Backwards otherwise"
   :ui/toggle-brackets             "Toggle whether to display brackets"
   :go/search-in-page              "Search in the current page"
   :go/search                      "Full text search"
   :go/journals                    "Go to journals"
   :go/backward                    "Backwards"
   :go/forward                     "Forwards"
   :search/re-index                "Rebuild search index"
   :sidebar/open-today-page        "Open today's page in the right sidebar"
   :sidebar/clear                  "Clear all in the right sidebar"
   :misc/copy                      "mod+c"
   :command-palette/toggle         "Toggle command palette"
   :graph/open                     "Select graph to open"
   :graph/remove                   "Remove a graph"
   :graph/add                      "Add a graph"
   :graph/save                     "Save current graph to disk"
   :command/run                    "Run git command"
   :go/home                        "Go to home"
   :go/all-pages                   "Go to all pages"
   :go/graph-view                  "Go to graph view"
   :go/keyboard-shortcuts          "Go to keyboard shortcuts"
   :go/tomorrow                    "Go to tomorrow"
   :go/next-journal                "Go to next journal"
   :go/prev-journal                "Go to previous journal"
   :go/flashcards                  "Toggle flashcards"
   :ui/toggle-document-mode        "Toggle document mode"
   :ui/toggle-settings             "Toggle settings"
   :ui/toggle-right-sidebar        "Toggle right sidebar"
   :ui/toggle-left-sidebar         "Toggle left sidebar"
   :ui/toggle-help                 "Toggle help"
   :ui/toggle-theme                "Toggle between dark/light theme"
   :ui/toggle-contents             "Toggle Contents in sidebar"
   :ui/open-new-window             "Open another window"
   :command/toggle-favorite        "Add to/remove from favorites"
   :editor/open-file-in-default-app "Open file in default app"
   :editor/open-file-in-directory   "Open file in parent directory"
   :editor/copy-current-file        "Copy current file"
   :ui/toggle-wide-mode             "Toggle wide mode"
   :ui/select-theme-color           "Select available theme colors"
   :ui/goto-plugins                 "Go to plugins dashboard"
   :editor/toggle-open-blocks       "Toggle open blocks (collapse or expand all blocks)"
   :ui/toggle-cards                 "Toggle cards"
   :git/commit                      "Git commit message"})

(def category
  {:shortcut.category/basics "Basics"
   :shortcut.category/formatting "Formatting"
   :shortcut.category/navigating "Navigation"
   :shortcut.category/block-editing "Block editing general"
   :shortcut.category/block-command-editing "Block command editing"
   :shortcut.category/block-selection "Block selection (press Esc to quit selection)"
   :shortcut.category/toggle "Toggle"
   :shortcut.category/others "Others"})

(def ^:large-vars/data-var dicts
  {:en (merge
        ;; Dynamically add this ns since command descriptions have to
        ;; stay in sync with shortcut.config command ids which do not
        ;; have a namespce
        (update-keys all-default-keyboard-shortcuts decorate-namespace)
        category)

   :zh-CN   {:shortcut.category/formatting            "格式化"
             :shortcut.category/basics                "基础操作"
             :shortcut.category/navigating            "移动"
             :shortcut.category/block-editing         "块编辑基本"
             :shortcut.category/block-command-editing "块编辑文本操作"
             :shortcut.category/block-selection       "块选择操作"
             :shortcut.category/toggle                "切换"
             :shortcut.category/others                "其他"
             :command.editor/indent                   "缩进块标签"
             :command.editor/outdent                  "取消缩进块"
             :command.editor/move-block-up            "向上移动块"
             :command.editor/move-block-down          "向下移动块"
             :command.editor/new-block                "创建块"
             :command.editor/new-line                 "块中新建行"
             :command.editor/zoom-in                  "聚焦"
             :command.editor/zoom-out                 "退出聚焦"
             :command.editor/follow-link              "跟随光标下的链接"
             :command.editor/open-link-in-sidebar     "在侧边栏打开"
             :command.editor/expand-block-children    "展开"
             :command.editor/collapse-block-children  "折叠"
             :command.editor/select-block-up          "选择上方的块"
             :command.editor/select-block-down        "选择下方的块"
             :command.editor/select-all-blocks        "选择所有块"
             :command.ui/toggle-help                  "显示/关闭帮助"
             :command.git/commit                      "提交消息"
             :command.go/search                       "全文搜索"
             :command.go/backward                     "回退"
             :command.go/forward                      "前进"
             :command.go/search-in-page               "在当前页面搜索"
             :command.ui/toggle-document-mode         "切换文档模式"
             :command.ui/toggle-contents              "打开/关闭目录"
             :command.ui/toggle-theme                 "在暗色/亮色主题之间切换"
             :command.ui/toggle-right-sidebar         "启用/关闭右侧栏"
             :command.ui/toggle-settings              "显示/关闭设置"
             :command.go/journals                     "跳转到日记"
             :command.ui/toggle-wide-mode             "切换宽屏模式"
             :command.ui/toggle-brackets              "切换是否显示括号"
             :command.search/re-index                 "重新建立搜索索引"
             :command.editor/bold                     "粗体"
             :command.editor/italics                  "斜体"
             :command.editor/insert-link              "Html 链接"
             :command.editor/highlight                "高亮"
             :command.editor/undo                     "撤销"
             :command.editor/redo                     "重做"
             :command.editor/copy                     "复制"
             :command.editor/cut                      "剪切"
             :command.editor/up                       "向上移动光标 / 向上选择"
             :command.editor/down                     "向下移动光标 / 向下选择"
             :command.editor/left                     "向左移动光标 / 向左选择"
             :command.editor/right                    "向右移动光标 / 向右选择"
             :command.editor/backspace                "向左删除"
             :command.editor/delete                   "向右删除"
             :command.editor/cycle-todo               "切换TODO状态"
             :command.editor/clear-block              "清除块内容"
             :command.editor/kill-line-before         "删除光标右侧行"
             :command.editor/kill-line-after          "删除光标左侧行"
             :command.editor/beginning-of-block       "移动光标到块开始位置"
             :command.editor/end-of-block             "移动光标到块末尾"
             :command.editor/forward-word             "光标向后移动一个单词"
             :command.editor/backward-word            "光标向前移动一个单词"
             :command.editor/forward-kill-word        "向后删除一个单词"
             :command.editor/backward-kill-word       "向前删除一个单词"
             :command.editor/open-edit                "编辑选中块"
             :command.editor/delete-selection         "删除选中块"
             :command.editor/toggle-open-blocks       "切换折叠/展开所有块（非编辑状态）"}
   :zh-Hant {:command.editor/indent                  "縮進塊標簽"
             :command.editor/outdent                 "取消縮進塊"
             :command.editor/move-block-up           "向上移動塊"
             :command.editor/move-block-down         "向下移動塊"
             :command.editor/new-block               "創建塊"
             :command.editor/new-line                "塊中新建行"
             :command.editor/zoom-in                 "聚焦"
             :command.editor/zoom-out                "推出聚焦"
             :command.editor/follow-link             "跟隨光標下的鏈接"
             :command.editor/open-link-in-sidebar    "在側邊欄打開"
             :command.editor/expand-block-children   "展開"
             :command.editor/collapse-block-children "折疊"
             :command.editor/select-block-up         "選擇上方的塊"
             :command.editor/select-block-down       "選擇下方的塊"
             :command.editor/select-all-blocks       "選擇所有塊"
             :command.ui/toggle-help                 "顯示/關閉幫助"
             :command.git/commit                     "提交消息"
             :command.go/search                      "全文搜索"
             :command.ui/toggle-document-mode        "切換文檔模式"
             :command.ui/toggle-theme                "“在暗色/亮色主題之間切換”"
             :command.ui/toggle-right-sidebar        "啟用/關閉右側欄"
             :command.go/journals                    "跳轉到日記"}

   :de      {:shortcut.category/formatting           "Formatierung"
             :command.editor/indent                  "Block einrücken"
             :command.editor/outdent                 "Block ausrücken"
             :command.editor/move-block-up           "Block nach oben verschieben"
             :command.editor/move-block-down         "Block nach unten verschieben"
             :command.editor/new-block               "Neuen Block erstellen"
             :command.editor/new-line                "Neue Zeile innerhalb des Blocks erstellen"
             :command.editor/zoom-in                 "Heranzoomen"
             :command.editor/zoom-out                "Herauszoomen"
             :command.editor/follow-link             "Link unter dem Cursor folgen"
             :command.editor/open-link-in-sidebar    "Link in Seitenleiste öffnen"
             :command.editor/expand-block-children   "Erweitern"
             :command.editor/collapse-block-children "Zusammenklappen"
             :command.editor/select-block-up         "Block oberhalb auswählen"
             :command.ui/toggle-help                 "Hilfe aktivieren"
             :command.go/search                      "Volltextsuche"
             :command.ui/toggle-document-mode        "Dokumentenmodus umschalten"
             :command.ui/toggle-theme                "Umschalten zwischen dunklem/hellem Thema"
             :command.ui/toggle-right-sidebar        "Rechte Seitenleiste umschalten"
             :command.go/journals                    "Zu Journalen springen"
             :command.git/commit                     "Git Commit-Nachricht"
             :command.editor/select-block-down       "Block unterhalb auswählen"
             :command.editor/select-all-blocks       "Alle Blöcke auswählen"}
   :fr      {:shortcut.category/formatting           "Formats"
             :command.editor/indent                  "Indenter un Bloc vers la droite"
             :command.editor/outdent                 "Indenter un Bloc vers la gauche"
             :command.editor/move-block-up           "Déplacer un bloc au dessus"
             :command.editor/move-block-down         "Déplacer un bloc en dessous"
             :command.editor/new-block               "Créer un nouveau bloc"
             :command.editor/new-line                "Aller à la ligne dans un bloc"
             :command.editor/zoom-in                 "Zoomer"
             :command.editor/zoom-out                "Dézoomer"
             :command.editor/follow-link             "Suivre le lien sous le curseur"
             :command.editor/open-link-in-sidebar    "Ouvrir le lien dans la barre latérale"
             :command.editor/expand-block-children   "Etendre"
             :command.editor/collapse-block-children "Réduire"
             :command.editor/select-block-up         "Sélectionner le bloc au dessus"
             :command.editor/select-block-down       "Sélectionner le bloc en dessous"
             :command.editor/select-all-blocks       "Sélectionner tous les blocs"
             :command.ui/toggle-help                 "Afficher l'aide"
             :command.git/commit                     "Message de commit Git"
             :command.go/search                      "Recherche globale dans le texte"
             :command.ui/toggle-document-mode        "Intervertir le mode document"
             :command.ui/toggle-theme                "Intervertir le thème foncé/clair"
             :command.ui/toggle-right-sidebar        "Afficher/cacher la barre latérale"
             :command.go/journals                    "Aller au Journal"}

   :af      {:shortcut.category/formatting           "Formatering"
             :command.editor/indent                  "Ingekeepte blok oortjie"
             :command.editor/outdent                 "Oningekeepte blok"
             :command.editor/move-block-up           "Skuif Blok Boontoe"
             :command.editor/move-block-down         "Skuif Blok Ondertoe"
             :command.editor/new-block               "Skep 'n nuwe blok"
             :command.editor/new-line                "Nuwe lyn in blok"
             :command.editor/zoom-in                 "Zoem in"
             :command.editor/zoom-out                "Zoem uit"
             :command.editor/follow-link             "Volg die skakel onder die wyser"
             :command.editor/open-link-in-sidebar    "Maak skakel in kantlys oop"
             :command.editor/expand-block-children   "Brei uit"
             :command.editor/collapse-block-children "Vou in"
             :command.editor/select-block-up         "Kies blok bo"
             :command.editor/select-block-down       "Kies blok onder"
             :command.editor/select-all-blocks       "Kies alle blokke"
             :command.ui/toggle-help                 "Wissel help"
             :command.git/commit                     "Jou git stoor boodskap"
             :command.go/search                      "Volteks soek"
             :command.ui/toggle-document-mode        "Wissel dokument modus"
             :command.go/journals                    "Spring na joernale"
             :command.ui/toggle-theme                "Wissel tussen donker/lig temas"
             :command.ui/toggle-right-sidebar        "Wissel regter sybalk"}

   :es      {:shortcut.category/formatting            "Formato"
             :shortcut.category/basics                "Básico"
             :shortcut.category/navigating            "Navegación"
             :shortcut.category/block-editing         "Edición de bloque general"
             :shortcut.category/block-command-editing "Comandos edición de bloque"
             :shortcut.category/block-selection       "Selección de bloques (pulsar Esc para salir)"
             :shortcut.category/toggle                "Alternar"
             :shortcut.category/others                "Otros"
             :command.editor/indent                   "Aumentar sangría"
             :command.editor/outdent                  "Disminuir sangría"
             :command.editor/move-block-up            "Mover bloque arriba"
             :command.editor/move-block-down          "Mover bloque abajo"
             :command.editor/new-block                "Crear bloque nuevo"
             :command.editor/new-line                 "Nueva linea en bloque"
             :command.editor/zoom-in                  "Acercar / Adelante"
             :command.editor/zoom-out                 "Alejar / Atrás"
             :command.editor/follow-link              "Seguir enlace bajo el cursor"
             :command.editor/open-link-in-sidebar     "Abrir enlace en barra lateral"
             :command.editor/expand-block-children    "Expandir"
             :command.editor/collapse-block-children  "Colapsar"
             :command.editor/select-block-up          "Seleccionar bloque de arriba"
             :command.editor/select-block-down        "Seleccionar bloque de abajo"
             :command.editor/select-all-blocks        "Seleccionar todos los bloques"
             :command.ui/toggle-help                  "Alternar ayuda"
             :command.git/commit                      "Confirmar"
             :command.go/search                       "Buscar en el grafo"
             :command.go/search-in-page               "Buscar en la página actual"
             :command.ui/toggle-document-mode         "Alternar modo documento"
             :command.ui/toggle-contents              "Alternar Contenido en barra lateral"
             :command.ui/toggle-theme                 "Alternar entre tema claro/oscuro"
             :command.ui/toggle-right-sidebar         "Alternar barra lateral"
             :command.ui/toggle-settings              "Alternar Opciones"
             :command.go/journals                     "Ir a los diarios"
             :command.ui/toggle-wide-mode             "Alternar modo ancho"
             :command.ui/toggle-brackets              "Alternar corchetes"
             :command.search/re-index                 "Reconstruir índice de búsqueda"
             :command.editor/bold                     "Negrita"
             :command.editor/italics                  "Cursiva"
             :command.editor/insert-link              "Enlace html"
             :command.editor/highlight                "Resaltado"
             :command.editor/undo                     "Deshacer"
             :command.editor/redo                     "Rehacer"
             :command.editor/copy                     "Copiar"
             :command.editor/cut                      "Pegar"
             :command.editor/up                       "Mover cursor arriba / Seleccionar arriba"
             :command.editor/down                     "Mover cursor abajo / Seleccionar abajo"
             :command.editor/left                     "Mover cursor a la izquierda / Abrir bloque seleccionado al inicio"
             :command.editor/right                    "Mover cursor a la derecha / Abrir bloque seleccionado al final"
             :command.editor/backspace                "Retroceso / Eliminar hacia atrás"
             :command.editor/delete                   "Suprimir / Eliminar hacia delante"
             :command.editor/cycle-todo               "Rotar estado TODO del elemento"
             :command.editor/clear-block              "Borrar contenido del bloque"
             :command.editor/kill-line-before         "Borrar linea antes del cursor"
             :command.editor/kill-line-after          "Borrar linea despues del cursor"
             :command.editor/beginning-of-block       "Mover cursor al inicio del bloque"
             :command.editor/end-of-block             "Mover cursor al final del bloque"
             :command.editor/forward-word             "Mover cursor una palabra adelante"
             :command.editor/backward-word            "Mover cursor una palabra atrás"
             :command.editor/forward-kill-word        "Borrar palabra posterior"
             :command.editor/backward-kill-word       "Borrar palabra anterior"
             :command.editor/open-edit                "Editar bloque seleccionado"
             :command.editor/delete-selection         "Eliminar bloques seleccionados"
             :command.editor/toggle-open-blocks       "Alternar bloques abieros, (colapsar o expandir todos)"}

   :ru      {:shortcut.category/formatting            "Форматирование"
             :shortcut.category/basics                "Базовые"
             :shortcut.category/navigating            "Навигация"
             :shortcut.category/block-editing         "Общее редактирование блока"
             :shortcut.category/block-command-editing "Команды редактирования блока"
             :shortcut.category/block-selection       "Выделение блоков (нажмите Esc для снятия выделения)"
             :shortcut.category/toggle                "Переключатели"
             :shortcut.category/others                "Разное"
             :command.editor/indent                   "Увеличить отступ"
             :command.editor/outdent                  "Уменьшить отступ"
             :command.editor/move-block-up            "Передвинуть блок выше"
             :command.editor/move-block-down          "Передвинуть блок ниже"
             :command.editor/new-block                "Создать новый блок"
             :command.editor/new-line                 "Новая строка в блоке"
             :command.editor/zoom-in                  "Увеличить / Вперед"
             :command.editor/zoom-out                 "Уменьшить / Назад"
             :command.editor/follow-link              "Перейти по ссылке под курсором"
             :command.editor/open-link-in-sidebar     "Открыть ссылку в боковой панели"
             :command.editor/expand-block-children    "Раскрыть"
             :command.editor/collapse-block-children  "Свернуть"
             :command.editor/select-block-up          "Выбрать блок выше"
             :command.editor/select-block-down        "Выбрать блок ниже"
             :command.editor/select-all-blocks        "Выбрать все блоки"
             :command.ui/toggle-help                  "Переключить помощь"
             :command.git/commit                      "Подтвердить"
             :command.go/search                       "Искать на графе"
             :command.go/search-in-page               "Искать на текущей странице"
             :command.ui/toggle-document-mode         "Переключить режи документа"
             :command.ui/toggle-contents              "Переключить контент на боковой панели"
             :command.ui/toggle-theme                 "Переключение между светлой / темной темой"
             :command.ui/toggle-right-sidebar         "Переключить боковую панель"
             :command.ui/toggle-settings              "Переключить параметры"
             :command.go/journals                     "Перейти в Дневники"
             :command.ui/toggle-wide-mode             "Переключить широкоформатный режим"
             :command.ui/toggle-brackets              "Переключить скобки"
             :command.search/re-index                 "Восстановить индекс поиска"
             :command.editor/bold                     "Жирный"
             :command.editor/italics                  "Курсив"
             :command.editor/insert-link              "HTML ссылка"
             :command.editor/highlight                "Выделение"
             :command.editor/undo                     "Отменить"
             :command.editor/redo                     "Вернуть"
             :command.editor/copy                     "Копировать"
             :command.editor/cut                      "Вырезать"
             :command.editor/up                       "Переместить курсор вверх / Выбрать вверх"
             :command.editor/down                     "Переместить курсор вниз / Выбрать вниз"
             :command.editor/left                     "Переместить курсор влево / Открыть выбранный блок в начале"
             :command.editor/right                    "Переместить курсор вправо / Открыть выбранный блок в конце"
             :command.editor/backspace                "Удалить перед курсором"
             :command.editor/delete                   "Удалить после курсора"
             :command.editor/cycle-todo               "Переключить состояние элемента TODO"
             :command.editor/clear-block              "Удалить содержимое блока"
             :command.editor/kill-line-before         "Удалить строку до курсора"
             :command.editor/kill-line-after          "Удалить строку после курсора"
             :command.editor/beginning-of-block       "Переместите курсор в начало блока"
             :command.editor/end-of-block             "Переместите курсор в конец блока"
             :command.editor/forward-word             "Переместить курсор на одно слово вперед"
             :command.editor/backward-word            "Переместить курсор на одно слово назад"
             :command.editor/forward-kill-word        "Удалить следующее слово"
             :command.editor/backward-kill-word       "Удалить предыдущее слово"
             :command.editor/open-edit                "Редактировать выбранный блок"
             :command.editor/delete-selection         "Удалить выбранные блоки"
             :command.editor/toggle-open-blocks       "Переключить открытые блоки (свернуть или развернуть все)"}

   :nb-NO   {:shortcut.category/formatting            "Formatering"
             :shortcut.category/basics                "Basis"
             :shortcut.category/navigating            "Navigasjon"
             :shortcut.category/block-editing         "Blokkredigering generelt"
             :shortcut.category/block-command-editing "Blokkredigering kommandoer"
             :shortcut.category/block-selection       "Blokkseleksjon (trykk ESC for å avslutte)"
             :shortcut.category/toggle                "Veksling"
             :shortcut.category/others                "Annet"
             :command.editor/indent                   "Innrykk inn"
             :command.editor/outdent                  "Innrykk ut"
             :command.editor/move-block-up            "Flytt blokk opp"
             :command.editor/move-block-down          "Flytt blokk ned"
             :command.editor/new-block                "Opprett ny blokk"
             :command.editor/new-line                 "Ny linje i nåværende blokk"
             :command.editor/zoom-in                  "Zoom inn / Fremover"
             :command.editor/zoom-out                 "Zoom ut / Tilbake"
             :command.editor/follow-link              "Følg lenke under markøren"
             :command.editor/open-link-in-sidebar     "Åpne lenke i sidestolpe"
             :command.editor/expand-block-children    "Utvid"
             :command.editor/collapse-block-children  "Slå sammen"
             :command.editor/select-block-up          "Velg blokk over"
             :command.editor/select-block-down        "Velg blokk under"
             :command.editor/select-all-blocks        "Velg alle blokker"
             :command.ui/toggle-help                  "Vis hjelp"
             :command.git/commit                      "Git commit beskjed"
             :command.go/search                       "Fulltekst søk"
             :command.go/search-in-page               "Søk på nåværende side"
             :command.ui/toggle-document-mode         "Aktiver dokumentmodus"
             :command.ui/toggle-contents              "Åpne favoritter i sidestolpen"
             :command.ui/toggle-theme                 "Veksle mellom lyst og mørkt tema"
             :command.ui/toggle-left-sidebar          "Aktiver venstre sidestolpe"
             :command.ui/toggle-right-sidebar         "Aktiver høyre sidestolpe"
             :command.ui/toggle-settings              "Åpne innstillinger"
             :command.go/journals                     "Gå til dagbok"
             :command.ui/toggle-wide-mode             "Aktiver vid-modus"
             :command.ui/toggle-brackets              "Aktiver vising av klammer"
             :command.search/re-index                 "Gjenoppbygg søkeindeks"
             :command.editor/bold                     "Fet"
             :command.editor/italics                  "Kursiv"
             :command.editor/insert-link              "HTML lenke"
             :command.editor/highlight                "Markering"
             :command.editor/undo                     "Angre"
             :command.editor/redo                     "Gjør om"
             :command.editor/copy                     "Kopier"
             :command.editor/cut                      "Klipp ut"
             :command.editor/up                       "Flytt markøren opp / Velg opp"
             :command.editor/down                     "Flytt markøren ned / Velg ned"
             :command.editor/left                     "Flytt markøren til venstre / Åpne valgt blokk på begynnelsen"
             :command.editor/right                    "Flytt markøren til høyre / Åpne valgt blokk på slutten"
             :command.editor/backspace                "Backspace / Slett bakover"
             :command.editor/delete                   "Delete / Slett forover"
             :command.editor/cycle-todo               "Veksle TODO status for valg linje"
             :command.editor/clear-block              "Slett alt innhold i blokken"
             :command.editor/kill-line-before         "Slett linje foran markøren"
             :command.editor/kill-line-after          "Slett linsje etter markøren"
             :command.editor/beginning-of-block       "Flytt markøren til begynnelsen av blokken"
             :command.editor/end-of-block             "Flytt markøren til slutten av blokken"
             :command.editor/forward-word             "Flytt markøren frem ett ord"
             :command.editor/backward-word            "Flytt markøren bakover ett ord"
             :command.editor/forward-kill-word        "Slett ett ord forover"
             :command.editor/backward-kill-word       "Slett ett ord bakover"
             :command.editor/open-edit                "Rediger valgt blokk"
             :command.editor/delete-selection         "Slett valgte blokker"
             :command.editor/toggle-open-blocks       "Veksle åpne blokker (slå sammen eller utvid alle blokker)"}

   :pt-PT   {:shortcut.category/formatting            "Formatação"
             :shortcut.category/basics                "Básico"
             :shortcut.category/navigating            "Navegação"
             :shortcut.category/block-editing         "Edição geral de blocos"
             :shortcut.category/block-command-editing "Comandos de edição de blocos"
             :shortcut.category/block-selection       "Seleção de blocos (premir Esc para sair)"
             :shortcut.category/toggle                "Alternar"
             :shortcut.category/others                "Outros"
             :command.editor/indent                   "Aumentar avanço de parágrafo"
             :command.editor/outdent                  "Diminuir avanço de parágrafo"
             :command.editor/move-block-up            "Mover bloco para cima"
             :command.editor/move-block-down          "Mover bloco para baixo"
             :command.editor/new-block                "Criar novo bloco"
             :command.editor/new-line                 "Nova linha no bloco actual"
             :command.editor/zoom-in                  "Aproximar / Para a frente"
             :command.editor/zoom-out                 "Afastar / Para trás"
             :command.editor/follow-link              "Seguir ligação sob o cursor"
             :command.editor/open-link-in-sidebar     "Abrir ligação na barra lateral"
             :command.editor/expand-block-children    "Expandir"
             :command.editor/collapse-block-children  "Colapsar"
             :command.editor/select-block-up          "Selecionar bloco acima"
             :command.editor/select-block-down        "Selecionar bloco abaixo"
             :command.editor/select-all-blocks        "Selecionar todos os blocos"
             :command.ui/toggle-help                  "Alternar ajuda"
             :command.git/commit                      "Confirmar"
             :command.go/search                       "Pesquisar no grafo"
             :command.go/search-in-page               "Pesquisar na página atual"
             :command.ui/toggle-document-mode         "Alternar modo de documento"
             :command.ui/toggle-contents              "Alternar Conteúdo na barra lateral"
             :command.ui/toggle-theme                 "Alternar entre tema claro/escuro"
             :command.ui/toggle-right-sidebar         "Alternar barra lateral"
             :command.ui/toggle-settings              "Alternar Opções"
             :command.go/journals                     "Ir para diários"
             :command.ui/toggle-wide-mode             "Alternar modo de ecrã amplo"
             :command.ui/toggle-brackets              "Alternar parênteses rectos"
             :command.search/re-index                 "Reconstruir índice de pesquisa"
             :command.editor/bold                     "Negrito"
             :command.editor/italics                  "Itálico"
             :command.editor/insert-link              "Inserir ligação html"
             :command.editor/highlight                "Realçado"
             :command.editor/undo                     "Desfazer"
             :command.editor/redo                     "Refazer"
             :command.editor/copy                     "Copiar"
             :command.editor/cut                      "Cortar"
             :command.editor/up                       "Mover cursor para cima / Selecionar para cima"
             :command.editor/down                     "Mover cursor para baixo / Selecionar para baixo"
             :command.editor/left                     "Mover cursor para a esquerda / Abrir bloco selecionado no início"
             :command.editor/right                    "Mover cursor para a direita / Abrir bloco selecionado no final"
             :command.editor/backspace                "Retroceder / Eliminar para atrás"
             :command.editor/delete                   "Apagar / Eliminar para a frente"
             :command.editor/cycle-todo               "Alternar estado TODO do elemento"
             :command.editor/clear-block              "Apagar conteúdo do bloco"
             :command.editor/kill-line-before         "Apagar linha antes do cursor"
             :command.editor/kill-line-after          "Apagar linha depois do cursor"
             :command.editor/beginning-of-block       "Mover o cursor para o início do bloco"
             :command.editor/end-of-block             "Mover o cursor para o fim do bloco"
             :command.editor/forward-word             "Mover o cursor para a próxima palavra"
             :command.editor/backward-word            "Mover o cursor para a palavra anterior"
             :command.editor/forward-kill-word        "Apagar a próxima palavra"
             :command.editor/backward-kill-word       "Apagar a palavra anterior"
             :command.editor/open-edit                "Editar bloco selecionado"
             :command.editor/delete-selection         "Eliminar blocos selecionados"
             :command.editor/toggle-open-blocks       "Alternar blocos abertos (colapsar ou expandir todos)"}

   :pt-BR   {:shortcut.category/formatting            "Formatação"
             :shortcut.category/basics                "Básico"
             :shortcut.category/navigating            "Navegação"
             :shortcut.category/block-editing         "Edição geral de blocos"
             :shortcut.category/block-command-editing "Comandos de edição de blocos"
             :shortcut.category/block-selection       "Seleção de blocos (aperte Esc para sair)"
             :shortcut.category/toggle                "Alternar"
             :shortcut.category/others                "Outros"
             :command.editor/indent                   "Aumentar avanço de parágrafo"
             :command.editor/outdent                  "Diminuir avanço de parágrafo"
             :command.editor/move-block-up            "Mover bloco para cima"
             :command.editor/move-block-down          "Mover bloco para baixo"
             :command.editor/new-block                "Criar novo bloco"
             :command.editor/new-line                 "Nova linha no bloco actual"
             :command.editor/zoom-in                  "Aproximar / Para a frente"
             :command.editor/zoom-out                 "Afastar / Para trás"
             :command.editor/follow-link              "Seguir ligação sob o cursor"
             :command.editor/open-link-in-sidebar     "Abrir ligação na barra lateral"
             :command.editor/expand-block-children    "Expandir"
             :command.editor/collapse-block-children  "Recolher"
             :command.editor/select-block-up          "Selecionar bloco acima"
             :command.editor/select-block-down        "Selecionar bloco abaixo"
             :command.editor/select-all-blocks        "Selecionar todos os blocos"
             :command.ui/toggle-help                  "Alternar ajuda"
             :command.git/commit                      "Confirmar"
             :command.go/search                       "Pesquisar no grafo"
             :command.go/search-in-page               "Pesquisar na página atual"
             :command.ui/toggle-document-mode         "Alternar modo de documento"
             :command.ui/toggle-contents              "Alternar Conteúdo na barra lateral"
             :command.ui/toggle-theme                 "Alternar entre tema claro/escuro"
             :command.ui/toggle-right-sidebar         "Alternar barra lateral"
             :command.ui/toggle-settings              "Alternar Opções"
             :command.go/journals                     "Ir para diários"
             :command.ui/toggle-wide-mode             "Alternar largura extendida"
             :command.ui/toggle-brackets              "Alternar colchetes"
             :command.search/re-index                 "Reconstruir índice de pesquisa"
             :command.editor/bold                     "Negrito"
             :command.editor/italics                  "Itálico"
             :command.editor/insert-link              "Inserir vínculo"
             :command.editor/highlight                "Realçado"
             :command.editor/undo                     "Desfazer"
             :command.editor/redo                     "Refazer"
             :command.editor/copy                     "Copiar"
             :command.editor/cut                      "Cortar"
             :command.editor/up                       "Mover cursor para cima / Selecionar para cima"
             :command.editor/down                     "Mover cursor para baixo / Selecionar para baixo"
             :command.editor/left                     "Mover cursor para a esquerda / Abrir bloco selecionado no início"
             :command.editor/right                    "Mover cursor para a direita / Abrir bloco selecionado no final"
             :command.editor/backspace                "Retroceder / Eliminar para trás"
             :command.editor/delete                   "Deletar / Eliminar para frente"
             :command.editor/cycle-todo               "Alternar estado A FAZER do elemento"
             :command.editor/clear-block              "Apagar conteúdo do bloco"
             :command.editor/kill-line-before         "Apagar linha antes do cursor"
             :command.editor/kill-line-after          "Apagar linha depois do cursor"
             :command.editor/beginning-of-block       "Mover o cursor para o início do bloco"
             :command.editor/end-of-block             "Mover o cursor para o fim do bloco"
             :command.editor/forward-word             "Mover o cursor para a próxima palavra"
             :command.editor/backward-word            "Mover o cursor para a palavra anterior"
             :command.editor/forward-kill-word        "Apagar a próxima palavra"
             :command.editor/backward-kill-word       "Apagar a palavra anterior"
             :command.editor/open-edit                "Editar bloco selecionado"
             :command.editor/delete-selection         "Eliminar blocos selecionados"
             :command.editor/toggle-open-blocks       "Alternar blocos abertos (recolher ou expandir todos)"
             :command.auto-complete/complete          "Auto-completar: Escolha o item selecionado"
             :command.auto-complete/next              "Auto-completar: Selecione o próximo item"
             :command.auto-complete/prev              "Auto-completar: Selecione o item anterior"
             :command.auto-complete/shift-complete    "Auto-completar: Abra o item selecionado na barra lateral"
             :command.cards/forgotten                 "Cartas: Esquecido"
             :command.cards/next-card                 "Cartas: Próxima carta"
             :command.cards/recall                    "Cartas: Demorar um pouco para lembrar"
             :command.cards/remembered                "Cartas: Relembrado"
             :command.cards/toggle-answers            "Cartas: mostrar/esconder as respostas/clozes"
             :command.command/toggle-favorite         "Adicionar para/remover dos favoritos"
             :command.command-palette/toggle          "Editar atalhos"
             :command.date-picker/complete            "Pegar data: Escolha o dia selecionado"
             :command.date-picker/next-day            "Pegar data: Selecione o próximo dia"
             :command.date-picker/next-week           "Pegar data: Selecione a próxima semana"
             :command.date-picker/prev-day            "Pegar data: Selecione o dia anterior"
             :command.date-picker/prev-week           "Pegar data: Selecione a semana anterior"
             :command.editor/escape-editing           "Sair da edição"
             :command.editor/insert-youtube-timestamp "Inserir timestamp do youtube"
             :command.editor/paste-text-in-one-block-at-point "Colar texto em um bloco no ponto"
             :command.editor/replace-block-reference-at-point "Substitua a referência do bloco pelo seu conteúdo no ponto"
             :command.editor/strike-through           "Tachar"
             :command.go/all-pages                    "Ir para todas as páginas"
             :command.go/backward                     "Voltar"
             :command.go/flashcards                   "Trocar flashcards"
             :command.go/forward                      "Avançar"
             :command.go/graph-view                   "Ir para o gráfico"
             :command.go/home                         "Volar para o inicio"
             :command.go/keyboard-shortcuts           "Ir para os atalhos do teclado"
             :command.go/next-journal                 "Ir ao proximo jornal"
             :command.go/prev-journal                 "Ir ao jornal anterior"
             :command.go/tomorrow                     "Ir para amanhã"
             :command.graph/add                       "Adicionar um gráfico"
             :command.graph/open                      "Selecionar gráfico para abrir"
             :command.graph/remove                    "Remover um gráfico"
             :command.pdf/next-page                   "Próxima página do atual pdf doc"
             :command.pdf/previous-page               "Página anterior do atual pdf doc"
             :command.sidebar/clear                   "Limpar tudo da barra lateral direita"
             :command.sidebar/open-today-page         "Abrir a página de hoje na barra lateral direita"
             :command.ui/select-theme-color           "Selecionar as cores do tema disponível"
             :command.ui/toggle-cards                 "Trocar cartas"
             :command.ui/toggle-left-sidebar          "Trocar barra lateral esquerda"
             :command.auto-complete/open-link         "Auto-completar: Abra o item selecionado no navegador"
             :command.command/run                     "Execute o comando Git"
             :command.editor/copy-current-file        "Copiar o arquivo atual"
             :command.editor/open-file-in-default-app "Abra o arquivo no aplicativo padrão"
             :command.editor/open-file-in-directory   "Abra o arquivo na pasta"
             :command.graph/save                      "Salvar gráfico atual no computador"
             :command.misc/copy                       "Copiar (copiar seleção ou referência do bloco)"
             :command.ui/goto-plugins                 "Ir para o painel de plugins"
             :command.ui/open-new-window              "Abra uma nova janela"}

   :ja      {:shortcut.category/formatting                "フォーマット"
             :shortcut.category/basics                "基本操作"
             :shortcut.category/navigating            "ナビゲーション"
             :shortcut.category/block-editing         "ブロック単位の編集"
             :shortcut.category/block-command-editing "ブロック内の編集"
             :shortcut.category/block-selection       "ブロック選択"
             :shortcut.category/toggle                "トグル"
             :shortcut.category/others                "その他"
             :command.editor/indent                   "インデント"
             :command.editor/outdent                  "アウトデント"
             :command.editor/move-block-up            "ブロックを上へ移動"
             :command.editor/move-block-down          "ブロックを下へ移動"
             :command.editor/new-block                "新しいブロック"
             :command.editor/new-line                 "新しい行"
             :command.editor/zoom-in                  "ズームイン"
             :command.editor/zoom-out                 "ズームアウト"
             :command.editor/follow-link              "リンクを開く"
             :command.editor/open-link-in-sidebar     "サイドバーでリンクを開く"
             :command.editor/expand-block-children    "子ブロックを展開"
             :command.editor/collapse-block-children  "子ブロックを折り畳み"
             :command.editor/select-block-up          "上のブロックを選択"
             :command.editor/select-block-down        "下のブロックを選択"
             :command.editor/select-all-blocks        "全てのブロックを選択"
             :command.editor/replace-block-reference-at-point        "この場所でブロック参照をそのコンテンツで置き換え"
             :command.editor/paste-text-in-one-block-at-point        "カーソル位置へテキストとして貼り付け"
             :command.ui/toggle-help                  "ヘルプのトグル"
             :command.git/commit                      "コミット"
             :command.go/search                       "検索"
             :command.go/backward                     "戻る"
             :command.go/forward                      "前へ"
             :command.go/flashcards                   "フラッシュカードのトグル"
             :command.go/home                         "ホームへ移動"
             :command.go/all-pages                    "全ページへ移動"
             :command.go/graph-view                   "グラフビューへ移動"
             :command.go/tomorrow                     "明日へ移動"
             :command.go/next-journal                 "次の日誌へ移動"
             :command.go/prev-journal                 "前の日誌へ移動"
             :command.go/keyboard-shortcuts           "キーボードショートカットへ移動"
             :command.ui/open-new-window              "別のウィンドウを開く"
             :command.go/search-in-page               "ページ内を検索"
             :command.ui/toggle-document-mode         "ドキュメントモードのトグル"
             :command.ui/toggle-contents              "目次のトグル"
             :command.ui/toggle-theme                 "テーマのトグル"
             :command.ui/toggle-right-sidebar         "右サイドバーのトグル"
             :command.ui/toggle-settings              "トグル設定"
             :command.go/journals                     "日誌"
             :command.ui/toggle-wide-mode             "ワイドモードのトグル"
             :command.ui/toggle-brackets              "ブラケット表示On/Offのトグル"
             :command.search/re-index                 "インデックス再構築"
             :command.editor/bold                     "太字"
             :command.editor/italics                  "斜体"
             :command.editor/insert-link              "リンク挿入"
             :command.editor/highlight                "ハイライト"
             :command.editor/undo                     "元に戻す"
             :command.editor/redo                     "やり直し"
             :command.editor/copy                     "コピー"
             :command.editor/cut                      "切り取り"
             :command.editor/up                       "カーソル上移動 / 上を選択"
             :command.editor/down                     "カーソル下移動 / 下を選択"
             :command.editor/left                     "カーソル左移動 / 左を選択"
             :command.editor/right                    "カーソル右移動 / 右を選択"
             :command.editor/select-up                "上のコンテンツを選ぶ"
             :command.editor/select-down              "下のコンテンツを選ぶ"
             :command.editor/backspace                "前の文字を削除"
             :command.editor/delete                   "次の文字を削除"
             :command.editor/cycle-todo               "現在の項目の TODO 状態をローテートさせる"
             :command.editor/clear-block              "ブロックをクリア"
             :command.editor/kill-line-before         "行中のカーソル位置から前を削除"
             :command.editor/kill-line-after          "行中のカーソル位置から先を削除"
             :command.editor/beginning-of-block       "カーソルをブロックのはじめへ移動"
             :command.editor/end-of-block             "カーソルをブロックの最後へ移動"
             :command.editor/forward-word             "カーソルを次の単語へ移動"
             :command.editor/backward-word            "カーソルを前の単語へ移動"
             :command.editor/forward-kill-word        "次の単語を削除"
             :command.editor/backward-kill-word       "前の単語を削除"
             :command.editor/open-edit                "選択したブロックを編集"
             :command.editor/delete-selection         "選択したブロックを削除"
             :command.editor/toggle-open-blocks       "ブロック展開のトグル（全てのブロックを折りたたみ／展開）"
             :command.ui/toggle-cards                 "フラッシュカードのトグル"
             :command.ui/toggle-left-sidebar          "左サイドバーのトグル"
             :command.pdf/next-page                   "現在のPDF文書で次のページへ"
             :command.pdf/previous-page               "現在のPDF文書で前のページへ"
             :command.command/run                             "Git コマンドを実行"
             :command.command-palette/toggle                  "コマンドパレットのトグル"
             :command.graph/open                              "グラフを選択して開く"
             :command.graph/remove                            "グラフを削除"
             :command.graph/add                               "グラフを追加"
             :command.graph/save                              "現在のグラフをディスクへ保存"
             :command.sidebar/clear                           "右サイドバーの内容を全てクリア"
             :command.sidebar/open-today-page                 "今日の日誌を右サイドバーで開く"
             :command.editor/insert-youtube-timestamp         "YouTubeのタイプスタンプを挿入"
             :command.auto-complete/complete                  "自動補完：項目を選択"
             :command.auto-complete/prev                      "自動補完：前の項目を選択"
             :command.auto-complete/next                      "自動補完：次の項目を選択"
             :command.auto-complete/shift-complete            "自動補完：選択した項目をサイドバーで開く"
             :command.auto-complete/open-link                 "自動補完：選択したアイテムをブラウザで開く"
             :command.date-picker/complete                    "日付選択：選択した日で決定"
             :command.date-picker/prev-day                    "日付選択：前の日を選ぶ"
             :command.date-picker/next-day                    "日付選択：次の日を選ぶ"
             :command.date-picker/prev-week                   "日付選択：前の週を選ぶ"
             :command.date-picker/next-week                   "日付選択：次の週を選ぶ"
             :command.cards/forgotten                         "カード：忘れられた"
             :command.cards/next-card                         "カード：次のカード"
             :command.cards/recall                            "カード：思い出すのに時間がかかる"
             :command.cards/remembered                        "カード：覚えている"
             :command.cards/toggle-answers                    "カード：答えや穴埋めの表示／隠すのトグル"
             :command.command/toggle-favorite                 "お気に入りへの追加／削除のトグル"
             :command.editor/copy-current-file                "現在のファイルをコピー"
             :command.editor/escape-editing                   "編集をやめる"
             :command.editor/open-file-in-default-app         "ファイルを規定のアプリで開く"
             :command.editor/open-file-in-directory           "ファイルをディレクトリで開く"
             :command.editor/strike-through                   "打ち消し線"
             :command.misc/copy                               "コピー"
             :command.ui/goto-plugins                         "プラグインへ"
             :command.ui/select-theme-color                   "利用可能なテーマ色を選択"}

   :it      {:command.date-picker/complete         "Selettore data: scegli il giorno selezionato"
             :command.date-picker/prev-day         "Selettore data: Seleziona il giorno precedente"
             :command.date-picker/next-day         "Selettore data: Seleziona il giorno successivo"
             :command.date-picker/prev-week        "Selettore data: Seleziona la settimana precedente"
             :command.date-picker/next-week        "Selettore data: Seleziona la settimana successiva"
             :command.pdf/previous-page            "Pagina precedente del pdf corrente"
             :command.pdf/next-page                "Pagina successiva del pdf corrente"
             :command.auto-complete/complete       "Auto completamento: Scegli l'oggetto selezionato"
             :command.auto-complete/prev           "Auto completamento: Seleziona l'oggetto precedente"
             :command.auto-complete/next           "Auto completamento: Seleziona l'oggetto successivo"
             :command.auto-complete/shift-complete "Auto completamento: Apri l'oggetto selezionato nella barra laterale"
             :command.auto-complete/open-link      "Auto completamento: Apri l'oggetto selezionato nel browser"
             :command.cards/toggle-answers         "Carte: mostra/nascondi risposte/chiusure"
             :command.cards/next-card              "Carte: prossima carta"
             :command.cards/forgotten              "Carte: dimenticato"
             :command.cards/remembered             "Carte: ricordato"
             :command.cards/recall                 "Carte: ci ho messo un pò a ricordarlo"
             :command.editor/escape-editing        "Esci dalla modifica"
             :command.editor/backspace             "Tasto Backspace / Cancella all'indietro"
             :command.editor/delete                "Tasto Delete / Cancella avanti"
             :command.editor/new-block             "Crea un nuovo blocco"
             :command.editor/new-line              "Nuova riga accapo nel blocco attuale"
             :command.editor/follow-link           "Segui il link sotto al cursore"
             :command.editor/open-link-in-sidebar  "Apri il link nella barra laterale"
             :command.editor/bold                  "Grassetto"
             :command.editor/italics               "Corsivo"
             :command.editor/highlight             "Evidenzia"
             :command.editor/strike-through        "Barrato"
             :command.editor/clear-block           "Elimina l'intero contenuto del blocco"
             :command.editor/kill-line-before      "Cancella la riga prima della posizione del cursore"
             :command.editor/kill-line-after       "Cancella la riga dopo la posizione del cursore"
             :command.editor/beginning-of-block    "Muovi il cursore all'inizio di un blocco"
             :command.editor/end-of-block          "Muovi il cursore alla fine di un blocco"
             :command.editor/forward-word          "Muovi il cursore in avanti di una parola"
             :command.editor/backward-word         "Muovi il cursore all'indietro di una parola"
             :command.editor/forward-kill-word     "Elimina una parola in avanti"
             :command.editor/backward-kill-word    "Elimina una parola all'indietro"
             :command.editor/replace-block-reference-at-point "Sostituisci il riferimento di blocco con il suo contenuto al punto"
             :command.editor/paste-text-in-one-block-at-point "Incolla testo in un blocco al punto"
             :command.editor/insert-youtube-timestamp         "Inserisci marca temporale di youtube"
             :command.editor/cycle-todo              "Cicla lo stato TODO dell'elemento corrente"
             :command.editor/up                      "Muovi il cursore sopra / Seleziona sopra"
             :command.editor/down                    "Muovi il cursore sotto / Seleziona sotto"
             :command.editor/left                    "Muovi il cursore a sinistra / Apri il blocco selezionato all'inizio"
             :command.editor/right                   "Muovi il cursore a destra / Apri il blocco selezionato all'inizio"
             :command.editor/select-up               "Seleziona il contenuto sopra"
             :command.editor/select-down             "Seleziona il contenuto sotto"
             :command.editor/move-block-up           "Muovi il blocco sopra"
             :command.editor/move-block-down         "Muovi il blocco sotto"
             :command.editor/open-edit               "Modifica il blocco selezionato"
             :command.editor/select-block-up         "Seleziona blocco sopra"
             :command.editor/select-block-down       "Seleziona blocco sotto"
             :command.editor/delete-selection        "Elimina i blocchi selezionati"
             :command.editor/expand-block-children   "Espandi"
             :command.editor/collapse-block-children "Collassa"
             :command.editor/indent                  "Rientra blocco"
             :command.editor/outdent                 "Annulla il rientro blocco"
             :command.editor/copy                    "Copia (copia una selezione o un riferimento di blocco)"
             :command.editor/cut                     "Taglia"
             :command.editor/undo                    "Annulla"
             :command.editor/redo                    "Rifai"
             :command.editor/insert-link             "Link HTML"
             :command.editor/select-all-blocks       "Seleziona tutti i blocchi"
             :command.editor/zoom-in                 "Ingrandisci blocco di modifica / Avanti altrimenti"
             :command.editor/zoom-out                "Rimpicciolisci il blocco di modifica / Indietro altrimenti"
             :command.ui/toggle-brackets             "Selezionare se visualizzare le parentesi"
             :command.go/search-in-page              "Cerca nella pagina attuale"
             :command.go/search                      "Ricerca testo completo"
             :command.go/journals                    "Vai ai diari"
             :command.go/backward                    "Indietro"
             :command.go/forward                     "Avanti"
             :command.search/re-index                "Ricostruisci indice di ricerca"
             :command.sidebar/open-today-page        "Apri la pagina di oggi nella barra laterale destra"
             :command.sidebar/clear                  "Pulisci tutto nella barra laterale destra"
             :command.misc/copy                      "mod+c"
             :command.command-palette/toggle         "Attiva/disattiva tavolozza comandi"
             :command.graph/open                     "Seleziona il diagramma da aprire"
             :command.graph/remove                   "Rimuovi un diagramma"
             :command.graph/add                      "Aggiungi un diagramma"
             :command.graph/save                     "Salva il diagramma corrente su disco"
             :command.command/run                    "Esegui comando git"
             :command.go/home                        "Vai all'inizio"
             :command.go/all-pages                   "Vai a tutte le pagine"
             :command.go/graph-view                  "Vai alla visualizzazione diagramma"
             :command.go/keyboard-shortcuts          "Vai alle scorciatoie da tastiera"
             :command.go/tomorrow                    "Vai a domani"
             :command.go/next-journal                "Vai al prossimo diario"
             :command.go/prev-journal                "Vai al diario precedente"
             :command.go/flashcards                  "Attiva/disattiva carte flash"
             :command.ui/toggle-document-mode        "Attiva/disattiva modalità documento"
             :command.ui/toggle-settings             "Attiva/disattiva impostazioni"
             :command.ui/toggle-right-sidebar        "Attiva/disattiva barra laterale destra"
             :command.ui/toggle-left-sidebar         "Attiva/disattiva barra laterale sinistra"
             :command.ui/toggle-help                 "Attiva/disattiva aiuto"
             :command.ui/toggle-theme                "Passa dal tema scuro a quello chiaro"
             :command.ui/toggle-contents             "Attiva/disattiva i contenuti nella barra laterale"
             :command.ui/open-new-window             "Apri un'altra finestra"
             :command.command/toggle-favorite        "Aggiungi a/rimuovi dai preferiti"
             :command.editor/open-file-in-default-app "Apri file nell'app predefinita"
             :command.editor/open-file-in-directory   "Apri file nella directory principale"
             :command.editor/copy-current-file        "Copia file corrente"
             :command.ui/toggle-wide-mode             "Attiva/disattiva modalità ampia"
             :command.ui/select-theme-color           "Seleziona i colori del tema disponibili"
             :command.ui/goto-plugins                 "Vai alla dashboard dei plugin"
             :command.editor/toggle-open-blocks       "Attiva/disattiva i blocchi aperti (comprimi o espandi tutti i blocchi)"
             :command.ui/toggle-cards                 "Attiva/disattiva le carte"
             :command.git/commit                      "Git messaggio di commit"
             :shortcut.category/basics                "Nozioni di base"
             :shortcut.category/formatting            "Formattazione"
             :shortcut.category/navigating            "Navigazione"
             :shortcut.category/block-editing         "Modiifica blocco generale"
             :shortcut.category/block-command-editing "Modifica comandi blocco"
             :shortcut.category/block-selection       "Selezione blocco (premi Esc per uscire dalla selezione)"
             :shortcut.category/toggle                "Attiva/disattiva"
             :shortcut.category/others                "Altri"

   }
   :tr      {:shortcut.category/basics "Temel bilgiler"
             :shortcut.category/formatting "Biçimlendirme"
             :shortcut.category/navigating "Gezinme"
             :shortcut.category/block-editing "Genel blok düzenleme"
             :shortcut.category/block-command-editing "Blok düzenleme komutuları"
             :shortcut.category/block-selection "Blok seçimi (seçimden çıkmak için Esc tuşuna basın)"
             :shortcut.category/toggle "Aç/Kapat"
             :shortcut.category/others "Diğer"
             :command.date-picker/complete         "Tarih seçici: Seçilen günü seç"
             :command.date-picker/prev-day         "Tarih seçici: Önceki günü seç"
             :command.date-picker/next-day         "Tarih seçici: Sonraki günü seç"
             :command.date-picker/prev-week        "Tarih seçici: Önceki haftayı seç"
             :command.date-picker/next-week        "Tarih seçici: Sonraki haftayı seç"
             :command.pdf/previous-page            "Geçerli pdf belgesinin önceki sayfası"
             :command.pdf/next-page                "Geçerli pdf belgesinin sonraki sayfası"
             :command.auto-complete/complete       "Otomatik tamamlama: Seçili öğeyi seç"
             :command.auto-complete/prev           "Otomatik tamamlama: Önceki öğeyi seç"
             :command.auto-complete/next           "Otomatik tamamlama: Sonraki öğeyi seç"
             :command.auto-complete/shift-complete "Otomatik tamamlama: Seçili öğeyi kenar çubuğunda aç"
             :command.auto-complete/open-link      "Otomatik tamamlama: Seçili öğeyi tarayıcıda aç"
             :command.cards/toggle-answers         "Kartlar: cevapları ve cümle tamamlamayı göster/gizle"
             :command.cards/next-card              "Kartlar: sonraki kart"
             :command.cards/forgotten              "Kartlar: unutuldu"
             :command.cards/remembered             "Kartlar: hatırlandı"
             :command.cards/recall                 "Kartlar: hatırlamak biraz zaman aldı"
             :command.editor/escape-editing        "Düzenlemeden çık"
             :command.editor/backspace             "Geri tuşu (Backspace) / Geriye doğru sil"
             :command.editor/delete                "Silme tuşu (Delete) / İleriye doğru sil"
             :command.editor/new-block             "Yeni blok oluştur"
             :command.editor/new-line              "Geçerli blokta yeni satır"
             :command.editor/follow-link           "İmlecin altındaki bağlantıyı takip et"
             :command.editor/open-link-in-sidebar  "Bağlantıyı kenar çubuğunda aç"
             :command.editor/bold                  "Kalın"
             :command.editor/italics               "İtalik"
             :command.editor/highlight             "Vurgulu"
             :command.editor/strike-through        "Üstü çizili"
             :command.editor/clear-block           "Tüm blok içeriğini sil"
             :command.editor/kill-line-before      "İmleç konumundan önceki satırı sil"
             :command.editor/kill-line-after       "İmleç konumundan sonraki satırı sil"
             :command.editor/beginning-of-block    "İmleci bir bloğun başına taşı"
             :command.editor/end-of-block          "İmleci bir bloğun sonuna taşı"
             :command.editor/forward-word          "İmleci bir kelime ileri götür"
             :command.editor/backward-word         "İmleci bir kelime geri götür"
             :command.editor/forward-kill-word     "İleriye doğru bir kelimeyi sil"
             :command.editor/backward-kill-word    "Geriye doğru bir kelimeyi sil"
             :command.editor/replace-block-reference-at-point "Blok referansını bu konumdaki içeriğiyle değiştirin"
             :command.editor/paste-text-in-one-block-at-point "İmleç konumunda metin olarak yapıştırın"
             :command.editor/insert-youtube-timestamp         "Youtube zaman damgası ekle"
             :command.editor/cycle-todo              "Geçerli öğenin TODO durumunu değiştir"
             :command.editor/up                      "İmleci yukarı taşı / Yukarıyı seç"
             :command.editor/down                    "İmleci aşağı taşı / Aşağı seç"
             :command.editor/left                    "İmleci sola hareket ettir / Seçili bloğu aç ve başına git"
             :command.editor/right                   "İmleci sağa hareket ettir / Seçili bloğu aç ve sonuna git"
             :command.editor/select-up               "Yukarıdaki içeriği seçin"
             :command.editor/select-down             "Aşağıdaki içeriği seçin"
             :command.editor/move-block-up           "Bloğu yukarı taşı"
             :command.editor/move-block-down         "Bloğu aşağı taşı"
             :command.editor/open-edit               "Seçili bloğu düzenle"
             :command.editor/select-block-up         "Yukarıdaki bloğu seçin"
             :command.editor/select-block-down       "Aşağıdaki bloğu seçin"
             :command.editor/delete-selection        "Seçili blokları sil"
             :command.editor/expand-block-children   "Genişlet"
             :command.editor/collapse-block-children "Daralt"
             :command.editor/indent                  "Bloğu girintile"
             :command.editor/outdent                 "Blok girintisini azalt"
             :command.editor/copy                    "Kopyala (seçimi veya blok referansını kopyalar)"
             :command.editor/cut                     "Kes"
             :command.editor/undo                    "Geri al"
             :command.editor/redo                    "Tinele"
             :command.editor/insert-link             "HTML Bağlantısı"
             :command.editor/select-all-blocks       "Tüm blokları seç"
             :command.editor/zoom-in                 "Düzenlenen bloğu yakınlaştır / Aksi takdirde ileri git"
             :command.editor/zoom-out                "Düzenlenen bloğu uzaklaştır / Aksi takdirde geri git"
             :command.ui/toggle-brackets             "Köşeli ayraçların görüntülenip görüntülenmeyeceğini değiştir"
             :command.go/search-in-page              "Geçerli sayfada ara"
             :command.go/search                      "Tam metin araması"
             :command.go/journals                    "Günlüğe git"
             :command.go/backward                    "Geriye git"
             :command.go/forward                     "İleriye git"
             :command.search/re-index                "Arama dizinini yeniden oluştur"
             :command.sidebar/open-today-page        "Sağ kenar çubuğunda bugünün sayfasını açın"
             :command.sidebar/clear                  "Sağ kenar çubuğundaki herşeyi temizle"
             :command.misc/copy                      "mod+c"
             :command.command-palette/toggle         "Komut paletini aç"
             :command.graph/open                     "Açılacak grafiği seçin"
             :command.graph/remove                   "Bir grafiği kaldır"
             :command.graph/add                      "Grafik ekle"
             :command.graph/save                     "Mevcut grafiği diske kaydet"
             :command.command/run                    "Git komutunu çalıştır"
             :command.go/home                        "Ana sayfaya git"
             :command.go/all-pages                   "Bütün sayfalara git"
             :command.go/graph-view                  "Grafik görünümüne git"
             :command.go/keyboard-shortcuts          "Klavye kısayollarına git"
             :command.go/tomorrow                    "Yarının günlüğüne git"
             :command.go/next-journal                "Sonraki günlüğe git"
             :command.go/prev-journal                "Önceki günlüğe git"
             :command.go/flashcards                  "Bilgi kartlarına git"
             :command.ui/toggle-document-mode        "Belge modunu aç/kapat"
             :command.ui/toggle-settings             "Ayarları aç/kapat"
             :command.ui/toggle-right-sidebar        "Sağ kenar çubuğunu aç/kapat"
             :command.ui/toggle-left-sidebar         "Sol kenar çubuğunu aç/kapat"
             :command.ui/toggle-help                 "Yardımı aç/kapat"
             :command.ui/toggle-theme                "Koyu ve açık tema arasında geçiş yap"
             :command.ui/toggle-contents             "Kenar çubuğundaki içeriği aç/kapat"
             :command.ui/open-new-window             "Başka bir pencere aç"
             :command.command/toggle-favorite        "Sık kullanılanlara ekle/çıkar"
             :command.editor/open-file-in-default-app "Dosyayı varsayılan uygulamada aç"
             :command.editor/open-file-in-directory   "Dosyayı üst dizinde aç"
             :command.editor/copy-current-file        "Geçerli dosyayı kopyala"
             :command.ui/toggle-wide-mode             "Geniş modu aç/kapat"
             :command.ui/select-theme-color           "Kullanılabilir tema renklerini seçin"
             :command.ui/goto-plugins                 "Eklentiler panosuna git"
             :command.editor/toggle-open-blocks       "Açık blokları kapat/aç (tüm blokları daralt veya genişlet)"
             :command.ui/toggle-cards                 "Kartları aç/kapat"
             :command.git/commit                      "Git commit mesajı"}})
