//
// Copyright 2016 Pixar
//
// Licensed under the Apache License, Version 2.0 (the "Apache License")
// with the following modification; you may not use this file except in
// compliance with the Apache License and the following modification to it:
// Section 6. Trademarks. is deleted and replaced with:
//
// 6. Trademarks. This License does not grant permission to use the trade
//    names, trademarks, service marks, or product names of the Licensor
//    and its affiliates, except as required to comply with Section 4(c) of
//    the License and to reproduce the content of the NOTICE file.
//
// You may obtain a copy of the Apache License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the Apache License with the above modification is
// distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied. See the Apache License for the specific
// language governing permissions and limitations under the Apache License.
//

#line 3 "<stdout>"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 39
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

/* For convenience, these vars (plus the bison vars far below)
   are macros in the reentrant scanner. */
#define yyin yyg->yyin_r
#define yyout yyg->yyout_r
#define yyextra yyg->yyextra_r
#define yyleng yyg->yyleng_r
#define yytext yyg->yytext_r
#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)
#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)
#define yy_flex_debug yyg->yy_flex_debug_r

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yyg->yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yyg->yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE textFileFormatYyrestart(yyin ,yyscanner )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = yyg->yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yyg->yy_c_buf_p = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yyg->yytext_ptr , yyscanner )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	yy_size_t yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via textFileFormatYyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( yyg->yy_buffer_stack \
                          ? yyg->yy_buffer_stack[yyg->yy_buffer_stack_top] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE yyg->yy_buffer_stack[yyg->yy_buffer_stack_top]

void textFileFormatYyrestart (FILE *input_file ,yyscan_t yyscanner );
void textFileFormatYy_switch_to_buffer (YY_BUFFER_STATE new_buffer ,yyscan_t yyscanner );
YY_BUFFER_STATE textFileFormatYy_create_buffer (FILE *file,int size ,yyscan_t yyscanner );
void textFileFormatYy_delete_buffer (YY_BUFFER_STATE b ,yyscan_t yyscanner );
void textFileFormatYy_flush_buffer (YY_BUFFER_STATE b ,yyscan_t yyscanner );
void textFileFormatYypush_buffer_state (YY_BUFFER_STATE new_buffer ,yyscan_t yyscanner );
void textFileFormatYypop_buffer_state (yyscan_t yyscanner );

static void textFileFormatYyensure_buffer_stack (yyscan_t yyscanner );
static void textFileFormatYy_load_buffer_state (yyscan_t yyscanner );
static void textFileFormatYy_init_buffer (YY_BUFFER_STATE b,FILE *file ,yyscan_t yyscanner );

#define YY_FLUSH_BUFFER textFileFormatYy_flush_buffer(YY_CURRENT_BUFFER ,yyscanner)

YY_BUFFER_STATE textFileFormatYy_scan_buffer (char *base,yy_size_t size ,yyscan_t yyscanner );
YY_BUFFER_STATE textFileFormatYy_scan_string (yyconst char *yy_str ,yyscan_t yyscanner );
YY_BUFFER_STATE textFileFormatYy_scan_bytes (yyconst char *bytes,yy_size_t len ,yyscan_t yyscanner );

void *textFileFormatYyalloc (yy_size_t ,yyscan_t yyscanner );
void *textFileFormatYyrealloc (void *,yy_size_t ,yyscan_t yyscanner );
void textFileFormatYyfree (void * ,yyscan_t yyscanner );

#define yy_new_buffer textFileFormatYy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        textFileFormatYyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            textFileFormatYy_create_buffer(yyin,YY_BUF_SIZE ,yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        textFileFormatYyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            textFileFormatYy_create_buffer(yyin,YY_BUF_SIZE ,yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define textFileFormatYywrap(yyscanner) 1
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

typedef int yy_state_type;

#define yytext_ptr yytext_r

static yy_state_type yy_get_previous_state (yyscan_t yyscanner );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  ,yyscan_t yyscanner);
static int yy_get_next_buffer (yyscan_t yyscanner );
static void yy_fatal_error (yyconst char msg[] ,yyscan_t yyscanner );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yyg->yytext_ptr = yy_bp; \
	yyleng = (size_t) (yy_cp - yy_bp); \
	yyg->yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yyg->yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 69
#define YY_END_OF_BUFFER 70
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[396] =
    {   0,
        0,    0,    0,    0,   70,   68,    1,    7,    7,   68,
        2,   67,   68,   67,   67,   68,   62,   68,   67,   49,
       49,   68,   49,   49,   49,   49,   49,   49,   49,   49,
       49,   49,   49,   49,   49,   49,    5,    5,    5,    5,
        5,    1,    7,    0,    0,    0,    2,    0,    0,    0,
        0,   61,   63,    0,   65,    4,    3,   64,   62,    0,
        0,   52,    0,   53,   49,    0,   49,   68,   49,   49,
       49,   49,   49,   49,   49,   49,   49,   49,   49,   49,
       49,   49,   49,   49,   49,   49,   49,   49,   49,   49,
       49,   49,   49,   49,    6,   56,   58,    0,    0,   56,

        0,   55,   57,    0,    0,   55,    0,    0,    0,    3,
       64,    0,   64,   53,    0,    0,   51,   49,    8,   49,
       49,   49,   49,   16,   49,   49,   49,   20,   49,   49,
       49,   49,   49,   49,   49,   49,   49,   49,   49,   34,
       49,   49,   49,   49,   49,   49,   49,   49,   49,   49,
        0,    0,    0,    0,    0,    0,   66,    0,   65,    0,
        0,    0,   50,   51,    0,   25,   49,   49,   49,   49,
       49,   49,   49,   49,   49,   49,   22,   49,   49,   49,
       27,   49,   49,   49,   49,   49,   49,   49,   49,   49,
       49,   49,   49,   49,   49,   49,   49,   49,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,   50,    0,
       49,   10,   49,   49,   49,   49,   49,   49,   49,   49,
       49,   49,   49,   49,   49,   49,   49,   49,   49,   49,
       49,   37,   49,   49,   49,   49,   49,   49,   49,   49,
       60,    0,   59,    0,   54,    0,   49,   11,   49,   13,
       49,   17,   49,   49,   49,   23,   49,   26,   49,   49,
       49,   49,   49,   49,   49,   49,   49,   49,   49,   49,
       49,   49,   49,   49,   60,   59,   54,   54,   49,   12,
       49,   15,   49,   49,   49,   49,   28,   49,   49,   49,
       49,   49,   35,   49,   49,   49,   49,   49,   49,   44,

       49,   48,   54,   54,   49,   49,   49,   49,   21,   49,
       49,   49,   49,   49,   49,   49,   49,   49,   49,   49,
       49,   49,   47,   54,   49,   49,   49,   49,   49,   49,
       49,   49,   49,   33,   36,   49,   38,   49,   49,   49,
       49,   49,    9,   14,   18,   49,   49,   29,   49,   31,
       32,   49,   49,   49,   49,   49,   45,   19,   49,   49,
       40,   49,   49,   49,   43,   46,   24,   49,   49,   49,
       49,   49,   49,   49,   49,   49,   49,   49,   49,   49,
       49,   49,   49,   49,   49,   49,   42,   49,   49,   41,
       49,   49,   30,   39,    0

    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    5,    6,    7,    8,    9,    6,    9,   10,    9,
        9,   11,   12,    9,   13,   14,   15,   16,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   18,    9,   19,
        9,   20,    6,   21,   22,   23,   24,   25,   26,   27,
       23,   23,   23,   23,   23,   28,   23,   29,   23,   30,
       23,   23,   31,   23,   32,   23,   23,   23,   23,   23,
        9,   33,    9,    6,   23,    6,   34,   35,   36,   37,

       38,   39,   40,   41,   42,   23,   43,   44,   45,   46,
       47,   48,   23,   49,   50,   51,   52,   53,   23,   54,
       55,   56,    9,    6,    9,    6,    1,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,

        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6
    } ;

static yyconst flex_int32_t yy_meta[57] =
    {   0,
        1,    1,    2,    3,    4,    4,    4,    4,    4,    4,
        4,    4,    4,    4,    4,    5,    5,    6,    7,    4,
        4,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    4,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8
    } ;

static yyconst flex_int16_t yy_base[417] =
    {   0,
        0,    0,   54,   56,  917,  918,   59,  918,  913,   55,
        0,  918,   53,   52,   54,   61,   64,  895,  893,  895,
       56,  866,   55,   57,   73,   59,   65,   61,   64,   75,
       78,   79,   82,   66,   67,  101,  918,  918,  918,  896,
      864,  119,  918,   92,  902,  125,    0,  100,  898,  132,
      106,  124,  129,  861,  131,  918,    0,  135,  154,  147,
      886,  918,  884,  883,  885,  884,  126,  918,  138,  131,
      156,  135,  136,  158,  148,  159,  160,  161,  165,  167,
      169,  171,  170,  173,  176,  182,  181,  185,  178,  192,
      175,  187,  188,  186,  918,  918,  918,  204,  208,  210,

      229,  918,  918,  214,  224,  228,  235,  862,  236,    0,
      234,  238,  242,  918,  223,    0,  882,  228,  881,  222,
      224,  245,  246,  247,  249,  251,  252,  880,  255,  257,
      258,  260,  259,  261,  264,  262,  265,  267,  274,  270,
      271,  268,  272,  277,  283,  285,  278,  287,  296,  300,
      314,  890,  319,  317,  886,  326,  918,  314,  316,  307,
      342,  316,  877,  876,  875,  874,  316,  320,  323,  330,
      333,  321,  335,  336,  338,  339,  873,  343,  342,  346,
      872,  344,  351,  353,  349,  354,  356,  357,  359,  358,
      365,  367,  372,  361,  379,  380,  382,  384,  882,  397,

      398,  405,  878,  396,  399,  408,  418,  432,  869,  868,
      405,  866,  397,  406,  399,  407,  410,  425,  427,  428,
      429,  432,  431,  434,  436,  437,  438,  439,  440,  441,
      444,  846,  442,  445,  447,  446,  449,  453,  448,  457,
      918,  832,  918,  822,  810,  503,  462,  805,  466,  463,
      467,  789,  474,  471,  472,  778,  477,  769,  478,  480,
      481,  490,  491,  492,  493,  498,  495,  507,  503,  504,
      509,  510,  511,  517,  776,  772,  754,  511,  513,  756,
      515,  749,  518,  528,  520,  529,  748,  530,  532,  533,
      538,  540,  741,  541,  543,  545,  547,  548,  549,  740,

      550,  729,  918,  586,  553,  551,  559,  558,  728,  561,
      562,  575,  574,  577,  564,  578,  565,  583,  587,  598,
      588,  593,  727,  633,  595,  605,  600,  599,  601,  606,
      608,  609,  611,  726,  722,  622,  721,  612,  620,  624,
      625,  626,  718,  716,  715,  628,  629,  713,  630,  711,
      710,  633,  631,  635,  638,  639,  646,  704,  647,  648,
      703,  650,  652,  655,  700,  699,  451,  654,  656,  653,
      660,  662,  667,  668,  670,  669,  676,  677,  679,  682,
      683,  681,  684,  690,  691,  685,  395,  695,  697,  281,
      692,  698,  200,  121,  918,  748,  756,  764,  772,  780,

      785,  789,  797,  805,  813,  821,  829,  832,  840,  848,
      853,  123,  857,  865,  873,  877
    } ;

static yyconst flex_int16_t yy_def[417] =
    {   0,
      395,    1,  396,  396,  395,  395,  395,  395,  395,  397,
      398,  395,  399,  395,  395,  395,  395,  400,  401,  402,
      402,  395,  402,  402,  402,  402,  402,  402,  402,  402,
      402,  402,  402,  402,  402,  402,  395,  395,  395,  395,
      395,  395,  395,  397,  403,  404,  398,  399,  405,  406,
      395,  395,  395,  395,  395,  395,  407,  395,  395,  395,
      400,  395,  401,  395,  402,  408,  402,  395,  402,  402,
      402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
      402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
      402,  402,  402,  402,  395,  395,  395,  409,  397,  397,

      404,  395,  395,  410,  399,  399,  406,  395,  395,  407,
      395,  395,  395,  395,  411,  412,  413,  402,  402,  402,
      402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
      402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
      402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
      409,  409,  414,  410,  410,  415,  395,  395,  395,  411,
      411,  411,  416,  413,  408,  402,  402,  402,  402,  402,
      402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
      402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
      402,  402,  402,  402,  402,  402,  402,  402,  409,  409,

      414,  414,  410,  410,  415,  415,  411,  411,  416,  395,
      402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
      402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
      402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
      395,  409,  395,  410,  395,  411,  402,  402,  402,  402,
      402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
      402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
      402,  402,  402,  402,  409,  410,  395,  411,  402,  402,
      402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
      402,  402,  402,  402,  402,  402,  402,  402,  402,  402,

      402,  402,  395,  411,  402,  402,  402,  402,  402,  402,
      402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
      402,  402,  402,  411,  402,  402,  402,  402,  402,  402,
      402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
      402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
      402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
      402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
      402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
      402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
      402,  402,  402,  402,    0,  395,  395,  395,  395,  395,

      395,  395,  395,  395,  395,  395,  395,  395,  395,  395,
      395,  395,  395,  395,  395,  395
    } ;

static yyconst flex_int16_t yy_nxt[975] =
    {   0,
        6,    7,    8,    9,    7,    6,   10,   11,   12,   13,
        6,    6,   14,   15,   16,   17,   17,   12,   18,    6,
       19,   20,   20,   20,   20,   20,   20,   20,   21,   20,
       20,   20,   22,   23,   20,   24,   25,   20,   20,   20,
       20,   26,   27,   20,   28,   29,   30,   31,   32,   33,
       34,   35,   36,   20,   20,   20,   38,   39,   38,   39,
       42,   45,   49,   42,   40,   51,   40,   52,   53,   55,
       55,   56,   66,   66,   66,   57,   66,   58,   66,   59,
       59,   66,   66,   66,   66,   50,   41,   46,   41,   60,
       66,   69,   66,   54,   79,   66,   66,   80,   96,   66,

       71,   60,   67,   72,   77,   70,   78,   92,   73,  102,
       74,   83,   93,   81,   75,   84,   86,   88,   66,   76,
       42,   55,   55,   42,   46,   87,   85,   82,   44,   89,
      163,  100,   50,   90,   94,   48,   91,   58,   66,   53,
       53,  106,   58,   66,   53,   53,   55,   55,   66,   60,
      111,  111,   66,   66,   60,   66,  109,  101,  112,  112,
       60,   60,  113,  113,  107,   66,   60,   58,  109,   59,
       59,  118,   60,   66,  119,   66,   66,   66,   66,   60,
      122,  120,   66,  126,   66,  123,   66,   66,   66,  121,
       66,   60,   66,   66,  128,   66,  124,  127,   66,   66,

      129,  125,   66,   66,   66,   66,  130,  133,  134,   66,
      152,  132,  131,  137,   96,  144,   96,   66,  143,  147,
      139,  136,  138,  155,  135,  140,  145,  142,  141,  149,
      146,  148,   44,  102,  150,  100,  153,  102,   48,   66,
       46,   66,   46,  161,  106,   66,  156,  158,  158,  111,
      111,  159,  159,  113,  113,  162,   50,  113,  113,   60,
       50,  101,   66,   66,   66,  166,   66,  107,   66,   66,
      167,   60,   66,  168,   66,   66,   66,   66,   66,   66,
      172,   66,   66,  169,   66,   66,  173,   66,   66,   66,
      170,   66,  176,  177,   66,   66,  171,  179,   66,  175,

       66,  174,   66,  184,   66,  178,  183,  182,  180,  181,
      192,  186,  191,   66,  185,  190,  187,   66,  189,  188,
      152,  151,  194,  193,  195,  201,  155,  161,  154,  159,
      159,  159,  159,   66,  196,  205,  208,   66,   66,  162,
       66,  197,  160,  160,  160,  160,  153,   66,  162,  156,
       66,  202,   66,   66,  198,   66,   66,  211,  206,   66,
       66,   66,  207,   66,  213,  222,   66,  214,   66,  212,
       66,   66,  216,   66,   66,   66,   66,  218,   66,  215,
      221,  219,   66,  223,   66,  217,  227,  220,  231,   66,
      224,  229,  225,  230,  226,  232,   66,   66,  236,   66,

      234,   66,  228,  152,  242,  155,  233,  151,  244,  237,
      154,  201,   66,  235,   66,  239,   66,  205,  160,  160,
      160,  160,   66,   66,   66,  240,  238,   66,  156,  153,
      202,  206,  160,  160,  160,  160,  248,  202,  245,  247,
      206,  249,   66,  250,   66,   66,   66,  252,   66,   66,
      251,   66,  246,   66,   66,   66,   66,   66,   66,   66,
      254,   66,   66,   66,   66,   66,   66,  259,   66,  255,
       66,  253,  257,  264,   66,  267,  263,  256,  265,   66,
       66,  258,  271,   66,   66,  260,  262,  281,   66,   66,
      261,   66,  266,  273,   66,   66,  270,   66,   66,  268,

      269,  272,  274,  160,  160,  160,  160,   66,   66,   66,
       66,  289,   66,  279,  287,   66,  280,  282,  286,  283,
       66,   66,  285,  278,   66,  284,   66,   66,   66,  288,
       66,  304,   66,  297,   66,   66,  291,   66,  295,  294,
      290,  293,  292,  162,  296,   66,   66,   66,  306,   66,
       66,  307,  298,  299,  300,   66,  302,   66,   66,  308,
       66,  301,   66,  305,   66,   66,   66,   66,   66,  309,
       66,  311,  310,  314,  313,   66,   66,  315,   66,   66,
      322,   66,   66,  312,  317,  316,  160,  160,  160,  160,
      325,   66,   66,  318,   66,   66,  321,  329,  319,  323,

       66,  326,  320,  328,   66,   66,  324,  327,  330,  331,
       66,  332,   66,  334,  333,   66,   66,   66,   66,  339,
      336,  338,   66,   66,  340,   66,   66,  335,   66,   66,
      342,  341,  337,  160,  160,  160,  160,   66,  344,   66,
      346,   66,   66,   66,  343,   66,   66,   66,   66,  347,
       66,  348,   66,  245,  345,   66,   66,  349,  350,  352,
      351,  353,  356,   66,   66,   66,  359,   66,  354,   66,
       66,   66,   66,   66,  363,  355,  357,   66,  358,   66,
      360,  362,  361,  364,   66,   66,   66,   66,  365,  368,
      371,  369,  367,   66,   66,  366,   66,  374,   66,   66,

       66,   66,   66,  370,  372,  378,  373,   66,   66,   66,
      375,  379,   66,  376,   66,   66,   66,   66,  377,  380,
       66,   66,  382,  384,  385,  383,  381,   66,   66,  387,
       66,  386,   66,   66,  390,   66,  388,  389,   66,   66,
      391,  393,  392,   66,   66,   66,   66,  394,   37,   37,
       37,   37,   37,   37,   37,   37,   44,   66,   66,   44,
       44,   44,   44,   44,   47,   66,   66,   47,   47,   47,
       47,   47,   48,   66,  303,   48,   48,   48,   48,   48,
       61,  243,  241,   61,   61,   61,   66,   61,   63,   63,
       63,   63,   63,   65,   65,   66,   65,   97,   97,   97,

       97,   97,   97,   97,   97,   99,   66,   99,   99,   99,
       99,   99,   99,  103,  103,  103,  103,  103,  103,  103,
      103,  105,   66,  105,  105,  105,  105,  105,  105,  110,
      277,  276,  110,  110,  110,  110,  110,  117,  275,  117,
      151,  151,  151,  151,  151,  151,  151,  151,  154,  154,
      154,  154,  154,  154,  154,  154,  160,  160,  160,  160,
      160,  164,  164,   66,  164,  200,  200,  200,  200,  200,
      200,  200,  200,  204,  204,  204,  204,  204,  204,  204,
      204,  209,  209,   66,  209,  116,  210,  243,  241,   66,
       66,   66,  395,  165,  210,  203,  199,   66,   66,  165,

      157,  116,   66,  115,  114,   62,  108,  104,   98,   68,
       95,   68,   66,   64,   62,   43,  395,    5,  395,  395,
      395,  395,  395,  395,  395,  395,  395,  395,  395,  395,
      395,  395,  395,  395,  395,  395,  395,  395,  395,  395,
      395,  395,  395,  395,  395,  395,  395,  395,  395,  395,
      395,  395,  395,  395,  395,  395,  395,  395,  395,  395,
      395,  395,  395,  395,  395,  395,  395,  395,  395,  395,
      395,  395,  395,  395
    } ;

static yyconst flex_int16_t yy_chk[975] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    3,    3,    4,    4,
        7,   10,   13,    7,    3,   14,    4,   14,   14,   15,
       15,   16,   23,   21,   24,   16,   26,   17,   28,   17,
       17,   29,   27,   34,   35,   13,    3,   10,    4,   17,
       25,   23,   30,   14,   28,   31,   32,   29,   44,   33,

       24,   17,   21,   24,   26,   23,   27,   34,   24,   48,
       25,   31,   35,   30,   25,   31,   32,   33,   36,   25,
       42,   51,   51,   42,   44,   32,   31,   30,   46,   33,
      412,   46,   48,   33,   36,   50,   33,   52,  394,   52,
       52,   50,   53,   67,   53,   53,   55,   55,   70,   52,
       58,   58,   72,   73,   53,   69,   55,   46,   60,   60,
       58,   52,   60,   60,   50,   75,   53,   59,   55,   59,
       59,   67,   58,   71,   69,   74,   76,   77,   78,   59,
       72,   70,   79,   75,   80,   73,   81,   83,   82,   71,
       84,   59,   91,   85,   76,   89,   74,   75,   87,   86,

       77,   74,   88,   94,   92,   93,   78,   81,   82,   90,
       98,   80,   79,   85,   99,   89,  100,  393,   88,   91,
       86,   84,   85,  104,   83,   86,   90,   87,   86,   93,
       90,   92,  101,  105,   94,  101,   98,  106,  107,  120,
       99,  121,  100,  115,  107,  118,  104,  109,  109,  111,
      111,  109,  109,  112,  112,  115,  105,  113,  113,  111,
      106,  101,  122,  123,  124,  118,  125,  107,  126,  127,
      120,  111,  129,  121,  130,  131,  133,  132,  134,  136,
      124,  135,  137,  122,  138,  142,  125,  140,  141,  143,
      122,  139,  129,  130,  144,  147,  123,  132,  390,  127,

      145,  126,  146,  137,  148,  131,  136,  135,  133,  134,
      145,  139,  144,  149,  138,  143,  140,  150,  142,  141,
      151,  153,  147,  146,  148,  153,  154,  160,  156,  158,
      158,  159,  159,  167,  149,  156,  162,  168,  172,  160,
      169,  150,  161,  161,  161,  161,  151,  170,  162,  154,
      171,  153,  173,  174,  150,  175,  176,  167,  156,  179,
      178,  182,  161,  180,  169,  179,  185,  170,  183,  168,
      184,  186,  172,  187,  188,  190,  189,  174,  194,  171,
      178,  175,  191,  180,  192,  173,  185,  176,  189,  193,
      182,  187,  183,  188,  184,  190,  195,  196,  194,  197,

      192,  198,  186,  200,  201,  204,  191,  202,  205,  195,
      206,  202,  387,  193,  213,  197,  215,  206,  207,  207,
      207,  207,  211,  214,  216,  198,  196,  217,  204,  200,
      201,  205,  208,  208,  208,  208,  213,  202,  207,  211,
      206,  214,  218,  215,  219,  220,  221,  217,  223,  222,
      216,  224,  208,  225,  226,  227,  228,  229,  230,  233,
      219,  231,  234,  236,  235,  239,  237,  224,  367,  220,
      238,  218,  222,  229,  240,  233,  228,  221,  230,  247,
      250,  223,  237,  249,  251,  225,  227,  250,  254,  255,
      226,  253,  231,  239,  257,  259,  236,  260,  261,  234,

      235,  238,  240,  246,  246,  246,  246,  262,  263,  264,
      265,  261,  267,  247,  259,  266,  249,  251,  257,  253,
      269,  270,  255,  246,  268,  254,  271,  272,  273,  260,
      279,  278,  281,  269,  274,  283,  263,  285,  267,  266,
      262,  265,  264,  278,  268,  284,  286,  288,  281,  289,
      290,  283,  270,  271,  272,  291,  274,  292,  294,  284,
      295,  273,  296,  279,  297,  298,  299,  301,  306,  285,
      305,  288,  286,  291,  290,  308,  307,  292,  310,  311,
      301,  315,  317,  289,  295,  294,  304,  304,  304,  304,
      305,  313,  312,  296,  314,  316,  299,  310,  297,  301,

      318,  306,  298,  308,  319,  321,  304,  307,  311,  312,
      322,  313,  325,  315,  314,  320,  328,  327,  329,  320,
      317,  319,  326,  330,  320,  331,  332,  316,  333,  338,
      322,  321,  318,  324,  324,  324,  324,  339,  326,  336,
      328,  340,  341,  342,  325,  346,  347,  349,  353,  329,
      352,  330,  354,  324,  327,  355,  356,  331,  332,  336,
      333,  338,  341,  357,  359,  360,  347,  362,  339,  363,
      370,  368,  364,  369,  354,  340,  342,  371,  346,  372,
      349,  353,  352,  355,  373,  374,  376,  375,  356,  360,
      364,  362,  359,  377,  378,  357,  379,  370,  382,  380,

      381,  383,  386,  363,  368,  374,  369,  384,  385,  391,
      371,  375,  388,  372,  389,  392,  366,  365,  373,  376,
      361,  358,  378,  380,  381,  379,  377,  351,  350,  383,
      348,  382,  345,  344,  386,  343,  384,  385,  337,  335,
      388,  391,  389,  334,  323,  309,  302,  392,  396,  396,
      396,  396,  396,  396,  396,  396,  397,  300,  293,  397,
      397,  397,  397,  397,  398,  287,  282,  398,  398,  398,
      398,  398,  399,  280,  277,  399,  399,  399,  399,  399,
      400,  276,  275,  400,  400,  400,  258,  400,  401,  401,
      401,  401,  401,  402,  402,  256,  402,  403,  403,  403,

      403,  403,  403,  403,  403,  404,  252,  404,  404,  404,
      404,  404,  404,  405,  405,  405,  405,  405,  405,  405,
      405,  406,  248,  406,  406,  406,  406,  406,  406,  407,
      245,  244,  407,  407,  407,  407,  407,  408,  242,  408,
      409,  409,  409,  409,  409,  409,  409,  409,  410,  410,
      410,  410,  410,  410,  410,  410,  411,  411,  411,  411,
      411,  413,  413,  232,  413,  414,  414,  414,  414,  414,
      414,  414,  414,  415,  415,  415,  415,  415,  415,  415,
      415,  416,  416,  212,  416,  210,  209,  203,  199,  181,
      177,  166,  165,  164,  163,  155,  152,  128,  119,  117,

      108,   66,   65,   64,   63,   61,   54,   49,   45,   41,
       40,   22,   20,   19,   18,    9,    5,  395,  395,  395,
      395,  395,  395,  395,  395,  395,  395,  395,  395,  395,
      395,  395,  395,  395,  395,  395,  395,  395,  395,  395,
      395,  395,  395,  395,  395,  395,  395,  395,  395,  395,
      395,  395,  395,  395,  395,  395,  395,  395,  395,  395,
      395,  395,  395,  395,  395,  395,  395,  395,  395,  395,
      395,  395,  395,  395
    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#line 1 "pxr/usd/sdf/textFileFormat.ll"
#line 2 "pxr/usd/sdf/textFileFormat.ll"
//
// Copyright 2016 Pixar
//
// Licensed under the Apache License, Version 2.0 (the "Apache License")
// with the following modification; you may not use this file except in
// compliance with the Apache License and the following modification to it:
// Section 6. Trademarks. is deleted and replaced with:
//
// 6. Trademarks. This License does not grant permission to use the trade
//    names, trademarks, service marks, or product names of the Licensor
//    and its affiliates, except as required to comply with Section 4(c) of
//    the License and to reproduce the content of the NOTICE file.
//
// You may obtain a copy of the Apache License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the Apache License with the above modification is
// distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied. See the Apache License for the specific
// language governing permissions and limitations under the Apache License.
//

#include "pxr/pxr.h"
#include "pxr/base/arch/fileSystem.h"
#include "pxr/base/tf/stringUtils.h"
#include "pxr/usd/sdf/textParserContext.h"
#include "pxr/usd/sdf/parserHelpers.h"

// Token table from yacc file
#include "textFileFormat.tab.h"

#ifndef fileno
#define fileno(fd) ArchFileNo(fd)
#endif
#ifndef isatty
#define isatty(fd) ArchFileIsaTTY(fd)
#endif

using std::map;
using std::vector;

PXR_NAMESPACE_USING_DIRECTIVE

#define YYSTYPE Sdf_ParserHelpers::Value

// As a pure parser, we must define the following
#define YY_DECL int textFileFormatYylex(YYSTYPE *yylval_param, yyscan_t yyscanner)

// The context object will be used to store global state for the parser.
#define YY_EXTRA_TYPE Sdf_TextParserContext *

/* Configuration options for flex */
/* States */

#line 840 "<stdout>"

#define INITIAL 0
#define SLASHTERIX_COMMENT 1

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* Holds the entire state of the reentrant scanner. */
struct yyguts_t
    {

    /* User-defined. Not touched by flex. */
    YY_EXTRA_TYPE yyextra_r;

    /* The rest are the same as the globals declared in the non-reentrant scanner. */
    FILE *yyin_r, *yyout_r;
    size_t yy_buffer_stack_top; /**< index of top of stack. */
    size_t yy_buffer_stack_max; /**< capacity of stack. */
    YY_BUFFER_STATE * yy_buffer_stack; /**< Stack as an array. */
    char yy_hold_char;
    yy_size_t yy_n_chars;
    yy_size_t yyleng_r;
    char *yy_c_buf_p;
    int yy_init;
    int yy_start;
    int yy_did_buffer_switch_on_eof;
    int yy_start_stack_ptr;
    int yy_start_stack_depth;
    int *yy_start_stack;
    yy_state_type yy_last_accepting_state;
    char* yy_last_accepting_cpos;

    int yylineno_r;
    int yy_flex_debug_r;

    char *yytext_r;
    int yy_more_flag;
    int yy_more_len;

    YYSTYPE * yylval_r;

    }; /* end struct yyguts_t */

static int yy_init_globals (yyscan_t yyscanner );

    /* This must go here because YYSTYPE and YYLTYPE are included
     * from bison output in section 1.*/
    #    define yylval yyg->yylval_r
    
int textFileFormatYylex_init (yyscan_t* scanner);

int textFileFormatYylex_init_extra (YY_EXTRA_TYPE user_defined,yyscan_t* scanner);

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int textFileFormatYylex_destroy (yyscan_t yyscanner );

int textFileFormatYyget_debug (yyscan_t yyscanner );

void textFileFormatYyset_debug (int debug_flag ,yyscan_t yyscanner );

YY_EXTRA_TYPE textFileFormatYyget_extra (yyscan_t yyscanner );

void textFileFormatYyset_extra (YY_EXTRA_TYPE user_defined ,yyscan_t yyscanner );

FILE *textFileFormatYyget_in (yyscan_t yyscanner );

void textFileFormatYyset_in  (FILE * in_str ,yyscan_t yyscanner );

FILE *textFileFormatYyget_out (yyscan_t yyscanner );

void textFileFormatYyset_out  (FILE * out_str ,yyscan_t yyscanner );

yy_size_t textFileFormatYyget_leng (yyscan_t yyscanner );

char *textFileFormatYyget_text (yyscan_t yyscanner );

int textFileFormatYyget_lineno (yyscan_t yyscanner );

void textFileFormatYyset_lineno (int line_number ,yyscan_t yyscanner );

int textFileFormatYyget_column  (yyscan_t yyscanner );

void textFileFormatYyset_column (int column_no ,yyscan_t yyscanner );

YYSTYPE * textFileFormatYyget_lval (yyscan_t yyscanner );

void textFileFormatYyset_lval (YYSTYPE * yylval_param ,yyscan_t yyscanner );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int textFileFormatYywrap (yyscan_t yyscanner );
#else
extern int textFileFormatYywrap (yyscan_t yyscanner );
#endif
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int ,yyscan_t yyscanner);
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * ,yyscan_t yyscanner);
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (yyscan_t yyscanner );
#else
static int input (yyscan_t yyscanner );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg , yyscanner)
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int textFileFormatYylex \
               (YYSTYPE * yylval_param ,yyscan_t yyscanner);

#define YY_DECL int textFileFormatYylex \
               (YYSTYPE * yylval_param , yyscan_t yyscanner)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    yylval = yylval_param;

	if ( !yyg->yy_init )
		{
		yyg->yy_init = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yyg->yy_start )
			yyg->yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			textFileFormatYyensure_buffer_stack (yyscanner);
			YY_CURRENT_BUFFER_LVALUE =
				textFileFormatYy_create_buffer(yyin,YY_BUF_SIZE ,yyscanner);
		}

		textFileFormatYy_load_buffer_state(yyscanner );
		}

	{
#line 66 "pxr/usd/sdf/textFileFormat.ll"


    /* skip over whitespace and comments */
    /* handle the first line # comment specially, since it contains the
       magic token */
#line 1111 "<stdout>"

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yyg->yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yyg->yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yyg->yy_start;
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				yyg->yy_last_accepting_state = yy_current_state;
				yyg->yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 396 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 918 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = yyg->yy_last_accepting_cpos;
			yy_current_state = yyg->yy_last_accepting_state;
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yyg->yy_hold_char;
			yy_cp = yyg->yy_last_accepting_cpos;
			yy_current_state = yyg->yy_last_accepting_state;
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 71 "pxr/usd/sdf/textFileFormat.ll"
{}
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 72 "pxr/usd/sdf/textFileFormat.ll"
{
        if (yyextra->menvaLineNo == 1) {
            (*yylval_param) = std::string(yytext, yyleng);
            return TOK_MAGIC;
        }
    }
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 78 "pxr/usd/sdf/textFileFormat.ll"
{}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 79 "pxr/usd/sdf/textFileFormat.ll"
BEGIN SLASHTERIX_COMMENT ;
	YY_BREAK
case 5:
/* rule 5 can match eol */
YY_RULE_SETUP
#line 80 "pxr/usd/sdf/textFileFormat.ll"
;
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 81 "pxr/usd/sdf/textFileFormat.ll"
BEGIN INITIAL ;
	YY_BREAK
/* newline is returned as TOK_NL
     * Note that newlines embedded in quoted strings and tuples are counted
     * as part of the token and do NOT emit a separate TOK_NL.
     */
case 7:
/* rule 7 can match eol */
YY_RULE_SETUP
#line 87 "pxr/usd/sdf/textFileFormat.ll"
{
        yyextra->menvaLineNo++;
        return TOK_NL;
    }
	YY_BREAK
/* literal keywords.  we return the yytext so that the yacc grammar
       can make use of it. */
case 8:
YY_RULE_SETUP
#line 94 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_ADD; }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 95 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_ATTRIBUTES; }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 96 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_CLASS; }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 97 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_CONFIG; }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 98 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_CONNECT; }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 99 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_CUSTOM; }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 100 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_CUSTOMDATA; }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 101 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_DEFAULT; }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 102 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_DEF; }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 103 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_DELETE; }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 104 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_DICTIONARY; }
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 105 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_DISPLAYUNIT; }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 106 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_DOC; }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 107 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_INHERITS; }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 108 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_KIND; }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 109 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_MAPPER; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 110 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_NAMECHILDREN; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 111 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_NONE; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 112 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_OFFSET; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 113 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_OVER; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 114 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_PAYLOAD; }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 115 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_PERMISSION; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 116 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_PREFIX_SUBSTITUTIONS; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 117 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_PROPERTIES; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 118 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_REFERENCES; }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 119 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_RELOCATES; }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 120 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_REL; }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 121 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_REORDER; }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 122 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_ROOTPRIMS; }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 123 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_SCALE; }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 124 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_SUBLAYERS; }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 125 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_SUFFIX_SUBSTITUTIONS; }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 126 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_SPECIALIZES; }
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 127 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_SYMMETRYARGUMENTS; }
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 128 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_SYMMETRYFUNCTION; }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 129 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_TIME_SAMPLES; }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 130 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_UNIFORM; }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 131 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_VARIANTSET; }
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 132 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_VARIANTSETS; }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 133 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_VARIANTS; }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 134 "pxr/usd/sdf/textFileFormat.ll"
{ (*yylval_param) = std::string(yytext, yyleng); return TOK_VARYING; }
	YY_BREAK
/* unquoted C/Python identifier */
case 49:
YY_RULE_SETUP
#line 137 "pxr/usd/sdf/textFileFormat.ll"
{
        (*yylval_param) = std::string(yytext, yyleng);
        return TOK_IDENTIFIER;
    }
	YY_BREAK
/* unquoted C++ namespaced identifier -- see bug 10775 */
case 50:
YY_RULE_SETUP
#line 143 "pxr/usd/sdf/textFileFormat.ll"
{
        (*yylval_param) = std::string(yytext, yyleng);
        return TOK_CXX_NAMESPACED_IDENTIFIER;
    }
	YY_BREAK
/* unquoted namespaced identifier.  matches any number of colon
     * delimited C/Python identifiers */
case 51:
YY_RULE_SETUP
#line 150 "pxr/usd/sdf/textFileFormat.ll"
{
        (*yylval_param) = std::string(yytext, yyleng);
        return TOK_NAMESPACED_IDENTIFIER;
    }
	YY_BREAK
/* scene paths */
case 52:
YY_RULE_SETUP
#line 156 "pxr/usd/sdf/textFileFormat.ll"
{
        (*yylval_param) = Sdf_EvalQuotedString(yytext, yyleng, 1);
        return TOK_PATHREF;
    }
	YY_BREAK
/* Single '@'-delimited asset references */
case 53:
YY_RULE_SETUP
#line 162 "pxr/usd/sdf/textFileFormat.ll"
{
        (*yylval_param) = 
            Sdf_EvalAssetPath(yytext, yyleng, /* tripleDelimited = */ false);
        return TOK_ASSETREF;
    }
	YY_BREAK
/* Triple '@'-delimited asset references. */
case 54:
/* rule 54 can match eol */
YY_RULE_SETUP
#line 169 "pxr/usd/sdf/textFileFormat.ll"
{
        (*yylval_param) = 
            Sdf_EvalAssetPath(yytext, yyleng, /* tripleDelimited = */ true);
        return TOK_ASSETREF;
    }
	YY_BREAK
/* Singly quoted, single line strings with escapes.
       Note: we handle empty singly quoted strings below, to disambiguate
       them from the beginning of triply-quoted strings.
       Ex: "Foo \"foo\"" */
case 55:
#line 180 "pxr/usd/sdf/textFileFormat.ll"
case 56:
YY_RULE_SETUP
#line 180 "pxr/usd/sdf/textFileFormat.ll"
{  /* " //<- unfreak out coloring code */
        (*yylval_param) = Sdf_EvalQuotedString(yytext, yyleng, 1);
        return TOK_STRING;
    }
	YY_BREAK
/* Empty singly quoted strings that aren't the beginning of
       a triply-quoted string. */
case 57:
/* rule 57 can match eol */
*yy_cp = yyg->yy_hold_char; /* undo effects of setting up yytext */
YY_LINENO_REWIND_TO(yy_bp + 2);
yyg->yy_c_buf_p = yy_cp = yy_bp + 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 187 "pxr/usd/sdf/textFileFormat.ll"
{  /* ' // <- keep syntax coloring from freaking out */
        (*yylval_param) = std::string();
        return TOK_STRING;
    }
	YY_BREAK
case 58:
/* rule 58 can match eol */
*yy_cp = yyg->yy_hold_char; /* undo effects of setting up yytext */
YY_LINENO_REWIND_TO(yy_bp + 2);
yyg->yy_c_buf_p = yy_cp = yy_bp + 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 191 "pxr/usd/sdf/textFileFormat.ll"
{
        (*yylval_param) = std::string();
        return TOK_STRING;
    }
	YY_BREAK
/* Triply quoted, multi-line strings with escapes.
       Ex: """A\n\"B\"\nC""" */
case 59:
/* rule 59 can match eol */
#line 199 "pxr/usd/sdf/textFileFormat.ll"
case 60:
/* rule 60 can match eol */
YY_RULE_SETUP
#line 199 "pxr/usd/sdf/textFileFormat.ll"
{  /* " //<- unfreak out coloring code */

        unsigned int numlines = 0;
        (*yylval_param) = Sdf_EvalQuotedString(yytext, yyleng, 3, &numlines);
        yyextra->menvaLineNo += numlines;
        return TOK_STRING;
    }
	YY_BREAK
/* Super special case for negative 0.  We have to store this as a double to
     * preserve the sign.  There is no negative zero integral value, and we
     * don't know at this point what the final stored type will be. */
case 61:
YY_RULE_SETUP
#line 210 "pxr/usd/sdf/textFileFormat.ll"
{
        (*yylval_param) = double(-0.0);
        return TOK_NUMBER;
   }
	YY_BREAK
/* Positive integers: store as uint64_t if in range, otherwise double. */
case 62:
YY_RULE_SETUP
#line 216 "pxr/usd/sdf/textFileFormat.ll"
{
        bool outOfRange = false;
        (*yylval_param) = TfStringToUInt64(yytext, &outOfRange);
        if (outOfRange) {
           TF_WARN("Integer literal '%s' on line %d%s%s out of range, parsing "
                   "as double.  Consider exponential notation for large "
                   "floating point values.", yytext, yyextra->menvaLineNo,
                   yyextra->fileContext.empty() ? "" : " in file ",
                   yyextra->fileContext.empty() ? "" :
                   yyextra->fileContext.c_str());
           (*yylval_param) = TfStringToDouble(yytext);
        }
        return TOK_NUMBER;
    }
	YY_BREAK
/* Negative integers: store as long. */
case 63:
YY_RULE_SETUP
#line 232 "pxr/usd/sdf/textFileFormat.ll"
{
        bool outOfRange = false;
        (*yylval_param) = TfStringToInt64(yytext, &outOfRange);
        if (outOfRange) {
           TF_WARN("Integer literal '%s' on line %d%s%s out of range, parsing "
                   "as double.  Consider exponential notation for large "
                   "floating point values.", yytext, yyextra->menvaLineNo,
                   yyextra->fileContext.empty() ? "" : " in file ",
                   yyextra->fileContext.empty() ? "" :
                   yyextra->fileContext.c_str());
           (*yylval_param) = TfStringToDouble(yytext);
        }
        return TOK_NUMBER;
    }
	YY_BREAK
/* Numbers with decimal places or exponents: store as double. */
case 64:
#line 249 "pxr/usd/sdf/textFileFormat.ll"
case 65:
YY_RULE_SETUP
#line 249 "pxr/usd/sdf/textFileFormat.ll"
{
        (*yylval_param) = TfStringToDouble(yytext);
        return TOK_NUMBER;
    }
	YY_BREAK
/* regexps for negative infinity.  we don't handle inf and nan here
     * because they look like identifiers.  we handle them in parser where
     * we have the additional context we need to distinguish them from
     * identifiers. */
case 66:
YY_RULE_SETUP
#line 258 "pxr/usd/sdf/textFileFormat.ll"
{
        (*yylval_param) = -std::numeric_limits<double>::infinity();
        return TOK_NUMBER;
    }
	YY_BREAK
/* various single-character punctuation.  return the character
     * itself as the token.
     */
case 67:
YY_RULE_SETUP
#line 266 "pxr/usd/sdf/textFileFormat.ll"
{
        return yytext[0];
    }
	YY_BREAK
/* the default rule is to ECHO any unmatched character.  by returning a
     * token that the parser does not know how to handle these become syntax
     * errors instead.
     */
case 68:
YY_RULE_SETUP
#line 274 "pxr/usd/sdf/textFileFormat.ll"
{
        return TOK_SYNTAX_ERROR;
    }
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 278 "pxr/usd/sdf/textFileFormat.ll"
ECHO;
	YY_BREAK
#line 1639 "<stdout>"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(SLASHTERIX_COMMENT):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yyg->yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yyg->yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * textFileFormatYylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yyg->yy_c_buf_p <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state( yyscanner );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state , yyscanner);

			yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yyg->yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yyg->yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer( yyscanner ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yyg->yy_did_buffer_switch_on_eof = 0;

				if ( textFileFormatYywrap(yyscanner ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yyg->yy_c_buf_p = yyg->yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yyg->yy_c_buf_p =
					yyg->yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yyg->yy_c_buf_p =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars];

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of textFileFormatYylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = yyg->yytext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( yyg->yy_c_buf_p > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yyg->yy_c_buf_p - yyg->yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars = 0;

	else
		{
			yy_size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) (yyg->yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				yy_size_t new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					textFileFormatYyrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2 ,yyscanner );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yyg->yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			yyg->yy_n_chars, num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	if ( yyg->yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			textFileFormatYyrestart(yyin  ,yyscanner);
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) (yyg->yy_n_chars + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = yyg->yy_n_chars + number_to_move + (yyg->yy_n_chars >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) textFileFormatYyrealloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size ,yyscanner );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	yyg->yy_n_chars += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yyg->yytext_ptr = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (yyscan_t yyscanner)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_current_state = yyg->yy_start;

	for ( yy_cp = yyg->yytext_ptr + YY_MORE_ADJ; yy_cp < yyg->yy_c_buf_p; ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yyg->yy_last_accepting_state = yy_current_state;
			yyg->yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 396 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state , yyscan_t yyscanner)
{
	register int yy_is_jam;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner; /* This var may be unused depending upon options. */
	register char *yy_cp = yyg->yy_c_buf_p;

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yyg->yy_last_accepting_state = yy_current_state;
		yyg->yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 396 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 395);

	(void)yyg;
	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (yyscan_t yyscanner)
#else
    static int input  (yyscan_t yyscanner)
#endif

{
	int c;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	*yyg->yy_c_buf_p = yyg->yy_hold_char;

	if ( *yyg->yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yyg->yy_c_buf_p < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			/* This was really a NUL. */
			*yyg->yy_c_buf_p = '\0';

		else
			{ /* need more input */
			yy_size_t offset = yyg->yy_c_buf_p - yyg->yytext_ptr;
			++yyg->yy_c_buf_p;

			switch ( yy_get_next_buffer( yyscanner ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					textFileFormatYyrestart(yyin ,yyscanner);

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( textFileFormatYywrap(yyscanner ) )
						return EOF;

					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput(yyscanner);
#else
					return input(yyscanner);
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yyg->yy_c_buf_p = yyg->yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yyg->yy_c_buf_p;	/* cast for 8-bit char's */
	*yyg->yy_c_buf_p = '\0';	/* preserve yytext */
	yyg->yy_hold_char = *++yyg->yy_c_buf_p;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * @param yyscanner The scanner object.
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void textFileFormatYyrestart  (FILE * input_file , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! YY_CURRENT_BUFFER ){
        textFileFormatYyensure_buffer_stack (yyscanner);
		YY_CURRENT_BUFFER_LVALUE =
            textFileFormatYy_create_buffer(yyin,YY_BUF_SIZE ,yyscanner);
	}

	textFileFormatYy_init_buffer(YY_CURRENT_BUFFER,input_file ,yyscanner);
	textFileFormatYy_load_buffer_state(yyscanner );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * @param yyscanner The scanner object.
 */
    void textFileFormatYy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		textFileFormatYypop_buffer_state();
	 *		textFileFormatYypush_buffer_state(new_buffer);
     */
	textFileFormatYyensure_buffer_stack (yyscanner);
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	textFileFormatYy_load_buffer_state(yyscanner );

	/* We don't actually know whether we did this switch during
	 * EOF (textFileFormatYywrap()) processing, but the only time this flag
	 * is looked at is after textFileFormatYywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yyg->yy_did_buffer_switch_on_eof = 1;
}

static void textFileFormatYy_load_buffer_state  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	yyg->yytext_ptr = yyg->yy_c_buf_p = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	yyg->yy_hold_char = *yyg->yy_c_buf_p;
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * @param yyscanner The scanner object.
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE textFileFormatYy_create_buffer  (FILE * file, int  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) textFileFormatYyalloc(sizeof( struct yy_buffer_state ) ,yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in textFileFormatYy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) textFileFormatYyalloc(b->yy_buf_size + 2 ,yyscanner );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in textFileFormatYy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	textFileFormatYy_init_buffer(b,file ,yyscanner);

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with textFileFormatYy_create_buffer()
 * @param yyscanner The scanner object.
 */
    void textFileFormatYy_delete_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		textFileFormatYyfree((void *) b->yy_ch_buf ,yyscanner );

	textFileFormatYyfree((void *) b ,yyscanner );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a textFileFormatYyrestart() or at EOF.
 */
    static void textFileFormatYy_init_buffer  (YY_BUFFER_STATE  b, FILE * file , yyscan_t yyscanner)

{
	int oerrno = errno;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	textFileFormatYy_flush_buffer(b ,yyscanner);

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then textFileFormatYy_init_buffer was _probably_
     * called from textFileFormatYyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * @param yyscanner The scanner object.
 */
    void textFileFormatYy_flush_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		textFileFormatYy_load_buffer_state(yyscanner );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  @param yyscanner The scanner object.
 */
void textFileFormatYypush_buffer_state (YY_BUFFER_STATE new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (new_buffer == NULL)
		return;

	textFileFormatYyensure_buffer_stack(yyscanner);

	/* This block is copied from textFileFormatYy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		yyg->yy_buffer_stack_top++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from textFileFormatYy_switch_to_buffer. */
	textFileFormatYy_load_buffer_state(yyscanner );
	yyg->yy_did_buffer_switch_on_eof = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  @param yyscanner The scanner object.
 */
void textFileFormatYypop_buffer_state (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (!YY_CURRENT_BUFFER)
		return;

	textFileFormatYy_delete_buffer(YY_CURRENT_BUFFER ,yyscanner);
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if (yyg->yy_buffer_stack_top > 0)
		--yyg->yy_buffer_stack_top;

	if (YY_CURRENT_BUFFER) {
		textFileFormatYy_load_buffer_state(yyscanner );
		yyg->yy_did_buffer_switch_on_eof = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void textFileFormatYyensure_buffer_stack (yyscan_t yyscanner)
{
	yy_size_t num_to_alloc;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if (!yyg->yy_buffer_stack) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)textFileFormatYyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in textFileFormatYyensure_buffer_stack()" );
								  
		memset(yyg->yy_buffer_stack, 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		yyg->yy_buffer_stack_max = num_to_alloc;
		yyg->yy_buffer_stack_top = 0;
		return;
	}

	if (yyg->yy_buffer_stack_top >= (yyg->yy_buffer_stack_max) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = yyg->yy_buffer_stack_max + grow_size;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)textFileFormatYyrealloc
								(yyg->yy_buffer_stack,
								num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in textFileFormatYyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset(yyg->yy_buffer_stack + yyg->yy_buffer_stack_max, 0, grow_size * sizeof(struct yy_buffer_state*));
		yyg->yy_buffer_stack_max = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE textFileFormatYy_scan_buffer  (char * base, yy_size_t  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) textFileFormatYyalloc(sizeof( struct yy_buffer_state ) ,yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in textFileFormatYy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	textFileFormatYy_switch_to_buffer(b ,yyscanner );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to textFileFormatYylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       textFileFormatYy_scan_bytes() instead.
 */
YY_BUFFER_STATE textFileFormatYy_scan_string (yyconst char * yystr , yyscan_t yyscanner)
{
    
	return textFileFormatYy_scan_bytes(yystr,strlen(yystr) ,yyscanner);
}

/** Setup the input buffer state to scan the given bytes. The next call to textFileFormatYylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE textFileFormatYy_scan_bytes  (yyconst char * yybytes, yy_size_t  _yybytes_len , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	yy_size_t i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) textFileFormatYyalloc(n ,yyscanner );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in textFileFormatYy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = textFileFormatYy_scan_buffer(buf,n ,yyscanner);
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in textFileFormatYy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg , yyscan_t yyscanner)
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = yyg->yy_hold_char; \
		yyg->yy_c_buf_p = yytext + yyless_macro_arg; \
		yyg->yy_hold_char = *yyg->yy_c_buf_p; \
		*yyg->yy_c_buf_p = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the user-defined data for this scanner.
 * @param yyscanner The scanner object.
 */
YY_EXTRA_TYPE textFileFormatYyget_extra  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyextra;
}

/** Get the current line number.
 * @param yyscanner The scanner object.
 */
int textFileFormatYyget_lineno  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    
        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yylineno;
}

/** Get the current column number.
 * @param yyscanner The scanner object.
 */
int textFileFormatYyget_column  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    
        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yycolumn;
}

/** Get the input stream.
 * @param yyscanner The scanner object.
 */
FILE *textFileFormatYyget_in  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyin;
}

/** Get the output stream.
 * @param yyscanner The scanner object.
 */
FILE *textFileFormatYyget_out  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyout;
}

/** Get the length of the current token.
 * @param yyscanner The scanner object.
 */
yy_size_t textFileFormatYyget_leng  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyleng;
}

/** Get the current token.
 * @param yyscanner The scanner object.
 */

char *textFileFormatYyget_text  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yytext;
}

/** Set the user-defined data. This data is never touched by the scanner.
 * @param user_defined The data to be associated with this scanner.
 * @param yyscanner The scanner object.
 */
void textFileFormatYyset_extra (YY_EXTRA_TYPE  user_defined , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyextra = user_defined ;
}

/** Set the current line number.
 * @param line_number
 * @param yyscanner The scanner object.
 */
void textFileFormatYyset_lineno (int  line_number , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* lineno is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "textFileFormatYyset_lineno called with no buffer" );
    
    yylineno = line_number;
}

/** Set the current column.
 * @param line_number
 * @param yyscanner The scanner object.
 */
void textFileFormatYyset_column (int  column_no , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* column is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "textFileFormatYyset_column called with no buffer" );
    
    yycolumn = column_no;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * @param yyscanner The scanner object.
 * @see textFileFormatYy_switch_to_buffer
 */
void textFileFormatYyset_in (FILE *  in_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyin = in_str ;
}

void textFileFormatYyset_out (FILE *  out_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyout = out_str ;
}

int textFileFormatYyget_debug  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yy_flex_debug;
}

void textFileFormatYyset_debug (int  bdebug , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yy_flex_debug = bdebug ;
}

/* Accessor methods for yylval and yylloc */

YYSTYPE * textFileFormatYyget_lval  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yylval;
}

void textFileFormatYyset_lval (YYSTYPE *  yylval_param , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yylval = yylval_param;
}

/* User-visible API */

/* textFileFormatYylex_init is special because it creates the scanner itself, so it is
 * the ONLY reentrant function that doesn't take the scanner as the last argument.
 * That's why we explicitly handle the declaration, instead of using our macros.
 */

int textFileFormatYylex_init(yyscan_t* ptr_yy_globals)

{
    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) textFileFormatYyalloc ( sizeof( struct yyguts_t ), NULL );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    return yy_init_globals ( *ptr_yy_globals );
}

/* textFileFormatYylex_init_extra has the same functionality as textFileFormatYylex_init, but follows the
 * convention of taking the scanner as the last argument. Note however, that
 * this is a *pointer* to a scanner, as it will be allocated by this call (and
 * is the reason, too, why this function also must handle its own declaration).
 * The user defined value in the first argument will be available to textFileFormatYyalloc in
 * the yyextra field.
 */

int textFileFormatYylex_init_extra(YY_EXTRA_TYPE yy_user_defined,yyscan_t* ptr_yy_globals )

{
    struct yyguts_t dummy_yyguts;

    textFileFormatYyset_extra (yy_user_defined, &dummy_yyguts);

    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }
	
    *ptr_yy_globals = (yyscan_t) textFileFormatYyalloc ( sizeof( struct yyguts_t ), &dummy_yyguts );
	
    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }
    
    /* By setting to 0xAA, we expose bugs in
    yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));
    
    textFileFormatYyset_extra (yy_user_defined, *ptr_yy_globals);
    
    return yy_init_globals ( *ptr_yy_globals );
}

static int yy_init_globals (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from textFileFormatYylex_destroy(), so don't allocate here.
     */

    yyg->yy_buffer_stack = 0;
    yyg->yy_buffer_stack_top = 0;
    yyg->yy_buffer_stack_max = 0;
    yyg->yy_c_buf_p = (char *) 0;
    yyg->yy_init = 0;
    yyg->yy_start = 0;

    yyg->yy_start_stack_ptr = 0;
    yyg->yy_start_stack_depth = 0;
    yyg->yy_start_stack =  NULL;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = (FILE *) 0;
    yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * textFileFormatYylex_init()
     */
    return 0;
}

/* textFileFormatYylex_destroy is for both reentrant and non-reentrant scanners. */
int textFileFormatYylex_destroy  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		textFileFormatYy_delete_buffer(YY_CURRENT_BUFFER ,yyscanner );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		textFileFormatYypop_buffer_state(yyscanner);
	}

	/* Destroy the stack itself. */
	textFileFormatYyfree(yyg->yy_buffer_stack ,yyscanner);
	yyg->yy_buffer_stack = NULL;

    /* Destroy the start condition stack. */
        textFileFormatYyfree(yyg->yy_start_stack ,yyscanner );
        yyg->yy_start_stack = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * textFileFormatYylex() is called, initialization will occur. */
    yy_init_globals( yyscanner);

    /* Destroy the main struct (reentrant only). */
    textFileFormatYyfree ( yyscanner , yyscanner );
    yyscanner = NULL;
    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n , yyscan_t yyscanner)
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s , yyscan_t yyscanner)
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *textFileFormatYyalloc (yy_size_t  size , yyscan_t yyscanner)
{
	return (void *) malloc( size );
}

void *textFileFormatYyrealloc  (void * ptr, yy_size_t  size , yyscan_t yyscanner)
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void textFileFormatYyfree (void * ptr , yyscan_t yyscanner)
{
	free( (char *) ptr );	/* see textFileFormatYyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 278 "pxr/usd/sdf/textFileFormat.ll"



