//
// Copyright 2016 Pixar
//
// Licensed under the Apache License, Version 2.0 (the "Apache License")
// with the following modification; you may not use this file except in
// compliance with the Apache License and the following modification to it:
// Section 6. Trademarks. is deleted and replaced with:
//
// 6. Trademarks. This License does not grant permission to use the trade
//    names, trademarks, service marks, or product names of the Licensor
//    and its affiliates, except as required to comply with Section 4(c) of
//    the License and to reproduce the content of the NOTICE file.
//
// You may obtain a copy of the Apache License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the Apache License with the above modification is
// distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied. See the Apache License for the specific
// language governing permissions and limitations under the Apache License.
//
////////////////////////////////////////////////////////////////////////
// This file is generated by a script.  Do not edit directly.  Edit the
// wrapQuat.template.cpp file to make changes.

#include "pxr/pxr.h"
#include "pxr/base/gf/quatf.h"
#include "pxr/base/gf/quath.h"

#include "pxr/base/tf/pyUtils.h"
#include "pxr/base/tf/wrapTypeHelpers.h"
#include "pxr/base/tf/pyContainerConversions.h"

#include <boost/python/class.hpp>
#include <boost/python/copy_const_reference.hpp>
#include <boost/python/def.hpp>
#include <boost/python/implicit.hpp>
#include <boost/python/make_constructor.hpp>
#include <boost/python/operators.hpp>
#include <boost/python/overloads.hpp>
#include <boost/python/return_arg.hpp>

#include <string>

using namespace boost::python;

using std::string;

PXR_NAMESPACE_USING_DIRECTIVE

namespace {

static string __repr__(GfQuatf const &self) {
    return TF_PY_REPR_PREFIX + "Quatf(" +
        TfPyRepr(self.GetReal()) + ", " +
        TfPyRepr(self.GetImaginary()) + ")";
}

// Zero-initialized default ctor for python.
static GfQuatf *__init__() { return new GfQuatf(0); }

} // anonymous namespace 

void wrapQuatf()
{    
    object getImaginary =
        make_function(&GfQuatf::GetImaginary,
                      return_value_policy<return_by_value>());

    object setImaginaryVec =
        make_function((void (GfQuatf::*)(const GfVec3f &))
                      &GfQuatf::SetImaginary);

    object setImaginaryScl =
        make_function((void (GfQuatf::*)(float, float, float))
                      &GfQuatf::SetImaginary,
                      default_call_policies(),
                      (arg("i"), arg("j"), arg("k")));

    def("Slerp",
        (GfQuatf (*)(double, const GfQuatf&, const GfQuatf&))
        GfSlerp);
    
    class_<GfQuatf>("Quatf", no_init)
        .def("__init__", make_constructor(__init__))
                          
        .def(TfTypePythonClass())

        .def(init<float>(arg("real")))
        .def(init<float, const GfVec3f &>(
                 (arg("real"), arg("imaginary"))))
        .def(init<float, float, float, float>(
                 (arg("real"), arg("i"), arg("j"), arg("k"))))

        .def("GetIdentity", &GfQuatf::GetIdentity)
        .staticmethod("GetIdentity")

        .def("GetReal", &GfQuatf::GetReal)
        .def("SetReal", &GfQuatf::SetReal)
        .add_property("real", &GfQuatf::GetReal, &GfQuatf::SetReal)

        .def("GetImaginary", getImaginary)
        .def("SetImaginary", setImaginaryVec)
        .def("SetImaginary", setImaginaryScl)
        .add_property("imaginary", getImaginary, setImaginaryVec)

        .def("GetLength", &GfQuatf::GetLength)

        .def("GetNormalized", &GfQuatf::GetNormalized,
             (arg("eps")=GF_MIN_VECTOR_LENGTH))
        .def("Normalize", &GfQuatf::Normalize,
             (arg("eps")=GF_MIN_VECTOR_LENGTH), return_self<>())

        .def("GetConjugate", &GfQuatf::GetConjugate)
        .def("GetInverse", &GfQuatf::GetInverse)

        .def(str(self))
        .def(-self)
        .def(self == self)
        .def(self != self)
        .def(self *= self)
        .def(self *= float())
        .def(self /= float())
        .def(self += self)
        .def(self -= self)
        .def(self + self)
        .def(self - self)
        .def(self * self)
        .def(self * float())
        .def(float() * self)
        .def(self / float())

        .def("__repr__", __repr__)

        ;

    implicitly_convertible<GfQuath, GfQuatf>();

    to_python_converter<std::vector<GfQuatf>,
        TfPySequenceToPython<std::vector<GfQuatf> > >();
    
}
